      subroutine  init_ml_pars(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer freer(num_blocks)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
      character line*1024
      integer ierr
      integer i,j,k,ibin,ib,jc,jal,is
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n
      real Ict0,Ic(100)
      real del
      real a_all,b_all
      real eps,cent
      real expban,bans,exp1
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)

c
      integer, allocatable :: obs_bins(:)
c
      scale_ml(1:nbin_ml,1:(npart_act+1)) = 1.0
      sigma_ml(1:nbin_ml) = 0.0
      nref_ml(1:nbin_ml) = 0.0
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c  
      do i=1,num_blocks
         if(freer(i).eq.0.or.mlusework) then
            ibin = obs_bins(i)
            o_s = block_start(i)+1
            o_f = block_start(i+1)
            c_s = ref_2_asym_start(i)+1
            c_f = ref_2_asym_start(i+1)
            jc = 0
            do j=c_s,c_f
               jc = jc + 1
c
c---We need to use aniso scales also
               c_n = block_2_asym(j)
               a_all = fcalc(1,c_n)
               b_all = fcalc(2,c_n)
               hkl_this(1:3) = hkl_asym(1:3,c_n)
               expban        = 0.0
               do  is=1,nsym
                  hkl_sym=matmul(transpose(rot(1:3,1:3,is)),hkl_this)
                  s_this=matmul(transpose(rfr),hkl_sym)
                  ss_v(1) = s_this(1)*s_this(1)
                  ss_v(2) = s_this(2)*s_this(2)
                  ss_v(3) = s_this(3)*s_this(3)
                  ss_v(4) = 2.0*s_this(1)*s_this(2)
                  ss_v(5) = 2.0*s_this(1)*s_this(3)
                  ss_v(6) = 2.0*s_this(2)*s_this(3)
                  bans    = ss_v(1)*b_ls_aniso_over(1)+
     &                 ss_v(2)*b_ls_aniso_over(2)+
     &                 ss_v(3)*b_ls_aniso_over(3)+
     &                 ss_v(4)*b_ls_aniso_over(4)+
     &                 ss_v(5)*b_ls_aniso_over(5)+
     &                 ss_v(6)*b_ls_aniso_over(6)
                  exp1         = exp(-bans/4.0)
                  expban       = expban + exp1
               enddo
               expban = expban/nsym
               do k=1,npart_act
                  a_all = a_all + fpart(k,1,c_n)
                  b_all = b_all + fpart(k,2,c_n)
               enddo
               Ic(jc) = (a_all*a_all+b_all*b_all)*expban
            enddo
            do j=o_s,o_f
               o_c_s = obs_start(j) + 1
               o_c_f = obs_start(j+1)
               Ict0 = 0.0
               do k=o_c_s,o_c_f
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
               enddo
               del = sqrt(max(0.0,iobs(1,j)))-sqrt(Ict0)
               sigma_ml(ibin) = sigma_ml(ibin)+del*del
               nref_ml(ibin) = nref_ml(ibin) + 1
            enddo
         endif
      enddo
      do ib=1,nbin_ml
         if(nref_ml(ib).gt.0) then
            sigma_ml(ib) = sigma_ml(ib)/nref_ml(ib)
            sigma_ml(ib) = sigma_ml(ib)/3.0
c            write(*,*)ib,nref_ml(ib),sigma_ml(ib)
         else
            write(line,'(a,i5,a)')
     &           'There are not enough reflections in '//
     &           'the resolution bin ',ib,' for estimation'
            call errwrt(-1,line)
            call errwrt(1,'Problem in estimation. Cannot continue')
         endif
      enddo
c
      deallocate(obs_bins)
      return
      end
c
      subroutine  ls_ml_pars(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer freer(num_blocks)
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer ierr
c
c---locals
      integer, allocatable :: obs_bins(:)
c
      real sigma_ml0(maxbin+1),scale_ml0(20)
      integer maxcont_l
      parameter (maxcont_l = 48)
      real  Ic(maxcont_l)
      real a_all,b_all,ict,io0,exp1,expb,expbs,expbs_bulk,expban
      real s_b_part
      real hkl_this(3)
      integer npar,npar_s
      real toler
      integer il
      integer i,j,m,k,jc,jal,is,ip,jp,ip1,iint
      integer o_s,o_f,c_s,c_f,c_n,o_c_s,o_c_f,c_1
      integer ierror
      logical error
c
      integer npart_loc
      parameter (npart_loc = 20)
      real a_p(npart_loc),b_p(npart_loc)
      real dIctdp(npart_loc)
      real df1(npart_loc),df2(npart_loc,npart_loc)
      real shift(npart_loc)
      real dfdIct,d2fdIct
      integer icycle,ic_l,ncycle_sc
      integer icent
      real cent,eps,obs2e,ss2
c
      integer ibin,ib1,ibb
c
      real Ict0,Ict1,del,del2,bulk_cont
      integer l,n1_l,ii
      real expbulks,bulk,bulk2,expbulk,cnt,snorm,d2fds2
      real dfdsc,d2fd2sc
      real part_expbs
      real sigma,sigma1
c
      integer np
      logical conv_sc,conv_line
      real c0,c1,fold,fnew
      real f0,f1,f2
      real al0,d1,a,b
      real lambd,lambd2,lambdmin,r1,r2,g2p,tmp,tst
      real l12
      real tol_conv
c
c---- Assumptions: all ls scale values have already been applied.
c
c---  Do minimisation in resolution bins
      tol_conv = 1.0E-5
      al0 = 1.0e-4
      ncycle_sc = 20
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
      write(*,*)'agyer get_obs_bins in ls_ml_pars'
      do ibin=1,nbin_ml
         icycle = 0
         conv_sc = .FALSE.
         do while(icycle.le.ncycle_sc.and. .not.conv_sc)
            icycle = icycle + 1
            sigma_ml(ibin) = 0.0
            nref_ml(ibin) = 0
c
c--   Recalculate sigmas where it is necessay
            do i=1,num_blocks
               ib1 = obs_bins(i)
               if(ib1.eq.ibin) then
                  if(freer(i).gt.0 .or. mlusework) then
                     o_s = block_start(i) + 1
                     o_f = block_start(i+1)
                     c_s = ref_2_asym_start(i) + 1
                     c_f = ref_2_asym_start(i+1)
                     jc = 0
                     do j=c_s,c_f
                        jc = jc + 1
                        a_all = scale_ml(ibin,1)*fcalc(1,j)
                        b_all = scale_ml(ibin,1)*fcalc(2,j)
                        do k=1,npart_act
                           a_all = a_all+scale_ml(ibin,k+1)*fpart(k,1,j)
                           b_all = b_all+scale_ml(ibin,k+1)*fpart(k,2,j)
                        enddo
                        Ic(jc) = a_all**2+b_all**2
                     enddo
c     
                     do j=o_s,o_f
                        o_c_s = obs_start(j) + 1
                        o_c_f = obs_start(j+1)
                        Ict0 = 0.0
                        do k=o_c_s,o_c_f
                           jc = ref_2_asym(k)
                           jal = comp_numb(k)
                           Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
                        enddo
c     
c---  another option for delta
                        del = (max(-2.0*iobs(2,j),iobs(1,j))-Ict0)/
     &                       (sqrt(max(0.0,iobs(1,j)))+sqrt(Ict0))
c     del = sqrt(max(0.0,iobs(1j)))-sqrt(Ict0))
                        sigma_ml_bin(ibin) = sigma_ml_bin(ibin) + 
     &                       del**2
                        nref_ml(ibin) = nref_ml(ibin) + 1
                     enddo
                  endif
               endif
            enddo
c--   Previous subroutines should have made sure that the number of reflections
c--   is more than 0
            sigma_ml(ibin) = 
     &           sigma_ml(ibin)/max(1,nref_ml(ibin))
c     
c--   Now refine scale parameters
            f1 = 0.0
            do i=1,num_blocks
               ibb = obs_bins(i)
               if(ibb.eq.ibin) then
                  sigma = sigma_ml(ibin)
                  o_s = obs_start(i)+1
                  o_f = obs_start(i+1)
                  c_s = ref_2_asym_start(i)+1
                  c_f = ref_2_asym_start(i+1)
                  np = c_f-c_s+1
                  jc = 0
                  do j=c_s,c_f
                     a_p(1) = fcalc(1,k)
                     b_p(1) = fcalc(2,k)
                     a_all = scale_ml(ibin,1)*a_p(1)
                     b_all = scale_ml(ibin,1)*b_p(1)
                     do ip=1,npart_act
                        a_p(ip+1) = fpart(ip,1,k)
                        b_p(ip+1) = fpart(ip,2,k)
                        a_all = a_all + scale_ml(ibin,ip+1)*a_p(ip+1)
                        b_all = b_all + scale_ml(ibin,ip+1)*b_p(ip+1)
                     enddo
                     Ic(jc) = a_all*a_all+b_all*b_all
                  enddo
c
                  do j=o_s,o_f
                     o_c_s = obs_start(j) + 1
                     o_c_f = obs_start(j+1)
                     Ict0 = 0.0
                     dIctdp(1:np) = 0.0
                     do k=o_c_s,o_c_f
                        jc = ref_2_asym(k)
                        jal = comp_numb(k)
                        Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
                        dIctdp(1:np) = dIctdp(1:np) + 
     &                       2.0*twin_frac(jal)*(a_all*a_p(1:np)+
     &                       b_all*b_p(1:np))
                     enddo
                     c0 = max(-3.0*iobs(2,j),iobs(1,j))-Ict0
                     c1 = sqrt(max(0.0*iobs(2,j),iobs(1,j)))+sqrt(Ict0) 
                     f1 = f1+0.5*(c0/c1)**2/sigma+ 
     &                    0.5*log(sigma)
                     dfdIct = (-1.0/c1-0.5*c0/(sqrt(Ict0)*c1**2))/sigma
                     d2fdIct = 1.0/sigma
                     df1(1:np) = df1(1:np) + dfdIct*dIctdp(1:np)
                     do ip=1,np
                        do jp=1,np
                           df2(ip,jp) = df2(ip,jp)+
     &                          d2fdIct*dIctdp(ip)*dIctdp(jp)
                        enddo
                     enddo
                  enddo
               endif
            enddo
         enddo
c
c---line minimise
         fold = f1
         call  eigen_filter_r90(toler,df2(1:np,1:np),
     &        np,np,df1(1:np),shift(1:np),ierr)
         g2p = dot_product(shift(1:np),df1(1:np))
c
c---  line minimise
         tst = 0.0
         do j=1,np
            tst = max(tst,abs(shift(j))/max(abs(scale_ml(ibin,j)),1.0))
         enddo
         lambdmin = tol_conv/tst
         lambd = 1.0
c
c---Find a sensible lambda
         conv_line = .FALSE.
         scale_ml0(1:np) = scale_ml(ibin,1:np)
         ic_l = 0
         do while(ic_l.le.100)
            ic_l = ic_l + 1
            do ip=1,np
               scale_ml(ibin,ip)=scale_ml0(ip)+
     &              lambd*shift(ip)
               scale_ml(ibin,ip) = max(0.01,scale_ml(ibin,ip))
               scale_ml(ibin,ip) = min(1.5,scale_ml(ibin,ip))
            enddo
c
c---  New value of the function
            do i=1,num_blocks
               ibb = obs_bins(i)
               if(ibb.eq.ibin) then
                  o_s = obs_start(i) + 1
                  o_f = obs_start(i+1)
                  c_s = ref_2_asym_start(i) + 1
                  c_f = ref_2_asym_start(i+1)
                  sigma = sigma_ml(ibin)
c     
                  jc = 0
                  do j=c_s,c_f
                     jc = jc + 1
                     a_all = scale_ml(ibin,1)*fcalc(1,j)
                     b_all = scale_ml(ibin,1)*fcalc(2,j)
                     do k=1,npart_act
                        a_all = a_all+scale_ml(ibin,k+1)*fpart(k,1,j)
                        b_all = b_all+scale_ml(ibin,k+1)*fpart(k,2,j)
                     enddo
                     Ic(jc) = a_all**2+b_all**2
                  enddo
c     
                  do j=o_s,o_f
                     o_c_s = obs_start(j) + 1
                     o_c_f = obs_start(j+1)
                     Ict0 = 0.0
                     do k=o_c_s,o_c_f
                        jc = ref_2_asym(k)
                        jal = comp_numb(k)
                        Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
                     enddo
c     
c---  another option for delta
                     del = (max(-2.0*iobs(2,j),iobs(1,j))-Ict0)/
     &                    (sqrt(max(0.0*iobs(2,j),iobs(1,j)))+
     &                    sqrt(Ict0))
                     f1 = f1 + 0.5*del**2/sigma + 0.5*log(sigma)
                  enddo
               endif
            enddo
c
            if(lambd.le.lambdmin) goto 20
            if(f1.le.fold+al0*lambd*g2p) goto 20
c
c---  Try new point and use interpolations
            if(j.eq.1) then
               tmp = -g2p/(2.0*(f1-fold-lambd*g2p))
            else
               l12 = lambd-lambd2
               r1 = f1-fold-lambd*g2p
               r2 = f2-fold-lambd2*g2p
               a  = (r1/lambd**2-r2/lambd2**2)/l12
               b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
               if(a.eq.0.0) then
                  tmp = -g2p/(2.0*b)
               else
                  d1 = max(0.0,b**2-3.0*a*g2p)
                  tmp = (-b+sqrt(d1))/(3.0*a)
               endif
            endif
            tmp = min(tmp,0.5*lambd)
            lambd2 = lambd
            f2 = f1
            lambd = max(tmp,0.1*lambd)
         enddo
         call errwrt(1,'Line minimisation failed')
 20      continue
c---  Check the convergence
         tst = 0.0
         do  j=1,np
            tst = max(tst,
     &           abs(shift(j))*lambd/max(abs(scale_ml0(j)),1.0))
         enddo
         tst = g2p*lambd/np
         if(tst.lt.tol_conv.or.f1.ge.fold) then 
            if(f1.gt.fold) then
               scale_ml(ibin,1:np) = scale_ml0(1:np)
            endif
            conv_sc = .TRUE.
         endif
      enddo
      deallocate(obs_bins)
      return
      end
c
      subroutine  ml_ml_pars(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer freer(num_blocks)
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
      real fmax(2,nasym)
c
c---  outputs
      integer ierr
c
c---locals
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      real, allocatable :: aniso_scales(:)
c
      integer nref_l
      real sigma_l
      real sigma_ml0(maxbin+1),scale_ml0(20)
      integer maxcont_l
      parameter (maxcont_l = 48)
      real fc1
      real  Ic(maxcont_l)
      real a_all,b_all,sinp,cosp
      real toler
      integer il
      integer i,j,m,k,jc,jal,is,ip,jp,ip1,iint
      integer o_s,o_f,c_s,c_f,c_n,o_c_s,o_c_f,c_1
      integer ierror
      logical error
c
      integer npart_loc
      parameter (npart_loc = 20)
      real a_p(npart_loc+1),b_p(npart_loc+1)
      real dfcdp(npart_loc+1)
      real dfdfc,d2fdfc
      real df1(npart_loc+1),df2(npart_loc+1,npart_loc+1)
      real shift(npart_loc)
      integer icycle,ncycle_sc
      integer icent
      real cent,eps,obs2e,ss2
c
      integer ibin,ib1,ibb
c
      real Ict0,Ict1,del,del2,bulk_cont
      integer l,n1_l,ii
      real expbulks,bulk,bulk2,expbulk,cnt,snorm,d2fds2
      real sigma,sigma1,xx,xx1,xx2
      real fom,fomprime
c
      integer jcycle
      integer np
      logical conv_sc,conv_line
      real c0,c1,fold,fnew
      real f0,f1,f2
      real al0,d1,a,b
      real lambd,lambd2,lambdmin,r1,r2,g2p,tmp,tst
      real l12,eps1
      real tol_conv
      real sim,fom_calc
      external sim,fom_calc
c
c---- Assumptions: all ls scale values have already been applied.
c
c---  Do minimisation in resolution bins
      toler = 1.0e-8
      tol_conv = 1.0E-4
      al0 = 1.0e-4
      ncycle_sc = 20
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)

      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)

      np = npart_act + 1
c      write(*,*)'in ml_ml_pars',nbin_ml,mlusework
c      write(*,*)sigma_ml(1:nbin_ml)
c      mlusework = .TRUE.
      do ibin=1,nbin_ml
         icycle = 0
         conv_sc = .FALSE.
         do while(icycle.le.ncycle_sc.and. .not.conv_sc)
            icycle = icycle + 1
            sigma_ml_bin(ibin) = 0.0
            nref_ml(ibin) = 0
            sigma = sigma_ml(ibin)
c
c--   Recalculate sigmas where it is necessay
            sigma_l = 0.0
            nref_l  = 0
            do i=1,num_blocks
               ib1 = obs_bins(i)
               if(ib1.eq.ibin) then
                  if(freer(i).eq.0 .or. mlusework) then
                     o_s = block_start(i) + 1
                     o_f = block_start(i+1)
                     c_s = ref_2_asym_start(i) + 1
                     c_f = ref_2_asym_start(i+1)
                     jc = 0
                     do j=c_s,c_f
                        c_n = block_2_asym(j)
                        if(fmax(1,c_n).gt.0.0) then
                           jc = jc + 1
                           a_all = scale_ml(ibin,1)*fcalc(1,c_n)
                           b_all = scale_ml(ibin,1)*fcalc(2,c_n)
                           do k=1,npart_act
                              a_all=
     &                           a_all+scale_ml(ibin,k+1)*fpart(k,1,c_n)
                              b_all=
     &                           b_all+scale_ml(ibin,k+1)*fpart(k,2,c_n)
                           enddo
                           Ic(jc)=(a_all**2+b_all**2)
                           fc1 = sqrt(Ic(jc))
c(aniso_scales(c_n)
                           eps1 = epsls(c_n)*(1+centrs(c_n))
                           xx = 2.0*fmax(1,c_n)*fc1/
     &                          (sigma*eps1)
                           fom = fom_calc(centrs(c_n),xx)
                           sigma_l = sigma_l + 
     &                        2.0*(fmax(1,c_n)**2+Ic(jc)-
     &                        2.0*fom*fmax(1,c_n)*fc1)/eps1
                           nref_l = nref_l + 2-centrs(c_n)
                        endif
                     enddo
                  endif
               endif
            enddo
c--   Previous subroutines should have made sure that the number of reflections
c--   is more than 0
            sigma_ml(ibin) = sigma_l/max(1,nref_l)
c            write(*,*)sigma_ml(ibin),sigma
c            stop
c     
c--   Now refine scale parameters
            fold = 0.0
            np = npart_act + 1
            df1(1:np) = 0.0
            df2(1:np,1:np) = 0.0
            sigma = sigma_ml(ibin)
            do i=1,num_blocks
               ibb = obs_bins(i)
               if(ibb.eq.ibin) then
                  o_s = block_start(i)+1
                  o_f = block_start(i+1)
                  c_s = ref_2_asym_start(i)+1
                  c_f = ref_2_asym_start(i+1)
c                  np = c_f-c_s+1
                  jc = 0
                  do j=c_s,c_f
                     jc = jc + 1
                     c_n = block_2_asym(j)
                     if(fmax(1,c_n).gt.0.0) then
                        a_p(1) = fcalc(1,c_n)
                        b_p(1) = fcalc(2,c_n)
                        a_all = scale_ml(ibin,1)*a_p(1)
                        b_all = scale_ml(ibin,1)*b_p(1)
                        do ip=1,npart_act
                           a_p(ip+1) = fpart(ip,1,c_n)
                           b_p(ip+1) = fpart(ip,2,c_n)
                           a_all = a_all + scale_ml(ibin,ip+1)*a_p(ip+1)
                           b_all = b_all + scale_ml(ibin,ip+1)*b_p(ip+1)
                        enddo
                        Ic(jc) = a_all*a_all+b_all*b_all
                        fc1 = sqrt(Ic(jc))
                        sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
                        xx = 2.0*fmax(1,c_n)*fc1/sigma1
                        fom = fom_calc(centrs(c_n),xx)
                        fold = fold + (fmax(1,c_n)**2+Ic(jc))/sigma1
                        if(centrs(c_n).eq.0) then
                           call bessi0(xx,xx2,xx1)
                           fold = fold - xx1 - log(xx2) - 
     &                          log(fmax(1,c_n)) + log(sigma)
                           if(xx.eq.0.0) then
                              fomprime = 0.5
                           else
                              fomprime = 0.5-fom/xx-fom**2
                           endif
                        else
                           if(xx.gt.30) then
                              xx1 = xx
                              xx2 = 0.5
                           else
                              xx1 = 0.0
                              xx2 = cosh(xx)
                           endif
                           fomprime = 1.0 - fom**2
                           fold = fold - xx1 - log(xx2) + log(sigma)/2
                        endif
                        sinp = 0.0
                        cosp = 0.0
                        if(fc1.gt.0.0) then
                           cosp = a_all/fc1
                           sinp = b_all/fc1
                        endif
                        dfcdp(1:np) = cosp*a_p(1:np)+sinp*b_p(1:np)
                        dfdfc = (fc1-fom*fmax(1,c_n))/sigma1
                        d2fdfc = 1/sigma1
c
c---  could add 2.0*fomprime*(fmax(j)/sigma1)**2
                        df1(1:np) = df1(1:np) + dfdfc*dfcdp(1:np)
                        do ip=1,np
                           do jp=1,np
                              df2(ip,jp)=df2(ip,jp)+
     &                             d2fdfc*dfcdp(ip)*dfcdp(jp)
                           enddo
                        enddo
                     endif
                  enddo
               endif
            enddo
c
c---line minimise
            call  eigen_filter_r90(toler,df2(1:np,1:np),
     &           np,np,df1(1:np),shift(1:np),ierr)
            g2p = dot_product(shift(1:np),df1(1:np))
c     
c---  line minimise
            tst = 0.0
            do j=1,np
               tst = 
     &            max(tst,abs(shift(j))/max(abs(scale_ml(ibin,j)),1.0))
            enddo
            lambdmin = tol_conv/tst
            lambd = 1.0
c
c---  Find a sensible lambda
            conv_line = .FALSE.
            scale_ml0(1:np) = scale_ml(ibin,1:np)
            jcycle = 0
            do while(jcycle.le.100)
               jcycle = jcycle + 1
               do ip=1,np
                  scale_ml(ibin,ip)=scale_ml0(ip) -
     &                 lambd*shift(ip)
                  scale_ml(ibin,ip) = max(0.01,scale_ml(ibin,ip))
                  scale_ml(ibin,ip) = min(1.5,scale_ml(ibin,ip))
               enddo
c
c---  New value of the function
               f1 = 0.0
               do i=1,num_blocks
                  ibb = obs_bins(i)
                  if(ibb.eq.ibin) then
                     o_s = block_start(i) + 1
                     o_f = block_start(i+1)
                     c_s = ref_2_asym_start(i) + 1
                     c_f = ref_2_asym_start(i+1)
c     
                     jc = 0
                     do j=c_s,c_f
                        jc = jc + 1
                        c_n = block_2_asym(j)
                        if(fmax(1,c_n).gt.0.0) then
                           a_all = scale_ml(ibin,1)*fcalc(1,c_n)
                           b_all = scale_ml(ibin,1)*fcalc(2,c_n)
                           do k=1,npart_act
                              a_all=
     &                          a_all+scale_ml(ibin,k+1)*fpart(k,1,c_n)
                              b_all=
     &                          b_all+scale_ml(ibin,k+1)*fpart(k,2,c_n)
                           enddo
                           Ic(jc) = a_all*a_all+b_all*b_all
                           fc1 = sqrt(Ic(jc))
                           sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
                           xx = 2.0*fmax(1,c_n)*fc1/sigma1
                           f1 = f1 + (fmax(1,c_n)**2+Ic(jc))/sigma1
                           if(centrs(c_n).eq.0) then
                              call bessi0(xx,xx2,xx1)
                              f1 = f1 - xx1 - log(xx2) -
     &                             log(fmax(1,c_n)) + log(sigma)
                           else
                              if(xx.gt.30) then
                                 xx1 = xx
                                 xx2 = 0.5
                              else
                                 xx1 = 0.0
                                 xx2 = cosh(xx)
                              endif
                              f1 = f1 - xx1 - log(xx2) + log(sigma)/2
                           endif
                        endif
                     enddo
c   
                  endif
               enddo
c
c               write(*,*)fold,f1,lambd,g2p,scale_ml(1:np,ibin)
               if(lambd.le.lambdmin) goto 20
               if(f1.le.fold-al0*lambd*g2p) goto 20
c     
c---  Try new point and use interpolations
               if(jcycle.eq.1) then
                  tmp = -g2p/(2.0*(f1-fold+lambd*g2p))
               else
                  l12 = lambd-lambd2
                  r1 = f1-fold+lambd*g2p
                  r2 = f2-fold+lambd2*g2p
                  a  = (r1/lambd**2-r2/lambd2**2)/l12
                  b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
                  if(a.eq.0.0) then
                     tmp = g2p/(2.0*b)
                  else
                     d1 = max(0.0,b**2+3.0*a*g2p)
                     tmp = (-b+sqrt(d1))/(3.0*a)
                  endif
               endif
               tmp = min(tmp,0.5*lambd)
               lambd2 = lambd
               f2 = f1
               lambd = max(tmp,0.1*lambd)
            enddo
            call errwrt(1,'Line minimisation failed')
 20         continue
c---  Check the convergence
            tst = 0.0
            do  j=1,np
               tst = max(tst,
     &              abs(shift(j))*lambd/max(abs(scale_ml0(j)),1.0))
            enddo
            tst = g2p*lambd/np
            if(tst.lt.tol_conv.or.f1.ge.fold) then 
               if(f1.gt.fold) then
                  scale_ml(ibin,1:np) = scale_ml0(1:np)
               endif
               conv_sc = .TRUE.
            endif
         enddo
      enddo
c
      deallocate(obs_bins)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
c
      subroutine apply_scales_ls_twin(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,ierr)
      implicit none
c
c---  Apply the results of ls scaling to fcalc. Aniso is not applied
c---  It is much more complicated to apply aniso in the presence of 
c---  twinning. But for map calculation it can be taken off.
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer freer(num_blocks)
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c---  outputs
      integer ierr
c
c---  locals
      integer o_s,o_f,c_s,c_f,c_n,o_c_s,o_c_f,c_1

      integer i,j,ip
      real ss,bulk,sc,scp
      real lstlsq_r
      external lstlsq_r
c
c---body
      do i=1,nasym
         ss = lstlsq_r(1,hkl_asym(1:3,i))
         bulk = 1.0-scale_ls_bulk*exp(-b_ls_bulk*ss)
c         bulk = 1.0
         sc = scale_ls_over*exp(-b_ls_over*ss)*bulk
         sc = sqrt(sc)
c         sc = 1.0
         fcalc(1:2,i) = sc*fcalc(1:2,i)
         do ip=1,npart_act
            scp = sc*scale_ls_part(ip)*exp(-b_ls_part(ip)*ss)
            fpart(ip,1:2,i) = scp*fpart(ip,1:2,i)
         enddo
      enddo
c
      return
      end
c
      subroutine get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer obs_bins(num_blocks)
      integer ierr
c
      integer ibin,i
      integer o_s,o_f,c_s,c_f,c_1
      real rsq,stl_c
c
      real lstlsq_r
      external lstlsq_r
c
c---  body
      obs_bins(1:num_blocks) = 0
      do i=1,num_blocks
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,c_1))
         stl_c = sqrt(rsq)
         do ibin=1,nbin_ml
            if(stl_c.ge.sminb_ml(ibin).and.stl_c.le.smaxb_ml(ibin))
     &           then
               obs_bins(i) = ibin
               goto 50
            endif
         enddo
c         write(*,*)stl_c,sminb_ml(1),smaxb_ml(nbin_ml)
c         stop
         if(stl_c.le.sminb_ml(1)) obs_bins(i) = 1
         if(stl_c.ge.smaxb_ml(nbin_ml)) obs_bins(i)=nbin_ml
 50      continue
      enddo
      return
      end
c
      subroutine get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      real freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer epsls(nasym),centrs(nasym)
      real epsi
      integer ierr
c
c---locals
      integer i,isysab
c
c---body
      do i=1,nasym
         call epslon(hkl_asym(1:3,i),epsi,isysab)
         epsls(i) = epsi
         call centr(hkl_asym(1:3,i),centrs(i))
      enddo
      
      return
      end
c
      subroutine aniso_contrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     aniso_scales,
     &     ierr)
      implicit none
c
c---  Calculate contributions of anisotropic scales to each reflection in the
c---  asymmetric unit
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      real aniso_scales(nasym)
      integer ierr
c
c---  locals
      integer i,is
      real hkl_r(3),hkl_s(3),s(3)
      real sbs
      real ss,sc_p
      real lstlsq_r
      external lstlsq_r
c
c---  body
      do i=1,nasym
         aniso_scales(i) = 0.0
         ss = lstlsq_r(1,hkl_asym(1:3,i))
         sc_p = scale_ls_over*exp(-b_ls_over*ss)
         sc_p = sc_p*(1.0-scale_ls_bulk*exp(-b_ls_bulk*ss))

         do is=1,nsym
            hkl_r(1:3) = float(hkl_asym(1:3,i))
            hkl_s(1:3) = matmul(transpose(rot(1:3,1:3,is)),hkl_r(1:3))
            s(1:3) = matmul(transpose(rfr),hkl_s)
            sbs =     s(1)**1*  b_ls_aniso_over(1)+
     &                s(2)**2*  b_ls_aniso_over(2)+
     &                s(3)**2*  b_ls_aniso_over(3)+ 
     &           2.0*(s(1)*s(2)*b_ls_aniso_over(4)+
     &                s(1)*s(3)*b_ls_aniso_over(5)+
     &                s(2)*s(3)*b_ls_aniso_over(6))
            aniso_scales(i) = aniso_scales(i) + exp(-sbs/4.0)
         enddo
         aniso_scales(i) = aniso_scales(i)/nsym
      enddo

      return
      end
