      subroutine decide_twin_operators(input_file)
      implicit none
      include 'twin_refmac.fh'
      include 'restr_files.fh'
      character input_file*(*)
c
      integer ncomp,nasym
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: nref_comp(:)
      integer, allocatable :: hkl_comp(:,:)
      integer, allocatable :: comp_number(:)
      integer, allocatable :: refer_2_asym(:)
      integer, allocatable :: refer_2_symm(:)
      real, allocatable :: iobs(:,:)
      integer, allocatable :: free_refl(:)
c
      integer nobs1,ncomp1
c
      integer in_file
      integer i,itw,ierr
      character text_loc*128
      integer ntwin_domain_save
      real twin_oper_save(3,3,48),rot_l(3,3),tr_l(3)
      real r_merge(48)
c
c---  body
      if(twin_user_flag) return
      if(ntwin_domain.le.1) return
c
c---  Asymmetric unit
      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
      do i=1,nasym
         read(in_file)hkl_asym(1:3,i)
      enddo
      close(in_file)
c
      twin_oper_save(1:3,1:3,1:ntwin_domain) =
     &     twin_oper(1:3,1:3,1:ntwin_domain)
      ntwin_domain_save = ntwin_domain

      r_merge(1) = 0.0
      ntwin_domain = 2
      call read_refl_size(input_file,nobs1)
      ncomp1 = nobs1*ntwin_domain

      do itw=2,ntwin_domain_save
         allocate(iobs(2,nobs1))
         allocate(nref_comp(nobs1+1))
         allocate(hkl_comp(3,ncomp1))
         allocate(comp_number(ncomp1))
         allocate(free_refl(nobs1))
         twin_oper(1:3,1:3,2:2) = twin_oper_save(1:3,1:3,itw:itw)
         call read_refl_twin(input_file,nobs1,ncomp1,iobs,
     &        nref_comp,hkl_comp,comp_number,free_refl,
     &        ierr)      
c
c
c---  if twin operators defined by the program then check if potential twins
c---  are really twin. Calculate rmerge if it is more than 50 then 
c---  very likely not to be twin
         ncomp = ncomp1
c
c--Now we have read reflections with their potential comoponents
c--Components are twin domains. Now we are ready to organise observations
         allocate(refer_2_asym(ncomp1))
         allocate(refer_2_symm(ncomp1))
         call find_refer2asym(ncomp,hkl_comp,refer_2_asym,
     &        refer_2_symm,nasym,hkl_asym,ierr)
         

         deallocate(hkl_comp)
         call block_organise_observ(ncomp1,comp_number,refer_2_asym,
     &        refer_2_symm,nobs1,iobs,free_refl,nref_comp,
     &        nasym,hkl_asym,
     &        refl_file,ierr)
         deallocate(iobs)
         deallocate(nref_comp)
         deallocate(comp_number)
         deallocate(free_refl)

         deallocate(refer_2_symm)
         deallocate(refer_2_asym)
         call calculate_rmerge(r_merge(itw))
         rmerge_obs(itw) = r_merge(itw)
      enddo
      deallocate(hkl_asym)
c
      ntwin_domain = 1
      tr_l(1:3) = 0.0
      do itw=2,ntwin_domain_save
         rot_l(1:3,1:3) = twin_oper_save(1:3,1:3,itw)/12.0
         call put_symm_to_text(rot_l,tr_l,text_loc)

         if(r_merge(itw).ge.0.50) then
            write(*,*)'Symmetry operator :',trim(text_loc),
     &           '; R_merge =',r_merge(itw),'; Twin is unlikely '

         elseif(r_merge(itw).le.0.10) then
            write(*,*)'Symmetry operator= ',trim(text_loc),
     &           ' R_merge=',r_merge(itw),': twin or higher symmetry '
            ntwin_domain = ntwin_domain + 1
            twin_oper(1:3,1:3,ntwin_domain) = 
     &           twin_oper_save(1:3,1:3,itw)
c
c--   very strong twin or higher space group
         else
            write(*,'(a,a,a,f5.3,a)')
     &           'Symmetry operator= ',trim(text_loc),
     &           '; R_merge =',r_merge(itw),': twin is probable '
            ntwin_domain = ntwin_domain + 1
            twin_oper(1:3,1:3,ntwin_domain) = 
     &           twin_oper_save(1:3,1:3,itw)
         endif
      enddo

      return
      end
c
      subroutine calculate_rmerge(r_merge)
      implicit none
      include 'celsym.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'

      real r_merge
c
      integer nobs,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: iobs(:,:)
c
      integer i,ib,in_file,ierr
      integer ii,io1,kk,ko1,jo1,jj,io,jnum_o
      integer o_s,o_f,c_s,c_f
      integer nobs_block,nobs_block1
      real r_merge0,iaver
c
c---  body
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c     
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(iobs(2,nobs))
      allocate(obs_start(nobs+1))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      num_list = num_blocks
c
c---  How many fractions do we have. Need to be stored somewhere.
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
c            iobs(1:2,ii) = iobs(1:2,ii)/scale_ls_init
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c---  Consider calculating moments, correlations and other things

      r_merge = 0.0
      r_merge0 = 0.0
c
c---  Use robust stats like rank correlation etc
c
c---  Bootstrap??
      do ib=1,num_blocks
         o_s = block_start(ib) + 1
         o_f = block_start(ib+1)
         c_s = ref_2_asym_start(ib) + 1
         c_f = ref_2_asym_start(ib+1)
         if(c_f-c_s.gt.0) then
            iaver = 0.0
            nobs_block = o_f-o_s + 1
            nobs_block1 = nobs_block-nobs_block-1
            do i=o_s,o_f
               iaver = iaver + iobs(1,i)
            enddo
            iaver = iaver/nobs_block
            do i=o_s,o_f
               r_merge = r_merge + abs(iobs(1,i)-iaver)/nobs_block
               r_merge0 = r_merge0 + iobs(1,i)/nobs_block
            enddo
         endif
      enddo
c      write(*,*)r_merge,r_merge0
c      stop
      r_merge = r_merge/r_merge0
c
c---  deallocate
      deallocate(freer)
      deallocate(block_start)
      deallocate(ref_2_asym_start)
      deallocate(iobs)
      deallocate(obs_start)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)      
      return
      end
c
      subroutine decide_twin_opers_1(nasym,hkl_asym,fc)
      implicit none
      include 'twin_refmac.fh'
      integer nasym
      integer hkl_asym(3,nasym)
      real fc(2,nasym)
c
      integer, allocatable :: hkl_all(:,:)
      integer, allocatable :: refer_2_fc(:)
      integer hkl_out(3),hkl0(3),hkl1(3)
c
      integer itw,i,ir,ic,nelem,ndiff,ir1,ir2,itemp
      real rdiff,raver,io1,io2
c
c---  body
      if(ntwin_domain.le.1) return
      allocate(hkl_all(3,2*nasym))
      allocate(refer_2_fc(2*nasym))
      rmerge_calc(1) = 0.0
      do itw=2,ntwin_domain
         hkl_all(1:3,1:nasym) = hkl_asym(1:3,1:nasym)
         ic = nasym
         do ir=1,nasym
            refer_2_fc(ir) = ir
            hkl0 = matmul(transpose(twin_oper(1:3,1:3,itw)),
     &           hkl_asym(1:3,ir))
            hkl1(1:3) = hkl0(1:3)/12
            if(maxval(abs(12*hkl1(1:3)-hkl0(1:3))).eq.0) then
               ic = ic + 1
               hkl_all(1:3,ic) =hkl1(1:3)
               refer_2_fc(ic) = ir
            endif
         enddo
         nelem = ic
         do ir=1,nelem
            call hkl_2_asym(hkl_all(1:3,ir),hkl_out(1:3))
            hkl_all(1:3,ir) = hkl_out(1:3)
         enddo
         do ir=1,nelem
            itemp = hkl_all(1,ir)
            hkl_all(1,ir) = hkl_all(3,ir)
            hkl_all(3,ir) = itemp
         enddo
         call iheap_sort_r(nelem,3,hkl_all(1:3,1:nelem),
     &        refer_2_fc(1:nelem))
         do ir=1,nelem
            itemp = hkl_all(1,ir)
            hkl_all(1,ir) = hkl_all(3,ir)
            hkl_all(3,ir) = itemp
         enddo
         ir = 1
         ndiff = 0
         rdiff = 0.0
         raver = 0.0
         do while(ir.lt.nelem)
            if(maxval(abs(hkl_all(1:3,ir)-hkl_all(1:3,ir+1))).eq.0) 
     &           then
               ir1 = refer_2_fc(ir)
               ir2 = refer_2_fc(ir+1)
               if(ir1.ne.ir2) then
                  io1 = fc(1,ir1)**2+fc(2,ir1)**2
                  io2 = fc(1,ir2)**2+fc(2,ir2)**2
                  rdiff = rdiff + abs(io1-io2)
                  raver = raver + (abs(io1)+abs(io2))
                  ndiff = ndiff + 1
               endif
            endif
            ir = ir + 1
         enddo
         if(ndiff.gt.0) then
            rmerge_calc(itw) = rdiff/raver
         endif
      enddo
      do itw=1,ntwin_domain
         write(*,*)nasym,ndiff,itw,rmerge_obs(itw),rmerge_calc(itw)
      enddo
c      stop
      deallocate(refer_2_fc)
      deallocate(hkl_all)
      return
      end
c
      subroutine decide_twin_opers_fcalc
      implicit none
      include 'twin_refmac.fh'
      include 'celsym.fh'
c
      integer ndens
      logical filtered
c
      integer itw,itw1
      real tw_max
      real rot_l(3,3),tr_l(3),rot_l1(3,3)
      character text_loc*512
      integer ll
      character line*512
c
      integer is
      integer nprim_symm
      real rot_p(3,3,192),tr_p(1:3,1:3,192)
c
      if(.not.twin_flag.or.twin_user_flag.or.
     &     ntwin_domain.eq.1) return
c
c--Find all primitive symmetry elements
      call find_prim_symm(maxsym,nsym,nprim_symm,rot,tr,rot_p,tr_p)

      ndens = 1
      call sfcalc_and_scale_twin(ndens)
      call filter_out_small_tdomains(filtered)
      write(*,*)'---------------------------------------------------'
      call header(' Twin operators with estimated twin fractions')
      do itw=1,ntwin_domain
         rot_l(1:3,1:3) = float(twin_oper(1:3,1:3,itw))/12.0
         tr_l(1:3) = 0.0
         call put_symm_to_text(rot_l,tr_l,text_loc)
c
c---Generate all equivalent twin operators
         write(line,'(a,a15,a,48f4.3)')'Twin operator: ',trim(text_loc),
     &        '; Fraction = ',twin_frac(itw)
         if(nprim_symm.gt.1) then
            ll = len_trim(line)+1
            write(line(ll:),'(a)')'; Equivalent operators: '
            do is=2,nprim_symm
               rot_l1 = matmul(rot_l(1:3,1:3),rot_p(1:3,1:3,is))
               call put_symm_to_text(rot_l1,tr_l,text_loc)
               ll = len_trim(line)+1
               write(line(ll:),'(a15)')trim(text_loc)
               if(is.lt.nprim_symm) then
                  ll = len_trim(line)+1
                  write(line(ll:),'(a1)')';'
               endif
            enddo
         endif
         write(*,'(a)')trim(line)

      enddo
      if(twin_frac(1)*ntwin_domain.lt.0.97) then
         write(*,*)
         do itw=1,ntwin_domain
            if(tw_max.lt.twin_frac(itw)) then
               itw1 = itw
               tw_max = twin_frac(itw)
            endif
         enddo
         rot_l(1:3,1:3) =twin_oper(1:3,1:3,itw1)/12.0
         tr_l(1:3) = 0.0
         call put_symm_to_text(rot_l,tr_l,text_loc)
         write(*,*)'Consider reindexing. Major domain corresponds to ',
     &        'the operator ',trim(text_loc)
      endif
      write(*,*)'--------------------------------------------------'
      write(*,*)
c      stop
      return
      end
c
      subroutine filter_out_small_tdomains(filtered)
      implicit none
      include 'atom_com.fh'
      include 'twin_refmac.fh'

      logical filtered
c
c--   locals
      integer i,is,itw,itw1,itw2,itw3
      integer ntwin_domain_save
      integer twin_oper_save(3,3,48),rot_l(3,3),tr_l(3)
      integer inv_twin(3,3,48)
      integer trace_m
      integer iflag_twin(48),rot_l1(3,3),rot_l2(3,3)
      integer irot_c(3,3,192)
      real twin_sum
c
      logical change_flag
c
c---  body
      filtered = .FALSE.
      if(ntwin_domain.eq.1.or.twin_user_flag) return
      irot_c(1:3,1:3,1:cs_nsym) = nint(cs_m_cs(1:3,1:3,1:cs_nsym)*12.0)
      twin_oper_save(1:3,1:3,1:ntwin_domain) =
     &     twin_oper(1:3,1:3,1:ntwin_domain)
      ntwin_domain_save = ntwin_domain

c      ntwin_domain = 1
      iflag_twin(1:ntwin_domain) = 1
      do i=2,ntwin_domain_save
         if(twin_frac(i).le.small_twin_frac) then
            filtered = .TRUE.
            iflag_twin(i) = -1
         endif
      enddo
c
      if(.not.filtered) return
      do itw=1,ntwin_domain
         rot_l(1:3,1:3) = float(twin_oper(1:3,1:3,itw))/12
         rot_l1 = matmul(rot_l,cs_ort_to_frac)
         rot_l2 = transpose(rot_l)
         rot_l = matmul(rot_l,cs_frac_to_ort)
         inv_twin(1:3,1:3,itw) = nint(rot_l(1:3,1:3)*12.0)
      enddo
c     
c
c---make sure that we have group if we hadd twin operators to crystal symmetry
      change_flag = .TRUE.
      do while(change_flag)
         change_flag = .FALSE.
         do itw1 = 1,ntwin_domain
            if(iflag_twin(itw1).eq.1) then
               do itw2 = 1,ntwin_domain
                  if(iflag_twin(itw2).eq.1) then
                     rot_l(1:3,1:3) = matmul(twin_oper(1:3,1:3,itw1),
     &                    twin_oper(1:3,1:3,itw2))/12
                     do is=1,cs_nsym
                        rot_l1 = matmul(irot_c(1:3,1:3,is),
     &                       rot_l(1:3,1:3))/12
                        do itw3=1,ntwin_domain
                           rot_l2 = matmul(rot_l1(1:3,1:3),
     &                         inv_twin(1:3,1:3,itw3))/12
                           trace_m = rot_l2(1,1)+rot_l2(2,2)+rot_l2(3,3)
                           trace_m = trace_m/12 - 3
                           if(trace_m.eq.0) then
                              if(iflag_twin(itw3).eq.-1) then
                                 change_flag = .TRUE.
                                 iflag_twin(itw3) = 1
                              endif
                           endif
                        enddo
                     enddo
                  endif
               enddo
            endif
         enddo
      enddo
      ntwin_domain = 0
      filtered = .FALSE.
      do itw=1,ntwin_domain_save
         if(iflag_twin(itw).eq.1) then
            ntwin_domain = ntwin_domain + 1
            twin_oper(1:3,1:3,ntwin_domain) = 
     &           twin_oper_save(1:3,1:3,itw)
            twin_frac(ntwin_domain) = twin_frac(itw)
         else
            filtered = .TRUE.
         endif
      enddo
c
      if(.not.filtered) return
c
c---  Report about sruviving operators
      twin_sum = sum(twin_frac(1:ntwin_domain))
      twin_frac(1:ntwin_domain) = twin_frac(1:ntwin_domain)/twin_sum
      call reorganise_twin_data
      call twin_define_reso_bins_etc

c      stop
c
c---  Report decision made by this routine

      return
      end
c
      subroutine reorganise_twin_data
      implicit none
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
c---  reorginse data with given input reflection file, list of asymmetric unit
c---  and twin operators
c
      integer nobs1,ncomp,ncomp1,nasym
      real, allocatable :: iobs(:,:)
      integer, allocatable :: nref_comp(:)
      integer, allocatable :: hkl_comp(:,:)
      integer, allocatable :: comp_number(:)
      integer, allocatable :: free_refl(:)
      integer, allocatable :: refer_2_asym(:)
      integer, allocatable :: refer_2_symm(:)
      integer, allocatable :: hkl_asym(:,:)
c
      integer i
      integer in_file
      integer ierr
      character input_file*512
c
c---  body
      input_file = input_orig_data

      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
      do i=1,nasym
         read(in_file)hkl_asym(1:3,i)
      enddo
      close(in_file)


      call read_refl_size(input_file,nobs1)
      ncomp1 = nobs1*ntwin_domain
      allocate(iobs(2,nobs1))
      allocate(nref_comp(nobs1+1))
      allocate(hkl_comp(3,ncomp1))
      allocate(comp_number(ncomp1))
      allocate(free_refl(nobs1))
      call read_refl_twin(input_file,nobs1,ncomp1,iobs,
     &     nref_comp,hkl_comp,comp_number,free_refl,
     &     ierr) 
      ncomp = ncomp1
      allocate(refer_2_asym(ncomp1))
      allocate(refer_2_symm(ncomp1))
      call find_refer2asym(ncomp,hkl_comp,refer_2_asym,
     &     refer_2_symm,nasym,hkl_asym,ierr)
      
      deallocate(hkl_comp)
      call block_organise_observ(ncomp1,comp_number,refer_2_asym,
     &     refer_2_symm,nobs1,iobs,free_refl,nref_comp,
     &     nasym,hkl_asym,
     &     refl_file,ierr)
      
      deallocate(iobs)
      deallocate(refer_2_symm)
      deallocate(refer_2_asym)
      deallocate(nref_comp)
      deallocate(comp_number)
      deallocate(free_refl)
      deallocate(hkl_asym)

      return
      end
      
