C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C

C TODO
C 1) many contributions to 2nd derivative are missing
C 2) libration has effect on bondlength 

      SUBROUTINE TLS_REFINE
      IMPLICIT NONE
C
C---Refinement of TLS parameters

C   Note we don't want to apply U restraints when just TLS.
C   Restraints are in BREF, RIGID_BOND, BSPHERE_RESTR which are
C   called from GEOM.

C   TLS tensors are held in TMAT(6,MAXTLSGRP),LMAT(6,MAXTLSGRP),SMAT(8,MAXTLSGRP)
C   in orthogonal coordinates in A and radians (though radians are converted
C   to degrees on input/output).
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'const.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'save_all_params.fh'
      include 'mtz_things.fh'
c
c      INTEGER MCOLS
c      PARAMETER (MCOLS = 200)
c      INTEGER NLPRGI,NLPRGO,LOOKUP(MCOLS)
c      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
C---Local variables
C
      INTEGER IWRITE_FIRST,IANALYSE_REST,nmodel
      INTEGER IL_MIN
      integer igr
      INTEGER J,I,IA,ICYCL,IDOM,NTLSGRP20,IPAR,im
      INTEGER IFLAG,NTRY_THIS,ITR
      REAL ALPHA
      REAL TEMP_LOCAL,TLS_TRACE
      INTEGER NWORK_TLS
      PARAMETER (NWORK_TLS = 200)
      REAL*8 WORKSPACE(NWORK_TLS)
      integer jj,i1,i2
      REAL*8 SHIFTWGT,max_ldiag,max_lthis,sthis
      REAL*8 TOLER
      REAL ALP1,ALP2,DOT1_R
      REAL FXRAY_OLD
      real tmin_l
      LOGICAL ERROR
      CHARACTER MON_STYLE_SAVE*4
      LOGICAL LREFIN_SAVE,LINITIAL
      EXTERNAL DOT1_R
C---Define and initialise tls groups
c
c---  allocatable arrays for tls refinement
      real*8, allocatable :: gx_tls(:,:)
      real*8, allocatable :: hx_tls(:,:,:)
      real*8, allocatable :: shft_tls(:,:)
      real, allocatable :: tmat_save(:,:)
      real, allocatable :: lmat_save(:,:)
      real, allocatable :: smat_save(:,:)
c
c---  body
      CALL TLS_INIT
      call make_l_positive(tmin_l)
      call add_tmin_to_u(tmin_l)
      TOLER = 0.5D-7
c assuming one model only. may implement more models later.
      nmodel = 1
      im = 1
      shiftwgt = 1.0
      allocate(gx_tls(ntlsgrp,20))
      allocate(hx_tls(ntlsgrp,20,20))
      allocate(shft_tls(ntlsgrp,20))
      allocate(tmat_save(6,ntlsgrp))
      allocate(lmat_save(6,ntlsgrp))
      allocate(smat_save(8,ntlsgrp))


C---Calcalate A matrices for particular set of orthogonal coordinates
C   obtained from XORT0(3,MAXATOM). Elements of A are orthogonal coordinates
C   w.r.t. TLS orgins, and are placed back in XORT0(3,MAXATOM).
c      CALL CALC_AMAT

C---Calculate initial U matrices from initial TLS parameters
C   and (total) isotropic values.
      LINITIAL = .TRUE.
      CALL TLS2ANISOU(LINITIAL)
C
      MON_STYLE_SAVE = MON_STYLE
      NTLSGRP20 = NTLSGRP*20
      DO    ICYCL=1,NTLS_CYCLE
         IF(ICYCL.NE.1.AND.MON_STYLE.NE.'NONE'.AND.
     &                     MON_STYLE.NE.'MANY') MON_STYLE = 'FEW'
         IF(ICYCL.EQ.NTLS_CYCLE) MON_STYLE=MON_STYLE_SAVE
         IF (MON_STYLE.NE.'NONE') THEN
          WRITE(6,'(/,/,A,I4,/)') ' ***TLS refinement cycle*** ',ICYCL
         ENDIF
C
C---Calculate derivatives wrt individual atomic displacement parameters
         hcalc = .TRUE.
         gradc = .TRUE.
         CALL REFALL(nmodel)
         CALL REPORT_XRAY_STATS
         FXRAY_OLD = FXRAY
cd         ALL_SCALES_FLAG = .FALSE.
C
C---Testing only

         IF (MON_STYLE.EQ.'MANY') THEN
          WRITE(6,'(/,/,A,F12.3,/)') ' **X-ray residual** ',FXRAY
         ENDIF
C
C---Calculate derivatives wrt TLS parameters using chain rule
         CALL DERIVS_OF_TLS(gx_tls,hx_tls)
C
C---Solve linear equations using singular value decomposition
C
C---Add more conditioning and analysis
         max_ldiag = 0.0
         do jj=1,ntlsgrp
            CALL  DEIGEN_FILTER_R(TOLER,HX_TLS(jj,1:20,1:20),20,20,
     &           GX_TLS(jj,1:20),SHFT_TLS(jj,1:20),WORKSPACE,NWORK_TLS)
            max_ldiag = max(max_ldiag,maxval(abs(shft_tls(jj,7:9))))
         enddo
         max_ldiag = max_ldiag*rtodeg**2*shiftwgt
         if(max_ldiag.gt.5.0) shiftwgt = shiftwgt/2.0
         tmat_save(1:6,1:ntlsgrp) = tmat(1:6,1:ntlsgrp)
         lmat_save(1:6,1:ntlsgrp) = lmat(1:6,1:ntlsgrp)
         smat_save(1:8,1:ntlsgrp) = smat(1:8,1:ntlsgrp)
C
         do idom=1,ntlsgrp
            max_lthis = maxval(lmat(1:3,idom)+shft_tls(idom,7:9))
            if(max_lthis*rtodeg**2.gt.10.0) then
               sthis = 0.2
            else
               sthis = 1.0
            endif
            shft_tls(idom,1:20) = shft_tls(idom,1:20)*shiftwgt*sthis
            tmat(1:6,idom) = tmat_save(1:6,idom)+shft_tls(idom,1:6)
            lmat(1:6,idom) = lmat_save(1:6,idom)+shft_tls(idom,7:12)
            smat(1:8,idom) = smat_save(1:8,idom)+shft_tls(idom,13:20)
         enddo

         HCALC = .FALSE.
         GRADC = .FALSE.
         call SAVE_ALL_PARAMS('S',nmodel)
         DO IL_MIN=1,5
            call SAVE_ALL_PARAMS('R',nmodel)
            call make_l_positive(tmin_l)
            call add_tmin_to_u(tmin_l)
            call tls2anisou(linitial)
            call refall(nmodel)
c            write(*,*)fxray,fxray_old
            if(fxray.gt.fxray_old) then
c               write(*,*)shiftwgt*sthis*0.5
               shft_tls(1:ntlsgrp,1:20) = shft_tls(1:ntlsgrp,1:20)/2.0d0
               do igr=1,ntlsgrp
                  tmat(1:6,igr)=tmat_save(1:6,igr)+shft_tls(igr,1:6)
                  lmat(1:6,igr)=lmat_save(1:6,igr)+shft_tls(igr,7:12)
                  smat(1:8,igr)=smat_save(1:8,igr)+shft_tls(igr,13:20)
               enddo
               goto 10
            endif
            goto 20
 10         continue
         enddo
         tmat(1:6,1:ntlsgrp) = tmat_save(1:6,1:ntlsgrp)
         lmat(1:6,1:ntlsgrp) = lmat_save(1:6,1:ntlsgrp)
         smat(1:8,1:ntlsgrp) = smat_save(1:8,1:ntlsgrp)
         IF (PRINT_TLSPARS) THEN
           DO  IDOM=1,NTLSGRP
             WRITE(6,'(/,A,I4,A2,A)') 'TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
             WRITE(6,'(A11,I2,A4,6F8.3)') 'T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
             WRITE(6,'(A11,I2,A4,6F8.3)') 'L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
             WRITE(6,'(A11,I2,A4,8F8.3)') 'S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
           ENDDO
         ENDIF
         goto 30
 20      continue
c         CALL REFALL(nmodel)

         HCALC = .TRUE.
         GRADC = .TRUE.
         IF (PRINT_TLSPARS) THEN
           DO  IDOM=1,NTLSGRP
             WRITE(6,'(/,A,I4,A2,A)') 'TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
             WRITE(6,'(A11,I2,A4,6F8.3)') 'T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
             WRITE(6,'(A11,I2,A4,6F8.3)') 'L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
             WRITE(6,'(A11,I2,A4,8F8.3)') 'S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
           ENDDO
         ENDIF
C
C---Make shure trace of T matrices is 0. Sometimes numerical imprecisions
C---can cause departure from 0 trace
      ENDDO
 30   continue
      hcalc = .TRUE.
      GRADC = .TRUE.
      MON_STYLE = MON_STYLE_SAVE
C---Write new mtz
cd      IF(NLPRGO.NE.0) THEN
cd        LREFIN_SAVE = LREFIN
cd        LREFIN    = .FALSE.
cd        CALL REFALL(nmodel)
cd        LREFIN = LREFIN_SAVE
cd      ENDIF

c---Write new coordinate file
cd      CALL NEWBRK

C---Write new TLS parameters file
      IF(NTLS_CYCLE.GT.0) CALL WRITE_TLS_FILE

      DO   IA=1,N_ATOM_mod(im)
          DO   I=1,6
            U_ANISO_mod(I,IA,im) = UANISO_OLD_mod(I,IA,im)
            if (im.eq.1) U_ANISO(I,IA) = UANISO_OLD_mod(I,IA,im)
          ENDDO
      ENDDO
      UOVER_ATOM = 0.0
c
      deallocate(tmat_save)
      deallocate(lmat_save)
      deallocate(smat_save)
      deallocate(gx_tls)
      deallocate(hx_tls)
      deallocate(shft_tls)
      RETURN
      END
C
      SUBROUTINE MAKE_L_POSITIVE(tmin_out)
      IMPLICIT NONE
C
C---This subroutine make L matrices of TLS non-negative. In principle
C---if overall B would be in T then whole matrix should be positive definite.
C---It will have to be worked on.
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'refi_flags.fh'
C
      real tmin_out

      INTEGER I,j,IDOM,LWORK,INFO
      REAL UANISO0(3,3),UANISO1(6),EVALUE(3),WORK(100)
      real eigenv6(6),worksp(200)
      real amat(6,6),amat1(6,6),amat2(6,6)
      real eval_add
      real s11,s22,s33
      real rtodeg
C
      rtodeg = 45.0/atan2(1.0,1.0)
      LWORK = 200
      smat(1:8,1:ntlsgrp) = smat(1:8,1:ntlsgrp)*rtodeg
      lmat(1:6,1:ntlsgrp) = lmat(1:6,1:ntlsgrp)*rtodeg**2
      eval_add = 0.0
c--   Now try to make the whole TLS matrix non-negative
C
      tmin_out = 0.0
      do idom = 1,ntlsgrp
         tmin_out = min(tmin_out,minval(tmat(1:3,idom)))
      enddo
      do idom = 1,ntlsgrp
         tmat(1:3,idom) = tmat(1:3,idom) - tmin_out
      enddo
c
      do idom=1,ntlsgrp
         amat(1,1) = LMAT(1,IDOM)
         AMAT(2,2) = LMAT(2,IDOM)
         AMAT(3,3) = LMAT(3,IDOM)
         AMAT(1,2) = LMAT(4,IDOM)
         AMAT(1,3) = LMAT(5,IDOM)
         AMAT(2,3) = LMAT(6,IDOM)

         amat(4,4) = tmat(1,idom)
         amat(5,5) = tmat(2,idom)
         amat(6,6) = tmat(3,idom)
         amat(4,5) = tmat(4,idom)
         amat(4,6) = tmat(5,idom)
         amat(5,6) = tmat(6,idom)

         s33 = -(2.0*smat(2,idom)+smat(1,idom))/3.0
         s11 = s33 + smat(2,idom)
         s22 = s11 + smat(1,idom)
         amat(1,4) = s11
         amat(1,5) = smat(3,idom)
         amat(1,6) = smat(4,idom)
         amat(2,4) = smat(6,idom)
         amat(2,5) = s22
         amat(2,6) = smat(5,idom)
         amat(3,4) = smat(7,idom)
         amat(3,5) = smat(8,idom)
         amat(3,6) = s33
         do i=2,6
            do j=1,i
               amat(i,j) = amat(j,i)
            enddo
         enddo
         call ssyev('V','U',6,amat,6,eigenv6,worksp,lwork,info)
         do i=1,6
            eigenv6(i) = max(eigenv6(i),0.0)
         enddo
         do i=1,6
            do j=1,6
               amat1(i,j) = amat(j,i)*eigenv6(i)
            enddo
         enddo
         amat2 = matmul(amat,amat1)
         lmat(1,idom) = amat2(1,1)
         lmat(2,idom) = amat2(2,2)
         lmat(3,idom) = amat2(3,3)
         lmat(4,idom) = amat2(1,2) 
         lmat(5,idom) = amat2(1,3) 
         lmat(6,idom) = amat2(2,3) 

         tmat(1,idom) = amat2(4,4)
         tmat(2,idom) = amat2(5,5) 
         tmat(3,idom) = amat2(6,6)
         tmat(4,idom) = amat2(4,5)
         tmat(5,idom) = amat2(4,6)
         tmat(6,idom) = amat2(5,6)

         smat(1,idom) = amat2(2,5) - amat2(1,4)
         smat(2,idom) = amat2(1,4) - amat2(3,6) 
         smat(3,idom) = amat2(1,5) 
         smat(4,idom) = amat2(1,6)
         smat(5,idom) = amat2(2,6) 
         smat(6,idom) = amat2(2,4)
         smat(7,idom) = amat2(3,4)
         smat(8,idom) = amat2(3,5)

c         call ssyev('V','U',6,amat2,6,eigenv6,worksp,lwork,info)
c         write(*,*)'sec',eigenv6(1:6)
      enddo
      smat(1:8,1:ntlsgrp) = smat(1:8,1:ntlsgrp)/rtodeg
      lmat(1:6,1:ntlsgrp) = lmat(1:6,1:ntlsgrp)/rtodeg**2
c      stop
      RETURN
      END
C
      SUBROUTINE ADD_CONDITIONS_TLS(NMAX20,NTLS20,NTLS,GX,HX,
     &             WORKSPACE,NWORKSPACE)
      IMPLICIT NONE
C
C---Add conditions to TLS. Current conditions are only trace over
C---translational parameters of TLS groups is equal 0. Overall B will be 
C---handled with scale and later with individual atomic refinement.
C
      INTEGER NMAX20,NTLS20,NTLS,NWORKSPACE
      REAL*8 GX(NMAX20),HX(NMAX20,NMAX20)
      REAL*8 WORKSPACE(*)
C
C---Local vriables
      INTEGER I,J,I1
      REAL GSAVE
C---
      IF(NWORKSPACE.LT.2*NTLS20) THEN
        CALL ERRWRT(1,'Not enough space for ADD_CONDITIONS_TLS')
      ENDIF
      DO  I=1,NTLS20
        WORKSPACE(I) = 0.0D0
        WORKSPACE(NTLS20+I) = HX(1,I)
      ENDDO
      DO   I=1,NTLS
         I1 = 20*(I-1)
         WORKSPACE(I1+1) = -1.0D0
         WORKSPACE(I1+2) = -1.0D0
         WORKSPACE(I1+3) = -1.0D0
      ENDDO
      GSAVE = GX(1)
      DO   I=1,NTLS20
        GX(I) = GX(I) + WORKSPACE(I)*GSAVE
        DO   J=1,NTLS20
           HX(I,J) = HX(I,J) + WORKSPACE(NTLS20+I)*WORKSPACE(J)+
     &                         WORKSPACE(NTLS20+J)*WORKSPACE(I)+
     &                   WORKSPACE(NTLS20+1)*WORKSPACE(I)*WORKSPACE(J)
        ENDDO
      ENDDO

      return
      END
C
      subroutine add_tmin_to_u(tmin_in)
      implicit none
      include 'atom_com.fh'
      include 'tls.fh'
c
      real tmin_in
c
c---  locals
      integer ia
c
c---  body
      if(tmin_in.ge.0.0) return

      do ia=1,n_atom
         if(igroup(ia).le.0) then
            if(u_aniso(2,ia).le.0) then
               u_aniso(1,ia) = u_aniso(1,ia) - tmin_in
            else
               u_aniso(1:3,ia) = u_aniso(1:3,ia) - tmin_in
            endif
         endif
      enddo
      return
      end
c
      SUBROUTINE TLS_INIT
C
C--Defines groups according to read parameters
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'tls.fh'
      include 'makecif.fh'

C
      integer nmodel
C---Local variables
      CHARACTER ATNMP*8,CHNNMP*4,TLSFIL*200,LINE*200
      INTEGER   IDOM,im
      REAL      RNUMTLSGRP(MAXTLSGRP),UANISO_ORT(6),UANISO_CELL(6)
      LOGICAL   LTLSSET(MAXTLSGRP)

C---Initialisations
      im=1
      nmodel=1
      DO   IA=1,N_ATOM_mod(im)
        XORT0(1,IA) = XYZ_CRD_mod(1,IA,im)
        XORT0(2,IA) = XYZ_CRD_mod(2,IA,im)
        XORT0(3,IA) = XYZ_CRD_mod(3,IA,im)
        DO    I=1,6
          UANISO_OLD_mod(I,IA,im) = U_ANISO_mod(I,IA,im)
        ENDDO
      ENDDO
C      
      T_REMAIN = 0.0
      DO IDOM=1,MAXTLSGRP
        DO I = 1,6
          TMAT(I,IDOM) = 0.0
          LMAT(I,IDOM) = 0.0
        ENDDO
        DO I = 1,8
          SMAT(I,IDOM) = 0.0
        ENDDO
        DO I = 1,3
          TLSORIGIN(I,IDOM) = 0.0
        ENDDO
        RNUMTLSGRP(IDOM) = 0.0
        LTLSSET(IDOM) = .FALSE.
      ENDDO

C---If TLSIN defined, read parameters in
      CALL UGTENV('TLSIN',TLSFIL)
      IF (TLSFIL.NE.' ') then 
         CALL READ_TLS_FILE
      else
c
c--define defualt tls groups chains or segids)
         call default_tls_groups
      endif

C  Move the NTLSGRP count here 
      NTLSGRP = 0
      DO   II=1,MAXTLSGRP
        IF(ITLSGRP_PIECES(II).GT.0) NTLSGRP = NTLSGRP+1
      ENDDO

      IF(NTLSGRP.GT.0) THEN
C---Set IGROUP(IA) for each atom based on input residue ranges 
C   and atom selection1
        DO   IA = 1,N_ATOM_mod(im)
         ATNMP      = ATM_NAME_INP(IA)
          call get_chain_namepdb(chnnmp,i_resid_mod(ia,im))
c          IF(REFID.EQ.'UNRE') THEN
c            CHNNMP = RES_NUM_PDB(I_RESID(IA))(1:1)
c          ELSE
c            CHNNMP = ASM_GROUP_ID(I_CHAIN(I_RESID(IA)))(1:1)
c          ENDIF

          READ(RES_NUM_PDB(I_RESID_mod(IA,im))(3:6),*)JRS
          IGROUP(IA) = 0
          IGROUP_mod(IA,im) = 0
C---Loop over TLS groups
c---Is this atom refinable. It should be moved to another place.
          DO IDOM=1,NTLSGRP
            IF(ITLSGRP_PIECES(IDOM).GT.0) THEN
              IPIECE = ITLSGRP_PIECES(IDOM)
C---Loop over pieces of TLS group
              DO IP1 = 1,IPIECE
                IF(CHNNMP.EQ.TLSGRP_CHN(IP1,IDOM).AND.
     +                    JRS.GE.ITLSGRP_FROM(IP1,IDOM).AND.
     +                    JRS.LE.ITLSGRP_TO(IP1,IDOM)) THEN
C---Loop over atom selections for this piece
C   Allow atom names (char*3), 'ALL', 'MNC', 'SDC'
                  DO ISEL=1,MAXSELECT
                    IF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.'ALL') THEN
                       IGROUP(IA)        = IDOM
                       IGROUP_mod(IA,im) = IDOM
                       GOTO 10
                     ELSEIF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.'MNC' .AND.
     +                  (ATNMP(1:2).EQ.'CA'.OR.ATNMP(1:2).EQ.'N '.OR.
     +                   ATNMP(1:2).EQ.'C '.OR.ATNMP(1:2).EQ.'O ')) THEN
                        IGROUP(IA)       = IDOM
                       IGROUP_mod(IA,im) = IDOM
                       GOTO 10
                    ELSEIF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.'SDC' .AND.
     +                 (ATNMP(1:2).NE.'CA'.AND.ATNMP(1:2).NE.'N '.AND.
     +                  ATNMP(1:2).NE.'C '.AND.ATNMP(1:2).NE.'O ')) THEN
                      IGROUP(IA)        = IDOM
                      IGROUP_mod(IA,im) = IDOM
                      GOTO 10
                    ELSEIF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.
     &                                        ATNMP(1:4)) THEN
                      IGROUP(IA)        = IDOM
                      IGROUP_mod(IA,im) = IDOM
                      GOTO 10
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 10       CONTINUE
        ENDDO
      ELSE
C---If no groups set up yet, default is whole molecule. It should be chains or
c--- segments. Problem is what to do with waters???
        NTLSGRP           = 1
        ITLSGRP_PIECES(1) = 1
        DO   IA=1,N_ATOM_mod(im)
           IGROUP(IA)        = 1
           IGROUP_mod(IA,im) = 1
        ENDDO
      ENDIF
      IA1 = 0
      DO   IA=1,N_ATOM_mod(im)
        
        IF(OCCUP_mod(IA,im).GT.0.0.AND.
     &        (CS_ELEMENT(ID_SF_mod(IA,im)).NE.'H   '.AND.
     &         CS_ELEMENT(ID_SF_mod(IA,im)).NE.'H-1  ')) THEN
          IA1 = IA1 + 1
          ATOM_REF_mod_FLAG(IA,im) = IA1*10 + 4
        ELSE IF(OCCUP_mod(IA,im).GT.0.0.AND.
     &        (CS_ELEMENT(ID_SF_mod(IA,im)).EQ.'H   '.OR.
     &         CS_ELEMENT(ID_SF_mod(IA,im)).EQ.'H-1  ')) THEN
          IA1 = IA1 + 1
          ATOM_REF_FLAG(IA) = IA1*10 + 2
        ELSE
           ATOM_REF_FLAG(IA) = 0
        ENDIF
      ENDDO

C---Report TLS Groups
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'######  TLS Group Definitions ######')
      CALL ERRWRT(-1,' ')
      DO II = 1,NTLSGRP
        WRITE(LINE,'(A,I4,A,I4)')'  Group:',II, 
     +  ':    No. of pieces:',ITLSGRP_PIECES(II)
        CALL ERRWRT(-1,LINE)
        DO III = 1,ITLSGRP_PIECES(II)
         WRITE(LINE,'(A,A,A,2I5)') ' Chain:  ',TLSGRP_CHN(iii,ii),
     +' Span:',ITLSGRP_FROM(III,II),ITLSGRP_TO(III,II)
          CALL ERRWRT(-1,LINE)
        END DO
        CALL ERRWRT(-1,' ')
      END DO
c
c---  add waters and ohter to tls group if it is necessary
      if(waters2tls.eq.'ADD') then
         call waters2groups
      endif

C **** Set origins for TLS groups ****

C---Return TLS group origins in TLSORIGIN

      CALL FIND_TLS_ORIGIN

C **** Set parameter values for TLS groups ****

C---Check if set already
      DO IDOM=1,NTLSGRP
        IF (TMAT(1,IDOM).NE.0.0) LTLSSET(IDOM) = .TRUE.        
      ENDDO 

C---Calculate initial T matrices for groups where not already set
      DO    IA=1,N_ATOM_mod(im)
        IDOM = IGROUP(IA)

        IF(IDOM.GT.0) THEN
          IF(.NOT.LTLSSET(IDOM)) THEN

C---Calculate averages for initial T matrix
C---Isotropic Bs should have been expanded by call to 
C   ALLB S2ANISOU in refmac.f
            Q = OCCUP(IA)
            RNUMTLSGRP(IDOM) = RNUMTLSGRP(IDOM) + Q
          ENDIF
        ENDIF
      ENDDO 

      DO IDOM=1,NTLSGRP

cd        IF(.NOT.LTLSSET(IDOM)) THEN
cd         DO I = 1,6
cd          TMAT(I,IDOM) = TMAT(I,IDOM)/RNUMTLSGRP(IDOM)
cd         ENDDO
cd        ENDIF

C---TLS2ANISOU uses DELxMAT to calculate shift in U_ANISO.
C   In first call, shift is from 0 to xMAT.

        IF (MON_STYLE.NE.'NONE'.AND.PRINT_TLSPARS) THEN
          WRITE(6,'(/,A)') ' Initial TLS parameters '
          WRITE(6,'(/,A,I4,A2,A)') ' TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
          WRITE(6,'(A11,I3,A4,6F8.3)') ' T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
          WRITE(6,'(A11,I3,A4,6F8.3)') ' L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
          WRITE(6,'(A11,I3,A4,8F8.3)') ' S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
        ENDIF
      ENDDO 

      RETURN
      END
c
      subroutine waters2groups
      implicit none
      include 'restr_files.fh'
      include 'atom_com.fh'
      include 'tls.fh'
      include 'models.fh'
c
c--   locals
      integer iscrv,ifail
      integer ia,id,nvdw1,iv(2),symm_l(4)
      integer im
      integer nchange
      real dmin_l
      logical things_to_do
c
c---  body
      dmin_l = 0.0
      call analyse_vdw(dmin_l)
      
      if(vdw_file_0(1:1).eq.' ') return
      call open_unform_file(iscrv,vdw_file_0,ifail)

      read(iscrv)nvdw1

      nchange = 0
      things_to_do = .TRUE.
      im = 1
      do while(things_to_do)
         things_to_do = .FALSE.
         nchange = 0
         do id=1,nvdw1
            read(iscrv)iv(1:2),symm_l(1:4)
            if(symm_l(1).eq.1.and.symm_l(2).eq.0.and.symm_l(3).eq.0.and.
     &           symm_l(4).eq.0) then
               if(igroup(iv(1)).gt.0) then
                  if(igroup(iv(2)).le.0) then
                     if(ires_type(i_resid(iv(2))).eq.9) then
                        igroup(iv(2)) = igroup(iv(1))
                        igroup_mod(iv(2),im)=igroup(iv(2))
                        nchange = nchange + 1
                     endif
                  endif
               elseif(igroup(iv(2)).gt.0) then
                  if(igroup(iv(1)).le.0) then
                     if(ires_type(i_resid(iv(1))).eq.9) then
                        igroup(iv(1)) = igroup(iv(2))
                        igroup_mod(iv(1),im)=igroup(iv(1))
                        nchange = nchange + 1
                     endif
                  endif
               endif
            endif
            if(nchange.gt.0) things_to_do = .TRUE.
         enddo
         rewind(iscrv)
         read(iscrv)nvdw1
      enddo

      nchange = 0
c      do ia=1,n_atom
c         if(res_name(i_resid(ia)).eq.'HQD') then
c            write(*,*)atm_name(ia),igroup(ia),ires_type(i_resid(ia))
c         endif
c         if(cs_element(id_sf(ia)).eq.'CL') then
c            write(*,*)atm_name(ia),ires_type(i_resid(ia))
c         endif
c         if(res_num_pdb(i_resid(ia))(1:6).eq.'XX3007') then
c            write(*,*)igroup(ia)
c         endif
c         if(igroup(ia).le.0.and.occup(ia).gt.0.0) then
c            write(*,*)atm_name(ia),res_name(i_resid(ia)),
c     &           res_num_pdb(i_resid(ia)),occup(ia)
c            if(occup(ia).gt.0.0) then
c               nchange = nchange + 1
c            endif
c         endif
c      enddo
      close(iscrv)
c      stop
      return
      end
c
      subroutine default_tls_groups
c
c---  define default tls groups. Do not use water "chains" as groups
c---- waters should be considered differently. They should be added to
c---  the groups they are close to
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'tls.fh'

c
c---  locals
      integer ia,igr,igr1,ipiece,isel,ip,idom,im,itype_l
      integer is,nsegment,nmax_segment
      character seg_cur*8,chnnmp*4
      character*8, allocatable :: segment_domain(:)
      integer, allocatable :: natom_tlsgr(:)
      logical seg_flag
c
      character line*512
c
c--body
      DO   ISEL=1,MAXSELECT
        DO  IP=1,MAXPIECES_TLS
          DO  IDOM=1,MAXTLSGRP
            TLSGRP_SELECT(ISEL,IP,IDOM) = ' '
          ENDDO
        ENDDO
      ENDDO
c
      nmax_segment = 1000
      seg_flag = .FALSE.
 15   continue
      nsegment = 1
      allocate(segment_domain(nmax_segment))
      allocate(natom_tlsgr(nmax_segment))
      natom_tlsgr(1:nmax_segment) = 0
      if(seg_flag) then
         segment_domain(1) = seg_id(1)
      else
         call get_chain_namepdb(chnnmp,i_resid(1))
         segment_domain(1) = chnnmp
      endif

      ipiece = 1
      igr = 1
      itlsgrp_pieces(igr) = 1
      TLSGRP_CHN(IPIECE,IGR) = segment_domain(1)
      itlsgrp_from(ipiece,igr) = -10
      itlsgrp_to(ipiece,igr) = 9999
      tlsgrp_select(1,1,igr)='ALL'
c
      im = 1
c
c---  Make sure that each group has sufficient number of atoms. It would
c---  also be good if tls groups would analysed: e.g. moment of inertia,
c---  length/width etc.
      do ia=1,n_atom_mod(im)
c
c---  If water then move on. Waters should be treated differently
         itype_l = ires_type(i_resid_mod(ia,im))
         if ((itype_l.eq.3.or.itype_l.eq.4.or.
     &        itype_l.eq.5.or.itype_l.eq.6).and.
     &        occup_mod(ia,im).gt.0.0) then
           if(seg_flag) then
               seg_cur = seg_id(ia)
               do is=1,nsegment
                  if(seg_cur.eq.segment_domain(is)) then
                     igr = is
                     goto 20
                  endif
               enddo
           else
               call get_chain_namepdb(chnnmp,i_resid_mod(ia,im))
               seg_cur = chnnmp
               do is=1,nsegment
                  if(seg_cur.eq.segment_domain(is)) then
                     igr = is
                     goto 20
                  endif
               enddo
           endif
           nsegment = nsegment + 1
           if(nsegment.gt.nmax_segment) then
               write(line,'(a,i5)')
     &              'Too many segigds. Maximum allowed is ',nmax_segment
               call errwrt(1,line)
           endif
           segment_domain(is) = seg_cur
           igr = nsegment
           itlsgrp_pieces(igr) = 1
           ipiece = 1
           TLSGRP_CHN(IPIECE,IGR) = seg_cur(1:4)
           itlsgrp_from(ipiece,igr) = -10
           itlsgrp_to(ipiece,igr) = 9999
           tlsgrp_select(1,1,igr)='ALL'
 20        continue
           natom_tlsgr(igr) = natom_tlsgr(igr) + 1
         endif
      enddo
      deallocate(segment_domain)
      do igr=1,nsegment
         if(natom_tlsgr(igr).le.150) then
            itlsgrp_pieces(igr) = 0
         endif
      enddo
c
c---  Remove small groups. They may cause problem
      igr = 0
c      write(*,*)nsegment
c      write(*,*)itlsgrp_pieces(1:nsegment)
      do while(igr.lt.nsegment)
         igr = igr + 1
         if(itlsgrp_pieces(igr).le.0) then
c            write(*,*)'Are we removing',igr
            if(igr.lt.nsegment) then
               do igr1 = igr,nsegment-1
                  itlsgrp_pieces(igr1) = itlsgrp_pieces(igr1+1)
                  itlsgrp_from(1,igr1) = itlsgrp_from(1,igr1+1)
                  itlsgrp_to(1,igr1) = itlsgrp_to(1,igr1+1)
                  tlsgrp_select(1,1,igr1) = tlsgrp_select(1,1,igr1+1)
                  tlsgrp_chn(1,igr1) = tlsgrp_chn(1,igr1+1)
               enddo
            endif
            itlsgrp_pieces(nsegment) = 0
            tlsgrp_chn(1,nsegment) = ' '
            nsegment = nsegment-1
         endif
      enddo
      deallocate(natom_tlsgr)
c      stop
      return
      end
c
      SUBROUTINE READ_TLS_FILE
      IMPLICIT NONE
C---Read TLS parameters from TLSIN
      INCLUDE 'atom_com.fh'
c      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'

      INTEGER NPARS
      PARAMETER (NPARS = 200)
      CHARACTER*60 OLINE

c---Things for parser
      CHARACTER LINE*256,KEY*4,CVALUE(NPARS)*4
      INTEGER IBEG(NPARS),IEND(NPARS),IDEC(NPARS),ITYP(NPARS),NTOK
      REAL FVALUE(NPARS)
      LOGICAL LEND,LPRINT

      CHARACTER RANGEFROM*20,RANGETO*20,ERRLIN*200
      INTEGER ITLSIN,IFAIL,IGR,IPIECE,ITOK,ISEL,I,LENSTR,IDOM,IP,IDOT
c
      character tls_in_file*512
      integer ii,itk,ierr
      integer nselect
      character select_atoms(MAXSELECT)*4
      integer ifirst,ilast
      character chnid*4
      EXTERNAL LENSTR
c
      call ugtenv('TLSIN',tls_in_file)
      call open_form_file(itlsin,tls_in_file,ifail)

      IGR = 0
      DO   ISEL=1,MAXSELECT
        DO  IP=1,MAXPIECES_TLS
          DO  IDOM=1,MAXTLSGRP
            TLSGRP_SELECT(ISEL,IP,IDOM) = ' '
          ENDDO
        ENDDO
      ENDDO
 10   CONTINUE

      LINE = ' '
      READ(ITLSIN,'(A)',END=999) LINE
      IF(LENSTR(LINE).LE.0) GOTO 10
      KEY  = ' '
      NTOK = NPARS
      LPRINT = .TRUE.

      CALL PARSER(KEY,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,NTOK,LEND,
     +            LPRINT)
      call ccpupc(key)
      do  i=1,ntok
         call ccpupc(cvalue(i))
      enddo
      IF(KEY(1:3).EQ.'TLS') THEN
        IGR = IGR + 1
        IF(IGR.GT.MAXTLSGRP) THEN
          WRITE(OLINE,'(A,I5)')
     &      'Too many tls groups. Maximum allowed is ',MAXTLSGRP
          CALL ERRWRT(1,OLINE)
        ENDIF
        TLSGRP_TITLE(IGR) = LINE(5:84)
      ELSEIF(KEY(1:4).EQ.'RANG') THEN
        ITLSGRP_PIECES(IGR) = ITLSGRP_PIECES(IGR) + 1
        IPIECE              = ITLSGRP_PIECES(IGR)
        itk = 2
       call get_range_tls(ntok,itk,ityp,ibeg,iend,line,cvalue,fvalue,
     &       ifirst,ilast,chnid,nselect,select_atoms,ierr)
cd        IF(IEND(2)-IBEG(2) .GT. 19)
cd     +       CALL ERRWRT(1,'Format for TLS RANGE too spread out')
cd        RANGEFROM = LINE (IBEG(2):IEND(2)) 
cd        IDOT = INDEX(RANGEFROM,'.')
cd        IF (IDOT.EQ.0) IDOT = IEND(2) - IBEG(2) + 2
cd        READ(RANGEFROM(2:IDOT-1),*) ITLSGRP_FROM(IPIECE,IGR)
        TLSGRP_CHN(IPIECE,IGR) = chnid
        itlsgrp_from(ipiece,igr)=ifirst
        itlsgrp_to(ipiece,igr) = ilast
        do ii=1,nselect
           tlsgrp_select(ii,ipiece,igr)=select_atoms(ii)
        enddo
cd        IF(IEND(3)-IBEG(3) .GT. 19)
cd     +       CALL ERRWRT(1,'Format for TLS RANGE too spread out')
cd        RANGETO = LINE (IBEG(3):IEND(3))
cd        IDOT = INDEX(RANGETO,'.')
cd        IF (IDOT.EQ.0) IDOT = IEND(3) - IBEG(3) + 2
cd        READ(RANGETO(2:IDOT-1),*) ITLSGRP_TO(IPIECE,IGR)

        IF(ITLSGRP_FROM(IPIECE,IGR).LT.-999) 
     &       ITLSGRP_PIECES(IGR) = -1 
C---Is an atom selection present?
cd        IF (NTOK.GE.4) THEN
cd          DO ITOK=4,NTOK
cd            ISEL=ITOK-3
cd            IF (ISEL.GT.MAXSELECT) THEN
cd              WRITE(ERRLIN,'(A,/,A,I4)') 
cd     +          'Too many atom selections made.',
cd     +          'Maximum allowed: ',MAXSELECT
cd              GOTO 10
cd            ENDIF
cd            TLSGRP_SELECT(ISEL,IPIECE,IGR)=LINE(IBEG(ITOK):IEND(ITOK))
cd          ENDDO
cd        ELSE
cd          TLSGRP_SELECT(1,IPIECE,IGR)='ALL'
cd        ENDIF
      ELSEIF(KEY(1:4).EQ.'ORIG') THEN
        CALL GTNREA(2,3,TLSORIGIN(1,IGR),NTOK,ITYP,FVALUE)
      ELSEIF(KEY.EQ.'T   ') THEN
        CALL GTNREA(2,6,TMAT(1,IGR),NTOK,ITYP,FVALUE)
      ELSEIF(KEY(1:4).EQ.'L   ') THEN
        CALL GTNREA(2,6,LMAT(1,IGR),NTOK,ITYP,FVALUE)
C---TLSIN holds L in units of degrees**2
        DO   I=1,6
          TMAT(I,IGR) = TMAT(I,IGR)
        ENDDO
        DO I = 1,6
          LMAT(I,IGR) = LMAT(I,IGR)*DEGTOR*DEGTOR
        ENDDO
      ELSEIF(KEY.EQ.'S   ') THEN
        CALL GTNREA(2,8,SMAT(1,IGR),NTOK,ITYP,FVALUE)
C---TLSIN holds S in units of degrees*Angstrom
        DO I = 1,8
          SMAT(I,IGR) = SMAT(I,IGR)*DEGTOR
        ENDDO
      ELSE IF(KEY(1:3).EQ.'END') THEN
         GOTO 999
      ENDIF

      GOTO 10
 999  CONTINUE
      CLOSE(ITLSIN)

      RETURN
      END
c
      subroutine get_range_tls(ntok,itk,ityp,ibeg,iend,line,cvalue,
     &     fvalue,ifirst,ilast,chnid,
     &     nselect,select_atoms,ierr)

      implicit none
      include 'atom_com.fh'
      include 'tls.fh'
c
c--inputs
      integer ntok,itk
      integer ityp(*),ibeg(*),iend(*)
      character line*(*)
      character cvalue(*)*4
      real fvalue(*)
c
c---outputs
      integer ierr
      integer nselect
      integer ifirst,ilast
      character chnid*(*)
      character select_atoms(maxselect)*(*)
c
c--locals
      integer itk1,ii
      CHARACTER RANGEFROM*20,RANGETO*20,ERRLIN*200
      INTEGER ITLSIN,IFAIL,IGR,IPIECE,ITOK,ISEL,I,LENSTR,IDOM,IP,IDOT
c
c--body
      itk1 = itk
      if(cvalue(itk).eq.'FROM') then
         call read_fromto1(ntok,itk1,cvalue,line,ibeg,iend,ityp,
     &        fvalue,ifirst,ilast,chnid,ierr)
         itk1 = itk+6
c         write(*,*)ifirst,ilast,chnid
         if(itk1.lt.ntok) then
            if(cvalue(itk1).eq.'SELE') then
               do  itok=itk1+1,ntok
                  isel = itok-itk1
                  select_atoms(isel)=line(ibeg(itok):iend(itok))
               enddo
            endif
         else
            isel = 1
            select_atoms(isel) = 'ALL'
         endif
         if(ierr.gt.0) then
            call errwrt(0,'Problem in reading TLS file')
            return
         endif
         tls_output_format = 'F'
      else
         tls_output_format = 'O'
         IF(IEND(2)-IBEG(2) .GT. 19)
     +        CALL ERRWRT(1,'Format for TLS RANGE too spread out')
         RANGEFROM = LINE (IBEG(2):IEND(2)) 
         IDOT = INDEX(RANGEFROM,'.')
         IF (IDOT.EQ.0) IDOT = IEND(2) - IBEG(2) + 2
         READ(RANGEFROM(2:IDOT-1),*) ifirst
         IF(IEND(3)-IBEG(3) .GT. 19)
     +        CALL ERRWRT(1,'Format for TLS RANGE too spread out')
         RANGETO = LINE (IBEG(3):IEND(3))
         IDOT = INDEX(RANGETO,'.')
         IF (IDOT.EQ.0) IDOT = IEND(3) - IBEG(3) + 2
         READ(RANGETO(2:IDOT-1),*) ilast
         chnid = rangefrom(1:1)
C---  Is an atom selection present?        IF (NTOK.GE.4) THEN
         if(ntok.gt.4) then
            DO ITOK=4,NTOK
               isel=ITOK-3
               IF (ISEL.GT.MAXSELECT) THEN
                  WRITE(ERRLIN,'(A,/,A,I4)') 
     +                 'Too many atom selections made.',
     +                 'Maximum allowed: ',MAXSELECT
                  ierr = 1
                  call errwrt(1,errlin)
               ENDIF
               select_atoms(isel) = line(ibeg(itok):iend(itok))
            ENDDO
         ELSE
            isel = 1
            select_atoms(1)='ALL'
         ENDIF
      endif
      nselect = isel
      return
      end

      subroutine write_tls_file
      implicit none
      include 'atom_com.fh'
      include 'tls.fh'

      if(tls_output_format.eq.'F') then
         call write_tls_file2
      else
         call write_tls_file1
      endif
      return
      end
c
      SUBROUTINE WRITE_TLS_FILE1

C---Write TLS parameters to TLSOUT
C   Can be analysed with CCP4 program TLSANL
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif_version.fh'
      INTEGER ITLSOUT,IFAIL,IDOM,III
      CHARACTER RANGEFROM*6,RANGETO*6,LINE*256,tls_out_file*512
      INTEGER LENSTR
      EXTERNAL LENSTR
c
      call ugtenv('TLSOUT',tls_out_file)
      if(len_trim(tls_out_file).le.0) tls_out_file='TLSOUT'
      call open_form_file(itlsout,tls_out_file,ifail)

      WRITE(ITLSOUT,'(/,A)') 'REFMAC_'//R_VERSNO

      DO IDOM=1,NTLSGRP

        WRITE(ITLSOUT,'(/,A4,A)') 'TLS ',
     &       TLSGRP_TITLE(IDOM)(1:LENSTR(TLSGRP_TITLE(IDOM)))
        DO III = 1,ITLSGRP_PIECES(IDOM)
          WRITE(RANGEFROM,'(A1,I4,A1)') TLSGRP_CHN(III,IDOM),
     +          ITLSGRP_FROM(III,IDOM),'.'
          WRITE(RANGETO,'(A1,I4,A1)') TLSGRP_CHN(III,IDOM),
     +          ITLSGRP_TO(III,IDOM),'.'

CC  Add in TLSGRP_SELECT
          WRITE(LINE,'(A7,A1,A6,A3,A6,A1)') 'RANGE  ',
     +            '''',RANGEFROM,''' ''',RANGETO,''''


          DO   ISEL = 1,MAXSELECT
            IF(TLSGRP_SELECT(ISEL,III,IDOM).NE.' ') THEN
              LINE = LINE(1:LENSTR(LINE))//' '//
     &             TLSGRP_SELECT(ISEL,III,IDOM)
     &             (1:LENSTR(TLSGRP_SELECT(ISEL,III,IDOM)))

            ENDIF
          ENDDO
          WRITE(ITLSOUT,'(A)')LINE(1:LENSTR(LINE))
        ENDDO
        WRITE(ITLSOUT,'(A7,3F8.3)') 'ORIGIN ',
     +                          (TLSORIGIN(I,IDOM),I=1,3)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'T   ',
     +                          (TMAT(I,IDOM),I=1,6)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'L   ',
     +                          (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
        WRITE(ITLSOUT,'(A4,8F8.4)') 'S   ',
     +                          (SMAT(I,IDOM)*RTODEG,I=1,8)

      ENDDO

      CLOSE(ITLSOUT)

      RETURN
      END
c
      SUBROUTINE WRITE_TLS_FILE2
      implicit none
C---Write TLS parameters to TLSOUT
C   Can be analysed with CCP4 program TLSANL
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif_version.fh'
c
c---locals
      character tls_out_file*512
      INTEGER ITLSOUT,IFAIL,IDOM,III
      integer i,isel
      CHARACTER RANGEFROM*6,RANGETO*6,LINE*256
c
c---locals
      INTEGER LENSTR
      EXTERNAL LENSTR

      call ugtenv('TLSOUT',tls_out_file)
      if(len_trim(tls_out_file).le.0) tls_out_file='TLSOUT'
      call open_form_file(itlsout,tls_out_file,ifail)

      WRITE(ITLSOUT,'(/,A)') 'REFMAC_'//R_VERSNO

      DO IDOM=1,NTLSGRP

        WRITE(ITLSOUT,'(/,A4,A)') 'TLS ',
     &       TLSGRP_TITLE(IDOM)(1:LENSTR(TLSGRP_TITLE(IDOM)))
        DO III = 1,ITLSGRP_PIECES(IDOM)
           write(line,'(2A,I5,1x,2A,i5,1x,2A)')'RANGE ','FROM ',
     &          itlsgrp_from(iii,idom),
     &          tlsgrp_chn(iii,idom),
     &          ' TO ',
     &          itlsgrp_to(iii,idom),
     &          tlsgrp_chn(iii,idom),
     &          ' SELECT '
          
          DO   ISEL = 1,MAXSELECT
            IF(TLSGRP_SELECT(ISEL,III,IDOM).NE.' ') THEN
              LINE = LINE(1:LENSTR(LINE))//' '//
     &             TLSGRP_SELECT(ISEL,III,IDOM)
     &             (1:LENSTR(TLSGRP_SELECT(ISEL,III,IDOM)))

            ENDIF
          ENDDO
          WRITE(ITLSOUT,'(A)')LINE(1:LENSTR(LINE))
        ENDDO
        WRITE(ITLSOUT,'(A7,3F8.3)') 'ORIGIN ',
     +                          (TLSORIGIN(I,IDOM),I=1,3)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'T   ',
     +                          (TMAT(I,IDOM),I=1,6)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'L   ',
     +                          (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
        WRITE(ITLSOUT,'(A4,8F8.4)') 'S   ',
     +                          (SMAT(I,IDOM)*RTODEG,I=1,8)

      ENDDO

      CLOSE(ITLSOUT)

      RETURN
      END
c

      subroutine tls2anisou_r1(ndomain,igroup,tmat,lmat,smat,
     &     xyz_ort0,uaniso_in,uaniso_out)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      integer ndomain
      integer igroup(n_atom)
      real tmat(6,ndomain),lmat(6,ndomain),smat(8,ndomain)
      real xyz_ort0(3,n_atom)
      real uaniso_in(6,n_atom),uaniso_out(6,n_atom)
c
      integer i,ia,idom,im
      real    x,y,z,uaniso_ort(6)
c
      im=1
      do ia=1,n_atom_mod(im)
         idom = igroup(ia)
         if(idom.gt.0.0) then
            x = xyz_ort0(1,ia)
            y = xyz_ort0(2,ia)
            z = xyz_ort0(3,ia)

            uaniso_ort(1:6) = uaniso_in(1:6,ia)

            UANISO_ORT(1) = UANISO_ORT(1) + TMAT(1,IDOM) + 
     +           LMAT(2,IDOM)*Z**2 + LMAT(3,IDOM)*Y**2 -
     +           2.0*LMAT(6,IDOM)*Y*Z +
     +           2.0*SMAT(6,IDOM)*Z - 2.0*SMAT(7,IDOM)*Y
            UANISO_ORT(2) = UANISO_ORT(2) + TMAT(2,IDOM) + 
     +           LMAT(3,IDOM)*X**2 + LMAT(1,IDOM)*Z**2 -
     +           2.0*LMAT(5,IDOM)*Z*X +
     +           2.0*SMAT(8,IDOM)*X - 2.0*SMAT(3,IDOM)*Z
            UANISO_ORT(3) = UANISO_ORT(3) + TMAT(3,IDOM) + 
     +           LMAT(1,IDOM)*Y**2 + LMAT(2,IDOM)*X**2 -
     +           2.0*LMAT(4,IDOM)*X*Y +
     +           2.0*SMAT(4,IDOM)*Y - 2.0*SMAT(5,IDOM)*X
            UANISO_ORT(4) = UANISO_ORT(4) + TMAT(4,IDOM) - 
     +           LMAT(4,IDOM)*Z**2 + LMAT(5,IDOM)*Y*Z +
     +           LMAT(6,IDOM)*X*Z - LMAT(3,IDOM)*X*Y +
     +           SMAT(7,IDOM)*X - SMAT(8,IDOM)*Y +
     +           SMAT(1,IDOM)*Z
            UANISO_ORT(5) = UANISO_ORT(5) + TMAT(5,IDOM) - 
     +           LMAT(5,IDOM)*Y**2 + LMAT(4,IDOM)*Y*Z +
     +           LMAT(6,IDOM)*X*Y - LMAT(2,IDOM)*X*Z +
     +           SMAT(5,IDOM)*Z - SMAT(6,IDOM)*X +
     +           SMAT(2,IDOM)*Y
            UANISO_ORT(6) = UANISO_ORT(6) + TMAT(6,IDOM) - 
     +           LMAT(6,IDOM)*X**2 + LMAT(5,IDOM)*Y*X +
     +           LMAT(4,IDOM)*X*Z - LMAT(1,IDOM)*Z*Y +
     +           SMAT(3,IDOM)*Y - SMAT(4,IDOM)*Z -
     +           (SMAT(1,IDOM) + SMAT(2,IDOM))*X
            uaniso_out(1:6,ia) = uaniso_ort(1:6)

         endif
      enddo

      return
      end
c
      subroutine tls_contribution(xyz,tlsorigin,tmat,lmat,smat,
     &     uaniso_out)
c
c--   calculate tls contributions
      implicit none
      real xyz(3),tlsorigin(3),tmat(6),lmat(6),smat(8)
      real uaniso_out(6)
c
c---  locals
      real x,y,z
c
c---  body
      x = xyz(1) - tlsorigin(1)
      y = xyz(2) - tlsorigin(2)
      z = xyz(3) - tlsorigin(3)
c
      uaniso_out(1) = tmat(1) + lmat(2)*z**2+
     &     lmat(3)*y**2-2.0*lmat(6)*y*z+2.0*smat(6)*z-2.0*smat(7)*y
      uaniso_out(2) =  tmat(2) + lmat(3)*x**2+
     &     lmat(1)*z**2-2.0*lmat(5)*x*z+2.0*smat(8)*x-2.0*smat(3)*z
      uaniso_out(3) =  tmat(3) + lmat(1)*y**2+
     &     lmat(2)*x**2-2.0*lmat(4)*x*y+2.0*smat(4)*y-2.0*smat(5)*x
      uaniso_out(4) =  tmat(4) - lmat(4)*z**2+lmat(5)*y*z+lmat(6)*x*z-
     &     lmat(3)*x*y + smat(7)*x - smat(8)*y + smat(1)*z 
      uaniso_out(5) =  tmat(5) - lmat(5)*y**2+lmat(4)*y*z+lmat(6)*x*y-
     &     lmat(2)*x*z + smat(5)*z - smat(6)*x + smat(2)*y 
      uaniso_out(6) =  tmat(6) - lmat(6)*x**2+lmat(5)*y*x+lmat(4)*x*z-
     &     lmat(1)*z*y + smat(3)*y - smat(4)*z - 
     &     (smat(1) + smat(2))*x 
c
      write(*,*)tmat
      write(*,*)lmat
      write(*,*)smat
      write(*,*)xyz
      write(*,*)tlsorigin
      write(*,*)uaniso_out
      return
      end

      SUBROUTINE TLS2ANISOU(LINITIAL)
      IMPLICIT NONE
C---Derive aniso-U from TLS tensors
C   These are held in U_ANISO(MAXATOM,6) in A**2 but w.r.t. crystallographic
C   axes.
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'

      REAL UANISO_ORT(6),X,Y,Z,u_min
      INTEGER IA,I,IANISO,IDOM,im
      INTEGER LWORK,INFO
      REAL UANISO0(3,3),UANISO1(6),EVALUE(3),WORKSPACE(100)
      LOGICAL LINITIAL,LRECALC
      real det3,det_l
      external det3
c
c---  body
      LWORK = 100
      im=1
 100  CONTINUE
C
C--May need to be removed
C
      CALL CALC_AMAT
c      write(*,*)uaniso_old_mod(1:3,1,im)
c      stop
      DO    IA=1,N_ATOM_mod(im)

        IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
        IDOM = IGROUP(IA)

        IF(IDOM.GT.0.AND.OCCUP_mod(IA,im).GT.0.0) THEN
c          X = XORT0(1,IA)
c          Y = XORT0(2,IA)
c          Z = XORT0(3,IA)
          x = xyz_crd_mod(1,ia,im) - tlsorigin(1,idom)
          y = xyz_crd_mod(2,ia,im) - tlsorigin(2,idom)
          z = xyz_crd_mod(3,ia,im) - tlsorigin(3,idom)

C---Transfer to UANISO_CELL
          IF(UANISO_OLD_mod(2,IA,im).NE.0.0) THEN
            DO I = 1,6
              UANISO_ORT(I) = UANISO_OLD_mod(I,IA,im)
            ENDDO
          ELSE
            UANISO_ORT(1) = UANISO_OLD_mod(1,IA,im)
            UANISO_ORT(2) = UANISO_OLD_mod(1,IA,im)
            UANISO_ORT(3) = UANISO_OLD_mod(1,IA,im)
            UANISO_ORT(4) = 0.0
            UANISO_ORT(5) = 0.0
            UANISO_ORT(6) = 0.0
          ENDIF

C---In the first call, the initial U_ANISO comes from XYZIN B factor
C   which contains contributions from individual factors and TLS parameters.
C   I.e. we start off with the correct isotropic value, which we preserve
C   while adding anisotropic component from initial TLS.
cd         IF (LINITIAL) 
cd     +    BISOOLD = (UANISO_ORT(1)+UANISO_ORT(2)+UANISO_ORT(3))/3.0

C---Symmetric tensors are in the order (1,1),(2,2),(3,3),(1,2),(1,3),(2,3)
C---The S tensor is in the order 
C   (2,2)-(1,1),(1,1)-(3,3),(1,2),(1,3),(2,3),(2,1),(3,1),(3,2)
C   Beware! RESTRAIN has different order.

C---If atom included in TLS analysis, derive U tensor in orthogonal units
C   See Table 2 of Schomaker and Trueblood
          UANISO_ORT(1) = UANISO_ORT(1) + TMAT(1,IDOM) + 
     +      LMAT(2,IDOM)*Z**2 + LMAT(3,IDOM)*Y**2 -
     +      2.0*LMAT(6,IDOM)*Y*Z +
     +      2.0*SMAT(6,IDOM)*Z - 2.0*SMAT(7,IDOM)*Y
          UANISO_ORT(2) = UANISO_ORT(2) + TMAT(2,IDOM) + 
     +      LMAT(3,IDOM)*X**2 + LMAT(1,IDOM)*Z**2 -
     +      2.0*LMAT(5,IDOM)*Z*X +
     +      2.0*SMAT(8,IDOM)*X - 2.0*SMAT(3,IDOM)*Z
          UANISO_ORT(3) = UANISO_ORT(3) + TMAT(3,IDOM) + 
     +      LMAT(1,IDOM)*Y**2 + LMAT(2,IDOM)*X**2 -
     +      2.0*LMAT(4,IDOM)*X*Y +
     +      2.0*SMAT(4,IDOM)*Y - 2.0*SMAT(5,IDOM)*X
          UANISO_ORT(4) = UANISO_ORT(4) + TMAT(4,IDOM) - 
     +      LMAT(4,IDOM)*Z**2 + LMAT(5,IDOM)*Y*Z +
     +      LMAT(6,IDOM)*X*Z - LMAT(3,IDOM)*X*Y +
     +      SMAT(7,IDOM)*X - SMAT(8,IDOM)*Y +
     +      SMAT(1,IDOM)*Z
          UANISO_ORT(5) = UANISO_ORT(5) + TMAT(5,IDOM) - 
     +      LMAT(5,IDOM)*Y**2 + LMAT(4,IDOM)*Y*Z +
     +      LMAT(6,IDOM)*X*Y - LMAT(2,IDOM)*X*Z +
     +      SMAT(5,IDOM)*Z - SMAT(6,IDOM)*X +
     +      SMAT(2,IDOM)*Y
          UANISO_ORT(6) = UANISO_ORT(6) + TMAT(6,IDOM) - 
     +      LMAT(6,IDOM)*X**2 + LMAT(5,IDOM)*Y*X +
     +      LMAT(4,IDOM)*X*Z - LMAT(1,IDOM)*Z*Y +
     +      SMAT(3,IDOM)*Y - SMAT(4,IDOM)*Z -
     +      (SMAT(1,IDOM) + SMAT(2,IDOM))*X

C---In the first call, restore correct isotropic component.
cd          IF (LINITIAL) THEN
cd           BISONEW = (UANISO_ORT(1)+UANISO_ORT(2)+UANISO_ORT(3))/3.0
cd           UANISO_ORT(1) = UANISO_ORT(1) - BISONEW + BISOOLD
cd           UANISO_ORT(2) = UANISO_ORT(2) - BISONEW + BISOOLD
cd           UANISO_ORT(3) = UANISO_ORT(3) - BISONEW + BISOOLD
cd          ENDIF

C
C---Make U vlues positive
                UANISO0(1,1) = UANISO_ORT(1)
                UANISO0(2,2) = UANISO_ORT(2)
                UANISO0(3,3) = UANISO_ORT(3)
                UANISO0(1,2) = UANISO_ORT(4)
                UANISO0(1,3) = UANISO_ORT(5)
                UANISO0(2,3) = UANISO_ORT(6)
                UANISO0(2,1) = UANISO0(1,2)
                UANISO0(3,1) = UANISO0(1,3)
                UANISO0(3,2) = UANISO0(2,3)
c                det_l = det3(uaniso0)
                call seig3dim(uaniso0,evalue,info)
c                if(evalue(1).lt.0) then
c                   write(*,*)'Negative U, TLS domain ',idom
c                   write(*,*)'xyz ',x,y,z
c                endif
cd                IF(EVALUE(1).LT.BResetMin.OR.EVALUE(2).LT.BResetMin.OR.
cd     &             EVALUE(3).LT.BResetMin.OR.EVALUE(1).GT.BResetMax.OR.
cd     &             EVALUE(2).GT.BResetMax.OR.EVALUE(3).GT.BResetMAX) 
cd     &                                   THEN
cd                  EVALUE(1)=AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(1)))
cd                  EVALUE(2)=AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(2)))
cd                  EVALUE(3)=AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(3)))
                  CALL EIGEN2U(EVALUE,UANISO0,UANISO1)
                  DO    IANISO=1,6
                    U_ANISO_mod(IANISO,IA,im) = UANISO_ORT(IANISO)
                    if (im.eq.1) U_ANISO(IANISO,IA) = UANISO_ORT(IANISO)
                  ENDDO
                  call find_min_eigen(u_aniso(1,ia),u_min)
                  if(u_min.lt.0.0) then
                     write(*,*)im
                     write(*,*)tmat(1:6,idom)
                     write(*,*)lmat(1:6,idom)
                     write(*,*)smat(1:8,idom)
                     write(*,*)uover_atom
                     write(*,*)'Problem'
                     write(*,*)'xyz ',ia,x,y,z,u_min,
     &                    u_aniso(1:6,ia),evalue,uaniso0(1,1:3)
                     stop
                  endif
cd                ENDIF
C---Transfer to U_ANISO 
cd          DO I = 1,6
cd            U_ANISO(I,IA) = UANISO_ORT(I)
cd          ENDDO
        ELSE
cd          DO  I=1,6
cd            U_ANISO(I,IA) = UANISO_OLD_mod(I,IA,im)
cd          ENDDO
C
          IF(UANISO_OLD_mod(2,IA,im).EQ.0.0) THEN
            if (im.eq.1) U_ANISO(1,IA) = UANISO_OLD_mod(1,IA,im)
            U_ANISO_mod(1,IA,im) = UANISO_OLD_mod(1,IA,im)
          ELSE
            DO   I=1,6
              U_ANISO_mod(I,IA,im) = UANISO_OLD_mod(I,IA,im)
              if (im.eq.1) U_ANISO(I,IA) = UANISO_OLD_mod(I,IA,im)

            ENDDO
          ENDIF
        ENDIF
        ENDIF
      ENDDO
C
C---Check positive definite
C
      LRECALC = .FALSE.
      IF (LRECALC) THEN
        DO IDOM=1,NTLSGRP
          IF (PRINT_TLSPARS) THEN
           WRITE(6,'(/,A,I4,A2,A)') ' TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
           WRITE(6,'(A11,I3,A4,6F8.3)') 'T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
           WRITE(6,'(A11,I3,A4,6F8.3)') 'L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
           WRITE(6,'(A11,I3,A4,9F8.3)') 'S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
          ENDIF
        ENDDO
        LINITIAL = .FALSE.
cd        GOTO 100
      ENDIF
c      uover_atom = 0.0
c      b_ls_over = 0.0
      RETURN
      END
C
      SUBROUTINE ADD_SCALE_CONTR
C
c---Adds contribution of scaling (isotropic u values) to individual U 
C---values
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
C
      INTEGER IA,im
C
      im = 1
      DO   IA=1,N_ATOM_mod(im)
        IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
        IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
           if(im.eq.1) U_ANISO(1,IA) = U_ANISO_mod(1,IA,im) + UOVER_ATOM
           U_ANISO_mod(1,IA,im) = U_ANISO_mod(1,IA,im) + UOVER_ATOM
        ELSE
           if(im.eq.1) U_ANISO(1,IA) = U_ANISO_mod(1,IA,im) + UOVER_ATOM
           if(im.eq.1) U_ANISO(2,IA) = U_ANISO_mod(2,IA,im) + UOVER_ATOM
           if(im.eq.1) U_ANISO(3,IA) = U_ANISO_mod(3,IA,im) + UOVER_ATOM
           U_ANISO_mod(1,IA,im) = U_ANISO_mod(1,IA,im) + UOVER_ATOM
           U_ANISO_mod(2,IA,im) = U_ANISO_mod(2,IA,im) + UOVER_ATOM
           U_ANISO_mod(3,IA,im) = U_ANISO_mod(3,IA,im) + UOVER_ATOM
        ENDIF
C
        IF(UANISO_OLD_mod(2,IA,im).LE.0.0) THEN
          UANISO_OLD_mod(1,IA,im) = UANISO_OLD_mod(1,IA,im) + UOVER_ATOM
        ELSE
          UANISO_OLD_mod(1,IA,im) = UANISO_OLD_mod(1,IA,im) + UOVER_ATOM
          UANISO_OLD_mod(2,IA,im) = UANISO_OLD_mod(2,IA,im) + UOVER_ATOM
          UANISO_OLD_mod(3,IA,im) = UANISO_OLD_mod(3,IA,im) + UOVER_ATOM
        ENDIF

        ENDIF
      ENDDO
      UOVER_ATOM = 0.0
      RETURN
      END
C
      SUBROUTINE MAKE_U_POSITIVE(nmodel)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      include 'tls.fh'

      integer nmodel
      INTEGER IA,im
      REAL U_MIN,UEIGEN
      integer jrs
      character chnnmp*4
C
      U_MIN = 1.0E32
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          read(res_num_pdb(i_resid_mod(ia,im))(3:6),*)jrs
          if (im.eq.1) call get_chain_namepdb(chnnmp,i_resid_mod(ia,im))
          IF(OCCUP_mod(IA,im).GT.0.0) THEN
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
               IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
                  U_MIN = AMIN1(U_MIN,U_ANISO(1,IA))
                  if(u_aniso_mod(1,ia,im).lt.BresetMin) then
c                     write(*,*)'Atom ',atm_name_inp(ia),chnnmp,
c     &                    jrs,u_aniso(1,ia)
                  endif
               ELSE
c                  write(*,*)ia,igroup(ia),u_aniso(1:6,ia)
                  CALL FIND_MIN_EIGEN(U_ANISO_mod(1,IA,im),UEIGEN)
                  U_MIN = AMIN1(U_MIN,UEIGEN)
                  if(ueigen.lt.0) then
                     write(*,*)'Atom ',atm_name_inp(ia),chnnmp,
     &                    jrs,ueigen
                  endif
               ENDIF
            ENDIF
          ENDIF
        ENDDO
      enddo
C
      IF(U_MIN.LT.BResetMin) THEN
        WRITE(*,*)'Problem in MAKE_U_POSITIVE',U_MIN,BResetMin
        do im=1,nmodel
          DO   IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              if (im.eq.1) U_ANISO(1,IA)=U_ANISO(1,IA)+BResetMin-U_MIN
              U_ANISO_mod(1,IA,im)=U_ANISO_mod(1,IA,im)+BResetMin-U_MIN
              IF (U_ANISO_mod(2,IA,im).ne.0.0) THEN
                if (im.eq.1) U_ANISO(2,IA)=U_ANISO(2,IA)+BResetMin-U_MIN
                if (im.eq.1) U_ANISO(3,IA)=U_ANISO(3,IA)+BResetMin-U_MIN
               U_ANISO_mod(2,IA,im)=U_ANISO_mod(2,IA,im)+BResetMin-U_MIN
               U_ANISO_mod(3,IA,im)=U_ANISO_mod(3,IA,im)+BResetMin-U_MIN
              ENDIF
            ENDIF
          ENDDO
        enddo
cd        UOVER_ATOM = UOVER_ATOM - BResetMin + U_MIN
cd        B_LS_OVER = B_LS_OVER0 + (BResetMin-U_MIN)*PISQ8
      ENDIF

      RETURN
      END
C
      SUBROUTINE CHECK_POSDEF_US(LRECALC)

      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'tls.fh'


      INTEGER IDOM,im
      LOGICAL LRECALC,ERROR
      REAL UANISO0(6),UANISO1(6),EVECTOR(9)

      LRECALC = .FALSE.

      im=1
      BMIN_LOCAL = 1.0E32
      DO    IA=1,N_ATOM_mod(im)
        IF(U_ANISO_mod(2,IA,im).NE.0.0) THEN
          CALL FIND_MIN_EIGEN(U_ANISO_mod(1,IA,im),EIGEN_MIN)
          BMIN_LOCAL = AMIN1(BMIN_LOCAL,EIGEN_MIN)
        ELSE
           BMIN_LOCAL = AMIN1(BMIN_LOCAL,U_ANISO_mod(1,IA,im))
        ENDIF
      ENDDO

      IF(BMIN_LOCAL.LT.BResetMin) THEN
cd        CALL ERRWRT(1,'We are here')
        DO    IDOM=1,NTLSGRP
          DO   I=1,3
            TMAT(I,IDOM) = TMAT(I,IDOM) + BResetMin - BMIN_LOCAL
          ENDDO
        ENDDO
        DO    IA=1,N_ATOM_mod(im)
cd          IF(IGROUP(IA).LE.0) THEN
            IF(U_ANISO_mod(2,IA,im).NE.0.0) THEN
              DO   I=1,3
                if (im.eq.1) U_ANISO(I,IA) = U_ANISO_mod(I,IA,im)
     &                                     + BResetMin-BMIN_LOCAL
                U_ANISO_mod(I,IA,im) = U_ANISO_mod(I,IA,im)
     &                                     + BResetMin-BMIN_LOCAL
              ENDDO
            ELSE
              if (im.eq.1) U_ANISO(1,IA) = U_ANISO_mod(1,IA,im)
     &                                   + BResetMin-BMIN_LOCAL
              U_ANISO_mod(1,IA,im) = U_ANISO_mod(1,IA,im)
     &                             + BResetMin-BMIN_LOCAL
            ENDIF
cd          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE CALC_AMAT

C---Calculates A matrices for particular set of orthogonal coordinates
C   obtained from XORT0(3,MAXATOM). Elements of A are orthogonal coordinates
C   w.r.t. TLS orgins, and are placed back in XORT0(3,MAXATOM).

C   Changing origin or equivalently XORT0 shouldn't affect converged values
C   of U, but does change corresponding values of T and S.
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'


      im=1
      DO    IA = 1,N_ATOM_mod(im)
         ITLSGRP = IGROUP(IA)
         IF(ITLSGRP.GT.0) THEN
           DO   IX=1,3
             XORT0(IX,IA) = xyz_crd_mod(IX,IA,im)-TLSORIGIN(IX,ITLSGRP)
           ENDDO
         ENDIF
      ENDDO

      RETURN
      END
       
      SUBROUTINE FIND_TLS_ORIGIN
C
C---Finds origin of each TLS group as centroid of atoms.
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'tls.fh'


      REAL QATOM(MAXTLSGRP)
      LOGICAL LORIGINSET(MAXTLSGRP)

      DO ITLSGRP = 1,NTLSGRP
        QATOM(ITLSGRP) = 0.0
        IF (TLSORIGIN(1,ITLSGRP).EQ.0.0) THEN
          LORIGINSET(ITLSGRP) = .FALSE.
          WRITE(6,'(/,A,I2,A,/)') 'Calculating TLS origin of group ',
     +                              ITLSGRP,' from centroid of group.'
        ELSE
          LORIGINSET(ITLSGRP) = .TRUE.
        ENDIF
      ENDDO
      DO    IA=1,N_ATOM
        ITLSGRP  = IGROUP(IA)
        IF(ITLSGRP.GT.0) THEN 
          IF(.NOT.LORIGINSET(ITLSGRP)) THEN
            DO    IX=1,3
              TLSORIGIN(IX,ITLSGRP) = TLSORIGIN(IX,ITLSGRP) +
     +                             xyz_crd_mod(IX,IA,1)*OCCUP_mod(IA,1)
            ENDDO
            QATOM(ITLSGRP) = QATOM(ITLSGRP) + OCCUP_mod(IA,1)
          ENDIF
        ENDIF
      ENDDO

      DO    ITLSGRP = 1,NTLSGRP
        IF(QATOM(ITLSGRP).GT.0.0 .AND. .NOT.LORIGINSET(ITLSGRP)) THEN
          DO   IX=1,3
            TLSORIGIN(IX,ITLSGRP)=TLSORIGIN(IX,ITLSGRP)/QATOM(ITLSGRP)
          ENDDO
        ENDIF
      ENDDO
      DO ITLSGRP = 1,NTLSGRP
        write(6,*) 'TLS origin for group ',ITLSGRP,
     +                           (TLSORIGIN(IX,ITLSGRP),IX=1,3)
      ENDDO

      RETURN
      END

      SUBROUTINE DERIVS_OF_TLS(gx_tls,hx_tls)
c
c---Add igroup, atom_ref_flag, xort0 into parameter list
C
C---Calculates derivatives of minimised function wrt TLS parameters.
C---using chain rule. 
C
C--- 1) Neglects second derivatives of U, but U linear in TLS.
C--- 2) Only diagonal terms w.r.t. atoms of second derivative of function 
C     wrt U are used. But HUU doesn't contain off-diagonal terms.
C--- 3) No cross-derivatives w.r.t. different TLS groups are included.
C     But these would need terms of 2) which aren't available.
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'refi_flags.fh'

c
      real*8 gx_tls(ntlsgrp,20),hx_tls(ntlsgrp,20,20)
c
      REAL DUDTLSGRP(6,20),DUDTLSGRP1(6,20),DUDTLSGRP2(6,20)

      INTEGER  NS_DIST(4)
  
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
C
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),  
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
C
cd      REAL HXX(6*MAXATOM),HUU(21*MAXATOM),HQQ(MAXATOM),HQU(6*MAXATOM)
cd      COMMON /REF_SEC/HXX,HUU,HQQ,HQU
C
      INTEGER IA,IA1,IA2,IA11,IA12,IA21,IA22,im
      REAL HX2DR(6)
      REAL H_XDD,H_UUD(3),H_UQD,H_QQD
      real h_uud_anom(3),h_uqd_anom,u_qqd_anom
      real xort0_l(3)
C
C---Initialise
      gx_tls(1:ntlsgrp,1:20)      = 0.0d0
      hx_tls(1:ntlsgrp,1:20,1:20) = 0.0d0
C
C---Calculate derivatives of minimised function wrt tlsgrp
C---parameters using chain rule. 
      IU   = 1
      IUU  = 1
      call calc_amat
      im = 1
      DO   IA=1,N_ATOM_mod(im)
        IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
          ITLSGRP = IGROUP(IA)
          IA11 = ATOM_REF_mod_FLAG(IA,im)/10
          IA21 = ATOM_REF_mod_FLAG(IA,im) - IA11*10
          IF(ITLSGRP.GT.0.AND.IA21.GT.2) THEN
             xort0_l(1:3) = xyz_crd(1:3,ia) - tlsorigin(1:3,itlsgrp)
             CALL DERIVS_WRT_TLSPARS(xort0_l(1:3),DUDTLSGRP)
             CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,H_UUD,H_UQD,H_QQD,
     &            h_uud_anom,h_uqd_anom,h_qqd_anom)  

             DO   IPAR = 1,20
                gx_tls(itlsgrp,ipar) = gx_tls(itlsgrp,ipar) + 
     +             (GU1(IU  )*DUDTLSGRP(1,IPAR)+
     +              GU1(IU+1)*DUDTLSGRP(2,IPAR)+
     +              GU1(IU+2)*DUDTLSGRP(3,IPAR)+
     +              GU1(IU+3)*DUDTLSGRP(4,IPAR)+
     +              GU1(IU+4)*DUDTLSGRP(5,IPAR)+
     +              GU1(IU+5)*DUDTLSGRP(6,IPAR))
                DO   IPAR1 = 1,20
c
C---First contribution: diagonal HUU elements
                  hx_tls(itlsgrp,ipar,ipar1)=hx_tls(itlsgrp,ipar,ipar1)+
     +               (H_UUD(1)*DUDTLSGRP(1,IPAR)*
     +                         DUDTLSGRP(1,IPAR1)+
     +               H_UUD(1)*DUDTLSGRP(2,IPAR)*
     +                        DUDTLSGRP(2,IPAR1)+
     +               H_UUD(1)*DUDTLSGRP(3,IPAR)*
     +                        DUDTLSGRP(3,IPAR1)+
     +               H_UUD(3)*DUDTLSGRP(4,IPAR)*
     +                        DUDTLSGRP(4,IPAR1)+
     +               H_UUD(3)*DUDTLSGRP(5,IPAR)*
     +                        DUDTLSGRP(5,IPAR1)+
     +               H_UUD(3)*DUDTLSGRP(6,IPAR)*
     +                        DUDTLSGRP(6,IPAR1))

C---Second contribution: off-diagonal HUU elements
                hx_tls(itlsgrp,ipar,ipar1)=hx_tls(itlsgrp,ipar,ipar1)+
     +           H_UUD(2)*(DUDTLSGRP(1,IPAR)*DUDTLSGRP(2,IPAR1) +
     +                     DUDTLSGRP(2,IPAR)*DUDTLSGRP(1,IPAR1)) +
     +           H_UUD(2)*(DUDTLSGRP(1,IPAR)*DUDTLSGRP(3,IPAR1) +
     +                     DUDTLSGRP(3,IPAR)*DUDTLSGRP(1,IPAR1)) +
     +           H_UUD(2)*(DUDTLSGRP(2,IPAR)*DUDTLSGRP(3,IPAR1) +
     +                     DUDTLSGRP(3,IPAR)*DUDTLSGRP(2,IPAR1))
              ENDDO
            ENDDO
          ENDIF
          IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
            IU  = IU  + 1
            IUU = IUU + 1
          ELSE
            IU  = IU  + 6
            IUU = IUU + 21
          ENDIF
        ENDIF
      ENDDO
c
      RETURN
      END

      SUBROUTINE DERIVS_WRT_TLSPARS(xort0,DUDTLSGRP)
C
C---Calculates derivatives of anisotropic displacement parameters wrt 
C---TLS parameters for atom IA and stores them in DUDTLSGRP

C---cf. RESTRAIN s/r lscalc line 9001

      real xort0(3)
      REAL DUDTLSGRP(6,20)

      integer itls,iu
      REAL X,Y,Z,XX,YY,ZZ,XY,XZ,YZ

      DO   ITLS = 1,20
       DO   IU = 1,6
         DUDTLSGRP(IU,ITLS) = 0.0
       ENDDO
      ENDDO

C---Contribution of T tensor
      DUDTLSGRP(1,1) = 1.0
      DUDTLSGRP(2,2) = 1.0
      DUDTLSGRP(3,3) = 1.0
      DUDTLSGRP(4,4) = 1.0
      DUDTLSGRP(5,5) = 1.0
      DUDTLSGRP(6,6) = 1.0

C---Contribution of L tensor
C   See G in Table 2 of Schomaker and Trueblood
      X = XORT0(1)
      Y = XORT0(2)
      Z = XORT0(3) 
      XX = X**2
      YY = Y**2
      ZZ = Z**2
      XY = X*Y
      XZ = X*Z
      YZ = Y*Z
      DUDTLSGRP(1, 8) = ZZ
      DUDTLSGRP(1, 9) = YY
      DUDTLSGRP(1,12) = -2.0*YZ
      DUDTLSGRP(2, 7) = ZZ
      DUDTLSGRP(2, 9) = XX
      DUDTLSGRP(2,11) = -2.0*XZ
      DUDTLSGRP(3, 7) = YY
      DUDTLSGRP(3, 8) = XX
      DUDTLSGRP(3,10) = -2.0*XY
      DUDTLSGRP(4, 9) = -XY
      DUDTLSGRP(4,10) = -ZZ
      DUDTLSGRP(4,11) = YZ
      DUDTLSGRP(4,12) = XZ
      DUDTLSGRP(5, 8) = -XZ
      DUDTLSGRP(5,10) = YZ
      DUDTLSGRP(5,11) = -YY
      DUDTLSGRP(5,12) = XY
      DUDTLSGRP(6, 7) = -YZ
      DUDTLSGRP(6,10) = XZ
      DUDTLSGRP(6,11) = XY
      DUDTLSGRP(6,12) = -XX

C---Contribution of S tensor
C   See H in Table 2 of Schomaker and Trueblood
      DUDTLSGRP(1,18) = 2.0*Z 
      DUDTLSGRP(1,19) = -2.0*Y
      DUDTLSGRP(2,20) = 2.0*X
      DUDTLSGRP(2,15) = -2.0*Z
      DUDTLSGRP(3,16) = 2.0*Y
      DUDTLSGRP(3,17) = -2.0*X
      DUDTLSGRP(4,19) = X
      DUDTLSGRP(4,20) = -Y
      DUDTLSGRP(4,13) = Z
      DUDTLSGRP(5,17) = Z
      DUDTLSGRP(5,18) = -X
      DUDTLSGRP(5,14) = Y
      DUDTLSGRP(6,15) = Y
      DUDTLSGRP(6,16) = -Z
      DUDTLSGRP(6,13) = -X
      DUDTLSGRP(6,14) = -X

      RETURN
      END

