C --- ENER_SUBR.FTN ---
C ------------------------------------------------------------
      SUBROUTINE ENER_TORS(MDOC,RS_NAME,RS_NTORS,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD,RS_CNS
     *     ,RMS_T,NT_GT_1S,NT_GT_3S,NT_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,LIST,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NTORS,RS_PRD
      REAL        X1(3),X2(3),X3(3),X(3),Y(3),Z(3)
      REAL        X4(3),V1(3),V4(3)
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MD    = -ABS(MDOC)-1
C -------------------------------
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)

      X3(1) = XYZ_CRD  (1,IA3)
      X3(2) = XYZ_CRD  (2,IA3)
      X3(3) = XYZ_CRD  (3,IA3)

      X4(1) = XYZ_CRD  (1,IA4)
      X4(2) = XYZ_CRD  (2,IA4)
      X4(3) = XYZ_CRD  (3,IA4)


      X(1) = X2(1) - X3(1)
      X(2) = X2(2) - X3(2)
      X(3) = X2(3) - X3(3)

      Y(1) = X1(1) - X2(1)
      Y(2) = X1(2) - X2(2)
      Y(3) = X1(3) - X2(3)

      CALL NB_VMOD(X,AX)
      CALL NB_VMOD(Y,AY)
      IF(AX.LE.0.1.OR.AY.LE.0.1) RETURN

      X(1) = X3(1) - X2(1)
      X(2) = X3(2) - X2(2)
      X(3) = X3(3) - X2(3)

      Y(1) = X4(1) - X3(1)
      Y(2) = X4(2) - X3(2)
      Y(3) = X4(3) - X3(3)

      CALL NB_VMOD(X,AX)
      CALL NB_VMOD(Y,AY)
      IF(AX.LE.0.1.OR.AY.LE.0.1) RETURN

      CALL CALC_TORS_E(X1,X2,X3,X4,PHI)
      ANGLE = PHI
      PHI   = PHI/PI180
C --
c#
c# _atom_type atomic chemical type
c# _const     Constant KPHI
c# _period    NPH number of minima in the function
c# _angle     angle DELTA
c#            PHI - actual angle 
c#
c#          ENERGY = KPHI * ( 1 - COS( NPH * PHI -   DELTA) )
c#
c
      ANGLE0 = RS_VIDL * PI180
      RSCNS  = RS_CNS  
      IPRD   = RS_PRD

C ---
      IF(IPRD.GT.0) RETURN


      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        SSLIM = -1
      ENDIF      

C      IF(RS_CNS.LE.0.001) THEN
C      ELSE

        RS_NTORS = RS_NTORS+1

        IF(RSCNS.LE.0.001) RSCNS = 10.0

        IF(IPRD.LE.0) THEN
          IPRD  = 1
          DELTA = ABS(RS_VIDL - PHI*IPRD)
          IF(DELTA.GT.180.0) THEN
            DELTA = ABS(DELTA-360.0)
          ENDIF 
          ANG  = (ANGLE-ANGLE0)
          IF(ANG.GT. PI) ANG = ANG - TWOPI
          IF(ANG.LE.-PI) ANG = ANG + TWOPI

          ENERGY = (RSCNS * ANG * ANG )/2.0
          DERIV  = RSCNS * ANG
          DERIV2 = 2.0 * RSCNS 

          IF(LIST.EQ.'T') THEN
            T=ANG/PI180
            WRITE(LINE,*) RS_PRD,RSCNS,ENERGY,T
            CALL MSGDOC(MD,LINE)
          ENDIF      

        ELSE

          DELTA = ABS(RS_VIDL - PHI*IPRD)
          IF(DELTA.GT.180.0) THEN
            DELTA = ABS(DELTA-360.0)
          ENDIF 

          ANG  = (ANGLE*IPRD-ANGLE0)
          IF(ANG.GT. PI) ANG = ANG - TWOPI
          IF(ANG.LE.-PI) ANG = ANG + TWOPI

          ENERGY = (RSCNS * (1.0  -  COS(ANG)))/2.0

          DERIV  = (RSCNS * IPRD * SIN(ANG))/2.0
          DERIV2 = RSCNS * IPRD * IPRD

        ENDIF

        CALL NB_VUNIT(X,Z,JERR)
        CALL NB_VMULT(Z,Y,V4)
        CALL NB_VMOD(V4,AV4)

        DERIVX4 = DERIV * V4(1)    
        DERIVY4 = DERIV * V4(2)    
        DERIVZ4 = DERIV * V4(3)    


        X(1) = X2(1) - X3(1)
        X(2) = X2(2) - X3(2)
        X(3) = X2(3) - X3(3)

        Y(1) = X1(1) - X2(1)
        Y(2) = X1(2) - X2(2)
        Y(3) = X1(3) - X2(3)


        CALL NB_VUNIT(X,Z,JERR)
        CALL NB_VMULT(Z,Y,V1)
        CALL NB_VMOD(V1,AV1)

        DERIVX1 = DERIV * V1(1)    
        DERIVY1 = DERIV * V1(2)    
        DERIVZ1 = DERIV * V1(3)    


c        I_BLOCK(IA1)=1
c        I_BLOCK(IA3)=1
        TORS_DER   (1,IA1) = TORS_DER   (1,IA1) + DERIVX1  
        TORS_DER   (2,IA1) = TORS_DER   (2,IA1) + DERIVY1  
        TORS_DER   (3,IA1) = TORS_DER   (3,IA1) + DERIVZ1  
        TORS_DER   (1,IA4) = TORS_DER   (1,IA4) + DERIVX4  
        TORS_DER   (2,IA4) = TORS_DER   (2,IA4) + DERIVY4  
        TORS_DER   (3,IA4) = TORS_DER   (3,IA4) + DERIVZ4  
        TORS_ENER  (  IA1) = TORS_ENER  (  IA1) + ENERGY 
        TORS_ENER  (  IA4) = TORS_ENER  (  IA4) + ENERGY 
        TORS_DER2  (IA1)   = TORS_DER2  (IA1) + DERIV2 * AV1
        TORS_DER2  (IA4)   = TORS_DER2  (IA4) + DERIV2 * AV4
        TORS_ENER_TOTAL    = TORS_ENER_TOTAL  + 2.0*ENERGY   
        TORS_ENER_RMS      = TORS_ENER_RMS    + 4.0*ENERGY*ENERGY   
        ENER_TOTAL         = ENER_TOTAL       + 2.0*ENERGY
        ENER_RMS           = ENER_RMS         + 4.0*ENERGY*ENERGY

        SD = RS_SDI
        IF(SD.LE.0.0) SD = 1.0
        TEST = ABS(DELTA)/SD
        IF(TEST.GT. 1.0) NT_GT_1S  = NT_GT_1S  + 1 
        IF(TEST.GT. 3.0) NT_GT_3S  = NT_GT_3S  + 1 
        IF(TEST.GT.10.0) NT_GT_10S = NT_GT_10S + 1
        RMS_T = RMS_T + DELTA*DELTA 

C        test=-1.0
        IF(TEST.GT.SSLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          A     = ANGLE/PI180
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *    ,RS_VIDL,RS_VOBS,A

 100      FORMAT(
     *    'TORS',1X,A4,A1,'- ',A4,A1,'- ',A4,A1,'- ',A4,A1
     *      ,' # PHI idl init obs:',F7.2,1X,F7.2,1X,F7.2)
          CALL MSGDOC(MD,LINE)

C      IF(RS_CNS.LE.0.001) THEN
c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,RS_CNS
c 200      FORMAT(5G12.4)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX4,DERIVY4,DERIVZ4,AV1,AV4
c          CALL MSGDOC(MD,LINE)
        ENDIF


C      ENDIF
 
      RETURN
      END

      SUBROUTINE ENER_ANGLE(MDOC,RS_NAME,RS_NANGL,RS_LABEL
     *     ,IA1,IA2,IA3,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,RMS_A,NA_GT_1S,NA_GT_3S,NA_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,LIST,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
      INCLUDE 'ref_com.fh'
C -----------
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NANGL
      REAL        X1(3),X2(3),X3(3),X(3),Y(3),Z(3),NOR(3)
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MD    = -ABS(MDOC)-1
C -------------------------------
      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        SSLIM = -1
      ENDIF      
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)

      X3(1) = XYZ_CRD  (1,IA3)
      X3(2) = XYZ_CRD  (2,IA3)
      X3(3) = XYZ_CRD  (3,IA3)
     
      DX1   = X1(1)-X2(1)
      DY1   = X1(2)-X2(2)
      DZ1   = X1(3)-X2(3)
      DX3   = X3(1)-X2(1)
      DY3   = X3(2)-X2(2)
      DZ3   = X3(3)-X2(3)

      X(1) = X1(1) - X2(1) 
      X(2) = X1(2) - X2(2) 
      X(3) = X1(3) - X2(3) 

      Y(1) = X3(1) - X2(1) 
      Y(2) = X3(2) - X2(2) 
      Y(3) = X3(3) - X2(3) 

      CALL NB_VMOD(X,AX)
      CALL NB_VMOD(Y,AY)
      IF(AX.LE.0.1.OR.AY.LE.0.1) RETURN
      CALL NB_VPROD(X,Y,S)
      COSA  = S/(AX*AY)


      IF(ABS(COSA).GT.1.0) THEN
        ANGLE = 0.0
        IF(COSA.LT.0.0) ANGLE=PI
      ELSE
        ANGLE = ACOS(COSA)
      ENDIF

C --
C#
C# _atom_type atomic chemical type
C# _const     constant KTHETA
C# _value     equilibrium value for the angle THETA0
C#           THETA - actual angle    
C#
C#           ENERGY = KTHETA * ( THETA - THETA0 )**2
C#
      ANGLE0 = RS_VIDL * PI180
      RSCNS  = RS_CNS  
C ---
      IF(ABS(ANGLE).LE.0.0.OR.RS_CNS.LE.0.01) THEN

      ELSE

        RS_NANGL = RS_NANGL +1

        DELTA  = (ANGLE-ANGLE0)

        ENERGY = (RSCNS * DELTA * DELTA)/2.0

        DERIV  = RSCNS * DELTA
        DERIV2 = 2.0 * RSCNS

        CALL NB_VMULT(X,Y,Z)
        CALL NB_VUNIT(Z,NOR,JERR)
        CALL NB_VMULT(X,NOR,Z)
        CALL NB_VMOD(Z,AZ1)
        DERIVX1 = DERIV * Z(1)    
        DERIVY1 = DERIV * Z(2)    
        DERIVZ1 = DERIV * Z(3)    
        CALL NB_VMULT(Y,X,Z)
        CALL NB_VUNIT(Z,NOR,JERR)
        CALL NB_VMULT(Y,NOR,Z)
        CALL NB_VMOD(Z,AZ3)
        DERIVX3 = DERIV * Z(1)
        DERIVY3 = DERIV * Z(2)
        DERIVZ3 = DERIV * Z(3)
c        I_BLOCK(IA1)=1
c        I_BLOCK(IA3)=1
        ANGLE_DER   (1,IA1) = ANGLE_DER   (1,IA1) + DERIVX1  
        ANGLE_DER   (2,IA1) = ANGLE_DER   (2,IA1) + DERIVY1  
        ANGLE_DER   (3,IA1) = ANGLE_DER   (3,IA1) + DERIVZ1  
        ANGLE_DER   (1,IA3) = ANGLE_DER   (1,IA3) + DERIVX3  
        ANGLE_DER   (2,IA3) = ANGLE_DER   (2,IA3) + DERIVY3  
        ANGLE_DER   (3,IA3) = ANGLE_DER   (3,IA3) + DERIVZ3  
        ANGLE_ENER  (  IA1) = ANGLE_ENER  (  IA1) + ENERGY 
        ANGLE_ENER  (  IA3) = ANGLE_ENER  (  IA3) + ENERGY 
        ANGLE_DER2  (IA1)   = ANGLE_DER2  (IA1) + DERIV2*AZ1 
        ANGLE_DER2  (IA3)   = ANGLE_DER2  (IA3) + DERIV2*AZ3
        ANGLE_ENER_TOTAL    = ANGLE_ENER_TOTAL  + 2.0*ENERGY   
        ANGLE_ENER_RMS      = ANGLE_ENER_RMS    + 4.0*ENERGY*ENERGY   
        ENER_TOTAL          = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS            = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD  = RS_SDI
        DLT = DELTA/PI180
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DLT)/SD
        IF(TEST.GT. 1.0) NA_GT_1S  = NA_GT_1S  + 1 
        IF(TEST.GT. 3.0) NA_GT_3S  = NA_GT_3S  + 1 
        IF(TEST.GT.10.0) NA_GT_10S = NA_GT_10S + 1
        RMS_A = RMS_A + DLT*DLT 

C        test=-1.0
        IF(TEST.GT.SSLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          A     = ANGLE/PI180
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *    ,RS_VIDL,RS_VOBS,A


 100      FORMAT(
     *    'ANGL',1X,A4,A1,'- ',A4,A1,'- ',A4,A1
     *      ,' # ANG idl init obs: ',F7.2,1X,F7.2,1X,F7.2)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2
c 200      FORMAT(4G12.4)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX3,DERIVY3,DERIVZ3,DERIV2
c          CALL MSGDOC(MD,LINE)
        ENDIF


      ENDIF

      RETURN
      END

      SUBROUTINE ENER_BOND(MDOC,RS_NAME,RS_NBOND,RS_LABEL,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
      INCLUDE 'ref_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NBOND
      REAL        X1(3),X2(3)
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      CONST = 8.0*PI*PI
      IERR  = 0
      MD    = -ABS(MDOC)-1
C -------------------------------
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)
C      B1    = B_ISO    (  IA1)
      B1    = U_ANISO(1,IA1)*CONST

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)
C      B2    = B_ISO    (  IA2)
      B2    = U_ANISO(1,IA2)*CONST

c #  
c #  _atom_type  atomic chemical type
c #  _const      constant KBOND
c #  _value     equilibrium length of this bond BOND0
c #              BOND - actual bond length 
c #
c #              ENERGY = KBOND * ( BOND - BOND0 )**2
c #
      DX     = X1(1)-X2(1)
      DY     = X1(2)-X2(2)
      DZ     = X1(3)-X2(3)
      DB     = B1   -B2 


      DLEN2  = (DX*DX+DY*DY+DZ*DZ) 
      DLEN   = SQRT(DLEN2)

      IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN
C ---
      IF(DLEN2.LE.0.01.OR.RS_CNS.LE.0.01) THEN

      ELSE

        RS_NBOND = RS_NBOND +1

        DELTA  = (DLEN-RS_VIDL)

        ENERGY = (RS_CNS * DELTA * DELTA)/2.0

        DERIV  = (RS_CNS * DELTA)/DLEN 
        DERIV2 =  2.0 * RS_CNS

        DERIVX = DERIV * DX
        DERIVY = DERIV * DY
        DERIVZ = DERIV * DZ
c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        BOND_DER   (1,IA1) = BOND_DER   (1,IA1) + DERIVX  
        BOND_DER   (2,IA1) = BOND_DER   (2,IA1) + DERIVY  
        BOND_DER   (3,IA1) = BOND_DER   (3,IA1) + DERIVZ  
        BOND_DER   (1,IA2) = BOND_DER   (1,IA2) - DERIVX  
        BOND_DER   (2,IA2) = BOND_DER   (2,IA2) - DERIVY  
        BOND_DER   (3,IA2) = BOND_DER   (3,IA2) - DERIVZ  
        BOND_ENER  (  IA1) = BOND_ENER  (  IA1) + ENERGY 
        BOND_ENER  (  IA2) = BOND_ENER  (  IA2) + ENERGY 
        BOND_DER2  (IA1)   = BOND_DER2  (IA1) + DERIV2 
        BOND_DER2  (IA2)   = BOND_DER2  (IA2) + DERIV2 
        BOND_ENER_TOTAL    = BOND_ENER_TOTAL    + 2.0*ENERGY   
        BOND_ENER_RMS      = BOND_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL         = ENER_TOTAL         + 2.0*ENERGY
        ENER_RMS           = ENER_RMS           + 4.0*ENERGY*ENERGY

        SD = RS_SDI
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
        IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
        IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
        RMS_B = RMS_B + DELTA*DELTA 

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RS_VIDL,RS_VOBS,DLEN


 100      FORMAT(
     *    'BOND',1X,A4,A1,'- ',A4,A1
     *      ,' # B idl init obs:',F7.3,1X,F7.3,1X,F7.3)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX,DERIVY,DERIVZ,DERIV2
c 200      FORMAT(4G12.4)
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF
C ----
      ELSE

      CNS = 8.0*PI*PI*RESOL

      IF(ABS(DB).LE.0.001.OR.CNS.LE.0.01) THEN

      ELSE

        RS_NBOND = RS_NBOND +1

        DELTA  = DB

        ENERGY = (CNS * DELTA * DELTA)/2.0

        DERIV  = (CNS * DELTA) 
        DERIV2 =  2.0 * CNS

        DERIVX = DERIV 
        BOND_DER   (1,IA1) = BOND_DER   (1,IA1) + DERIVX  
        BOND_DER   (1,IA2) = BOND_DER   (1,IA2) - DERIVX  
        BOND_ENER  (  IA1) = BOND_ENER  (  IA1) + ENERGY 
        BOND_ENER  (  IA2) = BOND_ENER  (  IA2) + ENERGY 
        BOND_DER2  (IA1)   = BOND_DER2  (IA1) + DERIV2 
        BOND_DER2  (IA2)   = BOND_DER2  (IA2) + DERIV2 
        BOND_ENER_TOTAL    = BOND_ENER_TOTAL    + 2.0*ENERGY   
        BOND_ENER_RMS      = BOND_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL         = ENER_TOTAL         + 2.0*ENERGY
        ENER_RMS           = ENER_RMS           + 4.0*ENERGY*ENERGY

        SD = 2.0
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
        IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
        IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
        RMS_B = RMS_B + DELTA*DELTA 


C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,300)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,B1,B2


 300      FORMAT(
     *    'BOND',1X,A4,A1,'- ',A4,A1
     *      ,' # B1 B2:',F7.3,1X,F7.3)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,400)
c     *    DERIVX,DERIV2,CNS
c 400      FORMAT(3G12.4)
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE ENER_VDW(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NVDW
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------

      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)

c#
c#  _atom_type      atomic chemical type
c#  _energy_min     EPSij  minimum of energy parameter
c#  _radius_min     Rmin radius of the minimum of energy parameter
c#                  Rij - actual distance
c#  _H_flag         "h" - the parameters for atoms with hydrogens 
c#
c#                      Lennard-Jones potential
c#
c#             ENERGY =  !EPSij! * ( (Rmin/Rij)**12 - 2 * (Rmin/Rij)**6 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS = 5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS = 4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS = 3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX = ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY = ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ = ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1) = CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *         CS_M_CS(3,1,IS)*TZ
      YF2(2) = CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *         CS_M_CS(3,2,IS)*TZ  
      YF2(3) = CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *         CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1) = CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *         CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2) = CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *         CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3) = CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *         CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R2.LE.0.01) THEN

      ELSE

        RSV_NVDW = RSV_NVDW +1

        COEF = 1.0
        IF(R.LT.1.0) THEN
          COEF = 1.0/R
          R2   = 1.0
          R    = 1.0
          D2   = 1.0
          D    = 1.0
        ENDIF

        DELTA  = (R-RSV_RIDL)

        RR     = RSV_RIDL/R
        RR2    = RR*RR
        RR6    = RR2*RR2*RR2
        RR12   = RR6*RR6
        CNS    = ABS(RSV_CNS)

        ENERGY = (CNS * (RR12 - 2.0 * RR6))/2.0

        DERIV  = (-6.0/R2)*(CNS * RR12 + ENERGY*2.0) * COEF
        DERIV2 = ABS((72.0*CNS)/(RSV_RIDL*RSV_RIDL)) *10.0

        DERIVX1 = DERIV * DX1 * 0.5
        DERIVY1 = DERIV * DY1 * 0.5
        DERIVZ1 = DERIV * DZ1 * 0.5

        DERIVX2 = DERIV * DX2 * 0.5
        DERIVY2 = DERIV * DY2 * 0.5
        DERIVZ2 = DERIV * DZ2 * 0.5

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        VDW_DER   (1,IA1) = VDW_DER   (1,IA1) + DERIVX1  
        VDW_DER   (2,IA1) = VDW_DER   (2,IA1) + DERIVY1  
        VDW_DER   (3,IA1) = VDW_DER   (3,IA1) + DERIVZ1  
        VDW_DER   (1,IA2) = VDW_DER   (1,IA2) + DERIVX2  
        VDW_DER   (2,IA2) = VDW_DER   (2,IA2) + DERIVY2  
        VDW_DER   (3,IA2) = VDW_DER   (3,IA2) + DERIVZ2  
        VDW_ENER  (  IA1) = VDW_ENER  (  IA1) + ENERGY 
        VDW_ENER  (  IA2) = VDW_ENER  (  IA2) + ENERGY 
        VDW_DER2  (IA1)   = VDW_DER2  (IA1) + DERIV2 
        VDW_DER2  (IA2)   = VDW_DER2  (IA2) + DERIV2 
        VDW_ENER_TOTAL    = VDW_ENER_TOTAL    + 2.0*ENERGY   
        VDW_ENER_RMS      = VDW_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL        = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS          = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD = 0.05
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
          IF(TEST.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
          IF(TEST.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
          RMS_VDW = RMS_VDW + DELTA*DELTA 
        ELSE
          TEST = -1.0
        ENDIF

C        test=-1
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,RSV_SYMM
 100      FORMAT('VDW ',1X,A4,A1,'- ',A4,A1
     *      ,' # B idl init obs:',F7.3,1X,F7.3,1X,F7.3,1X,A8)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
c 200      FORMAT(4G12.4,4i5)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF
C --------------------------------------
      RETURN
      END


      SUBROUTINE ENER_HB(MDOC,RSV_NAME,RSV_NHB,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NHB
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C -------------------------------
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)
c#
c#  _atom_type     atomic chemical type
c#  _hbond_min     EPSHij  energy at minimum
c#  _hbond_dist    RHmin distance at minimum of energy
c#                 RHij - actual distance
c#
c#         ENERGY = !EPSHij! * ( 5 * (RHmin/RHij)**12 - 6 * (RHmin/RHij)**10 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS = 5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS = 4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS = 3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX = ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY = ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ = ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1) = CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *         CS_M_CS(3,1,IS)*TZ
      YF2(2) = CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *         CS_M_CS(3,2,IS)*TZ  
      YF2(3) = CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *         CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1) = CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *         CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2) = CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *         CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3) = CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *         CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R2.LE.0.01) THEN

      ELSE

        RSV_NHB = RSV_NHB + 1

        COEF = 1.0
        IF(R.LT.1.0) THEN
          COEF = 1.0/R
          R2   = 1.0
          R    = 1.0
          D2   = 1.0
          D    = 1.0
        ENDIF
        DELTA  = (R-RSV_RIDL)
        RR     = RSV_RIDL/R
        RR2    = RR*RR
        RR6    = RR2*RR2*RR2
        RR10   = RR6*RR2*RR2
        RR12   = RR6*RR6
        CNS    = ABS(RSV_CNS)

        ENERGY = (CNS * (5.0 * RR12 - 6.0 * RR10))/2.0

        DERIV  = (-10.0/R2)*(CNS * RR12 + ENERGY*2.0) * COEF
        DERIV2 = ABS((120.0*CNS)/(RSV_RIDL*RSV_RIDL)) * 10.0

        DERIVX1 = DERIV * DX1 * 0.5
        DERIVY1 = DERIV * DY1 * 0.5
        DERIVZ1 = DERIV * DZ1 * 0.5
        DERIVX2 = DERIV * DX2 * 0.5
        DERIVY2 = DERIV * DY2 * 0.5
        DERIVZ2 = DERIV * DZ2 * 0.5

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        HB_DER   (1,IA1) = HB_DER   (1,IA1) + DERIVX1  
        HB_DER   (2,IA1) = HB_DER   (2,IA1) + DERIVY1  
        HB_DER   (3,IA1) = HB_DER   (3,IA1) + DERIVZ1  
        HB_DER   (1,IA2) = HB_DER   (1,IA2) + DERIVX2  
        HB_DER   (2,IA2) = HB_DER   (2,IA2) + DERIVY2  
        HB_DER   (3,IA2) = HB_DER   (3,IA2) + DERIVZ2  
        HB_ENER  (  IA1) = HB_ENER  (  IA1) + ENERGY 
        HB_ENER  (  IA2) = HB_ENER  (  IA2) + ENERGY 
        HB_DER2  (IA1)   = HB_DER2  (IA1) + DERIV2 
        HB_DER2  (IA2)   = HB_DER2  (IA2) + DERIV2 
        HB_ENER_TOTAL    = HB_ENER_TOTAL    + 2.0*ENERGY   
        HB_ENER_RMS      = HB_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL       = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS         = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD = 0.05
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NHB_GT_1S  = NHB_GT_1S  + 1 
          IF(TEST.GT. 3.0) NHB_GT_3S  = NHB_GT_3S  + 1 
          IF(TEST.GT.10.0) NHB_GT_10S = NHB_GT_10S + 1
          RMS_HB = RMS_HB + DELTA*DELTA 
        ELSE
          TEST =-1.0
        ENDIF

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,RSV_SYMM
 100      FORMAT(
     *    'HB  ',1X,A4,A1,'- ',A4,A1
     *      ,' # B idl init obs:',F7.3,1X,F7.3,1X,F7.3,1X,A8)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
c 200      FORMAT(4G12.4,4i5)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CALC_TORS_E(XX1,XX2,XX3,XX4,ANGOBS)
C -----------------------------------------------
C -P- CALC_TRSOBS - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      ANGOBS
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
C ---
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      X1 = XX1(1)
      Y1 = XX1(2)
      Z1 = XX1(3)

      X2 = XX2(1)
      Y2 = XX2(2)
      Z2 = XX2(3)

      X3 = XX3(1)
      Y3 = XX3(2)
      Z3 = XX3(3)

      X4 = XX4(1)
      Y4 = XX4(2)
      Z4 = XX4(3)

      A3 = X4-X3
      B3 = Y4-Y3
      C3 = Z4-Z3
      A2 = X3-X2
      B2 = Y3-Y2
      C2 = Z3-Z2
      A1 = X2-X1
      B1 = Y2-Y1
      C1 = Z2-Z1
      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z)
      E3   = SQRT(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z)
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG=1.
        IF(E1.LT.0.) COSG=-1.
      ELSE
        COSG = E1/(E2*E3)
      ENDIF
C---------------NOW WE ARE CALCULATING MIXED VECTORS------------------
C-----ABC=A1*(B2*C3-B3*C2)-A2*(B1*C3-B3*C1)+A3*(B1*C2-B2*C1) !-------
C------------------------------------------------------------------
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
      IF(ANGOBS.GT. PI ) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI ) ANGOBS = ANGOBS + TWOPI

      RETURN
      END

      SUBROUTINE CHECK_CHIR_EMIN(MDOC,RS_NAME,RS_NCHIR,RS_LABEL
     *     ,RS_NTORS,IA1,IA2,IA3,IA4
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,RMS_C,NC_GT_1S,NC_GT_3S,NC_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,LIST,IERR)
C ----------------------------------------------------------
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NCHIR,RS_NTORS
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
      REAL        V1(3),V2(3),V3(3),VT(3),V12(3),V13(3)
C ----------------------------------------------------------------
      IERR  = 0
      MD    = -ABS(MDOC)-1
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C --------
      RS_NCHIR = RS_NCHIR + 1
      CALL CALC_OVOL_PL(IA1,IA2,IA3,IA4,VOLOBS)

      VOL1 = RS_VIDL
      VOL2 = RS_VOBS  

      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(A,5I5,3F10.2,A)') 
     *  'TR:',RS_NCHIR,IA1,IA2,IA3,IA4,VOL1,VOL2,VOLOBS,RS_LABEL
        CALL MSGDOC(MD,LINE)
        SSLIM = -1
      ENDIF      

      PHIDL = RS_CNS*PI180
      IF(PHIDL.GT.TWOPI) RETURN

      IF(RS_LABEL(1:7).EQ.'negativ') THEN
        VOL1  = -VOL1
      ELSE IF(RS_LABEL(1:4).EQ.'both') THEN
        IF(VOLOBS.LT.0.0) VOL1  = -VOL1
      ENDIF

      DEL = ABS(VOL1-VOLOBS)
  
      I1 = IA2
      I2 = IA1
      I3 = IA3
      I4 = IA4
      V1(1) = XYZ_CRD(1,I2) - XYZ_CRD(1,I1) 
      V1(2) = XYZ_CRD(2,I2) - XYZ_CRD(2,I1) 
      V1(3) = XYZ_CRD(3,I2) - XYZ_CRD(3,I1) 
      V2(1) = XYZ_CRD(1,I3) - XYZ_CRD(1,I2) 
      V2(2) = XYZ_CRD(2,I3) - XYZ_CRD(2,I2) 
      V2(3) = XYZ_CRD(3,I3) - XYZ_CRD(3,I2) 
      V3(1) = XYZ_CRD(1,I4) - XYZ_CRD(1,I2) 
      V3(2) = XYZ_CRD(2,I4) - XYZ_CRD(2,I2) 
      V3(3) = XYZ_CRD(3,I4) - XYZ_CRD(3,I2) 
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VMOD(V3,AV3)
      CALL NB_VMULT(V1,V2,V12)
      CALL NB_VMOD(V12,AV12)
      CALL NB_VMULT(V1,V3,V13)
      CALL NB_VMOD(V13,AV13)
      IF(AV12.LE.0.001.OR.AV13.LE.0.001.OR.AV1.LE.0.1) GO TO 200

      CALL NB_VPROD(V12,V13,ACOS23)
      ACOS23 = ACOS23/(AV12*AV13)

      IF(ABS(ACOS23).GT.1.0) THEN
        PH = 0.0
        IF(ACOS23.LT.0.0) PH=PI
      ELSE
        PH = ACOS(ACOS23) 
      ENDIF

      CALL NB_VMULT(V1,V2,VT)
      CALL NB_VPROD(VT,V3,TEST)

      IF(TEST.LT.0.0) PH=-PH

      IF(PH.GT. PI) PH = PH - TWOPI        
      IF(PH.LE.-PI) PH = PH + TWOPI        

      CONST    = 8.0
      RS_NTORS = RS_NTORS + 1
      ANG      = PH-PHIDL
      IF(ANG.GT. PI) ANG = ANG - TWOPI        
      IF(ANG.LE.-PI) ANG = ANG + TWOPI        

      ENERGY = (CONST * ANG * ANG )/2.0

      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        T = ang/pi180
        t1= ph/pi180
        t2= phidl/pi180
        WRITE(LINE,'(A,6F10.2)') 
     *  'ch:', ENERGY,CONST,T,t1,t2,rs_cns
        CALL MSGDOC(MD,LINE)
        SSLIM = -1
      ENDIF      


      DERIV  = CONST * ANG
      DERIV2 = 2.0 * CONST 

      DERIVX3 = -DERIV * (V12(1)/AV1)    
      DERIVY3 = -DERIV * (V12(2)/AV1)
      DERIVZ3 = -DERIV * (V12(3)/AV1)

      DERIVX4 = DERIV * (V13(1)/AV1)
      DERIVY4 = DERIV * (V13(2)/AV1)
      DERIVZ4 = DERIV * (V13(3)/AV1)

c      I_BLOCK(I3)=1
c      I_BLOCK(I4)=1
      TORS_DER   (1,I3) = TORS_DER   (1,I3) + DERIVX3  
      TORS_DER   (2,I3) = TORS_DER   (2,I3) + DERIVY3  
      TORS_DER   (3,I3) = TORS_DER   (3,I3) + DERIVZ3  
      TORS_DER   (1,I4) = TORS_DER   (1,I4) + DERIVX4  
      TORS_DER   (2,I4) = TORS_DER   (2,I4) + DERIVY4  
      TORS_DER   (3,I4) = TORS_DER   (3,I4) + DERIVZ4  
      TORS_ENER  (  I3) = TORS_ENER  (  I3) + ENERGY 
      TORS_ENER  (  I4) = TORS_ENER  (  I4) + ENERGY 
      TORS_DER2  (I3)   = TORS_DER2  (I3) + DERIV2 * AV2
      TORS_DER2  (I4)   = TORS_DER2  (I4) + DERIV2 * AV3
      TORS_ENER_TOTAL   = TORS_ENER_TOTAL  + 2.0*ENERGY   
      TORS_ENER_RMS     = TORS_ENER_RMS    + 4.0*ENERGY*ENERGY   
      ENER_TOTAL        = ENER_TOTAL       + 2.0*ENERGY
      ENER_RMS          = ENER_RMS         + 4.0*ENERGY*ENERGY




 200  CONTINUE
      SD = 0.5
      IF(SD.LE.0.0) SD=1.0
      TEST = DEL/SD
      IF(TEST.GT. 1.0) NC_GT_1S  = NC_GT_1S  + 1 
      IF(TEST.GT. 3.0) NC_GT_3S  = NC_GT_3S  + 1 
      IF(TEST.GT.10.0) NC_GT_10S = NC_GT_10S + 1
      RMS_C = RMS_C + DEL*DEL 

C      test=-1.0
      IF(TEST.GT.SSLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG = 1

        WRITE(LINE,100) RS_NAME,RS_LABEL,
     *  ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *  ,VOL1,RS_VOBS,VOLOBS
 100    FORMAT(A4,1X,A8,
     *  A4,1X,A1,' : ',A4,1X,A1,',',A4,1X,A1,',',A4,1X,A1
     *          ,1X,F8.3,1X,F8.3,1X,F8.3)
        CALL MSGDOC(MD,LINE)

          A  = PH/PI180
          AI = PHIDL/PI180
          WRITE(LINE,300) A,AI,ENERGY
 300      FORMAT('PHI,PHIDL,E '
     *    ,1X,F7.2,1X,F7.2,1X,G12.4)
c          CALL MSGDOC(MD,LINE)
          WRITE(LINE,400)
     *    DERIVX3,DERIVY3,DERIVZ3,DERIV2,CONST
 400      FORMAT(5G12.4)
c          CALL MSGDOC(MD,LINE)
          WRITE(LINE,400)
     *    DERIVX4,DERIVY4,DERIVZ4,AV2,AV3
c          CALL MSGDOC(MD,LINE)


      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_PLAN_EMIN(MDOC,RS_NAME,RS_NPLAN,RS_LABEL
     *     ,RS_NTORS,RS_NUM,RS_NUM_OLD,IA1
     *     ,ATOM1,ALT1,RS_VIDL,RS_VOBS
     *     ,RMS_P,NP_GT_1S,NP_GT_3S,NP_GT_10S,SLIMR
     *     ,NA_PLAN,PL_LABEL,PL_IATOM,PL_ATOM,PL_ALT,PL_DEL,PL_DOBS
     *     ,PL_SD,MAXAPLN  
     *     ,C_LINE,IFLAG,LIST,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NPLAN,RS_NUM,RS_NUM_OLD,RS_NTORS
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,RES1*8
      REAL        V1(3),V2(3),V3(3),VT(3),V12(3),V13(3)

      INTEGER     NA_PLAN,PL_IATOM (MAXAPLN)
      CHARACTER   PL_LABEL*8
      CHARACTER   PL_ATOM  (MAXAPLN)*4
      CHARACTER   PL_ALT   (MAXAPLN)*1
      REAL        PL_DEL(MAXAPLN),PL_DOBS(MAXAPLN),PL_SD(MAXAPLN)
C --------------------------------------
      IERR  = 0
      MD    = -ABS(MDOC)-1
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -------------------------------
      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) 'RS_NUM,RS_NUM_OLD:',RS_NUM,RS_NUM_OLD
        CALL MSGDOC(MD,LINE)
        SSLIM = -1
      ENDIF      
C --------
      IF(RS_NUM.NE.RS_NUM_OLD) THEN
        IF(NA_PLAN.GE.4) THEN
          RS_NPLAN = RS_NPLAN + 1

          CALL  CALC_PLDEV_PL(NA_PLAN,PL_IATOM,PL_DEL)

          DO I=1,NA_PLAN
            DEL = ABS(PL_DEL(I))
            SD  = PL_SD (I)
            IF(SD.LE.0.0) SD=0.02
            TEST = DEL/SD
            IF(TEST.GT. 1.0) NP_GT_1S  = NP_GT_1S  + 1 
            IF(TEST.GT. 3.0) NP_GT_3S  = NP_GT_3S  + 1 
            IF(TEST.GT.10.0) NP_GT_10S = NP_GT_10S + 1
            RMS_P = RMS_P + DEL*DEL 
C            test=-1.0
            IF(TEST.GT.SSLIM) THEN
              IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
              IFLAG=1
              WRITE(LINE,100) PL_LABEL,
     *        PL_ATOM(I),PL_ALT(I),PL_SD(I),PL_DOBS(I),PL_DEL(I)
 100          FORMAT('PLAN',1X,A8,1X,
     *        A4,A1,' # DISP idl init obs: ',F8.3,1X,F8.3,1X,F8.3)
              CALL MSGDOC(MD,LINE)
            ENDIF
          ENDDO
          
          IF(NA_PLAN.EQ.4) THEN
            I1 = PL_IATOM(1)
            I2 = PL_IATOM(2)
            I3 = PL_IATOM(3)
            I4 = PL_IATOM(4)
            IF(I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) RETURN
            V1(1) = XYZ_CRD(1,I2) - XYZ_CRD(1,I1) 
            V1(2) = XYZ_CRD(2,I2) - XYZ_CRD(2,I1) 
            V1(3) = XYZ_CRD(3,I2) - XYZ_CRD(3,I1) 
            V2(1) = XYZ_CRD(1,I3) - XYZ_CRD(1,I2) 
            V2(2) = XYZ_CRD(2,I3) - XYZ_CRD(2,I2) 
            V2(3) = XYZ_CRD(3,I3) - XYZ_CRD(3,I2) 
            V3(1) = XYZ_CRD(1,I4) - XYZ_CRD(1,I2) 
            V3(2) = XYZ_CRD(2,I4) - XYZ_CRD(2,I2) 
            V3(3) = XYZ_CRD(3,I4) - XYZ_CRD(3,I2) 
            CALL NB_VMOD(V1,AV1)
            CALL NB_VMOD(V2,AV2)
            CALL NB_VMOD(V3,AV3)
            CALL NB_VMULT(V1,V2,V12)
            CALL NB_VMOD(V12,AV12)
            CALL NB_VMULT(V1,V3,V13)
            CALL NB_VMOD(V13,AV13)
            IF(AV12.LE.0.001.OR.AV13.LE.0.001.OR.AV1.LE.0.1)GO TO 200
            CALL NB_VPROD(V12,V13,ACOS23)
            ACOS23 = ACOS23/(AV12*AV13)


            IF(ABS(ACOS23).GT.1.0) THEN
              PH = 0.0
              IF(ACOS23.LT.0.0) PH=PI
            ELSE
              PH = ACOS(ACOS23) 
            ENDIF

            CALL NB_VMULT(V1,V2,VT)
            CALL NB_VPROD(VT,V3,TEST)
            IF(TEST.LT.0.0) PH=-PH

            IF(PH.GT. PI) PH = PH - TWOPI        
            IF(PH.LE.-PI) PH = PH + TWOPI        

            PHIDL = PI
            IF(ABS(PH).LT.(PI/2.0)) PHIDL=0.0
            CONST    = 8.0
            RS_NTORS = RS_NTORS + 1

            ANG      = PH-PHIDL

            IF(ANG.GT. PI) ANG = ANG - TWOPI        
            IF(ANG.LE.-PI) ANG = ANG + TWOPI        

            ENERGY = (CONST * ANG * ANG )/2.0

            DERIV  = CONST * ANG
            DERIV2 = 2.0 * CONST 

            DERIVX3 =  -DERIV * (V12(1)/AV1)    
            DERIVY3 =  -DERIV * (V12(2)/AV1)
            DERIVZ3 =  -DERIV * (V12(3)/AV1)

            DERIVX4 =  DERIV * (V13(1)/AV1)
            DERIVY4 =  DERIV * (V13(2)/AV1)
            DERIVZ4 =  DERIV * (V13(3)/AV1)

c            I_BLOCK(I3)=1
c            I_BLOCK(I4)=1
            TORS_DER   (1,I3) = TORS_DER   (1,I3) + DERIVX3  
            TORS_DER   (2,I3) = TORS_DER   (2,I3) + DERIVY3  
            TORS_DER   (3,I3) = TORS_DER   (3,I3) + DERIVZ3  
            TORS_DER   (1,I4) = TORS_DER   (1,I4) + DERIVX4  
            TORS_DER   (2,I4) = TORS_DER   (2,I4) + DERIVY4  
            TORS_DER   (3,I4) = TORS_DER   (3,I4) + DERIVZ4  
            TORS_ENER  (  I3) = TORS_ENER  (  I3) + ENERGY 
            TORS_ENER  (  I4) = TORS_ENER  (  I4) + ENERGY 
            TORS_DER2  (I3)   = TORS_DER2  (I3) + DERIV2 * AV2
            TORS_DER2  (I4)   = TORS_DER2  (I4) + DERIV2 * AV3
            TORS_ENER_TOTAL   = TORS_ENER_TOTAL  + 2.0*ENERGY   
            TORS_ENER_RMS     = TORS_ENER_RMS    + 4.0*ENERGY*ENERGY   
            ENER_TOTAL        = ENER_TOTAL       + 2.0*ENERGY
            ENER_RMS          = ENER_RMS         + 4.0*ENERGY*ENERGY




            A    = PH/PI180
            AI   = PHIDL/PI180
            AN   = ANG/PI180
            SD   = 2.0
            TEST = ABS(AN)/SD
C           test=-1.0
            IF(TEST.GT.SLIM) THEN

              WRITE(LINE,500) PL_LABEL
     *        ,PL_ATOM(1),PL_ALT(1),PL_ATOM(2),PL_ALT(2)
     *        ,PL_ATOM(3),PL_ALT(3),PL_ATOM(4),PL_ALT(4)
 500          FORMAT('PLAN',1X,A8,1X,4(A4,A1,1X))
c              CALL MSGDOC(MD,LINE)

              WRITE(LINE,300) A,AI,AN,ENERGY
 300          FORMAT('PHI,PHIDL,ANG,E '
     *        ,1X,F7.2,1X,F7.2,1X,F7.2,1X,G12.4)
c              CALL MSGDOC(MD,LINE)
              WRITE(LINE,400)
     *        DERIVX3,DERIVY3,DERIVZ3,DERIV2,CONST
 400          FORMAT(5G12.4)
c              CALL MSGDOC(MD,LINE)
              WRITE(LINE,400)
     *        DERIVX4,DERIVY4,DERIVZ4,AV2,AV3
c              CALL MSGDOC(MD,LINE)

            ENDIF

          ENDIF
 200      CONTINUE
        ENDIF
        NA_PLAN = 0
      ENDIF

      IF(RS_NUM_OLD.EQ.-2) RETURN

      NA_PLAN           = NA_PLAN+1
      PL_LABEL          = RS_LABEL
      PL_IATOM(NA_PLAN) = IA1
      PL_ATOM (NA_PLAN) = ATOM1
      PL_ALT  (NA_PLAN) = ALT1
      PL_DEL  (NA_PLAN) = 0.0
      PL_SD   (NA_PLAN) = RS_VIDL 
      PL_DEL  (NA_PLAN) = 0.0
      PL_DOBS (NA_PLAN) = RS_VOBS

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) 'NA,IA1:',NA_PLAN,IA1,';',ATOM1,';',RS_LABEL,';'
        CALL MSGDOC(MD,LINE)
      ENDIF      

      RETURN
      END

C ******
      SUBROUTINE CALC_OVOL_PL(I1,I2,I3,I4,VOLOBS)
C -----------------------------------------------
C -P- CALC_VOL - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      VOLOBS
      INTEGER*4 IC
C ---
      INCLUDE 'atom_com.fh'
C ******
      REAL A(9)
      INTEGER*4 I1,I2,I3,I4
      CHARACTER NAME*4
C ---------------------------------------
      VOLOBS = 0.0

      A(1)=XYZ_CRD(1,I2)-XYZ_CRD(1,I1)
      A(4)=XYZ_CRD(2,I2)-XYZ_CRD(2,I1)
      A(7)=XYZ_CRD(3,I2)-XYZ_CRD(3,I1)
      A(2)=XYZ_CRD(1,I3)-XYZ_CRD(1,I1)
      A(5)=XYZ_CRD(2,I3)-XYZ_CRD(2,I1)
      A(8)=XYZ_CRD(3,I3)-XYZ_CRD(3,I1)
      A(3)=XYZ_CRD(1,I4)-XYZ_CRD(1,I1)
      A(6)=XYZ_CRD(2,I4)-XYZ_CRD(2,I1)
      A(9)=XYZ_CRD(3,I4)-XYZ_CRD(3,I1)

      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))
      RETURN
      END


C ******
      SUBROUTINE  CALC_PLDEV_PL(N,IATM,DEL)
C -----------------------------------------------
C -P- CALC_PLDEV - 
C -S-
      INTEGER*4 N,IATM(*)
C ---
      INCLUDE 'atom_com.fh'
C ******
      PARAMETER  (MAXAPLN = 100)
      REAL      X(3,MAXAPLN),DEL(*),VM(3)
C -------------------------------------------------
      DO  I = 1,N
          II=IATM(I)
          X(1,I)=XYZ_CRD (1,II)
          X(2,I)=XYZ_CRD (2,II)
          X(3,I)=XYZ_CRD (3,II)
      ENDDO

      CALL FIT_PLANE_EMIN(N,X,VM,D)

      DO  I = 1,N
        DEL(I)=0
        DO J=1,3
          DEL(I)=DEL(I)+VM(J)*X(J,I)
        ENDDO
        DEL(I)=DEL(I)-D
      ENDDO
      RETURN
      END      

      SUBROUTINE FIT_PLANE_EMIN(N,X,VM,D)
C -P- PLAN - fit a least-squares plan to a set of points.
C -S-
C     PROCEDURE OF SCHOMAKER ET AL.(ACTA CRYST.,12,600,1959)
C
C ******
      REAL   X(3,*),XS(3),XXS(3,3),B(3,3),A(3,3)
      REAL   VM(3),VMI(3),BV(3)
      DATA   ZIP/1.0E-5/
      DATA   MM/10/
C ------------------------------------
C
C----SET UP THE A MATRIX
      SN = N
      IF(N.LE.0) STOP ' N =< 0 in subroutine "FIT_PLANE"'
C ---
      DO    I=1,3
        XS(I) = 0
        DO    K=1,N
          XS(I) = XS(I) + X(I,K)
        ENDDO
      ENDDO
C ---
      DO    I=1,3
        DO    J=1,3
          XXS(I,J) = 0
          DO    K=1,N
            XXS(I,J) = XXS(I,J) + X(I,K)*X(J,K)
          ENDDO
          A(I,J) = XXS(I,J) - XS(I)*XS(J)/SN
        ENDDO
      ENDDO
C
C----EVALUATE MATRIX B=ADJ(A)*G
C
      B(1,1) = A(2,2)*A(3,3)-A(2,3)*A(3,2)
      B(2,1) = A(3,1)*A(2,3)-A(2,1)*A(3,3)
      B(3,1) = A(2,1)*A(3,2)-A(3,1)*A(2,2)
      B(1,2) = A(3,2)*A(1,3)-A(1,2)*A(3,3)
      B(2,2) = A(1,1)*A(3,3)-A(3,1)*A(1,3)
      B(3,2) = A(3,1)*A(1,2)-A(1,1)*A(3,2)
      B(1,3) = A(1,2)*A(2,3)-A(1,3)*A(2,2)
      B(2,3) = A(2,1)*A(1,3)-A(1,1)*A(2,3)
      B(3,3) = A(1,1)*A(2,2)-A(2,1)*A(1,2)

C
C----CHOOSE THE LARGEST COLUMN VECTOR OF B AS THE INITIAL SOLUTION
C
      BV(1) = B(1,1)**2+B(2,1)**2+B(3,1)**2
      BV(2) = B(1,2)**2+B(2,2)**2+B(3,2)**2
      BV(3) = B(1,3)**2+B(2,3)**2+B(3,3)**2

      KK    = 1
      IF(BV(2).GT.BV( 1)) KK = 2
      IF(BV(3).GT.BV(KK)) KK = 3
      VM1 = B(1,KK)

      IF(ABS(VM1).LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      VMI_MIN = 1E30
      DO    I=1,3
        VMI(I) = B(I,KK)/VM1
        IF(ABS(VMI(I)).LT.VMI_MIN) VMI_MON = ABS(VMI(I))
      ENDDO

      IF(VMI_MIN.LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

C
C----SOLVE TO CONVERGENCE BY ITERATION OF M(I)=B*M(I-1)
C
      DO    NNN=1,MM
        VM(1)  = B(1,1)*VMI(1)+B(1,2)*VMI(2)+B(1,3)*VMI(3)
        VM(2)  = B(2,1)*VMI(1)+B(2,2)*VMI(2)+B(2,3)*VMI(3)
        VM(3)  = B(3,1)*VMI(1)+B(3,2)*VMI(2)+B(3,3)*VMI(3)
        IF(ABS(VMI(1)).LT.ZIP) GO TO 110
        IF(ABS(VMI(2)).LT.ZIP) GO TO 110
        IF(ABS(VMI(3)).LT.ZIP) GO TO 110
        RATIO1 = VM(1)/VMI(1)
        RATIO2 = VM(2)/VMI(2)
        RATIO3 = VM(3)/VMI(3)
        RAT12  = ABS(RATIO2/RATIO1-1.0)
        RAT13  = ABS(RATIO3/RATIO1-1.0)
        IF(RAT12.LT.ZIP.AND.RAT13.LT.ZIP) GO TO 110
        IF(ABS(VM(1)).LT.ZIP) GO TO 110
        DO    I=1,3
          VMI(I) = VM(I)/VM(1)
        ENDDO
      ENDDO   
C
C----NORMALIZE THE SOLUTION VECTOR AND EVALUATE D(PLANE TO ORIGIN DISTAN
C
  110 ORM = 0
      DO    I=1,3
        ORM = ORM + VM(I)*VM(I)
      ENDDO

      ORM = SQRT(ABS(ORM))

      IF(ORM.LT.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      DO     I=1,3
        VM(I) = VM(I)/ORM
      ENDDO

      D = (VM(1)*XS(1)+VM(2)*XS(2)+VM(3)*XS(3))/SN

      RETURN
      END

      SUBROUTINE ENER_HB_2(MDOC,RSV_NAME,RSV_NHB,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NHB
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      X1(1)= XYZ_CRD  (1,IA1)
      X1(2)= XYZ_CRD  (2,IA1)
      X1(3)= XYZ_CRD  (3,IA1)

      X2(1)= XYZ_CRD  (1,IA2)
      X2(2)= XYZ_CRD  (2,IA2)
      X2(3)= XYZ_CRD  (3,IA2)
c#
c#  _atom_type     atomic chemical type
c#  _hbond_min     EPSHij  energy at minimum
c#  _hbond_dist    RHmin distance at minimum of energy
c#                 RHij - actual distance
c#
c#            ENERGY = !EPSHij! * ( (RHmin/RHij)**12 - 2 * (RHmin/RHij)**10 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS=5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS=4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS=3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX=ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY=ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ=ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1)= CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *        CS_M_CS(3,1,IS)*TZ
      YF2(2)= CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *        CS_M_CS(3,2,IS)*TZ  
      YF2(3)= CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *        CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1)= CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *        CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2)= CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *        CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3)= CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *        CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R2.LE.0.01) THEN

      ELSE

        COEF=1.0
        IF(R.LT.0.5) THEN
          COEF = 1.0/R
          R2= 0.5
          R = 0.5
        ENDIF
        DELTA  = (R-RSV_RIDL)
 
        RSV_NHB = RSV_NHB + 1

        CNS    = ABS(RSV_CNS)

        CNS    = 20.0

        IF(DELTA.GE.0.0) GO TO 300

        ENERGY = (CNS * DELTA * DELTA )/2.0
        DERIV  = (CNS * DELTA * COEF  )/R 
        DERIV2 =  2.0 * CNS

        DERIVX1 = DERIV * DX1
        DERIVY1 = DERIV * DY1
        DERIVZ1 = DERIV * DZ1
        DERIVX2 = DERIV * DX2
        DERIVY2 = DERIV * DY2
        DERIVZ2 = DERIV * DZ2

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        HB_DER   (1,IA1)= HB_DER   (1,IA1) + DERIVX1  
        HB_DER   (2,IA1)= HB_DER   (2,IA1) + DERIVY1  
        HB_DER   (3,IA1)= HB_DER   (3,IA1) + DERIVZ1  
        HB_DER   (1,IA2)= HB_DER   (1,IA2) + DERIVX2  
        HB_DER   (2,IA2)= HB_DER   (2,IA2) + DERIVY2  
        HB_DER   (3,IA2)= HB_DER   (3,IA2) + DERIVZ2  
        HB_ENER  (  IA1)= HB_ENER  (  IA1) + ENERGY 
        HB_ENER  (  IA2)= HB_ENER  (  IA2) + ENERGY 
        HB_DER2  (IA1)  = HB_DER2  (IA1) + DERIV2 
        HB_DER2  (IA2)  = HB_DER2  (IA2) + DERIV2 
        HB_ENER_TOTAL   = HB_ENER_TOTAL    + 2.0*ENERGY   
        HB_ENER_RMS     = HB_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL       = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS         = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD=0.1
        IF(SD.LE.0.0) SD=1.0
        TEST=ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NHB_GT_1S  = NHB_GT_1S  + 1 
          IF(TEST.GT. 3.0) NHB_GT_3S  = NHB_GT_3S  + 1 
          IF(TEST.GT.10.0) NHB_GT_10S = NHB_GT_10S + 1
          RMS_HB = RMS_HB + DELTA*DELTA 
        ENDIF

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG=1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,D,ENERGY,RSV_SYMM,RSV_CNS
 100      FORMAT(
     *    'HB  ',1X,A4,A1,'- ',A4,A1
     *      ,1X,F7.3,1X,F7.3,1X,2F7.3,G12.4,1X,A8,F7.3)
          CALL MSGDOC(MD,LINE)

          WRITE(LINE,200)
     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
 200      FORMAT(4G12.4,4i5)
          CALL MSGDOC(MD,LINE)
          WRITE(LINE,200)
     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
          CALL MSGDOC(MD,LINE)
        ENDIF
 300    CONTINUE

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE ENER_VDW_2(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NVDW
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      X1(1)= XYZ_CRD  (1,IA1)
      X1(2)= XYZ_CRD  (2,IA1)
      X1(3)= XYZ_CRD  (3,IA1)

      X2(1)= XYZ_CRD  (1,IA2)
      X2(2)= XYZ_CRD  (2,IA2)
      X2(3)= XYZ_CRD  (3,IA2)

c#
c#  _atom_type      atomic chemical type
c#  _energy_min     EPSij  minimum of energy parameter
c#  _radius_min     Rmin radius of the minimum of energy parameter
c#                  Rij - actual distance
c#  _H_flag         "h" - the parameters for atoms with hydrogens 
c#
c#                      Lennard-Jones potential
c#
c#             ENERGY =  !EPSij! * ( (Rmin/Rij)**12 - 2 * (Rmin/Rij)**6 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS=5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS=4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS=3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX=ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY=ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ=ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1)= CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *        CS_M_CS(3,1,IS)*TZ
      YF2(2)= CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *        CS_M_CS(3,2,IS)*TZ  
      YF2(3)= CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *        CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1)= CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *        CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2)= CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *        CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3)= CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *        CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R2.LE.0.01) THEN

      ELSE

        RSV_NVDW = RSV_NVDW +1

        COEF=1.0
        IF(R.LT.1.0) THEN
          COEF = 1.0/R
          R2= 1.0
          R = 1.0
          D2= 1.0
          D = 1.0
        ENDIF

        DELTA  = (R-RSV_RIDL)

        RR     = RSV_RIDL/R
        RR2    = RR*RR
        RR6    = RR2*RR2*RR2
        RR12   = RR6*RR6
        CNS    = ABS(RSV_CNS)

        CNS    = 20.0
        IF(DELTA.GE.0.0) GO TO 300

        ENERGY = (CNS * DELTA * DELTA )/2.0
        DERIV  = (CNS * DELTA * COEF  )/R 
        DERIV2 =  2.0 * CNS

        DERIVX1 = DERIV * DX1
        DERIVY1 = DERIV * DY1
        DERIVZ1 = DERIV * DZ1

        DERIVX2 = DERIV * DX2
        DERIVY2 = DERIV * DY2
        DERIVZ2 = DERIV * DZ2

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        VDW_DER   (1,IA1)= VDW_DER   (1,IA1) + DERIVX1  
        VDW_DER   (2,IA1)= VDW_DER   (2,IA1) + DERIVY1  
        VDW_DER   (3,IA1)= VDW_DER   (3,IA1) + DERIVZ1  
        VDW_DER   (1,IA2)= VDW_DER   (1,IA2) + DERIVX2  
        VDW_DER   (2,IA2)= VDW_DER   (2,IA2) + DERIVY2  
        VDW_DER   (3,IA2)= VDW_DER   (3,IA2) + DERIVZ2  
        VDW_ENER  (  IA1)= VDW_ENER  (  IA1) + ENERGY 
        VDW_ENER  (  IA2)= VDW_ENER  (  IA2) + ENERGY 
        VDW_DER2  (IA1)  = VDW_DER2  (IA1) + DERIV2 
        VDW_DER2  (IA2)  = VDW_DER2  (IA2) + DERIV2 
        VDW_ENER_TOTAL   = VDW_ENER_TOTAL    + 2.0*ENERGY   
        VDW_ENER_RMS     = VDW_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL       = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS         = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD=0.1
        IF(SD.LE.0.0) SD=1.0
        TEST=ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
          IF(TEST.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
          IF(TEST.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
          RMS_VDW = RMS_VDW + DELTA*DELTA 
        ENDIF

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG=1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,D,ENERGY,RSV_SYMM,RSV_CNS
 100      FORMAT(
     *    'VDW ',1X,A4,A1,'- ',A4,A1
     *      ,1X,F7.3,1X,F7.3,1X,2F7.3,G12.4,1X,A8,F7.3)
          CALL MSGDOC(MD,LINE)

          WRITE(LINE,200)
     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
 200      FORMAT(4G12.4,4i5)
          CALL MSGDOC(MD,LINE)
          WRITE(LINE,200)
     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
          CALL MSGDOC(MD,LINE)
        ENDIF

 300    CONTINUE
  
      ENDIF
C --------------------------------------
      RETURN
      END
C ==============================================================
C ------------------------------------------------------------
      SUBROUTINE GET_TORS_EMIN(MDOC,RS_NAME,NTORS,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NTORS,RS_PRD
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      PI   =4.0*ATAN(1.0)
      TWOPI=2.0*PI
      PI180=PI/180.0
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NTORS.GE.MAXRTORS) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of tors restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRTORS in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NTORS = NTORS + 1
      RT_VIDL  (NTORS) = RS_VIDL
      RT_SDID  (NTORS) = RS_SDI
      RT_VOBS  (NTORS) = RS_VOBS
      RT_CNST  (NTORS) = RS_CNS
      RT_ANGLE (NTORS) = 0.0
      RT_IA1  (NTORS)  = IA1
      RT_IA2  (NTORS)  = IA2
      RT_IA3  (NTORS)  = IA3
      RT_IA4  (NTORS)  = IA4
      RT_PRD  (NTORS)  = RS_PRD
      RT_LABEL(NTORS)  = RS_LABEL
      RT_TYPE (NTORS)  = ' '
      RT_FLAG (NTORS)  = ' '
      RETURN
      END

      SUBROUTINE GET_ANGLE_EMIN(MDOC,RS_NAME,NANGL,RS_LABEL
     *     ,IA1,IA2,IA3
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NANGL
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      PI   =4.0*ATAN(1.0)
      TWOPI=2.0*PI
      PI180=PI/180.0
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NANGL.GE.MAXRANGL) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of angle restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRANGL in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NANGL = NANGL + 1
      RA_VIDL  (NANGL) = RS_VIDL
      RA_SDID  (NANGL) = RS_SDI
      RA_VOBS  (NANGL) = RS_VOBS
      RA_CNST  (NANGL) = RS_CNS
      RA_ANGLE (NANGL) = 0.0
      RA_IA1   (NANGL)  = IA1
      RA_IA2   (NANGL)  = IA2
      RA_IA3   (NANGL)  = IA3
      RA_TYPE  (NANGL)  = ' '
      RA_FLAG  (NANGL)  = ' '
      RETURN
      END

      SUBROUTINE GET_BOND_EMIN(MDOC,RS_NAME,NBOND,RS_LABEL,IA1,IA2
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NBOND
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NBOND.GE.MAXRBOND) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of bond restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRBOND in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NBOND = NBOND + 1
      RB_VIDL  (NBOND) = RS_VIDL
      RB_SDID  (NBOND) = RS_SDI
      RB_VOBS  (NBOND) = RS_VOBS
      RB_CNST  (NBOND) = RS_CNS
      RB_LENGTH(NBOND) = 0.0
      RB_IA1   (NBOND) = IA1
      RB_IA2   (NBOND) = IA2
      RB_CHEM  (NBOND) = RS_LABEL
      RB_TYPE  (NBOND) = ' '
      RB_FLAG  (NBOND) = ' '
      RETURN
      END

      SUBROUTINE GET_VDW_EMIN(MDOC,RSV_NAME,NVDW,RSV_SYMM,IA1,IA2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NVDW
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NVDW.GE.MAXRVDW) THEN
        CALL MSGERR(MDOC
     *  ,' WARNING: number of VDW restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRVDW in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NVDW = NVDW + 1
      RV_VIDL  (NVDW) = RSV_RIDL
      RV_SDID  (NVDW) = 0.0
      RV_VOBS  (NVDW) = RSV_ROBS
      RV_CNST  (NVDW) = RSV_CNS
      RV_LENGTH(NVDW) = 0.0
      RV_IA1   (NVDW) = IA1
      RV_IA2   (NVDW) = IA2
      RV_CHEM  (NVDW) = ' '
      RV_SYMM  (NVDW) = RSV_SYMM
      RV_TYPE  (NVDW) = ' '
      RV_FLAG  (NVDW) = RSV_HFLAG
      RETURN
      END


      SUBROUTINE GET_HB_EMIN(MDOC,RSV_NAME,NHB,RSV_SYMM,IA1,IA2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NHB
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NHB.GE.MAXRHB) THEN
        CALL MSGERR(MDOC
     *  ,' WARNING: number of H_bond restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRHB in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NHB = NHB + 1
      RH_VIDL  (NHB) = RSV_RIDL
      RH_SDID  (NHB) = 0.0
      RH_VOBS  (NHB) = RSV_ROBS
      RH_CNST  (NHB) = RSV_CNS
      RH_LENGTH(NHB) = 0.0
      RH_IA1   (NHB) = IA1
      RH_IA2   (NHB) = IA2
      RH_CHEM  (NHB) = ' '
      RH_SYMM  (NHB) = RSV_SYMM
      RH_TYPE  (NHB) = ' '
      RH_FLAG  (NHB) = RSV_HFLAG
      RETURN
      END

C ------------------------------------------------------------
      SUBROUTINE GET_CHIR_EMIN(MDOC,RS_NAME,NCHIR,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NCHIR
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MD    =-ABS(MDOC)-1
C -------------------------------
      IF(NCHIR.GE.MAXRCHIR) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of chirality restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRCHIR in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NCHIR = NCHIR + 1
      RC_VIDL  (NCHIR) = RS_VIDL
      RC_VOBS  (NCHIR) = RS_VOBS
      RC_CNST  (NCHIR) = RS_CNS
      RC_IA1   (NCHIR)  = IA1
      RC_IA2   (NCHIR)  = IA2
      RC_IA3   (NCHIR)  = IA3
      RC_IA4   (NCHIR)  = IA4
      RC_SIGN  (NCHIR)  = RS_LABEL
      RC_TYPE  (NCHIR)  = ' '
      RC_FLAG  (NCHIR)  = ' '
      RETURN
      END

      SUBROUTINE GET_PLAN_EMIN(MDOC,RS_NAME,NPLAN,RS_LABEL
     *     ,RS_NUM,RS_NUM_OLD,IA1
     *     ,RS_VIDL,RS_VOBS
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C -----------------------------------------------------------
C ==----------------------------------------------------------
      INTEGER*4   MDOC,IERR,IFLAG,IA1,IAA1
      INTEGER     NPLAN,RS_NUM,RS_NUM_OLD
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C --------------------------------------
      IERR  = 0
      MD    = -ABS(MDOC)-1
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -------------------------------
      IF(RS_NUM.NE.RS_NUM_OLD) THEN
        IF(NPLAN.GE.MAXRPLAN) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: number of plan restraints > limit.')
          CALL MSGERR(MDOC
     *    ,'      change parameter MAXRPLAN in "rstr_com.fh"')
          IERR=1
          RETURN
        ENDIF
        NPLAN = NPLAN + 1
        RP_NATOM(NPLAN)=0
      ENDIF

      NA = RP_NATOM(NPLAN) + 1
      IF(NA.GE.MAXRATMP) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of plan atoms > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRATMP in "rstr-com.fh"')
        IERR=1
        RETURN
      ENDIF
      RP_NATOM(NPLAN)    = RP_NATOM(NPLAN)+1

      RP_LABEL(NPLAN)    = RS_LABEL
      RP_FLAG (NPLAN)    = ' '
      RP_IATM (NA,NPLAN) = IA1
      RP_DEV  (NA,NPLAN) = RS_VIDL 
      RP_DOBS (NA,NPLAN) = RS_VOBS

      RETURN
      END

      SUBROUTINE POLTOCRD_S(INEXT,I,N,A,X
     *                    ,LENGTH,THETA,PHI,CONN,MAX1BRN)
C ---------------------
      REAL      LENGTH(*),X(3,*),THETA(*),PHI(*)
      REAL      A(3,3),DX(3),DY(3)
      INTEGER   CONN(MAX1BRN,*)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      PHI0 = PHI(CONN(N,I))
      PHII = PHI(INEXT)

      IF(CONN(N,I).NE.INEXT) PHII = PHII + PHI0 

      PHII   = PHII*PI180
      THETAI = THETA(INEXT)*PI180
      DX(1)  =-COS(THETAI)*LENGTH(INEXT)
      DDX    = SIN(THETAI)*LENGTH(INEXT)
      DX(2)  = COS(PHII)*DDX
      DX(3)  = SIN(PHII)*DDX

      CALL NB_MVMULT(A,DX,DY)

      X(1,INEXT) = X(1,I) + DY(1)
      X(2,INEXT) = X(2,I) + DY(2)
      X(3,INEXT) = X(3,I) + DY(3)

      RETURN
      END


      SUBROUTINE ANGTOCR_S(MDOC,LIST,ISTART,IFINISH
     *  ,X,NDIST
     *  ,LENGTH,THETA,PHI,CONN,MAX1BRN,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      REAL      LENGTH(*),X(3,*),THETA(*),PHI(*)
      INTEGER   CONN(MAX1BRN,*),NDIST(*)
C ---
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
      REAL      ASTACK(3,3,10)
C --------------------------------------
      REAL      A(3,3)
      INTEGER*4 IC
      CHARACTER LINE*256,LIST*1
C ---------------------------------------
C ----
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      IERR = 0
C ---
      DO I=1,3
      DO J=1,3
        A(I,J) = 0.0
      ENDDO
      ENDDO
      A(1,1) = 1.0
      A(2,2) = 1.0
      A(3,3) = 1.0
C ---
      I        = ISTART
      IC       = 1
      NSTCK    = 0

      X(1,I) = 0.0
      X(2,I) = 0.0
      X(3,I) = 0.0

  400 CONTINUE

      N = NDIST(I)

      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          IF(NSTCK.LE.0) THEN
            GO TO 2000
          ENDIF
 
          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          CALL  NB_MCOPY(ASTACK(1,1,NSTCK),A)
          NSTCK = NSTCK-1
          IF(I.LE.0.OR.IC.LE.0) THEN
            GO TO 2000
          ENDIF

        ELSE IF(N.EQ.1) THEN

          INEXT = CONN(1,I)
          CALL POLTOCRD_S(INEXT,I,N,A,X
     *        ,LENGTH,THETA,PHI,CONN,MAX1BRN)
          CALL CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
          IC    = 1
          I     = INEXT

        ELSE IF(N.GT.1) THEN

          INEXT = CONN(IC,I)

          CALL POLTOCRD_S(INEXT,I,N,A,X
     *        ,LENGTH,THETA,PHI,CONN,MAX1BRN)

          IF(IC.LT.N) THEN
            IC    = IC + 1
            NSTCK = NSTCK + 1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(LINE,
     *        '('' ERROR: '',A,'' : N-stack > '',I6)')
     *        MON,NSTLIM
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF

            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
            CALL  NB_MCOPY(A,ASTACK(1,1,NSTCK))
          ENDIF
   
          CALL CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
          I  = INEXT
          IC = 1

        ELSE

          GO TO 2000

        ENDIF
      GO TO 400
C -----------------
  500 CONTINUE
      RETURN
C ------------------
 2000 CONTINUE
      WRITE(LINE,
     *'('' WARNING: ANGTOCR : wrong tree structure'')')
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
C ---------------------
      REAL      A(3,3),Y(3,3),Z(3,3),X(3,3)
      REAL      THETA(*),PHI(*)
      INTEGER   CONN(MAX1BRN,*)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      PHI0 = PHI(CONN(N,I))
      PHII = PHI(INEXT)

      IF(CONN(N,I).NE.INEXT) PHII = PHII + PHI0 

      THETAI = THETA(INEXT)
C ---
      T = PI - THETAI*PI180
c      T = THETAI*PI180
      F = PHII*PI180
      COST   = COS(T)
      SINT   = SIN(T)
      COSF   = COS(F)
      SINF   = SIN(F)
C ---
      Y(1,1) = COST
      Y(1,2) =-SINT
      Y(1,3) = 0.0
      Y(2,1) = SINT*COSF
      Y(2,2) = COST*COSF
      Y(2,3) =-SINF
      Y(3,1) = SINT*SINF
      Y(3,2) = COST*SINF
      Y(3,3) = COSF

C      TT = t/pi180
C      WRITE(*,*) 'CA',INEXT,I,N
C      WRITE(*,*) 't,f',tt,phiI   
c      write(*,*) 'A ',A(1,1),A(1,2),A(1,3)
c      write(*,*) 'A ',A(2,1),A(2,2),A(2,3)
c      write(*,*) 'A ',A(3,1),A(3,2),A(3,3)
C
c      X(1,1) = 1.0
c      X(1,2) = 0.0
c      X(1,3) = 0.0
c      X(2,1) = 0.0
c      X(2,2) = COSF
c      X(2,3) =-SINF
c      X(3,1) = 0.0
c      X(3,2) = SINF
c      X(3,3) = COSF
C
c      write(*,*) 'x ',x(1,1),x(1,2),x(1,3)
c      write(*,*) 'x ',x(2,1),x(2,2),x(2,3)
c      write(*,*) 'x ',x(3,1),x(3,2),x(3,3)
C
c      Z(1,1) = COST
c      Z(1,2) =-SINT
c      Z(1,3) = 0.0
c      Z(2,1) = SINT
c      Z(2,2) = COST
c      Z(2,3) = 0.0
c      Z(3,1) = 0.0
c      Z(3,2) = 0.0
c      Z(3,3) = 1.0
C
c      write(*,*) 'z ',z(1,1),z(1,2),z(1,3)
c      write(*,*) 'z ',z(2,1),z(2,2),z(2,3)
c      write(*,*) 'z ',z(3,1),z(3,2),z(3,3)
C
c      CALL NB_MATMLT(X,Z,Y)
C
c      write(*,*) 'y ',y(1,1),y(1,2),y(1,3)
c      write(*,*) 'y ',y(2,1),y(2,2),y(2,3)
c      write(*,*) 'y ',y(3,1),y(3,2),y(3,3)
C
C      CALL NB_MTRANS(Y,Y)

      CALL NB_MATMLT(A,Y,Z)
      CALL NB_MCOPY(Z,A)
C ---
      RETURN
      END

