C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
       SUBROUTINE GAUSS_COEF_TAB_A2INF(N_POINTS_G,X_0_I,
     &                            X_POINTS,W_POINTS)
C
C---It finds gaussian integration rule with weights e^(-x^2/2) in the
C---range (-x_0,infinity)
C
C
c---Use Golub-Welcsh and  Wilf's method to find abcisses and weights for 
C---integration
C--W(I) = EVECTOR(1,I)**2* int_0^infty e^(-x^2/2)dx
C
C--EVECTOR is eigenvector of the tridiagonal matrix and EVECTOR(1,I)
C--is first element of i-th vector. See for Golub-Welsch and Wilf algorithms
C--Davis & Robinowitz. "Methods of Numerical Integration", Second edtition 
C--1984, Academic Press. Inc.
C
c---Similar information can be found in the lates edition (1992) of 
C--Numerical Recipes by Press, Teukolsky, Vetterling, Flannery
C--Previous editions does not have this
C
C---If somebody wants to repeat these algorithms for their purposes then several
C---ponts:
C---1) Accurate calculation of ERR_C is important especially for small X_0
C---2) It is important to use tridiagonal matrix diagonalisation. 
C---   Others are not very stable and precise
C
      IMPLICIT NONE
C
      INTEGER N_POINTS_G
      REAL X_0_I
      REAL  X_POINTS(*),W_POINTS(*)
C
      DOUBLE PRECISION A(64),B(64),W(64),P_N(64),P_N1(64),P_N0(64),
     &                 A1(64)
      DOUBLE PRECISION X_0,EXP_X,P_NORM,P_NORM1,P_NORM0,DII
      DOUBLE PRECISION DPI,RX_0,ERR_C,P_X0,P_X1,P_X,S1,S2,S3,T1,T2,S4
      DOUBLE PRECISION X_MAX,X_MIN,DELTA,DD1
      INTEGER I,J,NPARAM,NMAXP,J_P,N_MAX_P
C
      DOUBLE PRECISION AMAT_L(64,64),EVALUE(64),WORKSPACE(1000)
      INTEGER IWORK(1000)
      INTEGER LWORK,INFO,LIWORK
      DPI = DATAN2(1.0D0,1.0D0)*4.0D0
      NPARAM = N_POINTS_G
      NMAXP  = 64
      LWORK  = 1000
      LIWORK = 1000
      B(1) = 0.0D0
C
      X_0 = DBLE(X_0_I)
      EXP_X = DEXP(-X_0*X_0/2.0D0)

      RX_0 = -X_0/DSQRT(2.0D0)
      CALL DERRFC_R(RX_0,ERR_C)
      ERR_C = DSQRT(DPI/2.0D0)*ERR_C
      A(1) = EXP_X/ERR_C
      P_NORM1 = 1.0D0/DSQRT(ERR_C)

      P_NORM0 = 0.0D0
cd      P_X1    = 1.0
cd      P_X0    = 0.0
      DII = -1.0D0
      DO   I=2,NPARAM
        DII = DII + 2.0D0
        B(I) = (DII-(X_0+A(I-1))*A(I-1)-B(I-1))
        P_NORM = ((-X_0-A(I-1))*P_NORM1-
     *               DSQRT(B(I-1))*P_NORM0)/DSQRT(B(I))
        A(I)   = P_NORM*P_NORM*EXP_X
        P_NORM0 = P_NORM1
        P_NORM1 = P_NORM
      ENDDO
C
C---Now built matrix elements to find eigenvectors and eigenvalues.
C---In principle we need only tridiagonal form which can easily be diagonalised
C

      DO   I=1,64
        DO   J=1,64
          AMAT_L(I,J) = 0.0D0
        ENDDO
      ENDDO

      DO    I=1,NPARAM-1
        EVALUE(I) = A(I)
        A1(I)     = DSQRT(B(I+1))
      ENDDO
      EVALUE(NPARAM) = A(NPARAM)
c
C
C---Call lapack routine to diagonalise tridiagonal matrix.
      CALL DSTEVD_MO('V',NPARAM,EVALUE,A1,AMAT_L,NMAXP,
     &      WORKSPACE,LWORK, IWORK,LIWORK, INFO )

cd      WRITE(20,*)
cd      WRITE(20,*)'J_P ',J_P,X_0
cd      DO   I=1,NPARAM
cd        W(I) = ERR_C*AMAT_L(1,I)**2
cd        WRITE(20,*)EVALUE(I),W(I)
cd      ENDDO
      J_P = J_P + 1
      DO   I=1,NPARAM
        X_POINTS(I) = REAL(EVALUE(I))
cd        W_POINTS(I) = REAL(DLOG(ERR_C) + 
cd     &                2.0*DLOG(DABS(AMAT_L(1,I))))
        W_POINTS(I) = REAL(ERR_C*DABS(AMAT_L(1,I)**2))
      ENDDO      

      END
C
      SUBROUTINE DERRFC_R(X_0,ERR_C)
C
C---Calculate value of error function 
C---2/SQRT(PI)int_{x_0}^{infinity)e^{-x^2/2}
C---We need to give option to return not function itself but its logarithm.
C---It could be useful for large positive arguments.
C
c--For some recurrence relations we need high precision methods.
C--Here we sacrifice speed for sake of precisions. If speed is important
C--then other methods will have to be employed (see another routine 
C--which will come in this file)
C
      IMPLICIT NONE
      DOUBLE PRECISION X_0,ERR_C
      DOUBLE PRECISION T,Z,DPI
C
C---For small X_0 other techniques should be used. It seems that it
C---is good when X_0 is larger (perhaps good enough for X_0>1.0)
C--
      DPI = DATAN2(1.0D0,1.0D0)*4.0D0
      Z = DABS(X_0)
      IF(Z.GT.1.0D0) THEN
        T = 1.0D0/(1.0D0+0.5D0*Z)
        ERR_C = T*DEXP(-Z*Z-1.26551223D0+T*( 1.00002368D0+T*(
     *                      0.37409196D0+T*( 0.09678418D0+T*(
     &                     -0.18628806D0+T*(0.27886897+T*(
     &                     -1.13520398D0+T*(
     &                      1.48851587D0+T*(-0.82215223D0+T*
     &                      0.17087277)))))))))
        IF(X_0.LT.0.0D0) ERR_C = 2.0D0-ERR_C
      ELSE
C
C---Use different scheme. Let say series representation. Up do precision
C---needed. This way of doing things is deliberate. Precision of calculations
C---should be 10^(-12)
        ERR_C = 1.0D0-2.0D0/SQRT(DPI)*Z*(1.0D0 - Z*Z/ 3.0D0*(1.0D0-
     &                                     3.0D0*Z*Z/10.0D0*(1.0D0-
     &                                     5.0D0*Z*Z/21.0D0*(1.0D0-
     &                                     7.0D0*Z*Z/36.0D0*(1.0D0-
     &                                     9.0D0*Z*Z/55.0D0*(1.0D0-
     &                                    11.0D0*Z*Z/78.0D0*(1.0D0-
     &                                    13.0D0*Z*Z/105.0D0*(1.0D0-
     &                                    15.0D0*Z*Z/136.0D0*(1.0D0-
     &                                    17.0D0*Z*Z/171.0D0*(1.0D0-
     &                                    19.0D0*Z*Z/210.0D0*(1.0D0-
     &                                    21.0D0*Z*Z/253.0D0*(1.0D0-
     &                                    23.0D0*Z*Z/300.0D0*(1.0D0-
     &                                    25.0D0*Z*Z/351.0D0
     &                                              )))))))))))))
        IF(X_0.LT.0.0D0)ERR_C = 2.0D0-ERR_C
C
C---For medium X use continues fractions and calculate to 10^(-12) precision
C
C--For now it is not working because I have no idea what would be precision
C     ELSE IF(X.GT.1.0D0.AND.G.LT.5.0D0) THEN
C
C       ERR_C = 2.0D0*DEXP(-Z*Z)*
C                     (1.0D0/(Z+1.5D0/(Z+2.0D0/(Z+2.5D0/(Z+3.0D0/
C                            (Z+3.5D0/(Z+4.0D0/(Z+5.0D0/(Z+5.5D0/
C                            (Z+6.0D0/(Z+6.5D0/Z)))))))))))
      ENDIF
    
      RETURN
      END
