C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE FFT(NREF,ndens,DENS,FC,PHASE,NIND,IPP)
C ------------------------------------------------------
C    Routine from vagin package modified for compatability
C             with  refmac
C         (F,PHASE) --> DENS
C      MODIFIED BY G.N.M. 16.09.91
C ------------------------------------------------------
      implicit none
      INCLUDE   'celsym.fh'
      INCLUDE   'const.fh'
      integer nref,ndens,ipp
      integer n3max
      PARAMETER (N3MAX = 500)
      COMPLEX   DENS(N1/2,N2,N3,ndens),CDM,SM
      INTEGER   IH(MAXSYM),IK(MAXSYM),IL(MAXSYM)
      INTEGER   IDIM(3)
      INTEGER   NIND(*)
      REAL      FC(nref,ndens),PHASE(nref,ndens)
      REAL      COSD(MAXSYM+1),SIND(MAXSYM+1)
c,CZL(N3MAX,N3MAX),
c     +          SZL(N3MAX,N3MAX)
      integer i,icent,ifirst,idens,ierr,ihd,iii,ild,indd
      integer izz,izmin,isysab,izmax,iz,izn,izx,j,jh,jk,jl
      integer nx2,n,nxy
      real pcos,psin,snz,z,zero,voll_1
      REAL      FA(MAXSYM,100),FB(MAXSYM,100)
      real      ap,bp,ang,csz,epsi
      real      faa(100),fbb(100)
      real      fobs,phi
      INTEGER IHI(3)
c
c--   allocatable
      integer n3l
      real, allocatable :: czl(:,:)
      real, allocatable :: szl(:,:)
C
C---Common blocks
      integer ihmin,ikmin,ilmin,ihmax1,ikmax1,ilmax1
      INTEGER IHMAX,IKMAX,ILMAX
      COMMON /HKLLIM/ IHMAX, IKMAX, ILMAX
      EXTERNAL UNPACK
c
c---  locals
      integer id

C ======================================================================
c
c---allocate
      n3l = max(n3+1,ilmax+1)
      allocate(czl(n3l,n3l))
      allocate(szl(n3l,n3l))
c      IF(N3.GT.N3MAX) THEN
c        CALL ERRWRT(1,'In FFT of subag.f Increase N3MAX and recompile')
c      ENDIF
      IFIRST = 0
      DO     I=1,NumSymmetry
        DO     J=1,3
          TR(J,I)=TR(J,I)*24.
        ENDDO
      ENDDO
      NX2     = NX/2
      NXY     = NX*NY    
      NXY     = NXY/2
      ZERO    = 0.0
      CDM     = CMPLX(ZERO,ZERO)
      IDIM(1) = NX2   
      IDIM(2) = NY    
      IDIM(3) = 0     
C===================================================================            
      IZMIN = 0
      IZMAX = N3 - 1
      IZZ = 0
      DO    IZ = IZMIN,IZMAX
        IZZ = IZZ + 1
        Z = FLOAT(IZ)/FLOAT(NZ)
        ANG = TWOPI*Z
        CSZ = COS(ANG)
        SNZ = SIN(ANG)
        CZL(IZZ,1) = 1.0
        SZL(IZZ,1) = 0.0
        DO   I=2,ILMAX+1
           CZL(IZZ,I) = CZL(IZZ,I-1)*CSZ - SZL(IZZ,I-1)*SNZ
           SZL(IZZ,I) = SZL(IZZ,I-1)*CSZ + CZL(IZZ,I-1)*SNZ
        ENDDO
      ENDDO
      IZN = 1
      IZX = IZMAX-IZMIN+1
      dens(1:nx2,1:ny,1:n3,1:ndens) = cdm

      DO    III=1,NREF
C
C---Extract indexes and F's and make coefficients
        INDD = NIND(III)
        CALL UNPACK(INDD,IHI(1),IHI(2),IHI(3))
        IH(1) = IHI(1)
        IK(1) = IHI(2)
        IL(1) = IHI(3)
        CALL EPSLON(IHI,EPSI,ISYSAB)
cd        EPSI = EPSI/2.0
        CALL CENTR(IHI,ICENT)
        do idens=1,ndens
           FOBS  = FC(III,idens)*NSMULT/(EPSI*(1+ICENT))
           IF(IPP.EQ.0) THEN
              PHI   = PHASE(III,idens)
              FA(1,idens) = FOBS*COS(PHI)
              FB(1,idens) = FOBS*SIN(PHI)
           ELSE
              FA(1,idens) = FOBS
              FB(1,idens) = 0.0
           ENDIF
        enddo
        CALL GENER(N,ndens,IH,IK,IL,FA,FB,COSD,SIND,IFIRST,IPP)
C
C----Now calculate ft along l
        DO     I=1,N
          JH    = IH(I)
          JK    = IK(I)
          JL    = IL(I)
          FAA(1:ndens)   = FA(I,1:ndens)
          FBB(1:ndens)   = FB(I,1:ndens)
          IHD   = JH + 1
C
          IF(JK.LT.0) JK = NY + JK 
          ILD   = IABS(JL) + 1
          JK    = JK + 1
          DO    IZ = IZN,IZX
            PCOS = CZL(IZ,ILD)
            PSIN = SZL(IZ,ILD)
            IF(JL.LT.0) PSIN = -PSIN
            do idens=1,ndens
               IF(IPP.EQ.0) THEN
                  AP = FAA(idens)*PCOS + FBB(idens)*PSIN
                  BP = FBB(idens)*PCOS - FAA(idens)*PSIN
               ELSE
                  AP =  FAA(idens)*PCOS
                  BP = -FAA(idens)*PSIN
               ENDIF
               SM               = CMPLX(AP,BP)
               DENS(IHD,JK,IZ,idens)  = DENS(IHD,JK,IZ,idens) + SM
            enddo
          ENDDO 
        ENDDO
      ENDDO
      DO   IZ = IZN,IZX
         do idens=1,ndens
            CALL MDHFT(DENS(1,1,IZ,idens),IDIM,IERR)
            IF(IERR.NE.0) CALL ERRWRT(1,' Kernel MDHFT')
         enddo
      ENDDO
C
C---Divide calculated density by cell volume to get actual fourier transform
      VOLL_1 = FLOAT(NX*NY*NZ)
      dens(1:nx2,1:ny,1:n3,1:ndens) = 
     &     dens(1:nx2,1:ny,1:n3,1:ndens)/voll_1
      DO     I=1,NumSymmetry
        DO     J=1,3
          TR(J,I) = TR(J,I)/24.
        ENDDO
      ENDDO
      deallocate(czl)
      deallocate(szl)
      RETURN 
      END           

      SUBROUTINE GENER(NGEN,ndens,IH,IK,IL,FA,FB,COSD,SIND,IFIRST,IPP)
C -------------------------------------------
C ******
      INCLUDE   'celsym.fh'
      integer ngen,ndens
      INTEGER   IH(MAXSYM),IK(MAXSYM),IL(MAXSYM)
      REAL      FA(MAXSYM,100),FB(MAXSYM,100)
      REAL      COSD(MAXSYM+1),SIND(MAXSYM+1)
      REAL      TWOPI
      INTEGER   IFIRST
c
c---  locals
      real faa(100),fbb(100),fb1(100)
      DATA      TWOPI/6.2831852/
C -------------------------------------------
      IT = 0
      IF(IFIRST.EQ.0) THEN
        AN=TWOPI/24.
        CS=COS(AN)
        SS=SIN(AN)
        COSD(1)=1.
        SIND(1)=0.
        DO     I=2,25
          COSD(I)=COSD(I-1)*CS-SIND(I-1)*SS
          SIND(I)=SIND(I-1)*CS+COSD(I-1)*SS
        ENDDO
        IFIRST=1
      ENDIF
      NGEN=0
      IH1=IH(1)     
      IK1=IK(1)     
      IL1=IL(1)     
      FB1(1:ndens)=FB(1,1:ndens)
      FAA(1:ndens)=FA(1,1:ndens)
      DO     I=1,NumSymmetry
        JH = NINT(ROT(1,1,I)*IH1 +ROT(2,1,I)*IK1+ROT(3,1,I)*IL1)
        JK = NINT(ROT(1,2,I)*IH1 +ROT(2,2,I)*IK1+ROT(3,2,I)*IL1)
        JL = NINT(ROT(1,3,I)*IH1 +ROT(2,3,I)*IK1+ROT(3,3,I)*IL1)
        FBB(1:ndens)=FB1(1:ndens)      
        IF(IPP.EQ.0)IT=NINT(TR(1,I)*IH1 + TR(2,I)*IK1 + TR(3,I)*IL1)
        IF(JH.LT.0) THEN              
          JH=-JH        
          JK=-JK        
          JL=-JL        
          IT=-IT        
          FBB(1:ndens)=-FBB(1:ndens)      
        ENDIF
        K=I-1         
C        IF(K.NE.0) THEN
C          DO     L=1,NGEN
C            IF(IH(L).EQ.JH.AND.IK(L).EQ.JK.AND.IL(L).EQ.JL) GO TO 100
C          ENDDO
C        ENDIF
        NGEN=NGEN+1
        IH(NGEN)=JH
        IK(NGEN)=JK
        IL(NGEN)=JL
C
C---If FFT with phases
        IF(IPP.EQ.0) THEN
          IF(K.EQ.0) THEN
            FA(NGEN,1:ndens)=FAA(1:ndens)
            FB(NGEN,1:ndens)=FBB(1:ndens)
          ELSE
            IF(IT.LT.0) THEN              
              IT=IABS(IT)   
              IT=24-MOD(IT,24)                  
            ELSE
              IT=MOD(IT,24) 
            ENDIF
            IT=IT+1
            do idens=1,ndens
              FA(NGEN,idens)=FAA(idens)*COSD(IT)+FBB(idens)*SIND(IT)
              FB(NGEN,idens)=FBB(idens)*COSD(IT)-FAA(idens)*SIND(IT)
            enddo
          ENDIF
          IF(JH.EQ.0) THEN
C           IF(NGEN.NE.1) THEN
C              DO     K=1,NGEN-1
C                IF(JH.EQ.IH(K).AND.-JK.EQ.IK(K).AND.-JL.EQ.IL(K))
C     .          GO TO 100
C              ENDDO
C            ENDIF
            NGEN=NGEN+1
            IH(NGEN)= JH
            IK(NGEN)=-JK
            IL(NGEN)=-JL
            FA(NGEN,1:ndens)= FA(NGEN-1,1:ndens)
            FB(NGEN,1:ndens)=-FB(NGEN-1,1:ndens)
          ENDIF
C
C----If phaseless FFT
        ELSE
          FA(NGEN,1:ndens) = FAA(1:ndens)
          IF(JH.EQ.0) THEN
            NGEN = NGEN + 1
            IH(NGEN) = JH
            IK(NGEN) = -JK
            IL(NGEN) = -JL
            FA(NGEN,1:ndens) = FAA(1:ndens)
          ENDIF
        ENDIF
  100   CONTINUE      
      ENDDO
      RETURN
      END
C------------------------------------------------
C----
C----DENS --> (FC,PHASE) FFT PROGRAMS FROM VAGIN 
C----CRYSTALLOGRAPHIC PROGRAMS  PACKAGE MODIFIED 
C----          FOR refmac   ( G.N.M. 16.09.91 )
C----
C------------------------------------------------
C
C----------------------------------------------------------------------
      SUBROUTINE RFFT(NREF,ndens,DEN,FC,PHASE,NIND)
C---------------------------------------------------------------------
      implicit none

      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
c
      INTEGER   ID(3)
      integer nref,ndens,nxy1
      INTEGER HMAX,KMAX,LMAX
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
      REAL      DEN(n1,n2,n3,ndens),FC(nref,ndens),PHASE(nref,ndens)
      INTEGER   NIND(*)
CD      REAL      SFA(MAXSYM),SFB(MAXSYM)
      REAL      COSDD(MAXSYM+1),SINDD(MAXSYM+1)
      real fa(100),fb(100)
      INTEGER   LSYM(MAXSYM),SYM(3,MAXSYM)
C
c
      real, allocatable :: poolA(:,:)
      integer idens,il,ihs,iks,ils,i,j,ihn,ikn,iln,ind1,mh,mk,ml,ns
      integer nxy,ind,indd,ir,it,ierr
      real an,cosd,csan,cs,delsn,delcs,delang,fd,sind,sfa,sfb
      real snan,ss
      CHARACTER LINE*80
      EXTERNAL  UNPACK
C -------------------------------------------------------------
      NXY=NX*NY
      nxy1 = 4*nxy
      allocate(poolA(nxy1,ndens))
C-------------------------
cd      NYB2  =NY/2
C
C--------------------------------------------------------------
C---   ISYM
C--------------------------------------------------------------
      DO     I=1,NonCubSym
        IF(ROTR(3,1,I).NE.0..OR.ROTR(3,2,I).NE.0..OR.
     *    ABS(ROTR(3,3,I)).NE.1.) THEN
          WRITE(LINE,'(A)')'  WRONG SP.GROUP FOR RFT'
          CALL ERRWRT(1,LINE)
        ENDIF
        DO     J=1,3
          SYM(J,I)=NINT(24.0*TRR(J,I))
        ENDDO
      ENDDO
      AN = TWOPI/24.0
      CS = COS(AN)
      SS = SIN(AN)
      COSDD(1) = 1.0
      SINDD(1) = 0.0
      DO    I=2,25
        COSDD(I) = COSDD(I-1)*CS-SINDD(I-1)*SS
        SINDD(I) = SINDD(I-1)*CS+COSDD(I-1)*SS
      ENDDO
C--------------------------------------------------------
      DELANG = TWOPI/FLOAT(NZ)
      DELSN  = SIN(DELANG)
      DELCS  = COS(DELANG)
      CSAN   = 1.0
      SNAN   = 0.0
      ID(1)  = NX
      ID(2)  = NY
      ID(3)  = 0
C ---
C -----------------------------------
      IR  = 0
100   IR  = IR+1
      IND = NIND(IR)
      CALL UNPACK(IND,IHN,IKN,ILN)
      IF(IHN.EQ.0.AND.IKN.EQ.0.AND.ILN.EQ.0) GOTO 100
C============================================================================
      DO     IL=0,LMAX
C ------------------------------------------------
        CALL INDENS(NXY,ndens,POOLA,nxy1,CSAN,SNAN,
     *             DELCS,DELSN,DEN)
C------------------------------------------------------
        do idens=1,ndens
           CALL MDCFT2(POOLA(2,idens),ID,IERR)
        enddo
        IF(IERR.NE.0) CALL ERRWRT(1,'In MDCFT2')
C -----------------------------------------------------
  500   IF(ILN.LT.IL) GO TO 400
        IF(ILN.GT.IL) GO TO 300
C
        MH = IHN
        MK = IKN
        ML = ILN
        NS = 0
        FA(1:ndens) = 0.0
        FB(1:ndens) = 0.0
C---------------
        DO     I=1,NonCubSym
          IHS    = NINT(ROTR(1,1,I)*IHN+ROTR(2,1,I)*IKN+ROTR(3,1,I)*ILN)
          IKS    = NINT(ROTR(1,2,I)*IHN+ROTR(2,2,I)*IKN+ROTR(3,2,I)*ILN)
          ILS    = NINT(ROTR(1,3,I)*IHN+ROTR(2,3,I)*IKN+ROTR(3,3,I)*ILN)
          LSYM(I)= 1
          IF(ILS.LT.0) THEN
            IHS     = -IHS
            IKS     = -IKS
            ILS     = -ILS
            LSYM(I) = -LSYM(I)
          ENDIF
C
          NS      = NS + 1
          IF(IKS.LT.0) IKS = IKS + NY
          IKS  = IKS*NX
          IF(IHS.LT.0) IHS = IHS + NX
          IND1 = IKS + IHS + 1
          IND  = IND1*2
          IT    =MH*SYM(1,I)+MK*SYM(2,I)+ML*SYM(3,I)
          IF(IT.LT.0) THEN
            IT = IABS(IT)
            IT = 24-MOD(IT,24)
          ELSE
            IT = MOD(IT,24)
          ENDIF
          IT = IT + 1
          COSD  = COSDD(IT)
          SIND  = SINDD(IT)
          do idens=1,ndens
             SFA   = POOLA(IND,idens)
             SFB   =-POOLA(IND+1,idens)
             IF(LSYM(I).LT.0) SFB = -SFB
             FA(idens) = FA(idens) + SFA*COSD - SFB*SIND
             FB(idens) = FB(idens) + SFB*COSD + SFA*SIND
          enddo
399       CONTINUE
        ENDDO
C----------------------------------------
        do idens=1,ndens
           FD       = FA(idens)*FA(idens)+FB(idens)*FB(idens)
           FC(IR,idens)    = SQRT(FD)
           PHASE(IR,idens) = 0.0
           IF(FD.NE.0.0) PHASE(IR,idens)=ATAN2(FB(idens),FA(idens))
        enddo
C--------------------------------
400     IR   = IR+1
        IF(IR.GT.NREF)GOTO 200
        INDD = NIND(IR)
        CALL UNPACK(INDD,IHN,IKN,ILN)
        GO TO 500
C------------------------------------------------
  300   CONTINUE
      ENDDO
C=======================================================================
  200 CONTINUE
      deallocate(poolA)
      RETURN
      END

      SUBROUTINE INDENS(NXY,ndens,POOLA,nxy1,CSAN,SNAN,
     *             DELCS,DELSN,DEN)
C --------------------------------------------------------
      implicit none
      INCLUDE 'celsym.fh'
      integer ndens,nxy,nxy1,id
      REAL      POOLA(nxy1,ndens)
      REAL      DEN(N1,N2,N3,ndens)
      real      csan,snan,delcs,delsn
C --------------------------------
      integer nx1,ny1,ix,iy,iz,ixy,i
      real zero,cszl,snzl,stor
      real temp
      COMPLEX   DM
C -------------------------------------------------------------

      DO     I=1,2*NXY+1
        POOLA(I,1:ndens)=0.0
      ENDDO
      CSZL = 1.
      SNZL = 0.
      NX1  = MIN(NX,N1)
      NY1  = MIN(NY,N2)
C-------------
      DO     IZ=1,N3 
        IXY = 0
        DO     IY=1,NY1
          DO     IX=1,NX1
            IXY = IXY + 2
            do id = 1, ndens
          	  TEMP=DEN(IX,IY,IZ,id)
          	  if (temp.gt.0.) then
                POOLA(IXY,id)   = POOLA(IXY,id)   + TEMP*CSZL
                POOLA(IXY+1,id) = POOLA(IXY+1,id) - TEMP*SNZL
              endif
            enddo
          ENDDO
        ENDDO
        STOR = SNZL*CSAN + CSZL*SNAN
        CSZL = CSZL*CSAN - SNZL*SNAN
        SNZL = STOR
      ENDDO
      STOR = SNAN*DELCS + CSAN*DELSN
      CSAN = CSAN*DELCS - SNAN*DELSN
      SNAN = STOR
      RETURN
C --------------------------------------------------
      END
C
      SUBROUTINE PACK(IND,IH,IK,IL)
C
      INTEGER HMAX,KMAX,LMAX
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
C     pack indices h,k,l --> IND
C ******
C  Remember IL >=0
       IND = ( IL*(2*KMAX+1) + (IK + KMAX))*(2*HMAX+1) + ( IH + HMAX)
C      IND=((IL+000128)*000256+IK+000128)*000256+IH+000128
      RETURN
      END  

C ******
      SUBROUTINE UNPACK(IND,IH,IK,IL)
C
      INTEGER HMAX,KMAX,LMAX
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
C     unpack IND --> indices h,k,l  - Use HMAX,KMAX,LMAX to set limits
C ******
      IL     = IND/((2*KMAX+1)*(2*HMAX+1))
      ITEMP1 = IL*(2*KMAX+1)*(2*HMAX+1)
      ITEMP1 = IND-ITEMP1
      ITEMP2 = ITEMP1/(2*HMAX+1)
      IK     = ITEMP2-KMAX                                                      
      ITEMP2 = ITEMP2*(2*HMAX+1)
      ITEMP2 = ITEMP1-ITEMP2                     
      IH     = ITEMP2-HMAX              
      RETURN
      END

      SUBROUTINE MDHFT(X,DD,IERR)
C----------------------------------------------------------
      REAL    X(*)
      INTEGER DD(*)
      INTEGER PTS,I,J,K,KK,LL,NT,ND
      REAL    A,B,C,D,E,F,ANGLE,TWON
      INTEGER DIM(10)
      INCLUDE 'const.fh'
C---------------------------------------------------------
      IERR = 0
      NT   = 2
      DO     I=1,10
        DIM(I) = DD(I)
        IF(DIM(I).EQ.0) GO TO 200
        NT     = NT*DIM(I)
      ENDDO
      GO TO 700
  200 CONTINUE
      ND     = I
      NT     = IABS(NT)
      DIM(1) = -IABS(DIM(1))

      CALL MDCFT2(X,DIM,IERR)
      IF(IERR.NE.0) RETURN
      PTS    = -DIM(1)
      DIM(1) = PTS
      I      = 2*PTS
      TWON   = FLOAT(I)
      DO     J=1,NT,I
        X(J+1) = X(J)
      ENDDO
      PTS = PTS+1
      DO     J=3,PTS,2
        ANGLE = TWOPI*FLOAT(J/2)/TWON
        CO    = COS(ANGLE)
        SI    = SIN(ANGLE)
        K     = 2*(PTS-J)
        DO     KK=J,NT,I
          LL      = KK+K
          A       = X(KK)+X(LL)
          B       = X(KK)-X(LL)
          C       = X(KK+1)+X(LL+1)
          D       = X(KK+1)-X(LL+1)
          E       = B*CO+C*SI
          F       = B*SI-C*CO
          X(KK)   = A+F
          X(LL)   = A-F
          X(KK+1) = E+D
          X(LL+1) = E-D
        ENDDO
      ENDDO
      DO     J=2,ND
        DIM(J) = -IABS(DIM(J))
      ENDDO
      CALL MDCFT2(X,DIM,IERR)
      IF(IERR.NE.0) RETURN
      RETURN
  700 CONTINUE
      CALL ERRWRT(1,' MDHFT : more than nine dimensions')
      IERR = 1
      RETURN
      END
C ******
      SUBROUTINE MDCFT2(X,D,IERR)
      REAL    X(*)         
      INTEGER D(*)      
      LOGICAL ERROR     
      INTEGER I,INC,NT,SPACE,PTS,PMAX,PSYM,TWOGRP    
      INTEGER DIM(5),FACTOR(15),SYM(15),UNSYM(15)    
      IERR  = 0
      IF(D(1).EQ.0)RETURN        
      PMAX   = 19
      TWOGRP = 8         
      I      = 2    
      NT     = D(1)
  100 IF(D(I).EQ.0)GOTO 200       
      NT = NT*D(I)       
      I  = I+1  
      GOTO100
  200 CONTINUE         
      NT     = IABS(2*NT)    
      DIM(1) = NT        
      SPACE  = NT         
      INC    = NT/D(I-1)    
  300 CONTINUE         
      I = I-1  
      IF(I.EQ.0) RETURN 
      IF(D(I).LE.1)GOTO 600       
      PTS = D(I)
      CALL SRFP(PTS,PMAX,TWOGRP,FACTOR,SYM,PSYM,UNSYM,ERROR)
      IF(ERROR)  GOTO 700
      IF(I.EQ.1) GOTO 400
      DIM(2) = IABS(INC)
      DIM(3) = IABS(SPACE)
      DIM(4) = DIM(2)
      DIM(5) = 2
      GOTO 500
  400 CONTINUE
      DIM(2) = 2
      DIM(3) = NT
      DIM(4) = NT     
      DIM(5) = 2*PTS
  500 CONTINUE
      CALL MDFTKD(PTS,FACTOR,DIM,X(1),X(2))
      CALL DIPRP(PTS,SYM,PSYM,UNSYM,DIM,X(1),X(2))
  600 CONTINUE
      IF(I.LE.2) GOTO 300
      INC   = INC/D(I-1)  
      SPACE = SPACE/D(I)
      GOTO 300
  700 CONTINUE
      CALL ERRWRT(1,'Factorisation in MDCFT2')
      IERR = 1
      RETURN
      END
