      subroutine block_organise_observ(ncomp,comp_number,refer_2_asym,
     &     refer_2_symm,nobs,iobs,free_refl,nref_comp,
     &     nasym,hkl_asym,
     &     out_file_obs,ierr)
c
c---This subroutine organises observations into blocks. Inputs are
c---list of observations (including other properties such as
c---free reflections) with references to asymmetric unit. Each observation
c---has number of components and corresponding reference to asymmetric unit.
c---For each reference to asymmetric unit we also have symmetry element it 
c---uses to go to asymmetric unit.
c
c---Results will be written to "out_file_obs"
c---Flags for free relfections will be property of blocks
c
      implicit none
c
c---  inputs 
      integer nobs,ncomp,nasym
      integer comp_number(ncomp),refer_2_asym(ncomp),refer_2_symm(ncomp)
      real iobs(2,nobs)
      integer nref_comp(nobs+1)     
      integer free_refl(nobs)
      integer hkl_asym(3,nasym)
c
c---  Outputs
      integer ierr
      character out_file_obs*(*)
c
c---  locals: 
      integer, allocatable :: list1(:)
      integer, allocatable :: list2(:)
      integer, allocatable :: nf(:)
      integer, allocatable :: index_obs(:)
      integer, allocatable :: nref_block(:)
      integer, allocatable :: obs_in_this_block(:)
      integer, allocatable :: contr_ref_2_asym(:)
      integer list_size
      integer num_blocks,num_asym_ref
c     
c---For internal organisation of blocks. Maximum number of contributors
c---for a single blcok is 128. In general for exact psuedomerohedral
c---twin this number is 24. For non-merohedral twin it can be any number
      integer contr_refer_2_asym(128)
      integer jbegin,jend,jo_beg,jo_end,jsym,jo,is
      integer jobs,jnum_o,jnum
      integer iout_file,ifail,ll
      integer i,j,k
c
c---  Body
      if(.not.allocated(list1)) allocate(list1(ncomp))
      if(.not.allocated(list2)) allocate(list2(ncomp))
      if(.not.allocated(index_obs)) allocate(index_obs(nasym))
c     
c---  Initialise pointer from asym 2 observations
      if(len_trim(out_file_obs).le.0) then
         out_file_obs = ' '
         call find_unique_file_name(out_file_obs,'.twin.data')
      endif
      call open_unform_file(iout_file,out_file_obs,ifail)
c
      do  i=1,nasym
         index_obs(i) = 0
      enddo
c
c---  Create equivalence relations.
      list_size = 0
      do  i=1,nobs
         do   j=nref_comp(i)+1,nref_comp(i+1)
            is = refer_2_asym(j)
            if(index_obs(is).gt.0) then
               list_size = list_size + 1
               list1(list_size) = i
               list2(list_size) = index_obs(is)
            else
               index_obs(is) = i
            endif
         enddo
      enddo
c     
c---  Find the number of elements in the asymmetric unit for which we have
c---  observation. It will be needed later.
      num_asym_ref = 0
      do i=1,nasym
         if(index_obs(i).gt.0) num_asym_ref = num_asym_ref + 1
      enddo
      deallocate(index_obs)
c
c---If the list is empty then we are ready to organise observations.
c---Each block contains one observation that has one component only
c---The Number of contributors from the asymmetric unit to this observation 
c---is 1

      if(list_size.le.0) then
         write(iout_file)nobs,ncomp,nobs,nobs
         do  i=1,nobs
            write(iout_file)1,1,free_refl(i)
            write(iout_file)1,1
            write(iout_file)iobs(1,i),iobs(2,i),1,1,refer_2_symm(i)
            write(iout_file)refer_2_asym(i)
         enddo
c
c--   Deallocate all arrays before returning.
         deallocate(list1)
         deallocate(list2)
         close(iout_file)
         return
      endif
C
c---  List is not empty. Carry on with the organisation of the data
c
c---  Find equavalence classes
      if(.not.allocated(nf)) allocate(nf(nobs))
      call find_ancestor(list1,list2,list_size,nobs,nf)
      deallocate(list1)
      deallocate(list2)
c     
      if(.not.allocated(index_obs)) allocate(index_obs(nobs))
      do i=1,nobs
         index_obs(i) = i
      enddo
      call iheap_sort_r(nobs,1,nf,index_obs)
c     
c---  Now find block of observations
      if(.not.allocated(nref_block)) allocate(nref_block(nobs))
      if(.not.allocated(obs_in_this_block)) 
     &     allocate(obs_in_this_block(nobs))
      num_blocks=0
      nref_block(1) = 0
      obs_in_this_block(1) = index_obs(1)
c     
      do  i=1,nobs-1
         if(nf(i).eq.nf(i+1)) then
            obs_in_this_block(i+1) = index_obs(i+1)
         else
            num_blocks = num_blocks + 1
            nref_block(num_blocks+1) = i
            obs_in_this_block(i+1) = index_obs(i+1)
         endif
      enddo
c
      deallocate(nf)
      deallocate(index_obs)
c     
c---Now take references to asymmetric unit and make a seperate list
c---consisting of them. They are properties of blocks also. 
c---At the same time change references to asymmetric unit in the 
c---observations to internal references to references to asymmetric unit
c---for this observation block
c
c---Add or sort out free reflections
c
c--Add overall number: number of observations, number of all components, number
c--of all blocks and number of independent references to asymmetric unit
c
c--To find number of independent references to asymmetric unit we must sum all 
c--jsym-s

      write(iout_file) nobs,ncomp,num_blocks,num_asym_ref

      do  i=1,num_blocks
         jbegin = nref_block(i)+1
         jend   = nref_block(i+1)
         jnum   = jend-jbegin+1
c---  store the first contributor for the first observation in that block
         contr_refer_2_asym(1) = 
     &        refer_2_asym(nref_comp(obs_in_this_block(jbegin))+1)
c
c---  Wrong: jsym = 0
         jsym = 1
         do j=jbegin,jend
            jobs   = obs_in_this_block(j)
            jo_beg = nref_comp(jobs)+1
            jo_end = nref_comp(jobs+1)
            do  jo=jo_beg,jo_end
               do is=1,jsym
                  if(refer_2_asym(jo).eq.contr_refer_2_asym(is)) then
                     refer_2_asym(jo) = is
                     goto 20
                  endif
               enddo
               jsym = jsym + 1
               contr_refer_2_asym(jsym) = refer_2_asym(jo)
               refer_2_asym(jo) = jsym
 20            continue
            enddo
         enddo
         write(iout_file)jnum,jsym,free_refl(obs_in_this_block(jbegin))

         do  j=jbegin,jend
            jobs = obs_in_this_block(j)
            jo_beg = nref_comp(jobs)+1
            jo_end = nref_comp(jobs+1)
            jnum_o = jo_end-jo_beg+1
            write(iout_file)jnum_o
c
c--   info about crystal et al
            write(iout_file)iobs(1,jobs),iobs(2,jobs),
     &           (comp_number(k),refer_2_asym(k),refer_2_symm(k),
     &           k=jo_beg,jo_end)
 
         enddo
         write(iout_file)(contr_refer_2_asym(jo),jo=1,jsym)
      enddo
c---Deallocatate all allocated arrays.
      deallocate(obs_in_this_block)
      deallocate(nref_block)
      close(iout_file)
      return
      end
c      
