C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE CALC_GEOM_CONTR(qqm,qqv,am,v)
c
c---This routine calculates contribution to derivatives from the  
C---geometric restraints
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
C
      integer qqm,qqv
      real am(qqm),v(qqv)
      INTEGER N_TARGET(QQD),N_OBJECT(QQD),NW_UVAL(QQD),
     &                 NSYM_DIST(4,QQD)
      COMMON /DISTNS/N_OBJECT,N_TARGET,NW_UVAL,NSYM_DIST
C
      INTEGER I
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
C
C----local variables
      REAL SUMDIS,SUMANG,SUMTOR,SUMCHIR,SUMPLANE,SUMVDW,SUMBR,SUM_BSH
      real sumspec,SUM_RIG,SUMP,SUMB,BDEL1
      real sumnmr,sumint
      INTEGER IA,NMTMP_POS,NVTMP_POS,NMMAXU,NVMAXU,LM
      INTEGER ID,IA1,IA2,IR
c
      integer nmax_rests
      integer ierr
C
C---Initialisation
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0
      DO   IA=1,N_ATOM
        NREST_PER_ATOM(IA) = 0
      ENDDO
C
C---Find restraint per atom.
      DO   ID=1,NDIS
        IA1 = N_TARGET(ID)
        IA2 = N_OBJECT(ID)
        NREST_PER_ATOM(IA1) = NREST_PER_ATOM(IA1) + 1
        IF(IA1.NE.IA2) THEN
          NREST_PER_ATOM(IA2) = NREST_PER_ATOM(IA2) + 1
        ENDIF
      ENDDO
c
      nmax_rests = maxval(nrest_per_atom(1:n_atom))+30
      allocate(rest_per_atom(n_atom,nmax_rests))
      nrest_per_atom(1:n_atom) = 0
      rest_per_atom(1:n_atom,1:nmax_rests) = 0
      DO   ID=1,NDIS
        IA1 = N_TARGET(ID)
        IA2 = N_OBJECT(ID)
        NREST_PER_ATOM(IA1) = NREST_PER_ATOM(IA1) + 1
        REST_PER_ATOM(IA1,NREST_PER_ATOM(IA1)) = ID
        IF(IA1.NE.IA2) THEN
          NREST_PER_ATOM(IA2) = NREST_PER_ATOM(IA2) + 1

          REST_PER_ATOM(IA2,NREST_PER_ATOM(IA2)) = ID
        ENDIF
      ENDDO
C
C---Contribution from covalent bonds (and some other prespecified bond
C---lenghts)
      FGEOM = 0.0
cd      NDIST = 0
      IF(DIS_FLAG) THEN
        SUMDIS = 0.0
        IF(MON_STYLE.NE.'NONE'.AND.MON_STYLE.NE.'FEW') CALL DIST_OUTLIER
        CALL DIST_REF(SUMDIS,QQM,QQV,AM,V,QQD,N_TARGET,
     &              N_OBJECT,NSYM_DIST,NW_UVAL,NREST_PER_ATOM,
     &              REST_PER_ATOM)

        FGEOM = FGEOM + SUMDIS
      ENDIF
c
      call harm_ref(qqm,am)
      call spec_ref(sumspec,qqm,qqv,am,v)
      fgeom = fgeom + sumspec

c
      call noe_ref(sumnmr,qqm,qqv,am,v)
      fgeom = fgeom + sumnmr
C
c---Angle restraints
      IF(ANGL_FLAG) THEN
        SUMANG = 0.0
        IF(MON_STYLE.NE.'NONE'.AND.MON_STYLE.NE.'FEW') CALL ANGL_OUTLIER
        CALL ANGL_REF(SUMANG,QQM,QQV,AM,V,QQD,N_TARGET,
     &              N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)
        FGEOM = FGEOM + SUMANG
      ENDIF
cd      NBIS = NDIS
      IF(TOR_FLAG) THEN
        SUMTOR = 0
        CALL TORS_REF(SUMTOR,QQM,QQV,AM,V,QQD,N_TARGET,
     &              N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)
       FGEOM = FGEOM + SUMTOR
      ENDIF
cd      DO   I=1,NVPOS+9*NDIS
cd         WRITE(*,*)AM(I)
cd      ENDDO
cd      stop
cd      WRITE(*,*)'Number of distances = ',NDIS
cd      STOP
C
c---Put U-value restraint on bond lengthes and angles only
      IF(CHI_FLAG) THEN
        SUMCHIR = 0.0
        IF(MON_STYLE.NE.'NONE'.AND.MON_STYLE.NE.'FEW') 
     &       CALL CHIR_OUTLIER
        CALL CHIR_REF(SUMCHIR,QQM,QQV,AM,V,QQD,N_TARGET,
     &              N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)
       FGEOM = FGEOM + SUMCHIR

      ENDIF

cd      GOTO 999
C
cd      PLANE_FLAG = .FALSE.
      IF(PLANE_FLAG) THEN
        SUMPLANE = 0.0
        IF(MON_STYLE.NE.'NONE'.AND.MON_STYLE.NE.'FEW')CALL PLANE_OUTLIER
        CALL PLANE_REF(SUMPLANE,QQM,QQV,AM,V,QQD,N_TARGET,
     &              N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)
        FGEOM = FGEOM + SUMPLANE
      ENDIF

C
c---Vdw restraints
      IF(VDW_FLAG) THEN
        SUMVDW = 0.0
        CALL VDW_REF(SUMVDW,QQM,QQV,AM,V,QQD,
     &            N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL,
     &            NREST_PER_ATOM,REST_PER_ATOM)

       FGEOM = FGEOM + SUMVDW
      ENDIF
      call interv_ref(sumint,qqm,qqv,am,v,qqd,
     &     n_target,n_object,nsym_dist,nw_uval,nrest_per_atom,
     &     rest_per_atom,ierr)
      fgeom = fgeom + sumint
c
C----If U values should be refined calculate contribution from restraints
       IF(ITEMP.NE.0) THEN
          NMTMP_POS = NMPOS+9*NDIS+1
          NVTMP_POS = NVPOS+1
          NMMAXU    = QQM-NMTMP_POS+1
          NVMAXU    = QQV-NVTMP_POS+1
C
         IF(BDEL.GT.0.0) THEN
           BDEL1 = BDEL
           LM = NMTMP_POS
           DO   IA=1,N_ATOM
             IF(ATOM_REF_mod_FLAG(IA,1).GT.0) THEN
               IF(U_ANISO_mod(2,IA,1).LE.0.0) THEN
                 AM(LM) = 1/BDEL1**2
                 LM       = LM + 1
               ELSE
                 AM(LM  ) = 1/BDEL1**2
                 AM(LM+1) = 1/BDEL1**2
                 AM(LM+2) = 1/BDEL1**2
                 AM(LM+3) = 2.0/BDEL1**2
                 AM(LM+4) = 2.0/BDEL1**2
                 AM(LM+5) = 2.0/BDEL1**2
                 LM         = LM + 21
               ENDIF
             ENDIF
           ENDDO
         ENDIF
C
          SUMBR = 0.0
          CALL BREF(SUMBR,NMMAXU,NVMAXU,AM(NMTMP_POS),V(NVTMP_POS),QQD,
     &           N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL)
          FGEOM = FGEOM + SUMBR
C
C----If anisotropic refinement then add more restraints
          IF(ITEMP.GT.1) THEN
            
            SUM_BSH = 0.0
c            CALL BSPHERE_RESTR(SUM_BSH,NMMAXU,NVMAXU,AM(NMTMP_POS),
c     &            V(NVTMP_POS),QQD,
c     &            N_TARGET,N_OBJECT,NW_UVAL)

            FGEOM = FGEOM + SUM_BSH
            SUM_RIG = 0.0
            CALL RIGID_BOND(SUM_RIG,NMMAXU,NVMAXU,AM(NMTMP_POS),
     &            V(NVTMP_POS),
     &            QQD,N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL)

            FGEOM = FGEOM + SUM_RIG
          ENDIF
       ENDIF
C
cd       NDIS = NDIST
       IF(NUMBER_NCSR.GT.0) THEN
         CALL NCS_REF(QQM,QQV,AM,V,SUMP,SUMB)
       ENDIF 
c
c---Report info about geometry
 999  CONTINUE

      deallocate(nrest_per_atom)
      deallocate(rest_per_atom)
C
      CALL ERRWRT(-1,' ')
      RETURN
      END

      SUBROUTINE REPORT_OVER_GEOM
C
C----This routine reports info about overall statistics on geometry
      IMPLICIT NONE
      INCLUDE 'rharvest.fh'
      INCLUDE 'monitor.fh'
C
      INTEGER IREST,N_RESTR_REPORT
      CHARACTER LINE*128
C
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'------------------------------------------'//
     &'-------------------------------------')
      WRITE(LINE,'(A,A,A,A)')
     &   '             Restraint type            ', 
     & '  N restraints  ',' Rms Delta  ',
     &                                   ' Av(Sigma)'
      CALL ERRWRT(-1,LINE)
      N_RESTR_REPORT = HNRESTR
      IF(MON_STYLE.EQ.'FEW') N_RESTR_REPORT = MIN(2,HNRESTR)
      DO   IREST = 1,N_RESTR_REPORT
        IF(HRESTR_NUM(IREST).GT.0) THEN
           WRITE(LINE,'(A43,I8,F10.3,F10.3)')HRESTR_TYPE(IREST),
     &                                            HRESTR_NUM(IREST),
     &                                            HRESTR_DEV(IREST),
     &                                            HRESTR_DEVITAR(IREST)
           CALL ERRWRT(-1,LINE)
         ENDIF
       ENDDO
      CALL ERRWRT(-1,'------------------------------------------'//
     &'-------------------------------------')
      END

      SUBROUTINE DIST_REF(SUMDIS,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &            N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL,
     &            NREST_PER_ATOM,REST_PER_ATOM)
C
C---This routine calculates derivatives of restraints corresponding to
C---bond distances. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'


      INTEGER MAX_MAT,MAX_VEC,MAX_DIST
      REAL SUMDIS
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),
     &        N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      REAL A_MAT(*),VECT(*)
C
C---Local variables
      INTEGER I,ISCRB,ITX(3),N_BOND_REST(2),IW_UVAL,LL,IFAIL,IA1,IA2,
     &        ISYM1,IA11,IA21,IA12,IA22,IX,IPOS_VEC1,IPOS_VEC2,
     &        IPOS_MAT1,IPOS_MAT2,IDIST,IMODE
      integer ityp,nr_bond1
      INTEGER NDIST1_SYMM(4)
      REAL    XYZ_TMP1(3),XYZ_TMP(3),RS_VIDL,RS_SDI,DBDX1(3),DBDX2(3),
     &        RMS_BOND(2),ASIGMA_BOND(2),WEIGHT_L,BOND_C,
     &        SMALL_BOND,DBOND,DBOND2,DBONDW,ZBOND
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
      DATA SMALL_BOND/0.01/
C
      SUMDIS         = 0.0
      RMS_BOND(1)    = 0.0
      RMS_BOND(2)    = 0.0
      ZBOND          = 0.0
      ASIGMA_BOND(1) = 0.0
      ASIGMA_BOND(2) = 0.0
      N_BOND_REST(1) = 0
      N_BOND_REST(2) = 0
      IW_UVAL        = 1
      nbond_refmac   = 0
      call open_unform_file(iscrb,bond_file,ifail)
      read(iscrb)nr_bond1
 10   CONTINUE
      READ(ISCRB,END=999)IA1,IA2,RS_VIDL,RS_SDI,ISYM1,ITX(1),ITX(2),
     &                    ITX(3),ityp
      NDIST1_SYMM(1) = ISYM1
      NDIST1_SYMM(2) = ITX(1)
      NDIST1_SYMM(3) = ITX(2)
      NDIST1_SYMM(4) = ITX(3)
      IF(ISYM1.EQ.0) THEN
        NDIST1_SYMM(1) = 1
        NDIST1_SYMM(2) = 0
        NDIST1_SYMM(3) = 0
        NDIST1_SYMM(4) = 0
      ENDIF
      IF(RS_SDI.LE.0.0) GOTO 10
      IF(ATOM_REF_FLAG(IA1).LE.0.OR.ATOM_REF_FLAG(IA2).LE.0) GOTO 10
c
      IA11 = ATOM_REF_FLAG(IA1)/10
      IA21 = ATOM_REF_FLAG(IA2)/10
      IA12 = ATOM_REF_FLAG(IA1) - 10*IA11
      IA22 = ATOM_REF_FLAG(IA2) - 10*IA21
      IF(IA12.LE.0.OR.IA22.LE.0) GOTO 10

      WEIGHT_L = (WDSKAL/RS_SDI)**2
C
C---Check if this bond is through symmetry. If yes apply symmetry.
      IF(ISYM1.LE.0) ISYM1 = 1
      IF(ISYM1.NE.1.OR.ITX(1).NE.0.OR.ITX(2).NE.0.OR.ITX(3).NE.0) THEN
C
C-----Here we should search all symmetry to find atoms bound with each other.
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA2),XYZ_TMP,ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(I,1,ISYM1)*XYZ_TMP(1) +
     &                  RealSymmMatrx(I,2,ISYM1)*XYZ_TMP(2) +
     &                  RealSymmMatrx(I,3,ISYM1)*XYZ_TMP(3) +
     &                  RealSymmMatrx(I,4,ISYM1) + FLOAT(ITX(I))
        ENDDO 
        CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)
      ELSE
        XYZ_TMP(1) = XYZ_CRD(1,IA2)
        XYZ_TMP(2) = XYZ_CRD(2,IA2)
        XYZ_TMP(3) = XYZ_CRD(3,IA2)
      ENDIF
C
C---Calculate derivative of the bond w.r.t. atomic parameters
      DBDX1(1) = XYZ_CRD(1,IA1)-XYZ_TMP(1)
      DBDX1(2) = XYZ_CRD(2,IA1)-XYZ_TMP(2)
      DBDX1(3) = XYZ_CRD(3,IA1)-XYZ_TMP(3)
C
      BOND_C  = SQRT(DBDX1(1)**2+DBDX1(2)**2+DBDX1(3)**2)
      DBOND   = RS_VIDL - BOND_C
      DBOND2  = DBOND**2
      SUMDIS  = SUMDIS + 0.5*WEIGHT_L*DBOND2
      IF(IA12.GT.2.AND.IA22.GT.2) THEN
        RMS_BOND(1)    = RMS_BOND(1) + DBOND2
        ASIGMA_BOND(1) = ASIGMA_BOND(1) + RS_SDI
        ZBOND          = ZBOND + DBOND2/RS_SDI**2
        N_BOND_REST(1) = N_BOND_REST(1) + 1
        nbond_refmac   = nbond_refmac + 1
      ELSE
        RMS_BOND(2)    = RMS_BOND(2) + DBOND2
        ASIGMA_BOND(2) = ASIGMA_BOND(2) + RS_SDI
        N_BOND_REST(2) = N_BOND_REST(2) + 1
      ENDIF
      DBONDW  = WEIGHT_L*DBOND
C
      DO  IX=1,3
        DBDX1(IX) =  DBDX1(IX)/AMAX1(SMALL_BOND,BOND_C)
        DBDX2(IX) = -DBDX1(IX)
      ENDDO
      IF(ISYM1.GT.1) THEN
        CALL MAT2VECT(3,3,CS_FRAC_TO_ORT,DBDX2,XYZ_TMP,ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(1,I,ISYM1)*XYZ_TMP(1) +
     &                  RealSymmMatrx(2,I,ISYM1)*XYZ_TMP(2) +
     &                  RealSymmMatrx(3,I,ISYM1)*XYZ_TMP(3) 
        ENDDO 
        CALL MAT2VECT(3,3,CS_ORT_TO_FRAC,XYZ_TMP1,DBDX2,ERROR)
      ENDIF
C
C---Increment vector elements
C
c---Instead of IA1 take reference to atomic number. It is necessary for
C---cases when atom should not be refined but present
C
C---If bond is through symmetry then it should also be processed. Only atom 
C---IA2 could be through symmetry.
c
      IPOS_VEC1 = 3*IA11-3
      IPOS_VEC2 = 3*IA21-3
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC1,VECT,DBONDW,DBDX1)
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC2,VECT,DBONDW,DBDX2)
C
C---Increment matrix elements. Atom blocks
      IPOS_MAT1 = 6*IA11 - 6
      IPOS_MAT2 = 6*IA21 - 6
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHT_L,DBDX1)
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT2,A_MAT,WEIGHT_L,DBDX2)
C
C---Increment matrix elements. Distance block
C
C---Find out if this atom pair is present already in the list. In principle
C---all distances should be unique but it may not happen.
      CALL  FIND_RESTRAINT(MAX_DIST,NDIS,IDIST,IA1,IA2,NDIST1_SYMM,
     &             N_ATOM,
     &            NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &            NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
cd      NW_UVAL(IDIST) = IW_UVAL
      IF(IA11.NE.IA21) THEN
C
C---If atoms are not same then. Add symmetry

        IPOS_MAT1 = NMPOS + 9*(IDIST-1)
C
C---Distance pair number is IDIST. N_ATT_REF_MAT is 6*N_REFINABLE_ATOMS
C---Non-diagonal terms should be added also
        IF(IMODE.EQ.0) THEN
C
C---IA1 is target and IA2 is object
          CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHT_L,
     &                                 DBDX1,DBDX2)
        ELSE
C
C---IA1 is object and IA2 is target
          CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHT_L,
     &                                 DBDX2,DBDX1)
        ENDIF
      ELSE
C
C---Increment diagonal terms only
        IPOS_MAT1 = 6*IA11 - 6
        IF(IMODE.EQ.0) THEN
          CALL INCR_MATR_DIAGONAL1(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHT_L,
     &                                                    DBDX1,DBDX2)
        ELSE
          CALL INCR_MATR_DIAGONAL1(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHT_L,
     &                                                    DBDX2,DBDX1)
        ENDIF
      ENDIF
C
C---Overall statistics. 
      GOTO 10
 999  CONTINUE
C
C---Save for harvesting and reporting
      IF(N_BOND_REST(1).GT.0) THEN
        HNRESTR = HNRESTR + 1
        HRESTR_TYPE(HNRESTR) = 'Bond distances: refined atoms'
        HRESTR_CIF(HNRESTR) = 'r_bond_refined_d'
        RMS_BOND(1) = SQRT(RMS_BOND(1)/FLOAT(N_BOND_REST(1)))
        ASIGMA_BOND(1) = ASIGMA_BOND(1)/FLOAT(N_BOND_REST(1))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_BOND(1)
        HRESTR_DEV(HNRESTR)     = RMS_BOND(1)
        HRESTR_Z(HNRESTR)  = SQRT(ZBOND/N_BOND_REST(1))
        HRESTR_NUM(HNRESTR)     = N_BOND_REST(1)
      ENDIF
      IF(N_BOND_REST(2).GT.0) THEN
        HNRESTR = HNRESTR + 1
        HRESTR_TYPE(HNRESTR) = 'Bond distances: others'
        HRESTR_CIF(HNRESTR) = 'r_bond_other_d'
        RMS_BOND(2) = SQRT(RMS_BOND(2)/FLOAT(N_BOND_REST(2)))
        ASIGMA_BOND(2) = ASIGMA_BOND(2)/FLOAT(N_BOND_REST(2))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_BOND(2)
        HRESTR_DEV(HNRESTR)     = RMS_BOND(2)
        HRESTR_NUM(HNRESTR)     = N_BOND_REST(2)
      ENDIF
      CLOSE(ISCRB)
      ISCRB = 0
c      stop
      RETURN
      END
c
      SUBROUTINE calc_rms_bond(rmsbond,zbond)
C
C---This routine calculates derivatives of restraints corresponding to
C---bond distances. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'


      integer nbond
      real rmsbond,zbond
C
C---Local variables
      INTEGER I,ISCRB,ITX(3),N_BOND_REST(2),IW_UVAL,LL,IFAIL,IA1,IA2,
     &        ISYM1,IA11,IA21,IA12,IA22,IX,IPOS_VEC1,IPOS_VEC2,
     &        IPOS_MAT1,IPOS_MAT2,IDIST,IMODE
      integer ib
      integer ityp,nr_bond1
      INTEGER NDIST1_SYMM(4)
      REAL    XYZ_TMP1(3),XYZ_TMP(3),RS_VIDL,RS_SDI,DBDX1(3),DBDX2(3),
     &        RMS_BOND(2),ASIGMA_BOND(2),WEIGHT_L,BOND_C,
     &        SMALL_BOND,DBOND,DBOND2
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
      DATA SMALL_BOND/0.01/
C
      rmsbond = 0.0
      zbond   = 0.0
      nbond   = 0


      call open_unform_file(iscrb,bond_file,ifail)
      read(iscrb)nr_bond1
      do ib=1,nr_bond1
         READ(ISCRB,END=999)IA1,IA2,RS_VIDL,RS_SDI,ISYM1,ITX(1),ITX(2),
     &        ITX(3),ityp
         NDIST1_SYMM(1) = ISYM1
         NDIST1_SYMM(2) = ITX(1)
         NDIST1_SYMM(3) = ITX(2)
         NDIST1_SYMM(4) = ITX(3)
         IF(ISYM1.EQ.0) THEN
            NDIST1_SYMM(1) = 1
            NDIST1_SYMM(2) = 0
            NDIST1_SYMM(3) = 0
            NDIST1_SYMM(4) = 0
         ENDIF
         IF(rs_sdi.gt.0.0.and.
     &        ATOM_REF_FLAG(IA1).gt.0.OR.ATOM_REF_FLAG(IA2).gt.0) then
c
            IA11 = ATOM_REF_FLAG(IA1)/10
            IA21 = ATOM_REF_FLAG(IA2)/10
            IA12 = ATOM_REF_FLAG(IA1) - 10*IA11
            IA22 = ATOM_REF_FLAG(IA2) - 10*IA21

            WEIGHT_L = (WDSKAL/RS_SDI)**2
C
C---  Check if this bond is through symmetry. If yes apply symmetry.
            IF(ISYM1.LE.0) ISYM1 = 1
            IF(ISYM1.NE.1.OR.ITX(1).NE.0.OR.
     &           ITX(2).NE.0.OR.ITX(3).NE.0) THEN
C     
C-----Here we should search all symmetry to find atoms bound with each other.
               CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA2),
     &              XYZ_TMP,ERROR)
               DO   I=1,3
                  XYZ_TMP1(I) = RealSymmMatrx(I,1,ISYM1)*XYZ_TMP(1) +
     &                 RealSymmMatrx(I,2,ISYM1)*XYZ_TMP(2) +
     &                 RealSymmMatrx(I,3,ISYM1)*XYZ_TMP(3) +
     &                 RealSymmMatrx(I,4,ISYM1) + FLOAT(ITX(I))
               ENDDO 
               CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)
            ELSE
               XYZ_TMP(1) = XYZ_CRD(1,IA2)
               XYZ_TMP(2) = XYZ_CRD(2,IA2)
               XYZ_TMP(3) = XYZ_CRD(3,IA2)
            ENDIF
C
C---  Calculate derivative of the bond w.r.t. atomic parameters
            DBDX1(1) = XYZ_CRD(1,IA1)-XYZ_TMP(1)
            DBDX1(2) = XYZ_CRD(2,IA1)-XYZ_TMP(2)
            DBDX1(3) = XYZ_CRD(3,IA1)-XYZ_TMP(3)
C     
            BOND_C  = SQRT(DBDX1(1)**2+DBDX1(2)**2+DBDX1(3)**2)
            DBOND   = RS_VIDL - BOND_C
            IF(IA12.GT.2.AND.IA22.GT.2) THEN
               rmsbond = rmsbond + dbond2
               zbond   = zbond + dbond2/rs_sdi**2
               nbond   = nbond + 1
            ENDIF
         endif
      enddo
 999  CONTINUE
C
C---Save for harvesting and reporting
      if(nbond.gt.0) then
         rmsbond = sqrt(rmsbond/float(nbond))
         zbond   = sqrt(zbond/float(nbond))
      endif

      CLOSE(ISCRB)
      ISCRB = 0
c      stop
      RETURN
      END
C
      SUBROUTINE INCR_VECTOR(MAXVECT,IPOS,VECT,DBONDW,DBDX)
      IMPLICIT NONE
C
C---this subroutine increments firts derivative vector elements
C---for functions type sum(d-d0)^2. It assumes that derivatives of
C---d wrt atomic parameters have been calculated and stored in DBDX
      INTEGER MAXVECT,IPOS
      REAL DBONDW,VECT(*),DBDX(*)
C
      CHARACTER LINE*128
C
      IF(IPOS+3.GT.MAXVECT) THEN
        WRITE(LINE,'(A,I10,A,I10)') 'Maximum size ',MAXVECT,
     &              'Current size ',IPOS
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(1,'Size of VECT should be increased')
      ENDIF
      VECT(IPOS + 1) = VECT(IPOS + 1) + DBONDW*DBDX(1)
      VECT(IPOS + 2) = VECT(IPOS + 2) + DBONDW*DBDX(2)
      VECT(IPOS + 3) = VECT(IPOS + 3) + DBONDW*DBDX(3)
c
      RETURN
      END
C
      SUBROUTINE INCR_MATR_DIAGONAL(MAX_MAT,IPOS,A_MAT,WEIGHT_L,DBDX)
      IMPLICIT NONE
C
C---This subroutine increments diagonal terms for second derivative matrix
      INTEGER MAX_MAT,IPOS
      REAL A_MAT(*),WEIGHT_L,DBDX(*)
C
      IF(IPOS+6.GT.MAX_MAT) THEN
        CALL ERRWRT(1,'Error in INCR_MATR_DIAGONAL. Size of matrix'//
     &         ' for second derivatives')
      ENDIF
      A_MAT(IPOS+1) = A_MAT(IPOS+1) + WEIGHT_L*DBDX(1)*DBDX(1)
      A_MAT(IPOS+2) = A_MAT(IPOS+2) + WEIGHT_L*DBDX(2)*DBDX(2)
      A_MAT(IPOS+3) = A_MAT(IPOS+3) + WEIGHT_L*DBDX(3)*DBDX(3)

      A_MAT(IPOS+4) = A_MAT(IPOS+4) + WEIGHT_L*DBDX(2)*DBDX(1)
      A_MAT(IPOS+5) = A_MAT(IPOS+5) + WEIGHT_L*DBDX(3)*DBDX(1)
      A_MAT(IPOS+6) = A_MAT(IPOS+6) + WEIGHT_L*DBDX(3)*DBDX(2)

      END
C
      SUBROUTINE INCR_MATR_DIAGONAL1(MAX_MAT,IPOS,A_MAT,WEIGHT_L,DBDX1,
     &                                 DBDX2)
      IMPLICIT NONE
C
C---This subroutine increments diagonal terms for second derivative matrix when
C---atoms are related with each other for example through symmetry.
C
      INTEGER MAX_MAT,IPOS
      REAL A_MAT(*),WEIGHT_L,DBDX1(*),DBDX2(*)
C
C
      IF(IPOS+6.GT.MAX_MAT) THEN
        CALL ERRWRT(1,'Error in INCR_MATR_DIAGONAL. Size of matrix'//
     &         ' for second derivatives')
      ENDIF
      A_MAT(IPOS+1) = A_MAT(IPOS+1) + 2.0*WEIGHT_L*DBDX1(1)*DBDX2(1)
      A_MAT(IPOS+2) = A_MAT(IPOS+2) + 2.0*WEIGHT_L*DBDX1(2)*DBDX2(2)
      A_MAT(IPOS+3) = A_MAT(IPOS+3) + 2.0*WEIGHT_L*DBDX1(3)*DBDX2(3)

      A_MAT(IPOS+4) = A_MAT(IPOS+4) + WEIGHT_L*(DBDX1(1)*DBDX2(2)+
     &                                          DBDX2(1)*DBDX1(2))
      A_MAT(IPOS+5) = A_MAT(IPOS+5) + WEIGHT_L*(DBDX1(1)*DBDX2(3)+
     &                                          DBDX2(1)*DBDX1(3))
      A_MAT(IPOS+6) = A_MAT(IPOS+6) + WEIGHT_L*(DBDX1(2)*DBDX2(3)+
     &                                          DBDX2(2)*DBDX1(3))

      END
C
      SUBROUTINE INCR_MATR_NDIAG(MAX_MAT,IPOS,A_MAT,WEIGHT_L,
     &                DBDX1,DBDX2)
      IMPLICIT NONE
C
c---This routine increments non diagonal terms of matrix element. It is
C---not ready
      REAL A_MAT(*),DBDX1(3),DBDX2(3)
      REAL WEIGHT_L
c
      INTEGER IPOS,MAX_MAT
      CHARACTER LINE*128
C
      IF(IPOS+9.GT.MAX_MAT) THEN
        WRITE(LINE,'(A,I10,A,I10)') 'Maximum size ',MAX_MAT,
     &              'Current size ',IPOS
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(1,'Size of MATR should be increased')
      ENDIF
c
      A_MAT(IPOS + 1) = A_MAT(IPOS + 1) + WEIGHT_L*DBDX1(1)*DBDX2(1)
      A_MAT(IPOS + 2) = A_MAT(IPOS + 2) + WEIGHT_L*DBDX1(2)*DBDX2(1)
      A_MAT(IPOS + 3) = A_MAT(IPOS + 3) + WEIGHT_L*DBDX1(3)*DBDX2(1)

      A_MAT(IPOS + 4) = A_MAT(IPOS + 4) + WEIGHT_L*DBDX1(1)*DBDX2(2)
      A_MAT(IPOS + 5) = A_MAT(IPOS + 5) + WEIGHT_L*DBDX1(2)*DBDX2(2)
      A_MAT(IPOS + 6) = A_MAT(IPOS + 6) + WEIGHT_L*DBDX1(3)*DBDX2(2)

      A_MAT(IPOS + 7) = A_MAT(IPOS + 7) + WEIGHT_L*DBDX1(1)*DBDX2(3)
      A_MAT(IPOS + 8) = A_MAT(IPOS + 8) + WEIGHT_L*DBDX1(2)*DBDX2(3)
      A_MAT(IPOS + 9) = A_MAT(IPOS + 9) + WEIGHT_L*DBDX1(3)*DBDX2(3)
C
      RETURN
      END
C
      SUBROUTINE FIND_RESTRAINT(MAXREST,NDIST,IDIST,IA1,IA2,
     &          NDIST1_SYMM,
     &          N_ATOM,
     &          NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
C
c---this routien finds position of IA1,IA2 restraint in the list of restraints
C---if it is not there then this pair is added to the list of resraints
C---Check symmetry also. 
      INTEGER NDIST1_SYMM(4)
      INTEGER MAXREST,NDIST,IDIST,IA1,IA2,N_ATOM,NREST_PER_ATOM(*),
     &        REST_PER_ATOM(N_ATOM,*),N_TARGET(*),N_OBJECT(*),
     &        NW_UVAL(*),NSYM_DIST(4,MAXREST)
      INTEGER IMODE,IW_UVAL
C
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_CUR,ITX_CUR(3)
      INTEGER IREST,IR1,I,FIRST
      INTEGER LENSTR
      EXTERNAL LENSTR
      DATA FIRST/0/
C
      IMODE = 0
      IF(NREST_PER_ATOM(IA1).GT.0.AND.NREST_PER_ATOM(IA2).GT.0) THEN
        DO   IREST = 1,NREST_PER_ATOM(IA1)
          IR1 = REST_PER_ATOM(IA1,IREST)
          IF(IR1.LE.0) THEN
            WRITE(*,*)IA1,NREST_PER_ATOM(IA1),IREST
            STOP
          ENDIF
          IF(N_OBJECT(IR1).EQ.IA2) THEN
C
C---Atom IA1 is target atom and atom IA2 is object
            IF(NSYM_DIST(1,IR1).EQ.NDIST1_SYMM(1).AND.
     &         NSYM_DIST(2,IR1).EQ.NDIST1_SYMM(2).AND.
     &         NSYM_DIST(3,IR1).EQ.NDIST1_SYMM(3).AND.
     &         NSYM_DIST(4,IR1).EQ.NDIST1_SYMM(4)) THEN
              IDIST = IR1
              IMODE = 0
              GOTO 200
            ENDIF
          ELSEIF(N_TARGET(IR1).EQ.IA2) THEN
C
C---Atom IA1 is object atom and atom IA2 is target
            ISYM1 = NDIST1_SYMM(1)
            ISYM2 = 1
            ITX1(1) = -NDIST1_SYMM(2)
            ITX1(2) = -NDIST1_SYMM(3)
            ITX1(3) = -NDIST1_SYMM(4)

            CALL SYM_FIND_R0(MAXSYM,NumSymmetry,RealSymmMatrx,ISYM1,
     &                    ISYM2,ITX1,ISYM_CUR,ITX_CUR,FIRST)
            IF(NSYM_DIST(1,IR1).EQ.ISYM_CUR  .AND.
     &         NSYM_DIST(2,IR1).EQ.ITX_CUR(1).AND.
     &         NSYM_DIST(3,IR1).EQ.ITX_CUR(2).AND.
     &         NSYM_DIST(4,IR1).EQ.ITX_CUR(3)) THEN
              IDIST = IR1
              IMODE = 1
              GOTO 200
            ENDIF

          ENDIF
        ENDDO
      ENDIF
C
C---this pair is not in the list add it
      NDIST = NDIST + 1
      IF(NDIST.GT.MAXREST) THEN
        CALL ERRWRT(1,'In find restraints number of pairs exceeds'//
     &       ' maximum allowed restraint pairs')
      ENDIF
      NREST_PER_ATOM(IA1) = NREST_PER_ATOM(IA1) + 1
      NREST_PER_ATOM(IA2) = NREST_PER_ATOM(IA2) + 1
      REST_PER_ATOM(IA1,NREST_PER_ATOM(IA1)) = NDIST
      REST_PER_ATOM(IA2,NREST_PER_ATOM(IA2)) = NDIST
      N_TARGET(NDIST) = IA1
      N_OBJECT(NDIST) = IA2
      DO   I=1,4
        NSYM_DIST(I,NDIST) = NDIST1_SYMM(I)
      ENDDO
      IF(NSYM_DIST(1,NDIST).LE.0) NSYM_DIST(1,NDIST) = 1
      IMODE = 0
      IDIST = NDIST
 200  CONTINUE
      IF(NW_UVAL(IDIST).LE.0) NW_UVAL(IDIST)  = IW_UVAL
      RETURN
      END
c
      SUBROUTINE FIND1_RESTRAINT(MAXREST,NDIST,IDIST,IA1,IA2,N_ATOM,
     &          NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          IMODE)
      IMPLICIT NONE
C
c---this routien finds position of IA1,IA2 restraint in the list of restraints
C---if it is not there then this pair is added to the list of resraints
C
      INTEGER MAXREST,NDIST,IDIST,IA1,IA2,N_ATOM,NREST_PER_ATOM(*),
     &        REST_PER_ATOM(N_ATOM,*),N_TARGET(*),N_OBJECT(*)
      INTEGER IMODE
C
      INTEGER IREST,IR1
C
      IMODE = 0
      IF(NREST_PER_ATOM(IA1).GT.0.AND.NREST_PER_ATOM(IA2).GT.0) THEN
        DO   IREST = 1,NREST_PER_ATOM(IA1)
          IR1 = REST_PER_ATOM(IA1,IREST)
          IF(N_TARGET(IR1).EQ.IA2) THEN
C
C---Atom IA1 is object atom and atom IA2 is target
            IDIST = IR1
            IMODE = 1
            GOTO 200
          ELSEIF(N_OBJECT(IR1).EQ.IA2) THEN
C
C---Atom IA1 is target atom and atom IA2 is object
            IDIST = IR1
            IMODE = 0
            GOTO 200
          ENDIF
        ENDDO
      ENDIF
C
C---this pair is not in the list add it
      NDIST = NDIST + 1
      IF(NDIST.GT.MAXREST) THEN
        CALL ERRWRT(1,'In find restraints number of pairs exceeds'//
     &       ' maximum allowed restraint pairs')
      ENDIF
      NREST_PER_ATOM(IA1) = NREST_PER_ATOM(IA1) + 1
      NREST_PER_ATOM(IA2) = NREST_PER_ATOM(IA2) + 1
      REST_PER_ATOM(IA1,NREST_PER_ATOM(IA1)) = NDIST
      REST_PER_ATOM(IA2,NREST_PER_ATOM(IA2)) = NDIST
      N_TARGET(NDIST) = IA1
      N_OBJECT(NDIST) = IA2
      IMODE = 0
      IDIST = NDIST
 200  CONTINUE
      RETURN
      END
C
      SUBROUTINE MAKE_DIST_LIST
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'restr_files.fh'
c
c--this subroutine reads file vdw_file_0 containing list of distances
C--and makes distance list for second derivative calculation
      integer nvdw1
      INTEGER N_TARGET(QQD),N_OBJECT(QQD),N_UVAL(QQD),NSYM_DIST(4,QQD)
      COMMON /DISTNS/ N_OBJECT,N_TARGET,N_UVAL,NSYM_DIST
C
      INTEGER ISCRV,IFAIL,LL,IVDW_TYPE,ID,I
      REAL DVDW_IDEAL,VDW_SDI
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      NDIS = 0
C
C--Check if file exists
      IF(VDW_FILE_0(1:1).EQ.' ') RETURN
      call open_unform_file(iscrv,vdw_file_0,ifail)

      read(iscrv)nvdw1
      NDIS = 0
 10   CONTINUE
      NDIS = NDIS + 1
      READ(ISCRV,END=999)N_TARGET(NDIS),N_OBJECT(NDIS),
     &     NSYM_DIST(1:4,NDIS)
      IF(NSYM_DIST(1,NDIS).LE.0)NSYM_DIST(1,NDIS) = 1
      N_UVAL(NDIS) = 0
      GOTO 10
 999  CONTINUE
      NDIS = NDIS-1
c
c---  add all others, sort and remove redundant pairs
C
c      WRITE(*,*)'Number of distances so far ',NDIS 
      CLOSE(ISCRV)
c      STOP
      RETURN
      END
c
      SUBROUTINE GET_DIST_LIST(nvdw1)
      IMPLICIT NONE
      INCLUDE 'restr_files.fh'
c
c--Get the number of distance pairs
      integer nvdw1
C
      INTEGER ISCRV,ifail
C
C--Check if file exists
      nvdw1=0
      IF(VDW_FILE_0(1:1).EQ.' ') RETURN
      call open_unform_file(iscrv,vdw_file_0,ifail)
c
c---Add 
      read(iscrv)nvdw1

      CLOSE(ISCRV)
c      STOP
      RETURN
      END
c
      subroutine get_matrix_size(ndv1,qqm)
      include 'atom_com.fh'
      integer ndv1,qqm
c
c---  Calculate upper limit for second derivative matrix size
      integer i
      logical anis_flag
c
c---  body. Size are taken larger than necessary just to be sure
      anis_flag = .FALSE.
      if(maxval(u_aniso(1:n_atom,2)).gt.0.0) anis_flag = .TRUE.
      if(anis_flag) then
         qqm = 30*n_atom + 90*ndv1
      else
         qqm = 10*n_atom + 15*ndv1
      endif
      return
      end
c
      subroutine interv_ref(sumint,max_mat,max_vec,a_mat,vect,max_dist,
     &     n_target,n_object,nsym_dist,nw_uval,nrest_per_atom,
     &     rest_per_atom,ierr)
      implicit none
c
c---This routine calculates derivatives of NMR NOE style pseudorestraints
      include 'atom_com.fh'
      include 'models.fh'
      include 'celsym.fh'
      include 'monitor.fh'
      include 'vitals.fh'
      include 'rharvest.fh'
      include 'restr_files.fh'
      include 'weights.fh'
c
      real sumint
      integer max_mat,max_vec,ndist,max_dist
      real    a_mat(*),vect(*)
      integer nrest_per_atom(*),rest_per_atom(n_atom,*)
      integer n_target(*),n_object(*),nw_uval(*),nsym_dist(4,*)
c
      integer ierr
c
c---restraints file
      integer iscri,iend
      integer ninterval
      integer ia1(2),is_t(4)
      real    dmin,dmax,sigma,sigma_min,sigma_max
c
      integer ii,ia11,ia21,ia12,ia22
      integer is
      real    tx(3)
      real    xyz_tmp1(3),xyz_tmp2(3)
      real    xyz_t1(3),xyz_t2(3)
      real    dist,delta,w,delta1,delta2,delta4,deltaw
      real    dbdx1(3),dbdx2(3)
      real    small_bond
      data small_bond/0.001/
c
c---  matrix and vector
      integer imode,iw_uval,idist,itype_bond
      integer ipos_vec1,ipos_vec2,ipos_mat1,ipos_mat2
      integer ix
c
      character line*512
      integer ir1,ir2,ifirst
      character chnamp1*4,chnamp2*4
c
c---body
      sumint = 0
      ierr   = 0
      iw_uval = 1
      if(interval_file(1:1).eq.' ') return
      call open_unform_file(iscri,interval_file,ierr)
      if(ierr.gt.0) then
         write(*,*)'Problem with interval file'
         close(iscri)
         return
      endif
c     
      read(iscri,iostat=iend)ninterval
      if(iend.ne.0.or.ninterval.le.0) then
         close(iscri)
         return
      endif
      ifirst = 0
      do ii=1,ninterval
         read(iscri)ia1(1:2),is_t(1:4),dmin,dmax,sigma_min,sigma_max,
     &        itype_bond
         iw_uval = itype_bond
         if(iw_uval.le.0) iw_uval = 6
         if(sigma_min.le.0.0) sigma_min = 0.02
         if(sigma_max.le.0.0) sigma_max = 0.02
         ia11 = atom_ref_flag(ia1(1))/10
         ia21 = atom_ref_flag(ia1(2))/10
         ia12 = atom_ref_flag(ia1(1)) - 10*ia11
         ia22 = atom_ref_flag(ia1(2)) - 10*ia21

         if(ia1(1).gt.0.and.ia1(2).gt.0.and.
     &        ia12.gt.0.and.ia22.gt.0) then
            xyz_tmp1(1:3) = xyz_crd(1:3,ia1(1))
            xyz_tmp2(1:3) = xyz_crd(1:3,ia1(2))
            is = is_t(1)
            tx(1:3) = real(is_t(2:4))
            xyz_t1 = matmul(cs_ort_to_frac,xyz_tmp2)
            xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1)+
     &           cs_v_cs(1:3,is) + tx(1:3)
            xyz_tmp2 = matmul(cs_frac_to_ort,xyz_t2)
            dbdx1(1:3) = xyz_tmp1-xyz_tmp2
            dist = sqrt(sum(dbdx1**2))
            if(dist.lt.dmin) then
               delta = dmin - dist
               sigma = sigma_min
            else if(dist.gt.dmax) then
               delta = dmax - dist
               sigma = sigma_max
            else
               delta = 0
               sigma = sqrt((sigma_min**2+sigma_max**2)/2.0)
            endif
            if(mon_style.eq.'MANY'.or.mon_style.eq.'MEDI') then
               if(abs(delta).gt.badint*sigma) then
                  if(ifirst.eq.0) then
                     call header('Interval outliers')
                     write(line,'(a,f6.3,a)')
     &                    'Interval deviations from ideal >',
     &                    badint,'Sigma will be monitored'
                     call errwrt(-1,line)
                     call errwrt(-1,' ')
                     ifirst = 1
                  endif
                  ir1 = i_resid(ia1(1))
                  ir2 = i_resid(ia1(2))
                  call get_chain_namepdb(chnamp1,ir1)
                  call get_chain_namepdb(chnamp2,ir2)
                  write(line,'(11A,6(a,f6.3))')
     &                 chnamp1,RES_NUM_PDB(IR1)(3:7),
     &                 RES_NAME(IR1)(1:4),
     &                 ATM_NAME(IA1(1))(1:4),ID_ALT(IA1(1)),' - ',
     &                 chnamp2,RES_NUM_PDB(IR2)(3:7),
     &                 RES_NAME(IR2)(1:4),
     &                 ATM_NAME(IA1(2))(1:4),ID_ALT(IA1(2)),
     &                 ' mod. ',dist,' dmin=',dmin,' dmax=',dmax,
     &                 ' dev=',delta,' smin=',sigma_min,
     &                 ' smax=',sigma_max
                  call errwrt(-1,line)
               endif
            endif
c     
c---  accumulate statistics and report outliers

            delta2 = delta**2
            delta4 = delta**4
c            delta1 = 2.0*delta/max(dist,small_bond)
            w = 1/sigma**2
            sumint = sumint + 0.5*w*delta2
            do ix=1,3
               dbdx1(ix) = dbdx1(ix)/max(small_bond,dist)
            enddo
c            dbdx1(1:3) = dbdx1(1:3)
            dbdx2(1:3) = -dbdx1(1:3)
            xyz_t1 = matmul(transpose(cs_frac_to_ort),dbdx2)
            xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
            dbdx2 = matmul(transpose(cs_ort_to_frac),xyz_t2)

            deltaw = w*delta
            ipos_vec1 = 3*ia11-3
            ipos_vec2 = 3*ia21-3
            call incr_vector(max_vec,ipos_vec1,vect,deltaw,dbdx1)
            call incr_vector(max_vec,ipos_vec2,vect,deltaw,dbdx2)
            ipos_mat1 = 6*ia11-6
            ipos_mat2 = 6*ia21-6
            call incr_matr_diagonal(max_mat,ipos_mat1,a_mat,w,dbdx1)
            call incr_matr_diagonal(max_mat,ipos_mat2,a_mat,w,dbdx2)
            if(ia11.eq.ia21) then
               ipos_mat1 = 6*ia11-6
               call incr_matr_diagonal1(max_mat,ipos_mat1,a_mat,w,
     &              dbdx2,dbdx1)
            else
               call find_restraint(max_dist,ndis,idist,ia1(1),ia1(2),
     &              is_t,n_atom,nrest_per_atom,rest_per_atom,
     &              n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
               ipos_mat1 = nmpos + 9*(idist-1)
               if(imode.eq.0) then
                  call incr_matr_ndiag(max_mat,ipos_mat1,a_mat,w,
     &                 dbdx1,dbdx2)
               else
                  call incr_matr_ndiag(max_mat,ipos_mat1,a_mat,w,
     &                 dbdx2,dbdx1)
               endif
            endif
c
c---  Some stats and violation report
         endif
      enddo
      close(iscri)
      return
      end
C
      SUBROUTINE ANGL_REF(SUMANG,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &            N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL,
     &            NREST_PER_ATOM,REST_PER_ATOM)
      IMPLICIT NONE
C---This routine calculates derivatives of restraints corresponding to
C---bond angles. they are strored in the file. file is opened and
C---closed at the end of program
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'weights.fh'

      INTEGER MAX_MAT,MAX_VEC,NDIST,MAX_DIST
      REAL SUMANG
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),
     &        N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      REAL A_MAT(*),VECT(*)
C
C---Local variables
      integer nr_angle
      integer i,ia
      INTEGER ISCRA,IA1(3),N_ANGLE_REST(2),IW_UVAL,LL,IFAIL,
     &        IA11,IA21,IA31,IA12,IA32,IA22,IPOS_VEC1,IPOS_VEC2,
     &        IPOS_VEC3,IPOS_MAT1,IPOS_MAT2,IPOS_MAT3,IPOS_MAT,IX,
     &        JX,IDIST,IMODE
      INTEGER NDIST1_SYMM(4)
      REAL    RS_VIDL,RS_SDI
      real    RS_DIST,RS_DESD,SMALL_BOND,COS_ANGLE,SIN_ANGLE
      real     VECTOR1(3),VECTOR2(3),DADX(3,3),ANGLE,WEIGHTL
      real    RADTODEG,SMALL_SINE,RMS_ANGLE(2),ASIGMA_ANGLE(2)
      real    VEC1_NORM,VEC2_NORM,DANGLE,DANGLE2,DANGLEW
      real    VEC12_PROD,ZANGL
      integer is
      real    tx(3)
      integer is_t(4,3)
      real    xyz_t1(3),xyz_t2(3)
      real    xyz_tmp1(3,3)
      INTEGER LENSTR
      EXTERNAL LENSTR
     
      DATA SMALL_BOND/0.001/,SMALL_SINE/0.001/,RADTODEG/57.29578/
C
      RMS_ANGLE(1)    = 0.0
      ASIGMA_ANGLE(1) = 0.0
      RMS_ANGLE(2)    = 0.0
      ZANGL           = 0.0
      ASIGMA_ANGLE(2) = 0.0
      N_ANGLE_REST(1) = 0
      N_ANGLE_REST(2) = 0
      SUMANG          = 0.0
      IW_UVAL         = 2
      IF(ANGLE_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscra,angle_file,ifail)
      read(iscra)nr_angle
 10   CONTINUE
      READ(ISCRA,END=999)IA1(1:3),(is_t(1:4,i),i=1,3),RS_VIDL,RS_SDI
      IF(RS_SDI.LE.0.0) GOTO 10
      IF(ATOM_REF_FLAG(IA1(1)).LE.0.OR.ATOM_REF_FLAG(IA1(2)).LE.0.OR.
     &   ATOM_REF_FLAG(IA1(3)).LE.0) GOTO 10
      WEIGHTL = (WASKAL/RS_SDI)**2
      IA11    = ATOM_REF_FLAG(IA1(1))/10
      IA21    = ATOM_REF_FLAG(IA1(2))/10
      IA31    = ATOM_REF_FLAG(IA1(3))/10
      IA12    = ATOM_REF_FLAG(IA1(1)) - IA11*10
      IA22    = ATOM_REF_FLAG(IA1(2)) - IA21*10
      IA32    = ATOM_REF_FLAG(IA1(3)) - IA31*10
      IF(IA12.LE.0.OR.IA22.LE.0.OR.IA32.LE.0) GOTO 10
      xyz_tmp1(1:3,1:3) = xyz_crd(1:3,ia1(1:3))
      do ia = 1,3
         is = is_t(1,ia)
         tx(1:3) = float(is_t(2:4,ia))
         xyz_t1 = matmul(cs_ort_to_frac,xyz_tmp1(1:3,ia))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1) + 
     &        cs_v_cs(1:3,is) + tx(1:3)
         xyz_tmp1(1:3,ia) = matmul(cs_frac_to_ort,xyz_t2)
      enddo
C
      DO   IX=1,3
         VECTOR1(IX) = XYZ_TMP1(IX,2) - XYZ_TMP1(IX,1)
         VECTOR2(IX) = XYZ_TMP1(IX,2) - XYZ_TMP1(IX,3)
      ENDDO
      VEC1_NORM = AMAX1(SQRT(VECTOR1(1)**2+VECTOR1(2)**2+VECTOR1(3)**2),
     &     SMALL_BOND)
      VEC2_NORM = AMAX1(SQRT(VECTOR2(1)**2+VECTOR2(2)**2+VECTOR2(3)**2),
     &     SMALL_BOND)
      
      VEC12_PROD = VECTOR1(1)*VECTOR2(1)+VECTOR1(2)*VECTOR2(2)+
     *     VECTOR1(3)*VECTOR2(3)
      COS_ANGLE = AMIN1(1.0,VEC12_PROD/(VEC1_NORM*VEC2_NORM))
      SIN_ANGLE = AMIN1(1.0,AMAX1(SQRT(1-COS_ANGLE**2),SMALL_SINE))
      ANGLE     = ACOS(AMAX1(-1.0,AMIN1(1.0,COS_ANGLE)))*RADTODEG
C     
C---- Derivatives of the angle wrt atomic parameters
      DO    IX=1,3
         DADX(IX,1) = (VECTOR2(IX)/(VEC1_NORM*VEC2_NORM)-
     &        COS_ANGLE*VECTOR1(IX)/VEC1_NORM**2)/SIN_ANGLE
     &        *RADTODEG 
         DADX(IX,3) = (VECTOR1(IX)/(VEC1_NORM*VEC2_NORM)-
     &        COS_ANGLE*VECTOR2(IX)/VEC2_NORM**2)/SIN_ANGLE
     &        *RADTODEG
         DADX(IX,2) = -(DADX(IX,1)+DADX(IX,3))
      ENDDO
      do ia=1,3
         is = is_t(1,ia)
         xyz_t1 = matmul(transpose(cs_frac_to_ort),dadx(1:3,ia))
         xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
         dadx(1:3,ia) = matmul(transpose(cs_ort_to_frac),xyz_t2)
      enddo

      DANGLE = RS_VIDL - ANGLE
      DANGLE2 = DANGLE**2
C
c---Compile overall statistics. Make sure to distinguish refinable and
C---nonrefinable atoms
      SUMANG = SUMANG + 0.5*WEIGHTL*DANGLE2
      IF(IA12.GT.2.AND.IA22.GT.2.AND.IA32.GT.2) THEN
         RMS_ANGLE(1) = RMS_ANGLE(1) + DANGLE2
         ASIGMA_ANGLE(1) = ASIGMA_ANGLE(1) + RS_SDI
         ZANGL           = ZANGL + DANGLE2/RS_SDI**2
         N_ANGLE_REST(1) = N_ANGLE_REST(1) + 1
      ELSE
         RMS_ANGLE(2) = RMS_ANGLE(2) + DANGLE2
         ASIGMA_ANGLE(2) = ASIGMA_ANGLE(2) + RS_SDI
         N_ANGLE_REST(2) = N_ANGLE_REST(2) + 1
      ENDIF
      DANGLEW= DANGLE*WEIGHTL
C     
C---- Increment vector elements
      IPOS_VEC1 = 3*IA11-3
      IPOS_VEC2 = 3*IA21-3
      IPOS_VEC3 = 3*IA31-3
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC1,VECT,DANGLEW,DADX(1,1))
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC2,VECT,DANGLEW,DADX(1,2))
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC3,VECT,DANGLEW,DADX(1,3))

C---  Increment matrix elements. Atom block
      IPOS_MAT1 = 6*IA11-6
      IPOS_MAT2 = 6*IA21-6
      IPOS_MAT3 = 6*IA31-6
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,DADX(1,1))
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT2,A_MAT,WEIGHTL,DADX(1,2))
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT3,A_MAT,WEIGHTL,DADX(1,3))
C
C---Check if this restraint pair is present in the previous list. In principle
C---only IA1,IA3 may not present. Because usually IA1,IA2 and IA3,IA2 are
C---bonds. But we should check all of them
C      
      DO    IX=1,2
        DO   JX=IX+1,3
          NDIST1_SYMM(1) = 1
          NDIST1_SYMM(2) = 0
          NDIST1_SYMM(3) = 0
          NDIST1_SYMM(4) = 0
          CALL  FIND_RESTRAINT(MAX_DIST,NDIS,IDIST,IA1(IX),IA1(JX),
     &          NDIST1_SYMM,N_ATOM,
     &          NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
          IPOS_MAT = NMPOS + 9*(IDIST-1)

          IF(IMODE.EQ.0) THEN
C
C---When pair of IAs are equal???. At the moment no angles through symmetry.
C---Should be added. Or angles can be handled as distance restraints???
C
C---IA1 is target and IA2 is object
            CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT,A_MAT,WEIGHTL,
     &                                 DADX(1,IX),DADX(1,JX))
          ELSE
C
C---IA1 is object and IA2 is target
            CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT,A_MAT,WEIGHTL,
     &                                 DADX(1,JX),DADX(1,IX))
         ENDIF
        ENDDO
      ENDDO      
      GOTO 10
 999  CONTINUE
C
C---Save for harvesting and reporting overall statistics
      IF(N_ANGLE_REST(1).GT.0) THEN
        HNRESTR = HNRESTR + 1
        HRESTR_TYPE(HNRESTR) = 'Bond angles  : refined atoms'
        HRESTR_CIF(HNRESTR) = 'r_angle_refined_deg'
        RMS_ANGLE(1) = SQRT(RMS_ANGLE(1)/FLOAT(N_ANGLE_REST(1)))
        ASIGMA_ANGLE(1) = ASIGMA_ANGLE(1)/FLOAT(N_ANGLE_REST(1))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_ANGLE(1)
        HRESTR_DEV(HNRESTR)     = RMS_ANGLE(1)
        HRESTR_Z(HNRESTR)       = SQRT(ZANGL/N_ANGLE_REST(1))
        HRESTR_NUM(HNRESTR)     = N_ANGLE_REST(1)
      ENDIF
      IF(N_ANGLE_REST(2).GT.0) THEN
        HNRESTR = HNRESTR + 1
        HRESTR_TYPE(HNRESTR) = 'Bond angles  : others'
        HRESTR_CIF(HNRESTR) = 'r_angle_other_deg'
        RMS_ANGLE(2) = SQRT(RMS_ANGLE(2)/FLOAT(N_ANGLE_REST(2)))
        ASIGMA_ANGLE(2) = ASIGMA_ANGLE(2)/FLOAT(N_ANGLE_REST(2))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_ANGLE(2)
        HRESTR_DEV(HNRESTR)     = RMS_ANGLE(2)
        HRESTR_NUM(HNRESTR)     = N_ANGLE_REST(2)
      ENDIF
C
c---Close file and return
      CLOSE(UNIT=ISCRA)
      ISCRA = 0
      END
C
      SUBROUTINE TORS_REF(SUMTOR,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &              N_TARGET,N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)
C---This routine calculates derivatives of restraints corresponding to
C---torsion angles. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'const.fh'
      INCLUDE 'restr_files.fh'

      INTEGER MAX_MAT,MAX_VEC,MAX_DIST
      REAL SUMTOR
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),
     &        N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      REAL A_MAT(*),VECT(*)
C
C---Local variables
      integer nr_tors
      INTEGER ISCRT,IX,ITOR_FLAG,IA_T(4),IA1(4),IA12(4),
     &        N_TORS_REST(2,6),LL,IFAIL,ITORS_PERIOD,IT,IPOS_VEC,
     &        IPOS_MAT,IY,IMODE,I_TEMP,IDIST
      INTEGER I,J,IW_UVAL,IFIRST
      INTEGER NDIST1_SYMM(4)
      REAL    XYZ_TMP(3,4),DTHDX(3,4),RS_VIDL,RS_SDI,ANGLE,
     &        ASIGMA_TORS(2,6),RMS_TORS(2,6),WEIGHTL,DELTA,DELTA1,
     &        DELTAW,DELTA2,SIN1,COS1
      integer is_t(4,4)
      integer is
      real    tx(3)
      real    xyz_t1(3),xyz_t2(3)
      INTEGER LENSTR
      EXTERNAL LENSTR
      CHARACTER TORS_LABEL*8
C
      IFIRST = 0
      SUMTOR  = 0.0
      DO   I=1,6
        DO   J=1,2
          RMS_TORS(J,I) = 0.0
          ASIGMA_TORS(J,I) = 0.0
          N_TORS_REST(J,I) = 0
        ENDDO
      ENDDO
      IW_UVAL = 3
      IF(TORS_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscrt,tors_file,ifail)

      read(iscrt)nr_tors

 10   CONTINUE
      READ(ISCRT,END=999)TORS_LABEL,IA_T(1:4),(is_t(1:4,i),i=1,4),
     &      ITORS_PERIOD,RS_VIDL,RS_SDI,ITOR_FLAG
C
c---Check if this torsion angle has relevance. I.e. should this torsion
c---angle be included in restraints. Check is done bye name
      IF(ITOR_FLAG.EQ.0) GOTO 10
      if(itors_period.le.0) itors_period = 1

cd      IF(ITORS_PERIOD.NE.3.AND.ITORS_PERIOD.NE.1) GOTO 10
cd      IF(ITORS_PERIOD.NE.1) GOTO 10

      IF(RS_SDI.LE.0.0) GOTO 10      
      DO   IT = 1,4
        IF(ATOM_REF_FLAG(IA_T(IT)).LE.0) GOTO 10
        IA1(IT)  = ATOM_REF_FLAG(IA_T(IT))/10
        IA12(IT) = ATOM_REF_FLAG(IA_T(IT)) - IA1(IT)*10
        IF(IA12(IT).LE.0) GOTO 10
      ENDDO
      WEIGHTL = (WTSKAL/RS_SDI)**2
C
      xyz_tmp(1:3,1:4) = xyz_crd(1:3,ia_t(1:4))
      do it=1,4
         is = is_t(1,it)
         tx(1:3) = float(is_t(2:4,it))
         xyz_t1 = matmul(cs_ort_to_frac,xyz_tmp(1:3,it))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1) + 
     &        cs_v_cs(1:3,is) + tx(1:3)
         xyz_tmp(1:3,it) = matmul(cs_frac_to_ort,xyz_t2)
      enddo

C
C---Calculate torshion angle and derivatives
      CALL TORSHN_WITH_DERIVATIVES(XYZ_TMP,ANGLE,DTHDX)
      do it=1,4
         is = is_t(1,it)
         xyz_t1 = matmul(transpose(cs_frac_to_ort),dthdx(1:3,it))
         xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
         dthdx(1:3,it) = matmul(transpose(cs_ort_to_frac),xyz_t2)
      enddo
c
c---  symmetry
      DELTA = RS_VIDL - ANGLE
      DELTA1 = FLOAT(ITORS_PERIOD)*DELTA*DEGTOR
      DELTA2 = 0.0
      SIN1 = SIN(DELTA1)
      COS1 = COS(DELTA1)      
      IF(SIN1**2+COS1**2.GT.0.0) DELTA2 = ATAN2(SIN1,COS1)
      DELTA2 = DELTA2*RTODEG
      DELTA = DELTA2/FLOAT(ITORS_PERIOD)
      DELTAW= WEIGHTL*DELTA
      CALL TORS_OUTLIER(ANGLE,RS_VIDL,DELTA,ITORS_PERIOD,TORS_LABEL,
     &       MON_STYLE,IA_T,TORCUT,RS_SDI,IFIRST)
C
c----Compile overall statistics. Make sure to distinguish different type
C----of torsion angles and refinable and nonrefinables atoms
      DELTA2 = DELTA**2
      SUMTOR = SUMTOR + 0.5*WEIGHTL*DELTA2
      DO   IT = 1,4
        IF(IA12(IT).LE.2) GOTO 800
      ENDDO
      RMS_TORS(1,ITORS_PERIOD)    = RMS_TORS(1,ITORS_PERIOD) + DELTA2
      ASIGMA_TORS(1,ITORS_PERIOD) = ASIGMA_TORS(1,ITORS_PERIOD) + RS_SDI
      N_TORS_REST(1,ITORS_PERIOD) = N_TORS_REST(1,ITORS_PERIOD) + 1
      GOTO 810
 800  CONTINUE
      RMS_TORS(2,ITORS_PERIOD)    = RMS_TORS(2,ITORS_PERIOD) + DELTA2
      ASIGMA_TORS(2,ITORS_PERIOD) = ASIGMA_TORS(2,ITORS_PERIOD) + RS_SDI
      N_TORS_REST(2,ITORS_PERIOD) = N_TORS_REST(2,ITORS_PERIOD) + 1
 810  CONTINUE
C
      DO   IT=1,4
        IPOS_VEC = 3*IA1(IT)-3
        CALL INCR_VECTOR(MAX_VEC,IPOS_VEC,VECT,DELTAW,DTHDX(1,IT))
        IPOS_MAT = 6*IA1(IT)-6
        CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT,A_MAT,
     &                                         WEIGHTL,DTHDX(1,IT))
      ENDDO
C
C--Non diagonal terms
      DO   IX=1,3
        DO  IY=IX+1,4
          NDIST1_SYMM(1) = 1
          NDIST1_SYMM(2) = 0
          NDIST1_SYMM(3) = 0
          NDIST1_SYMM(4) = 0
          CALL  FIND_RESTRAINT(MAX_DIST,NDIS,IDIST,IA_T(IX),IA_T(IY),
     &          NDIST1_SYMM,
     &          N_ATOM,NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
          IPOS_MAT = NMPOS + 9*(IDIST-1)
          IF(IMODE.EQ.0) THEN
c
C---When pair of IAs are equal???. No torsions through symmetry. Should be
C---added. Can not be simply treated by distances???
C
C---IA1 is target and IA2 is object
            CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT,A_MAT,WEIGHTL,
     &                                 DTHDX(1,IX),DTHDX(1,IY))
          ELSE
C
C---IA1 is object and IA2 is target
            CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT,A_MAT,WEIGHTL,
     &                                 DTHDX(1,IY),DTHDX(1,IX))
         ENDIF
        ENDDO
      ENDDO
      GOTO 10
C
 999  CONTINUE
C
c---Save for harvesting and reporting
      DO   I=1,6
        DO   J=1,2
          IF(N_TORS_REST(J,I).GT.0) THEN
            RMS_TORS(J,I) = SQRT(RMS_TORS(J,I)/FLOAT(N_TORS_REST(J,I)))
            ASIGMA_TORS(J,I) = ASIGMA_TORS(J,I)/FLOAT(N_TORS_REST(J,I))
            HNRESTR = HNRESTR + 1
            IF(J.EQ.1) THEN
              WRITE( HRESTR_TYPE(HNRESTR),'(A,I2,A)') 
     &        'Torsion angles, period ',I,'. refined'
              WRITE( HRESTR_CIF(HNRESTR),'(A,I1,A)') 
     &        'r_dihedral_angle_',I,'_deg'
            ELSE
              WRITE( HRESTR_TYPE(HNRESTR),'(A,I2,A)') 
     &        'Torsion angles, period ',I,'. others'
              WRITE( HRESTR_CIF(HNRESTR),'(A,I1,A)') 
     &        'r_dihedral_angle_other_',I,'_deg'
            ENDIF
            HRESTR_DEVITAR(HNRESTR) = ASIGMA_TORS(J,I)
            HRESTR_DEV(HNRESTR)     = RMS_TORS(J,I)
            HRESTR_NUM(HNRESTR)     = N_TORS_REST(J,I)
          ENDIF
        ENDDO
      ENDDO
      CLOSE (UNIT=ISCRT)
      ISCRT = 0
      RETURN
      END
C
      SUBROUTINE TORSHN_WITH_DERIVATIVES(X,ANGLE,DIR)
C
      INCLUDE 'const.fh'
      
      REAL   ANGLE,G(3,3),X(3,4),DIR(3,4),Q(3,3),
     .            DADP(3,3,4),DBDP(3,3,4),DWDP(3,3,4),DWMAG(3,4),
     .            DRDX(3),D1(3),D2(3),D3(3),U(3),V(3),W(3),A(3),B(3)

      REAL SMALL_LEN
      DATA SMALL_LEN/0.0001/
      DO   I=1,3
        DO   J=1,3
           G(J,I) = 0.0
        ENDDO
      ENDDO
        G(1,1) = 1.0
        G(2,2) = 1.0
        G(3,3) = 1.0
C
C----FORM THE TRIAD OF INTERATOMIC VECTORS
      DO 10 I=1,3
        U(I) = X(I,1) - X(I,2)
        V(I) = X(I,4) - X(I,3)
        W(I) = X(I,3) - X(I,2)
   10 CONTINUE
C
C----Find a = u.cross.w
      CALL CROSS(A,U,W)
C
C----Find b = v.cross.w
      CALL CROSS(B,V,W)
C
C----Find |w|
      WMAG = AMAX1(SMALL_LEN,SQRT(W(1)**2+W(2)**2+W(3)**2))
C
C---- (A.CROSS.B).DOT.W = |A|*|B|*|W|*SIN(ANGLE)
C
      DO 20 J=1,3
        Q(1,J) = A(J)
        Q(2,J) = B(J)
        Q(3,J) = W(J)
   20 CONTINUE
      S = DET3(Q)
C
C---- (A.DOT.B)*|W| = |A|*|B|*|W|*COS(ANGLE)
      T = (A(1)*B(1) + A(2)*B(2) + A(3)*B(3))*WMAG
C
C----Torsion angle result in degrees
      ANGLE = 0.0
      IF (S.NE.0.0 .OR. T.NE.0.0) ANGLE = ATAN2(S,T)/DEGTOR
C
C----Return if derivatives are not needed
cd      IF(IDERIV.EQ.0) RETURN

      DIRDEN = AMAX1(SMALL_LEN,(S**2+T**2))*DEGTOR
C
C----Compute partial derivatives of a, b and w w.r.t. parameters
      DO    IX=1,3
        DO    JX=1,3 
          DRDX(JX) = G(JX,IX)
        ENDDO
C
        CALL CROSS(D1,DRDX,W)
        CALL CROSS(D2,U,DRDX)
        CALL CROSS(D3,V,DRDX)
C
        DO    JX=1,3
          DADP(JX,IX,1) = D1(JX)
          DADP(JX,IX,2) = -D1(JX) - D2(JX)
          DADP(JX,IX,3) = D2(JX)
          DBDP(JX,IX,2) = -D3(JX)
          DBDP(JX,IX,3) = D3(JX) - D1(JX)
          DBDP(JX,IX,4) = D1(JX)
          DWDP(JX,IX,2) = -DRDX(JX)
          DWDP(JX,IX,3) = DRDX(JX)
        ENDDO
        DWMAG(IX,3) = (W(1)*DRDX(1)+W(2)*DRDX(2)+W(3)*DRDX(3))/WMAG
        DWMAG(IX,2) = -DWMAG(IX,3)
      ENDDO
C
C----COMPUTE DERIVATIVES FROM PARTIALS BY THE CHAIN RULE
      DO     IX=1,3
        DO     IA=1,4
          DSDP = 0.0
          DTDP = 0.0
          IF(IA.NE.4) THEN
C
C....CONTRIBUTION OF PARTIALS OF A
          DO    JX=1,3
            Q(1,JX) = DADP(JX,IX,IA)
            Q(2,JX) = B(JX)
            Q(3,JX) = W(JX)
          ENDDO
          DSDP = DET3(Q)
          ADOTB = (DADP(1,IX,IA)*B(1)+DADP(2,IX,IA)*
     +                              B(2)+DADP(3,IX,IA)*B(3))
          DTDP = ADOTB*WMAG
          IF(IA.EQ.1) GO TO 95
          ENDIF
C
C....CONTRIBUTION OF PARTIALS OF B
          DO    JX=1,3
            Q(1,JX) = A(JX)
            Q(2,JX) = DBDP(JX,IX,IA)
            Q(3,JX) = W(JX)
          ENDDO
          DSDP = DSDP + DET3(Q)
          ADOTB = (A(1)*DBDP(1,IX,IA)+A(2)*DBDP(2,IX,IA)+
     +                                    A(3)*DBDP(3,IX,IA))
          DTDP = DTDP + ADOTB*WMAG
          IF(IA.NE.4) THEN
C
C....CONTRIBUTION OF PARTIALS OF W
            DO    JX=1,3
              Q(2,JX) = B(JX)
              Q(3,JX) = DWDP(JX,IX,IA)
            ENDDO
            DSDP = DSDP + DET3(Q)
            DTDP = DTDP + (T/WMAG)*DWMAG(IX,IA)
          ENDIF
C
C....COMPLETE DERIVATIVE
   95     DIR(IX,IA) = (T*DSDP-S*DTDP)/DIRDEN
        ENDDO
      ENDDO
      RETURN
      END
C

      SUBROUTINE TORSHN_WITH_DERIVATIVES1(XYZ,ANGLE,DTHDX)
      IMPLICIT NONE
C
C---This routine calculates torsion angles and its derivatives
C---wrt coordinates.
      REAL  ANGLE,XYZ(3,4),DTHDX(3,4)
      REAL  U(3),V(3),W(3),A(3),DADU(3,3),DADW(3,3),B(3),DBDV(3,3),
     &      DBDW(3,3),DADX(3,3,4),DBDX(3,3,4),DSINTDE(3,3),
     &      DCOSTDE(3,3),DSINTDX(3,4),DCOSTDX(3,4),Q(3,3)
      REAL WMAG,SINT,COST,SINT1,COST1,S2C2,AB,AB2W
      INTEGER I,J,IX,IY,IDER,IC
C
      REAL DEGTORAD,SMALL_VALUE
      DATA DEGTORAD/0.017453293/,SMALL_VALUE/0.00001/

C
C----Form the triad of interatomic vectors
      DO    I=1,3
        U(I) = XYZ(I,1) - XYZ(I,2)
        V(I) = XYZ(I,4) - XYZ(I,3)
        W(I) = XYZ(I,3) - XYZ(I,2)
      ENDDO
   10 CONTINUE
C----Find a = u.cross.w and its derivatives wrt u and w
      CALL CROSS_WITH_DERIVS(A,DADU,DADW,U,W)
C
C----Find b = v.cross.w and its derivatives wrt v and w
      CALL CROSS_WITH_DERIVS(B,DBDV,DBDW,V,W)
C
C----Find |w|
      WMAG = SQRT(W(1)**2+W(2)**2+W(3)**2)
C
C---- (A.CROSS.B).DOT.W = |A|*|B|*|W|*SIN(ANGLE) and its derivatives wrt A B W
C
      DO 20 J=1,3
        Q(J,1) = A(J)
        Q(J,2) = B(J)
        Q(J,3) = W(J)
   20 CONTINUE
      CALL DET3_WITH_DERIVS(Q,SINT,DSINTDE)
C
C---- (A.DOT.B)*|W| = |A|*|B|*|W|*COS(ANGLE) and its derivatives wrt A B W
      AB   = A(1)*B(1) + A(2)*B(2) + A(3)*B(3)
      AB2W = AB/AMAX1(SMALL_VALUE,WMAG)
      COST = AB*WMAG
      DO    IDER=1,3
         DCOSTDE(IDER,1) = B(IDER)*WMAG
         DCOSTDE(IDER,2) = A(IDER)*WMAG
         DCOSTDE(IDER,3) = W(IDER)*AB2W
      ENDDO
C
c---Using chain rule calculate derivatives of a,b,w wrt parameters of x1,x2,
C---x3,x4

      DO   IY=1,3
        DO   IX=1,3
          DADX(IX,IY,1) = DADU(IX,IY)
          DADX(IX,IY,3) = DADW(IX,IY)
          DADX(IX,IY,2) = -(DADU(IX,IY) + DADW(IX,IY))
          DADX(IX,IY,4) = 0.0

          DBDX(IX,IY,1) = 0.0
          DBDX(IX,IY,2) = -DBDW(IX,IY)
          DBDX(IX,IY,4) =  DBDV(IX,IY)
          DBDX(IX,IY,3) =  DBDW(IX,IY) - DBDV(IX,IY)

        ENDDO
      ENDDO
c
C----Calculate derivatives of sin(theta) and cos(theta) wrt parameters of x1,
C----x2,x3,x4
      DO   IY=1,4
        DO   IX=1,3
          DSINTDX(IX,IY) = 0.0
          DCOSTDX(IX,IY) = 0.0
        ENDDO
      ENDDO

      DO   IX=1,3
        DO   IY = 1,3
          DSINTDX(IX,1) =  DSINTDX(IX,1) + DSINTDE(IY,1)*DADX(IY,IX,1)
          DCOSTDX(IX,1) =  DCOSTDX(IX,1) + DCOSTDE(IY,1)*DADX(IY,IX,1)

          DSINTDX(IX,2) =  DSINTDX(IX,2) + DSINTDE(IY,1)*DADX(IY,IX,2) + 
     &                                     DSINTDX(IY,2)*DBDX(IY,IX,2) 
          DCOSTDX(IX,2) =  DCOSTDX(IX,2) + DCOSTDE(IY,1)*DADX(IY,IX,2) + 
     &                                     DCOSTDX(IY,2)*DBDX(IY,IX,2) 

          DSINTDX(IX,3) =  DSINTDX(IX,3) + DSINTDE(IY,1)*DADX(IY,IX,3) +
     &                                     DSINTDE(IY,2)*DBDX(IY,IX,3) 
          DCOSTDX(IX,3) =  DCOSTDX(IX,3) + DCOSTDE(IY,1)*DADX(IY,IX,3) +
     &                                     DCOSTDE(IY,2)*DBDX(IY,IX,3) 

          DSINTDX(IX,4) =  DSINTDX(IX,4) + DSINTDE(IY,2)*DBDX(IY,IX,4)
          DCOSTDX(IX,4) =  DCOSTDX(IX,4) + DCOSTDE(IY,2)*DBDX(IY,IX,4)

        ENDDO
        DSINTDX(IX,2) = DSINTDX(IX,2) - DSINTDE(IX,3)
        DCOSTDX(IX,2) = DCOSTDX(IX,2) - DCOSTDE(IX,3)

        DSINTDX(IX,3) = DSINTDX(IX,3) + DSINTDE(IX,3)
        DCOSTDX(IX,3) = DCOSTDX(IX,3) + DCOSTDE(IX,3)
      ENDDO
C
C----Torsion angle result in degrees
      ANGLE = 0.0
      S2C2  = (SINT**2+COST**2)*DEGTORAD
      IF (S2C2.NE.0.0) ANGLE=ATAN2(SINT,COST)/DEGTORAD
C
C----Complete derivative calculation using chain rule. We have derivatives
C----of sin(theta) and cos(theta) wrt parameters of x1 x2 x3 x4
cd      S2C2  = SINT**2 + COST**2
      SINT1 = SINT/AMAX1(SMALL_VALUE,S2C2)
      COST1 = COST/AMAX1(SMALL_VALUE,S2C2)
      DO   IC=1,4
        DO   IX=1,3
          DTHDX(IX,IC) = COST1*DSINTDX(IX,IC)-SINT1*DCOSTDX(IX,IC)
        ENDDO
      ENDDO

      RETURN
      END
C
      SUBROUTINE  CHIR_REF(SUMCHIR,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &              N_TARGET,N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)
C---This routine calculates derivatives of restraints corresponding to
C---chiral volumes. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'

      INTEGER MAX_MAT,MAX_VEC,MAX_DIST
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),
     &        N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      REAL A_MAT(*),VECT(*)
      REAL SUMCHIR
C
C---Local variables
      integer nr_chir
      integer i
      INTEGER ISCRC,IX,IA_C(4),IA1(4),IA12(4),N_CHIR_REST(2),IW_UVAL,
     &        LL,IFAIL,ICH,ITT,IY,IPOS_VEC,IPOS_MAT,IDIST,IMODE,
     &        ICHIR_SIGN
      real    xyz_tmp(3,4)
      REAL    A(3,3),DVOLDE(3,3),DVDX(3,4),RS_VIDL,RS_SDI,RS_OBS,
     &        RMS_CHIR(2),ASIGMA_CHIR(2),WEIGHTL,DELTA,DELTAW,DELTA2
      INTEGER NDIST1_SYMM(4)
      integer is_t(4,4)
      integer is
      real    tx(3)
      real     xyz_t1(3),xyz_t2(3)
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      SUMCHIR        = 0.0
      RMS_CHIR(1)    = 0.0
      ASIGMA_CHIR(1) = 0.0
      RMS_CHIR(2)    = 0.0
      ASIGMA_CHIR(2) = 0.0
      N_CHIR_REST(1) = 0
      N_CHIR_REST(2) = 0
      IW_UVAL        = 4
      IF(CHIR_FILE(1:1).EQ.' ') RETURN

      call open_unform_file(iscrc,chir_file,ifail)
      read(iscrc)nr_chir
 10   CONTINUE
      READ(ISCRC,END=999)IA_C(1:4),(is_t(1:4,i),i=1,4),
     &        RS_VIDL,RS_SDI,ICHIR_SIGN
      IF(RS_SDI.LE.0.0) GOTO 10
      DO   ICH = 1,4
         IF(ATOM_REF_FLAG(IA_C(ICH)).LE.0) GOTO 10
         IA1(ICH) = ATOM_REF_FLAG(IA_C(ICH))/10
         IA12(ICH) = ATOM_REF_FLAG(IA_C(ICH)) - IA1(ICH)*10
         IF(IA12(ICH).LE.0) GOTO 10
      ENDDO
      WEIGHTL = (WCSKAL/RS_SDI)**2
      xyz_tmp(1:3,1:4) = xyz_crd(1:3,ia_c(1:4))
c
c---  symmetry
      do  ich=1,4
         is = is_t(1,ich)
         tx(1:3) = float(is_t(2:4,ich))
         xyz_t1 = matmul(cs_ort_to_frac,xyz_tmp(1:3,ich))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1)+
     &        cs_v_cs(1:3,is) + tx(1:3)
         xyz_tmp(1:3,ich) = matmul(cs_frac_to_ort,xyz_t2)
      enddo
      do  ix=1,3
         a(1:3,ix) = xyz_tmp(1:3,ix+1) - xyz_tmp(1:3,1)
      enddo

      CALL DET3_WITH_DERIVS(A,RS_OBS,DVOLDE)
      IF(ICHIR_SIGN.EQ.0.AND.RS_OBS*RS_VIDL.LT.0.0) RS_VIDL = -RS_VIDL
      IF(ICHIR_SIGN.EQ.-1.AND.RS_VIDL.GT.0.0) RS_VIDL = -RS_VIDL
      IF(ICHIR_SIGN.EQ. 1.AND.RS_VIDL.LT.0.0) RS_VIDL = -RS_VIDL
      DELTA  = RS_VIDL-RS_OBS
      DELTAW = WEIGHTL*DELTA
      DELTA2 = DELTA**2
      DO   ITT = 1,4
        IF(IA12(ITT).LE.2) GOTO 800
      ENDDO
      RMS_CHIR(1) = RMS_CHIR(1) + DELTA2
      ASIGMA_CHIR(1) = ASIGMA_CHIR(1) + RS_SDI
      N_CHIR_REST(1) = N_CHIR_REST(1) + 1
      GOTO 810
 800  CONTINUE
      RMS_CHIR(2) = RMS_CHIR(2) + DELTA2
      ASIGMA_CHIR(2) = ASIGMA_CHIR(2) + RS_SDI
      N_CHIR_REST(2) = N_CHIR_REST(2) + 1
 810  CONTINUE
      SUMCHIR = SUMCHIR + WEIGHTL*DELTA2
      DO   IY=1,3
         DO   IX=1,3
            DVDX(IY,IX+1) = DVOLDE(IY,IX)
         ENDDO
         DVDX(IY,1) = -(DVDX(IY,2)+DVDX(IY,3)+DVDX(IY,4))
      ENDDO
c
c---  symmetry
      do ich=1,4
         is = is_t(1,ich)
         xyz_t1 = matmul(transpose(cs_frac_to_ort),dvdx(1:3,ich))
         xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
         dvdx(1:3,ich) = matmul(transpose(cs_ort_to_frac),xyz_t2)
      enddo
c
      DO   ICH=1,4
        IPOS_VEC = 3*IA1(ICH)-3
        CALL INCR_VECTOR(MAX_VEC,IPOS_VEC,VECT,DELTAW,DVDX(1,ICH))
        IPOS_MAT = 6*IA1(ICH)-6
        CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT,A_MAT,
     &                                         WEIGHTL,DVDX(1,ICH))
      ENDDO
C
C---  Non diagonal terms
      DO   IX=1,3
        DO  IY=IX+1,4
          NDIST1_SYMM(1) = 1
          NDIST1_SYMM(2) = 0
          NDIST1_SYMM(3) = 0
          NDIST1_SYMM(4) = 0
          CALL  FIND_RESTRAINT(MAX_DIST,NDIS,IDIST,IA_C(IX),IA_C(IY),
     &          NDIST1_SYMM,
     &          N_ATOM,NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
          IPOS_MAT = NMPOS + 9*(IDIST-1)
          IF(IMODE.EQ.0) THEN
C
C---When pair of IAs are equal. No plane through symmetry. Should be added
C
C
C---IA1 is target and IA2 is object
            CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT,A_MAT,WEIGHTL,
     &                                 DVDX(1,IX),DVDX(1,IY))
          ELSE
C
C---IA1 is object and IA2 is target
            CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT,A_MAT,WEIGHTL,
     &                                 DVDX(1,IY),DVDX(1,IX))
         ENDIF
        ENDDO
      ENDDO
      GOTO 10

 999  CONTINUE
C
C----Save for harvesting and reporting
      IF(N_CHIR_REST(1).GT.0) THEN
        HNRESTR = HNRESTR + 1
        RMS_CHIR(1) = SQRT(RMS_CHIR(1)/FLOAT(N_CHIR_REST(1)))
        ASIGMA_CHIR(1) = ASIGMA_CHIR(1)/FLOAT(N_CHIR_REST(1))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_CHIR(1)
        HRESTR_DEV(HNRESTR)     = RMS_CHIR(1)
        HRESTR_NUM(HNRESTR)     = N_CHIR_REST(1)
        HRESTR_TYPE(HNRESTR) = 'Chiral centres: refined atoms'
        HRESTR_CIF(HNRESTR) = 'r_chiral_restr'

      ENDIF
      IF(N_CHIR_REST(2).GT.0) THEN
        HNRESTR = HNRESTR + 1
        RMS_CHIR(2) = SQRT(RMS_CHIR(2)/FLOAT(N_CHIR_REST(2)))
        ASIGMA_CHIR(2) = ASIGMA_CHIR(2)/FLOAT(N_CHIR_REST(2))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_CHIR(2)
        HRESTR_DEV(HNRESTR)     = RMS_CHIR(2)
        HRESTR_NUM(HNRESTR)     = N_CHIR_REST(2)
        HRESTR_TYPE(HNRESTR) = 'Chiral centers: others'
        HRESTR_CIF(HNRESTR) = 'r_chiral_restr_other'
      ENDIF
      CLOSE(UNIT=ISCRC)
      ISCRC = 0

      RETURN
      END
C
      SUBROUTINE PLANE_REF(SUMPLAN,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &              N_TARGET,N_OBJECT,NSYM_DIST,
     &              NW_UVAL,NREST_PER_ATOM,REST_PER_ATOM)

C---This routine calculates derivatives of restraints corresponding to
C---planar groups. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'vitals.fh'
c
      INTEGER MAX_MAT,MAX_VEC,MAX_DIST,IW_UVAL
      REAL SUMPLAN
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),
     &        N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      REAL A_MAT(*),VECT(*)
C
C---  Local variables
      integer nr_plan,nmaxatom_plane
      INTEGER I,J,L,K,L1,K1,IPOS_MAT1,IPOS_VEC,IDIST,IMODE
      INTEGER ISCRP,IA_P(50),IA1(50),IA12(50),N_PLANE_REST(2),NPLANE,
     &        NPLANE1,IPL,LL,IFAIL,IERROR
      REAL    RS_VIDL,RS_SDI,XYZ_PLANE(3,50),VM(3),DPDX1(3),DPDX2(3),D,
     &        DVMDX(3,150),DDDX(3,50),
     &        RMS_PLANE(2),ASIGMA_PLANE(2),WEIGHTL,DELTA,DELTA2,DELTAW
      INTEGER NDIST1_SYMM(4)
      integer is_t(4,50)
      integer is
      real    tx(3)
      real    xyz_t1(3),xyz_t2(3)
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      SUMPLAN = 0.0
      RMS_PLANE(1) = 0.0
      ASIGMA_PLANE(1) = 0.0
      RMS_PLANE(2) = 0.0
      ASIGMA_PLANE(2) = 0.0
      N_PLANE_REST(1) = 0
      N_PLANE_REST(2) = 0
      IW_UVAL        = 5
      IF(PLANE_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscrp,plane_file,ifail)
      read(iscrp)nr_plan,nmaxatom_plane
 10   CONTINUE
      nplane = 0
      READ(ISCRP,END=999)NPLANE,RS_VIDL,RS_SDI,
     &     (IA_P(IPL),IPL=1,NPLANE),(is_t(1:4,i),i=1,nplane)
      IF(RS_SDI.LE.0.0) GOTO 10
      NPLANE1 = 0
      DO   IPL = 1,NPLANE
cd         IF(IA_P(IPL).LE.0) GOTO 10
cd         IF(ATOM_REF_FLAG(IA_P(IPL)).LE.0) GOTO 10
         IA1(IPL) = ATOM_REF_FLAG(IA_P(IPL))/10
         IA12(IPL) = ATOM_REF_FLAG(IA_P(IPL)) - IA1(IPL)*10
         IF(IA12(IPL).GT.0.AND.IA_P(IPL).GT.0) THEN
           NPLANE1 = NPLANE1 + 1
           IA_P(NPLANE1) = IA_P(IPL)
         ENDIF
      ENDDO
      IF(NPLANE1.LE.0) GOTO 10
      NPLANE = NPLANE1
      WEIGHTL = (WPSKAL/RS_SDI)**2
      xyz_plane(1:3,1:nplane) = xyz_crd(1:3,ia_p(1:nplane))
C
C---  symmetry
      do j=1,nplane
         is = is_t(1,j)
         tx(1:3) = float(is_t(2:4,j))
         xyz_t1 = matmul(cs_ort_to_frac,xyz_plane(1:3,j))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1)+
     &        cs_v_cs(1:3,is)+tx(1:3)
         xyz_plane(1:3,j) = matmul(cs_frac_to_ort,xyz_t2)
      enddo

      CALL PLANE_AND_DERIVS_R(NPLANE,XYZ_PLANE,VM,D,DVMDX,DDDX,IERROR)
C
cd      CALL PLANE_R(NPLANE,XYZ_PLANE,VM,D)
C
C---Calculate derivatives
      DO    J=1,NPLANE
        DELTA = D
        DO    I=1,3
          DELTA = DELTA - VM(I)*XYZ_PLANE(I,J)
        ENDDO
        DELTA2    = DELTA**2
        SUMPLAN   = SUMPLAN + 0.5*WEIGHTL*DELTA2
        IF(IA12(J).GT.2) THEN
          RMS_PLANE(1) = RMS_PLANE(1) + DELTA2
          ASIGMA_PLANE(1) = ASIGMA_PLANE(1) + RS_SDI
          N_PLANE_REST(1) = N_PLANE_REST(1) + 1
        ELSE
          RMS_PLANE(2) = RMS_PLANE(2) + DELTA2
          ASIGMA_PLANE(2) = ASIGMA_PLANE(2) + RS_SDI
          N_PLANE_REST(2) = N_PLANE_REST(2) + 1
        ENDIF
        DELTAW  = WEIGHTL*DELTA
        DPDX1(1) = VM(1)
        DPDX1(2) = VM(2)
        DPDX1(3) = VM(3)
        is = is_t(1,j)
        xyz_t1 = matmul(transpose(cs_frac_to_ort),dpdx1)
        xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
        dpdx1  = matmul(transpose(cs_ort_to_frac),xyz_t2)
c
c--   Symmetry
        IF(IA1(J).GT.0) THEN
          IPOS_VEC = 3*IA1(J)-3
          CALL INCR_VECTOR(MAX_VEC,IPOS_VEC,VECT,DELTAW,DPDX1)
cd          IPOS_MAT1 = 6*IA1(J) - 6
cd          CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
cd     &                    DPDX1)
        ENDIF
C
C---Now add second' derivatives
cd        GOTO 801
        DO  L=1,NPLANE
          L1 = 3*L-2
          IF(IA1(L).LE.0) GOTO 800
          IF(L.EQ.J) THEN
            DPDX1(1) = VM(1) + DVMDX(1,L1  )*XYZ_PLANE(1,J) +
     &                         DVMDX(2,L1  )*XYZ_PLANE(2,J) +
     &                         DVMDX(3,L1  )*XYZ_PLANE(3,J) -
     &                         DDDX(1,L)
            DPDX1(2) = VM(2) + DVMDX(1,L1+1)*XYZ_PLANE(1,J) +
     &                         DVMDX(2,L1+1)*XYZ_PLANE(2,J) +
     &                         DVMDX(3,L1+1)*XYZ_PLANE(3,J) -
     &                         DDDX(2,L)
            DPDX1(3) = VM(3) + DVMDX(1,L1+2)*XYZ_PLANE(1,J) +
     &                         DVMDX(2,L1+2)*XYZ_PLANE(2,J) +
     &                         DVMDX(3,L1+2)*XYZ_PLANE(3,J) -
     &                         DDDX(3,L)
          ELSE
            DPDX1(1) =         DVMDX(1,L1  )*XYZ_PLANE(1,J) +
     &                         DVMDX(2,L1  )*XYZ_PLANE(2,J) +
     &                         DVMDX(3,L1  )*XYZ_PLANE(3,J) -
     &                         DDDX(1,L)
            DPDX1(2) =         DVMDX(1,L1+1)*XYZ_PLANE(1,J) +
     &                         DVMDX(2,L1+1)*XYZ_PLANE(2,J) +
     &                         DVMDX(3,L1+1)*XYZ_PLANE(3,J) -
     &                         DDDX(2,L)
            DPDX1(3) =         DVMDX(1,L1+2)*XYZ_PLANE(1,J) +
     &                         DVMDX(2,L1+2)*XYZ_PLANE(2,J) +
     &                         DVMDX(3,L1+2)*XYZ_PLANE(3,J) -
     &                         DDDX(3,L)
          ENDIF
c
c---  Symmetry
          L1 = L1 + 3
          is = is_t(1,j)
          xyz_t1 = matmul(transpose(cs_frac_to_ort),dpdx1)
          xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
          dpdx1  = matmul(transpose(cs_ort_to_frac),xyz_t2)
          DO   K=L,NPLANE
            IF(IA1(K).LE.0) GOTO 700
            K1 = 3*K-2
            IF(K.EQ.J) THEN
              DPDX2(1) = VM(1) + DVMDX(1,K1  )*XYZ_PLANE(1,J) +
     &                           DVMDX(2,K1  )*XYZ_PLANE(2,J) +
     &                           DVMDX(3,K1  )*XYZ_PLANE(3,J) -
     &                           DDDX(1,K)
              DPDX2(2) = VM(2) + DVMDX(1,K1+1)*XYZ_PLANE(1,J) +
     &                           DVMDX(2,K1+1)*XYZ_PLANE(2,J) +
     &                           DVMDX(3,K1+1)*XYZ_PLANE(3,J) -
     &                           DDDX(2,K)
              DPDX2(3) = VM(3) + DVMDX(1,K1+2)*XYZ_PLANE(1,J) +
     &                           DVMDX(2,K1+2)*XYZ_PLANE(2,J) +
     &                           DVMDX(3,K1+2)*XYZ_PLANE(3,J) -
     &                           DDDX(3,K)
            ELSE
              DPDX2(1) =         DVMDX(1,K1  )*XYZ_PLANE(1,J) +
     &                           DVMDX(2,K1  )*XYZ_PLANE(2,J) +
     &                           DVMDX(3,K1  )*XYZ_PLANE(3,J) -
     &                           DDDX(1,K)
              DPDX2(2) =         DVMDX(1,K1+1)*XYZ_PLANE(1,J) +
     &                           DVMDX(2,K1+1)*XYZ_PLANE(2,J) +
     &                           DVMDX(3,K1+1)*XYZ_PLANE(3,J) -
     &                           DDDX(2,K)
              DPDX2(3) =         DVMDX(1,K1+2)*XYZ_PLANE(1,J) +
     &                           DVMDX(2,K1+2)*XYZ_PLANE(2,J) +
     &                           DVMDX(3,K1+2)*XYZ_PLANE(3,J) -
     &                           DDDX(3,K)
            ENDIF
c
c---  symmetry
            is = is_t(1,k)
            xyz_t1 = matmul(transpose(cs_frac_to_ort),dpdx2)
            xyz_t2 = matmul(transpose(cs_m_cs(1:3,1:3,is)),xyz_t1)
            dpdx2  = matmul(transpose(cs_ort_to_frac),xyz_t2)
            IF(K.EQ.L) THEN
              IPOS_MAT1 = 6*IA1(L) - 6
              CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
     &                    DPDX1)
            ELSE
              NDIST1_SYMM(1) = 1
              NDIST1_SYMM(2) = 0
              NDIST1_SYMM(3) = 0
              NDIST1_SYMM(4) = 0
              CALL FIND_RESTRAINT(MAX_DIST,NDIS,IDIST,IA_P(L),IA_P(K),
     &          NDIST1_SYMM,N_ATOM,
     &          NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
              IPOS_MAT1 = NMPOS + 9*(IDIST-1) 
C
C---When pair of IAs are equal
C

              CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
     &                                 DPDX1,DPDX2)
            ENDIF
 700        CONTINUE
          ENDDO
 800      CONTINUE
        ENDDO
 801    CONTINUE
      ENDDO
      GOTO 10
 999  CONTINUE
C
c---Save for harvesting and reporting
      IF(N_PLANE_REST(1).GT.0) THEN
        HNRESTR = HNRESTR + 1
        RMS_PLANE(1) = SQRT(RMS_PLANE(1)/FLOAT(N_PLANE_REST(1)))
        ASIGMA_PLANE(1) = ASIGMA_PLANE(1)/FLOAT(N_PLANE_REST(1))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_PLANE(1)
        HRESTR_DEV(HNRESTR)     = RMS_PLANE(1)
        HRESTR_NUM(HNRESTR)     = N_PLANE_REST(1)
        HRESTR_TYPE(HNRESTR) = 'Planar groups: refined atoms'
        HRESTR_CIF(HNRESTR) = 'r_gen_planes_refined'

      ENDIF
      IF(N_PLANE_REST(2).GT.0) THEN
        HNRESTR = HNRESTR + 1
        RMS_PLANE(2) = SQRT(RMS_PLANE(2)/FLOAT(N_PLANE_REST(2)))
        ASIGMA_PLANE(2) = ASIGMA_PLANE(2)/FLOAT(N_PLANE_REST(2))
        HRESTR_DEVITAR(HNRESTR) = ASIGMA_PLANE(2)
        HRESTR_DEV(HNRESTR)     = RMS_PLANE(2)
        HRESTR_NUM(HNRESTR)     = N_PLANE_REST(2)
        HRESTR_TYPE(HNRESTR) = 'Planar groups: others'
        HRESTR_CIF(HNRESTR) = 'r_gen_planes_other'
      ENDIF
      CLOSE(UNIT=ISCRP)
      ISCRP = 0
      RETURN
      END
C
      SUBROUTINE VDW_REF(SUMVDW,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &            N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL,
     &            NREST_PER_ATOM,REST_PER_ATOM)
C
C---This routine calculates derivatives of restraints corresponding to
C---bond distances. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'

      INTEGER MAX_MAT,MAX_VEC,MAX_DIST
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),
     &        N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      REAL SUMVDW
      REAL A_MAT(*),VECT(*)
C
C---Local variables
      integer nr_vdw
      INTEGER I,ISCRV,ITX(3),N_VDW_REST(2,12),IFIRST,II
      real    rs_tmp
      REAL    XYZ_TMP1(3),XYZ_TMP(3),RS_VIDL,RS_SDI,DBDX1(3),DBDX2(3)
      real    SMALL_BOND,RMS_VDW(2,12),ASIGMA_VDW(2,12)
      INTEGER J,IW_UVAL,LL,IFAIL,IA1,IA2,IA11,IA21,IA12,IA22,IVDW_TYPE
      integer IX,IPOS_VEC1,IPOS_VEC2,IPOS_MAT1,IPOS_MAT2,IDIST,IMODE
      integer ISYM1
      INTEGER NDIST1_SYMM(4)
      REAL WEIGHTL,BOND_C,DBOND,DBONDW,DBOND2
      INTEGER LENSTR
      CHARACTER SYMM_ATOMS_OR_NOT*10,NBOND_RESTR_NAME*30
      integer ir1,ir2
      character chnamp1*4,chnamp2*4
c
      EXTERNAL LENSTR
      LOGICAL ERROR
      DATA SMALL_BOND/0.01/
C
      IFIRST = 0
      SUMVDW = 0.0
      DO    I=1,12
        DO   J=1,2
          RMS_VDW(J,I) = 0.0
          ASIGMA_VDW(J,I) = 0.0
          N_VDW_REST(J,I) = 0
        ENDDO
      ENDDO
      IW_UVAL = 6
      IF(VDW_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscrv,vdw_file,ifail)
      read(iscrv)nr_vdw
 10   CONTINUE
      READ(ISCRV,END=999)IA1,IA2,RS_VIDL,rs_tmp,RS_SDI,
     &     ISYM1,ITX(1),ITX(2),
     &     ITX(3),IVDW_TYPE
      NDIST1_SYMM(1) = ISYM1
      NDIST1_SYMM(2) = ITX(1)
      NDIST1_SYMM(3) = ITX(2)
      NDIST1_SYMM(4) = ITX(3)
      IF(RS_SDI.LE.0.0) GOTO 10
      IF(IA1.LE.0.OR.IA2.LE.0) GOTO 10
      IF(ATOM_REF_FLAG(IA1).LE.0.OR.ATOM_REF_FLAG(IA2).LE.0) GOTO 10
c
      IA11 = ATOM_REF_FLAG(IA1)/10
      IA21 = ATOM_REF_FLAG(IA2)/10
      IA12 = ATOM_REF_FLAG(IA1) - 10*IA11
      IA22 = ATOM_REF_FLAG(IA2) - 10*IA21

      WEIGHTL = (WVSKAL/RS_SDI)**2
C
C---  Check if this bond is through symmetry. If yes apply symmetry.
      IF(ISYM1.GT.1.OR.ITX(1).NE.0.OR.ITX(2).NE.0.OR.ITX(3).NE.0) THEN
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA2),XYZ_TMP,ERROR)
         DO   I=1,3
            XYZ_TMP1(I) = RealSymmMatrx(I,1,ISYM1)*XYZ_TMP(1) +
     &           RealSymmMatrx(I,2,ISYM1)*XYZ_TMP(2) +
     &           RealSymmMatrx(I,3,ISYM1)*XYZ_TMP(3) +
     &           RealSymmMatrx(I,4,ISYM1) + FLOAT(ITX(I))
         ENDDO 
         CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)
      ELSE
         XYZ_TMP(1) = XYZ_CRD(1,IA2)
         XYZ_TMP(2) = XYZ_CRD(2,IA2)
         XYZ_TMP(3) = XYZ_CRD(3,IA2)
      ENDIF
C
C---Calculate derivative of the bond w.r.t. atomic parameters
      DBDX1(1) = XYZ_CRD(1,IA1)-XYZ_TMP(1)
      DBDX1(2) = XYZ_CRD(2,IA1)-XYZ_TMP(2)
      DBDX1(3) = XYZ_CRD(3,IA1)-XYZ_TMP(3)
C     
      BOND_C  = SQRT(DBDX1(1)**2+DBDX1(2)**2+DBDX1(3)**2)
      DBOND   = RS_VIDL-BOND_C
c     
c      IR1 = I_RESID(IA1)
c      IR2 = I_RESID(IA2)
c      call get_chain_namepdb(chnamp1,ir1)
c      call get_chain_namepdb(chnamp2,ir2)
c      if(chnamp1.eq.chnamp2) dbond = 0.0
      IF(DBOND.LT.0.0) GOTO 10

      DBOND2  = DBOND**2
      SUMVDW  = SUMVDW + 0.5*WEIGHTL*DBOND2
      IF(IA12.GT.2.AND.IA22.GT.2) THEN
         RMS_VDW(1,IVDW_TYPE) = RMS_VDW(1,IVDW_TYPE) + DBOND2
         ASIGMA_VDW(1,IVDW_TYPE) = ASIGMA_VDW(1,IVDW_TYPE) + RS_SDI
         N_VDW_REST(1,IVDW_TYPE) = N_VDW_REST(1,IVDW_TYPE) + 1
      ELSE
         RMS_VDW(2,IVDW_TYPE) = RMS_VDW(2,IVDW_TYPE) + DBOND2
         ASIGMA_VDW(2,IVDW_TYPE) = ASIGMA_VDW(2,IVDW_TYPE) + RS_SDI
         N_VDW_REST(2,IVDW_TYPE)   = N_VDW_REST(2,IVDW_TYPE) + 1
      ENDIF
      DBONDW  = WEIGHTL*DBOND
C
      DO  IX=1,3
         DBDX1(IX) =  DBDX1(IX)/AMAX1(SMALL_BOND,BOND_C)
         DBDX2(IX) = -DBDX1(IX)
      ENDDO
      IF(ISYM1.GT.1) THEN
        CALL MAT2VECT(3,3,CS_FRAC_TO_ORT,DBDX2,XYZ_TMP,ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(1,I,ISYM1)*XYZ_TMP(1) +
     &                  RealSymmMatrx(2,I,ISYM1)*XYZ_TMP(2) +
     &                  RealSymmMatrx(3,I,ISYM1)*XYZ_TMP(3) 
        ENDDO 
        CALL MAT2VECT(3,3,CS_ORT_TO_FRAC,XYZ_TMP1,DBDX2,ERROR)
      ENDIF
C
C---Increment vector elements
C
c---Instead of IA1 take reference to atomic number. It is necessary for
C---cases when atom should not be refined but present
C
C---If bond is through symmetry then it should also be processed. Only atom 
C---IA2 could be through symmetry.
      IPOS_VEC1 = 3*IA11-3
      IPOS_VEC2 = 3*IA21-3
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC1,VECT,DBONDW,DBDX1)
      CALL INCR_VECTOR(MAX_VEC,IPOS_VEC2,VECT,DBONDW,DBDX2)
C
C---Increment matrix elements. Atom blocks
      IPOS_MAT1 = 6*IA11 - 6
      IPOS_MAT2 = 6*IA21 - 6
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,DBDX1)
      CALL INCR_MATR_DIAGONAL(MAX_MAT,IPOS_MAT2,A_MAT,WEIGHTL,DBDX2)

C
C---Increment matrix elements. Distance block
C
C---Find out if this atom pair is present already in the list. In principle
C---all distances should be unique
      CALL FIND_RESTRAINT(MAX_DIST,NDIS,IDIST,IA1,IA2,NDIST1_SYMM,
     &          N_ATOM,
     &          NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
     &          NSYM_DIST,NW_UVAL,IW_UVAL,IMODE)
      IF(IA11.NE.IA21) THEN
C
C---If atoms are not same then

        IPOS_MAT1 = NMPOS + 9*(IDIST-1)
        IF(IMODE.EQ.0) THEN
C
C---IA1 is target and IA2 is object
          CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
     &                                 DBDX1,DBDX2)
        ELSE
C
C---IA1 is object and IA2 is target
          CALL INCR_MATR_NDIAG(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
     &                                 DBDX2,DBDX1)
        ENDIF
C
C---When pair of IAs are equal.
C
      ELSE
        IPOS_MAT1 = IA11*6 - 6
        IF(IMODE.EQ.0) THEN
          CALL INCR_MATR_DIAGONAL1(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
     &                                                    DBDX1,DBDX2)
        ELSE
          CALL INCR_MATR_DIAGONAL1(MAX_MAT,IPOS_MAT1,A_MAT,WEIGHTL,
     &                                                   DBDX2,DBDX1)
        ENDIF
      ENDIF
C
C---Report outliers if necessary
      CALL VDW_OUTLIERS(BOND_C,RS_VIDL,IA1,IA2,IVDW_TYPE,RS_SDI,BADVDW,
     &      BAD_CONT,MON_STYLE,ISYM1,ITX,IFIRST)
      GOTO 10
 999  CONTINUE
C
C---Save for harvesting and reporting
      DO    I=1,12
        IF(I.LE.6) THEN
          SYMM_ATOMS_OR_NOT = ' '
        ELSE
          SYMM_ATOMS_OR_NOT = ': symmetry'
        ENDIF
        II = I
        IF(II.GT.6) II = II-6
        IF(II.EQ.1) THEN
           NBOND_RESTR_NAME = 'VDW repulsions'
        ELSEIF(II.EQ.2) THEN
           NBOND_RESTR_NAME = 'VDW; torsion '
        ELSEIF(II.EQ.3) THEN
           NBOND_RESTR_NAME = 'HBOND '
        ELSEIF(II.EQ.4) THEN
           NBOND_RESTR_NAME = 'Metal-ion'
        else if(ii.eq.5) then
           nbond_restr_name = 'DUMMY_NORMAL'
        else if(ii.eq.6) then
           nbond_restr_name = 'DUMMY_DUMMY'
        ENDIF
        DO   J=1,2
          IF(N_VDW_REST(J,I).GT.0) THEN
             RMS_VDW(J,I)=SQRT(RMS_VDW(J,I)/FLOAT(N_VDW_REST(J,I)))
             ASIGMA_VDW(J,I) = ASIGMA_VDW(J,I)/FLOAT(N_VDW_REST(J,I))
             HNRESTR = HNRESTR + 1
             HRESTR_DEVITAR(HNRESTR) = ASIGMA_VDW(J,I)
             HRESTR_DEV(HNRESTR)     = RMS_VDW(J,I)
             HRESTR_NUM(HNRESTR)     = N_VDW_REST(J,I)
             IF(J.EQ.1) THEN
               IF(SYMM_ATOMS_OR_NOT(1:1).NE.' ') THEN
                 HRESTR_TYPE(HNRESTR) = 
     &             trim(NBOND_RESTR_NAME)//trim(SYMM_ATOMS_OR_NOT)//
     &                       ': refined_atoms'
               ELSE
                 HRESTR_TYPE(HNRESTR) = 
     &             trim(NBOND_RESTR_NAME)//': refined_atoms'
               ENDIF
             ELSE
               IF(SYMM_ATOMS_OR_NOT(1:1).NE.' ') THEN
                 HRESTR_TYPE(HNRESTR) =  
     &             trim(NBOND_RESTR_NAME)//trim(SYMM_ATOMS_OR_NOT)//
     &                       ': others'
               ELSE
                  HRESTR_TYPE(HNRESTR) =  
     &                 trim(NBOND_RESTR_NAME)//'.others'
               ENDIF
             ENDIF
             IF(HRESTR_TYPE(HNRESTR).EQ.
     &         'VDW repulsions: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_nbd_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'VDW repulsions: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_nbd_other'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'VDW; torsion: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_nbtor_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'VDW: torsion: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_nbtor_other'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'HBOND: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_xyhbond_nbd_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'HBOND: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_xyhbond_nbd_other'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'Metal-ion: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_metal_ion_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'Metal-ion: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_metal_ion_other'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'VDW repulsions: symmetry: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_symmetry_vdw_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'VDW repulsions: symmetry: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_symmetry_vdw_other'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'HBOND; symmetry: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_symmetry_hbond_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'HBOND: symmetry: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_symmetry_hbond_other'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'Metal-ion: symmetry: refined atoms')THEN
               HRESTR_CIF(HNRESTR) = 'r_symmetry_metal_ion_refined'
             ELSEIF(HRESTR_TYPE(HNRESTR).EQ.
     &         'Metal-ion; symmetry: others')THEN
               HRESTR_CIF(HNRESTR) = 'r_symmetry_metal_ion_other'
            else if(hrestr_type(hnrestr).eq.
     &              'DUMMY_NORMAL: refined atoms') then
               hrestr_cif(hnrestr) = 'r_dummy_normal_nbd_refined'
            else if(hrestr_type(hnrestr).eq.
     &              'DUMMY_NORMAL: symmetry: refined atoms') then
               hrestr_cif(hnrestr) = 
     &              'r_symmetry_dummy_normal_nbd_refined'
            else if(hrestr_type(hnrestr).eq.
     &              'DUMMY_DUMMY: refined atoms') then
               hrestr_cif(hnrestr) = 'r_dummy_dummy_nbd_refined'
            else if(hrestr_type(hnrestr).eq.
     &              'DUMMY_DUMMY: symmetry: refined atoms') then
               hrestr_cif(hnrestr) = 
     &              'r_symmetry_dummy_dummy_nbd_refined'
             ENDIF
          ENDIF
        ENDDO
      ENDDO
      CLOSE(ISCRV)
      ISCRV = 0
      RETURN
      END
C
      SUBROUTINE VDW_OUTLIERS(BOND_C,RS_VIDL,IA1,IA2,IVDW_TYPE,RS_SDI,
     &            BADVDW,BAD_CONT,MON_STYLE,ISYM1,ITX,IFIRST)
C
c----Reports VDW outliers.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'

      INTEGER IVDW_TYPE,IFIRST,ISYM1
      INTEGER ITX(3)
      REAL BOND_C,RS_VIDL,BADVDW,RS_SDI,BAD_CONT
      CHARACTER MON_STYLE*(*)
C
      INTEGER IR1,IR2,IA1,IA2
      REAL DBOND
      CHARACTER LINE*180
      character chnamp1*4,chnamp2*4
C
      IF(MON_STYLE.EQ.'NONE'.OR.MON_STYLE.EQ.'FEW') RETURN
C
      DBOND = BOND_C-RS_VIDL
      IF(ABS(DBOND).GT.BADVDW*RS_SDI.OR.BOND_C.LE.BAD_CONT) THEN
C
C----Report
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('VDW outliers')
          WRITE(LINE,'(A,F6.3,A,F6.3,A)')'VDW deviations from the'//
     &      ' ideal >',BADVDW,'Sigma or dist < ',BAD_CONT,
     &      ' will be monitored'
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          IFIRST  = 1
        ENDIF
        IR1 = I_RESID(IA1)
        IR2 = I_RESID(IA2)
        call get_chain_namepdb(chnamp1,ir1)
        call get_chain_namepdb(chnamp2,ir2)
        WRITE(LINE,'(12A,F6.3,A,F6.3,A,F6.2,A,F5.2,A,4I3,A,I3)')
     &       chnamp1,RES_NUM_PDB(IR1)(3:7),
     &       RES_NAME(IR1)(1:4),
     &       ATM_NAME(IA1)(1:4),ID_ALT(IA1),' - ',
     &       chnamp2,RES_NUM_PDB(IR2)(3:7),
     &       RES_NAME(IR2)(1:4),
     &       ATM_NAME(IA2)(1:4),ID_ALT(IA2),
     &       ' mod.=',BOND_C,' id.=',RS_VIDL,
     &       ' dev=',DBOND,' sig.=',RS_SDI,' sym.=',
     &       ISYM1,ITX,' type =',ivdw_type
        CALL ERRWRT(-1,LINE)
      ENDIF        
      RETURN
      END
C
      SUBROUTINE BREF(SUMBR,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &            N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL)
C
C-----Subroutine puts restraints on U values between bonded atoms.
C-----Only covalent bonds, angle, and 1-4 planar bond have been taken 
C-----into account.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'pls_incl.fh'
C
      REAL  A_MAT(*),VECT(*)
      REAL SUMBR
      INTEGER N_TARGET(*),N_OBJECT(*),NW_UVAL(*),NSYM_DIST(4,*)
      INTEGER MAX_DIST,MAX_MAT,MAX_VEC
c      
      INTEGER N_BVAL_REST(2,4),I,J,NCLASS,IANISO1,LD,L1,ID,
     &        IT,IO,IT1,IO1,IT11,IO11,LOV,LOM,LTV,LTM,IPOSMT,IPOSMO
      INTEGER ISYM,IPOS,IANISO,IPOSM,IWT,L2,IFIRST,IAN,JAN
      integer ndist
      real    d,s
      REAL  WWTT(8),RRCONV(6,6),RRCONV1(6,6),RRCONV2(6,6),RRCONV3(6,6)
      REAL  DEL_ANISO(6)
      REAL  DEL_ANISO1(6),U_ORT(6),U_ORT1(6),U_ORT2(6),U_ORT3(6)
      REAL  RCONV_ISOANISO(6),RCONV_ISOANISO1(6),RMS_B(2,4)
      REAL  ASIGMA_B(2,4),DELB,DELB2,SUMW,WTT,SIGMA_B,WTT3
      LOGICAL ERROR
      CHARACTER SIDE_OR_MAINO*1,SIDE_OR_MAINT*1
      integer is,ierror,im
c
      integer, allocatable :: lposv(:)
      integer, allocatable :: lposm(:)
c
      real ro_unit(3,3),rfr_unit(3,3)
      real uucell2orth(6,6),uuorth2cell(6,6)
      real realsymm_aniso(6,6,192)
c
c---  body
      call nb_frorth(cs_cell(1),cs_cell(2),cs_cell(3),cs_cell(4),
     &     cs_cell(5),cs_cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call calc_unit_frac(cs_frac_to_ort,cs_cell,ro_unit)     
      call matinv3_r(ro_unit,rfr_unit)
      call find_conv_matrix(ro_unit,uucell2orth)
      call find_conv_matrix(rfr_unit,uuorth2cell)
      do  is=1,nsym
        call find_conv_matrix(cs_m_cs(1,1,is),realsymm_aniso(1,1,is))
      enddo
c
c---  Initialize
      im=1
      allocate(lposv(n_atom))
      allocate(lposm(n_atom))
c
c---body
C>IJT Work-around bug causing restraints to be mis-counted.
C      S = 0.
      DO ID = 1,NDIS
        IF (NW_UVAL(ID).EQ.1) THEN
          IO = N_OBJECT(ID)
          IT = N_TARGET(ID)
C
C-IJT Test for angle distance, if so exit loop.
          D=0.
          DO J=1,3
            D=D+(XYZ_CRD_mod(J,IT,im)-XYZ_CRD_mod(J,IO,im))**2
          ENDDO
C          S = MAX(S,D)
          IF (D.GT.5.76) GOTO 10
C          PRINT '(I6,2I4,2(2X,3(2X,A)),F8.3)',ID,NW_UVAL(ID),
C     &    NSYM_DIST(1,ID),ATM_NAME(IO),RES_NAME_PDB(I_RESID(IO)),
C     &    RES_NUM_PDB(I_RESID(IO)),ATM_NAME(IT),
C     &    RES_NAME_PDB(I_RESID(IT)),RES_NUM_PDB(I_RESID(IT)),SQRT(D)
        ENDIF
      ENDDO
C
C-IJT Reset distance count.
10    NDIST=ID-1
C      PRINT '(/A,F8.3)','Dmax:',SQRT(S)
C<IJT
  
      SUMBR = 0.0
C
C---  Set the distance weighting scheme and initialise statistics
      IFIRST = 0
      DO   I=1,4
         DO   J=1,2
            N_BVAL_REST(J,I) = 0
            ASIGMA_B(J,I)    = 0.0
            RMS_B(J,I)       = 0.0
         ENDDO
      ENDDO
      NCLASS = 4
      SUMW   = 0.0
      DO    IWT=1,NCLASS
         WWTT(IWT) = 0.0
         IF(SIGB(IWT).NE.0.0) THEN
            WWTT(IWT) = WBSKAL/SIGB(IWT)*PISQ8
         ENDIF
      ENDDO
C
C----Find positions for gradient and diagonal of second derivative matrix
C----It is important if we are using mixed refinement (i.e. some atoms
C----have isotropic U value some anisotropic)
      CALL FIND_POS_OF_U(maxATOM,N_ATOM_mod,ATOM_REF_mod_FLAG,
     &     U_ANISO_mod,LPOSV,LPOSM,1)
C
C----Find conversion matrices for second derivative matrix. RRCONV
C----is for aniso-aniso atoms, RCONV_ISOANISO is for iso-aniso type
C----distances
      DO    IANISO=1,6
         DO   IANISO1=1,6
            RRCONV(IANISO,IANISO1) = 0.0
         ENDDO
      ENDDO
      DO   IANISO=1,3
         RRCONV(IANISO,IANISO)  = 1.0
         RCONV_ISOANISO(IANISO) = 1.0
      ENDDO
      DO   IANISO=4,6
         RRCONV(IANISO,IANISO)  = 2.0
         RCONV_ISOANISO(IANISO) = 0.0
      ENDDO
C
C----Cycle over distances for which B-value restraints are to be used
      LD = 1
      L1 = 0
      L2 = NMTMP
c     d      STOP
c     d      IF(NDIS.LE.0) STOP
      DO     ID=1,NDIST
         IO    = N_OBJECT(ID)
         IT    = N_TARGET(ID)
         ISYM  = NSYM_DIST(1,ID)
         IF(NW_UVAL(ID).GT.0.AND.NW_UVAL(ID).LE.2) THEN
            IO1   = ATOM_REF_mod_FLAG(IO,im)/10
            IT1   = ATOM_REF_mod_FLAG(IT,im)/10
            IO11  = ATOM_REF_mod_FLAG(IO,im)-IO1*10
            IT11  = ATOM_REF_mod_FLAG(IT,im)-IT1*10
cd          IF(IO11.LE.0.OR.IT11.LE.0) GOTO 100
            CALL CHECK_SIDE_OR_MAIN(ATM_NAME(IO),SIDE_OR_MAINO)
            CALL CHECK_SIDE_OR_MAIN(ATM_NAME(IT),SIDE_OR_MAINT)
C
C---Atoms can be related through symmetry. Remember that. Check NSYM_DIST
C
            IWT  = NW_UVAL(ID)
            IF(SIDE_OR_MAINO.EQ.'S'.AND.SIDE_OR_MAINT.EQ.'S') IWT=IWT+2
cd          IF(IWT.LE.0.OR.IWT.GT.4) GO TO 100
            SIGMA_B = ABS(SIGB(IWT))
            WTT3    = max(WWTT(IWT),0.0)**2
            WTT     = WTT3/3.0
C     
            LOV   = LPOSV(IO1)
            LTV   = LPOSV(IT1)
            LOM   = LPOSM(IO1)
            LTM   = LPOSM(IT1)
            DELB2 = 0.0
C
            IF(U_ANISO_mod(2,IO,im).LE.0.0 .AND.
     &         U_ANISO_mod(2,IT,im).LE.0.0) THEN
C
C----Case 1: both atoms have isotropic U_value
C----Calculate delta U
               DELB       = U_ANISO_mod(1,IO,im) - U_ANISO_mod(1,IT,im)
               DELB2      = DELB*DELB
C
C----Increment the on-diagonal matrix elements
               A_MAT(L1+LOM) = A_MAT(L1+LOM) + WTT3
               A_MAT(L1+LTM) = A_MAT(L1+LTM) + WTT3
C
C----Increment the off-diagonal matrix elements. Atoms are different
               IF(IO.NE.IT) THEN
                  A_MAT(L2+LD)  = A_MAT(L2+LD) - WTT3
                  LD            = LD + 1
               ELSE
C---Atoms are same. Increment LD in any case. In principle in this case no
C---derivatives are involved as difference is always 0.
                  A_MAT(L1+LOM) = A_MAT(L1+LOM) - 2.0*WTT3
                  LD           = LD + 1
               ENDIF
C
C----Increment the vector elements
               VECT(LOV) = VECT(LOV) - DELB*WTT3
               VECT(LTV) = VECT(LTV) + DELB*WTT3
            ELSEIF(U_ANISO_mod(2,IO,im).LE.0.0 .AND.
     &             U_ANISO_mod(2,IT,im).GT.0.0) THEN
C
C----Case 2: atom IO is isotropic and atom IT is anisotropic
C
C---Atoms cannot be same with different B value styles.
               IF(IO.EQ.IT) THEN
                  CALL ERRWRT(-1,'Programming error ')
                  CALL ERRWRT(-1,'Same atom has different B values')
                  CALL ERRWRT(1,
     &                 'Find the error causing it. It is a bug')
               ENDIF
C
               DO   IANISO = 1,6
                  U_ORT(IANISO) = U_ANISO_mod(IANISO,IT,im)
               ENDDO
C---Symmetry should be taken into account. 
               IF(ISYM.GT.1) THEN
                  CALL MAT2VECT(6,6,UUORTH2CELL,U_ORT,U_ORT2,ERROR)
                  CALL MAT2VECT(6,6,RealSymm_Aniso(1,1,ISYM),U_ORT2,
     &                 U_ORT1,ERROR)
                  CALL MAT2VECT(6,6,UUCELL2ORTH,U_ORT1,U_ORT,ERROR)
               ENDIF
               DO    IANISO=1,3
                 DEL_ANISO(IANISO) = U_ANISO_mod(1,IO,im)-U_ORT(IANISO)
                 DEL_ANISO(IANISO+3) = -2.0*U_ORT(IANISO+3)
                 DELB2  = DELB2 + (DEL_ANISO(IANISO)**2 
     +                 + DEL_ANISO(IANISO+3)**2/2.0)/3.0
               ENDDO
C
C---Convert DEL_ANISO via symmetry.
               IF(ISYM.GT.1) THEN
                  CALL MAT2VEC(6,6,UUCELL2ORTH,DEL_ANISO,U_ORT1,ERROR)   
                  CALL MAT2VEC(6,6,RealSymm_Aniso(1,1,ISYM),U_ORT1,
     &                 U_ORT2,ERROR)  
                  CALL MAT2VEC(6,6,UUORTH2CELL,U_ORT2,DEL_ANISO1,
     &                 ERROR) 
C
C---Non-diagonal terms
                  CALL MAT2VEC(6,6,UUCELL2ORTH,RCONV_ISOANISO,
     &                 U_ORT1,ERROR)
                  CALL MAT2VEC(6,6,RealSymm_Aniso(1,1,ISYM),
     &                 U_ORT1,U_ORT2,ERROR)
                  CALL MAT2VEC(6,6,UUORTH2CELL,U_ORT2,
     &                 RCONV_ISOANISO1,ERROR) 
C
C---Same for the second derivatives. Multiplication should be from 
C---both sides.    
                  CALL MAT2MAT(6,6,UUCELL2ORTH,RRCONV,RRCONV2,ERROR)
                  CALL MAT2MATT(6,6,RRCONV2,UUCELL2ORTH,RRCONV1,ERROR)
                  CALL MAT2MAT(6,6,RealSymm_Aniso(1,1,ISYM),RRCONV1,
     &                 RRCONV2,ERROR)
                  CALL MAT2MATT(6,6,RRCONV2,RealSymm_Aniso(1,1,ISYM),
     &                 RRCONV1,ERROR)
                  CALL MAT2MAT(6,6,UUORTH2CELL,RRCONV1,RRCONV2,ERROR)
                  CALL MAT2MATT(6,6,RRCONV2,UUORTH2CELL,RRCONV1,ERROR)
               ELSE
                  DO  IAN=1,6
                     DEL_ANISO1(IAN) = DEL_ANISO(IAN)
                     DO  JAN =1,6
                        RRCONV1(IAN,JAN) = RRCONV(IAN,JAN)
                     ENDDO
                  ENDDO
               ENDIF
C
C----Increment on diagonal terms
               A_MAT(L1+LOM) = A_MAT(L1+LOM) + WTT3
               IPOSM = L1 + LTM - 1
               DO    IANISO = 1,6
                  IPOSM     = IPOSM + 1
                  A_MAT(IPOSM) = A_MAT(IPOSM) + 
     &                 WTT*RRCONV1(IANISO,IANISO)
               ENDDO
               DO    IANISO=1,5
                  DO    IANISO1=IANISO+1,6
                     IPOSM     = IPOSM + 1
                     A_MAT(IPOSM) = A_MAT(IPOSM)+
     &                    WTT*RRCONV1(IANISO,IANISO1)
                  ENDDO
               ENDDO
C     
C---  Increment  off diagonal terms.
               DO    IANISO=1,6
                  A_MAT(L2+LD) = A_MAT(L2+LD) - WTT*
     &                 RCONV_ISOANISO1(IANISO)
                  LD        = LD + 1
               ENDDO
C     
C-----Increment vector elements
               VECT(LOV) = VECT(LOV) - WTT*(DEL_ANISO(1) + 
     +              DEL_ANISO(2) + DEL_ANISO(3))
               DO   IANISO=1,6
                  IPOS    = LTV + IANISO -1
                  VECT(IPOS) = VECT(IPOS) + WTT*DEL_ANISO1(IANISO)
               ENDDO
            ELSEIF(U_ANISO_mod(2,IO,im).GT.0.0 .AND.
     &             U_ANISO_mod(2,IT,im).LE.0.0) THEN
C
C---- Case 3: atom IO is anisotropic and atom IT is isotropic
C     
C---  Atoms can not have different B value styles and be same.
               IF(IO.EQ.IT) THEN
                  CALL ERRWRT(-1,'Programming error ')
                  CALL ERRWRT(-1,'Same atom has different B values')
                  CALL ERRWRT(1,
     &                 'Find the error causing it. It is a bug')
               ENDIF
C
C---  No symmetry is needed. Always second element is multiplied by symmetry.
C---  
               DO   IANISO = 1,6
                  U_ORT(IANISO) = U_ANISO_mod(IANISO,IO,im)
               ENDDO
               DO    IANISO=1,3
                  DEL_ANISO(IANISO) = U_ORT(IANISO)-U_ANISO_mod(1,IT,im)
                  DEL_ANISO(IANISO+3) =  2.0*U_ORT(IANISO+3)
                  DELB2               = DELB2 + (DEL_ANISO(IANISO)**2
     +                 + DEL_ANISO(IANISO+3)**2/2.0)/3.0
               ENDDO
C
C----Increment on diagonal terms
               A_MAT(L1+LTM) = A_MAT(L1+LTM) + WTT3
               IPOSM = L1 + LOM - 1
               DO    IANISO = 1,6
                  IPOSM        = IPOSM + 1
                  A_MAT(IPOSM) = A_MAT(IPOSM) + 
     &                 WTT*RRCONV(IANISO,IANISO)
               ENDDO
               DO    IANISO=1,5
                  DO    IANISO1=IANISO+1,6
                     IPOSM     = IPOSM + 1
                     A_MAT(IPOSM) = A_MAT(IPOSM)+
     &                    WTT*RRCONV(IANISO,IANISO1)
                  ENDDO
               ENDDO
C
C---Increment non-diagonal terms
               DO    IANISO=1,6
                  A_MAT(L2+LD) = A_MAT(L2+LD) - 
     &                 WTT*RCONV_ISOANISO(IANISO)
                  LD        = LD + 1
               ENDDO
C     
C---  Increment vector elements
C     
C---  Convert derivatives to cell system
               VECT(LTV) = VECT(LTV) + WTT*(DEL_ANISO(1) + 
     +              DEL_ANISO(2) + DEL_ANISO(3))
               DO   IANISO=1,6
                  IPOS       = LOV + IANISO -1
                  VECT(IPOS) = VECT(IPOS) - WTT*DEL_ANISO(IANISO)
               ENDDO
            ELSEIF(U_ANISO_mod(2,IO,im).GT.0.0 .AND.
     &             U_ANISO_mod(2,IT,im).GT.0.0) THEN
C
C----Case 4: both atoms are anisotropic
               DO   IANISO = 1,6
                  U_ORT (IANISO) = U_ANISO_mod(IANISO,IO,im)
                  U_ORT1(IANISO) = U_ANISO_mod(IANISO,IT,im)
               ENDDO
               IF(ISYM.GT.1) THEN
                  CALL MAT2VECT(6,6,UUORTH2CELL,U_ORT1,U_ORT2,ERROR)
                  CALL MAT2VECT(6,6,RealSymm_Aniso(1,1,ISYM),U_ORT2,
     &                 U_ORT3,ERROR)
                  CALL MAT2VECT(6,6,UUCELL2ORTH,U_ORT3,U_ORT1,ERROR)
               ENDIF
               DO    IANISO=1,3
                  DEL_ANISO(IANISO)   = 
     &                 (U_ORT(IANISO)   - U_ORT1(IANISO))
                  DEL_ANISO(IANISO+3) = 
     +                 2.0*(U_ORT(IANISO+3) - U_ORT1(IANISO+3))
                  DELB2  = DELB2 + 
     +                 (DEL_ANISO(IANISO)**2+
     &                 DEL_ANISO(IANISO+3)**2/2.0)/3.0
               ENDDO
               IF(ISYM.GT.1) THEN
C     
                  CALL MAT2VEC(6,6,UUCELL2ORTH,DEL_ANISO,U_ORT1,ERROR)
                  CALL MAT2VEC(6,6,RealSymm_Aniso(1,1,ISYM),U_ORT1,
     &                 U_ORT2,ERROR)
                  CALL MAT2VEC(6,6,UUORTH2CELL,U_ORT2,DEL_ANISO1,ERROR)
C
C---  Second derivatives. Both sides are multiplied
                  CALL MAT2MAT(6,6,UUORTH2CELL,RRCONV,RRCONV1,ERROR)
                  CALL MAT2MATT(6,6,UUORTH2CELL,RRCONV1,RRCONV2,ERROR)
                  CALL MAT2MAT(6,6,RealSymm_Aniso(1,1,ISYM),RRCONV2,
     &                 RRCONV1,ERROR)
                  CALL MAT2MATT(6,6,RealSymm_ANISO(1,1,ISYM),RRCONV1,
     &                 RRCONV2,ERROR)
                  CALL MAT2MAT(6,6,UUCELL2ORTH,RRCONV1,RRCONV2,ERROR)
                  CALL MAT2MATT(6,6,UUCELL2ORTH,RRCONV2,RRCONV1,ERROR)
C
c---  Second derivatives for non-diag terms. One side only. Left side???
                  CALL MAT2MAT(6,6,UUORTH2CELL,RRCONV,RRCONV2,ERROR)
                  CALL MAT2MAT(6,6,RealSymm_Aniso(1,1,ISYM),RRCONV2,
     &                 RRCONV3,ERROR)
                  CALL MAT2MAT(6,6,UUCELL2ORTH,RRCONV3,RRCONV2,ERROR)
               ELSE
                  DO   IAN=1,6
                     DEL_ANISO1(IAN) = DEL_ANISO(IAN)
                     DO   JAN=1,6
                        RRCONV1(JAN,IAN) = RRCONV(IAN,JAN)
                        RRCONV2(JAN,IAN) = RRCONV(IAN,JAN)
                     ENDDO
                  ENDDO
               ENDIF
C
C---  Now for derivatives

C
C---  Increment diagonal terms
               IPOSMO =  L1 + LOM - 1
               IPOSMT =  L1 + LTM - 1
               DO    IANISO = 1,6
                  IPOSMO     = IPOSMO + 1
                  IPOSMT     = IPOSMT + 1
                  A_MAT(IPOSMO) = A_MAT(IPOSMO)+
     &                 WTT*RRCONV(IANISO,IANISO)
                  A_MAT(IPOSMT) = A_MAT(IPOSMT)+
     &                 WTT*RRCONV1(IANISO,IANISO)
               ENDDO
               DO    IANISO=1,5
                  DO    IANISO1=IANISO+1,6
                     IPOSMO     = IPOSMO + 1
                     IPOSMT     = IPOSMT + 1
                     A_MAT(IPOSMO)=A_MAT(IPOSMO)+
     &                    WTT*RRCONV(IANISO,IANISO1)
                     A_MAT(IPOSMT)=A_MAT(IPOSMT)+
     &                    WTT*RRCONV1(IANISO,IANISO1)
                  ENDDO
               ENDDO
C
C---- Increment non diagonal terms
C     
C---  If atoms are different
C
               IF(IO.NE.IT) THEN
                  DO    IANISO=1,6
                     DO    IANISO1=1,6
                        A_MAT(L2+LD)=A_MAT(L2+LD)-
     &                       WTT*RRCONV2(IANISO,IANISO1)
                        LD        = LD + 1
                     ENDDO
                  ENDDO
               ELSE
C     
C---  Increment diagonal terms
C     
                  IPOSMO =  L1 + LOM - 1
                  DO    IANISO = 1,6
                     IPOSMO     = IPOSMO + 1
                     A_MAT(IPOSMO) = A_MAT(IPOSMO)-
     &                    2.0*WTT*RRCONV(IANISO,IANISO)
                  ENDDO
                  DO    IANISO=1,5
                     DO    IANISO1=IANISO+1,6
                        IPOSMO     = IPOSMO + 1
                        A_MAT(IPOSMO)=A_MAT(IPOSMO)-WTT*
     &                       (RRCONV2(IANISO,IANISO1) + 
     &                       RRCONV2(IANISO1,IANISO))
                     ENDDO
                  ENDDO
                  LD = LD + 36
               ENDIF
C
C-----Increment vector elements
               DO   IANISO=1,6
                  IPOS       = LOV + IANISO - 1
                  VECT(IPOS) = VECT(IPOS) - 
     &                 WTT*DEL_ANISO(IANISO)
                  IPOS       = LTV + IANISO - 1
                  VECT(IPOS) = VECT(IPOS) + 
     &                 WTT*DEL_ANISO1(IANISO)
               ENDDO
            ENDIF
C
C---- Compile statistics
            SUMW      = SUMW      + WTT*DELB2
            IF(IO11.GT.2.AND.IT11.GT.2) THEN
               RMS_B(1,IWT) = RMS_B(1,IWT) + DELB2
               N_BVAL_REST(1,IWT) = N_BVAL_REST(1,IWT) + 1
               ASIGMA_B(1,IWT)    = ASIGMA_B(1,IWT) + SIGMA_B
            ELSE
               RMS_B(2,IWT)       = RMS_B(2,IWT) + DELB2
               N_BVAL_REST(2,IWT) = N_BVAL_REST(2,IWT) + 1
               ASIGMA_B(2,IWT)    = ASIGMA_B(2,IWT) + SIGMA_B
            ENDIF
C     
C---  Report outliers if necessary
            SUMBR = SUMBR + WTT3*DELB2
            IF(MON_STYLE.NE.'NONE'.AND.MON_STYLE.NE.'FEW') 
     &           CALL BFAC_OUTLIER(IFIRST,IO,IT,IWT,
     &           U_ANISO_mod(1,IO,im),U_ANISO_mod(1,IT,im))
         ELSE
            IF(U_ANISO_mod(2,IO,im).LE.0.0 .AND.
     &         U_ANISO_mod(2,IT,im).LE.0.0) THEN
               LD = LD + 1
            ELSEIF(U_ANISO_mod(2,IO,im).GT.0.0 .AND.
     &             U_ANISO_mod(2,IT,im).GT.0.0) THEN
               LD = LD + 36
            ELSE
               LD = LD + 6
            ENDIF
         ENDIF
 100     CONTINUE
      ENDDO
cd      STOP
C
C----Save for harvesting and reporting
      DO   I=1,4
        DO   J=1,2
          IF(N_BVAL_REST(J,I).GT.0) THEN
            RMS_B(J,I) = SQRT(RMS_B(J,I)/N_BVAL_REST(J,I))* PISQ8
            ASIGMA_B(J,I) = ASIGMA_B(J,I)/N_BVAL_REST(J,I)
            HNRESTR = HNRESTR + 1

             HRESTR_DEVITAR(HNRESTR) = ASIGMA_B(J,I)
             HRESTR_DEV(HNRESTR)     = RMS_B(J,I)
             HRESTR_NUM(HNRESTR)     = N_BVAL_REST(J,I)
             IF(I.EQ.1) THEN
               IF(J.EQ.1) THEN
                 HRESTR_TYPE(HNRESTR) = 
     &             'M. chain bond B values: refined atoms'
                 HRESTR_CIF(HNRESTR) = 'r_mcbond_it'
               ELSE
                 HRESTR_TYPE(HNRESTR) = 'M. chain bond B values: others'
                 HRESTR_CIF(HNRESTR) = 'r_mcbond_other'
               ENDIF
             ELSEIF(I.EQ.2) THEN
               IF(J.EQ.1) THEN
                 HRESTR_TYPE(HNRESTR) = 
     &            'M. chain angle B values: refined atoms'
                 HRESTR_CIF(HNRESTR) = 'r_mcangle_it'
               ELSE
                HRESTR_TYPE(HNRESTR) = 'M. chain angle B values: others'
                 HRESTR_CIF(HNRESTR) = 'r_mcangle_other'
               ENDIF
             ELSEIF(I.EQ.3) THEN
               IF(J.EQ.1) THEN
                 HRESTR_TYPE(HNRESTR) = 
     &             'S. chain bond B values: refined atoms'
                 HRESTR_CIF(HNRESTR) = 'r_scbond_it'
               ELSE
                 HRESTR_TYPE(HNRESTR) = 'S. chain bond B values: others'
                 HRESTR_CIF(HNRESTR) = 'r_scbond_other'
               ENDIF
             ELSEIF(I.EQ.4) THEN
               IF(J.EQ.1) THEN
                 HRESTR_TYPE(HNRESTR) = 
     &            'S. chain angle B values: refined atoms'
                 HRESTR_CIF(HNRESTR) = 'r_scangle_it'
               ELSE
                HRESTR_TYPE(HNRESTR) = 'S. chain angle B values: others'
                 HRESTR_CIF(HNRESTR) = 'r_scangle_other'
               ENDIF
             ENDIF
          ENDIF
        ENDDO
      ENDDO
C
      deallocate(lposv)
      deallocate(lposm)
      RETURN
      END
C
      SUBROUTINE BFAC_OUTLIER(IFIRST,IO,IT,IWT,U1,U2)
C---Reports outlier for B-value restraints.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      INTEGER IFIRST,IO,IT,IWT
      REAL    U1(6),U2(6)
c
C---Local variables
      INTEGER IR1,IR2
      REAL DELB,DEL_A(6)
      REAL SIGMA_B
      CHARACTER LINE*132,ALT2CH*1
      character chnamp1*4,chnamp2*4
C
      IF(IWT.GT.4.OR.IWT.LE.0) RETURN
      IF(SIGB(IWT).EQ.0.0) RETURN
      SIGMA_B = ABS(SIGB(IWT))
c
C---First calculate difference between B-values U1 and U2 (they are assummed
C---to be as U values)
      IF(U1(2).EQ.0.0.AND.U2(2).EQ.0.0) THEN
c
C---Both atoms are isotropic. 
        DELB = ABS(U1(1)-U2(1))
      ELSEIF(U1(2).EQ.0.0.AND.U2(2).NE.0.0) THEN
        DEL_A(1) = U1(1)-U2(1)
        DEL_A(2) = U1(1)-U2(2)
        DEL_A(3) = U1(1)-U2(3)
        DEL_A(4) =      -U2(4)
        DEL_A(5) =      -U2(5)
        DEL_A(6) =      -U2(6)
        DELB = SQRT((DEL_A(1)**2+DEL_A(2)**2+DEL_A(3)**2+
     &          2.0*(DEL_A(4)**2+DEL_A(5)**2+DEL_A(6)**2))/3.0)
      ELSEIF(U1(2).NE.0.0.AND.U2(2).EQ.0.0) THEN
        DEL_A(1) = U1(1)-U2(1)
        DEL_A(2) = U1(2)-U2(1)
        DEL_A(3) = U1(3)-U2(1)
        DEL_A(4) = U1(4)
        DEL_A(5) = U1(5)
        DEL_A(6) = U1(6)
        DELB = SQRT((DEL_A(1)**2+DEL_A(2)**2+DEL_A(3)**2+
     &          2.0*(DEL_A(4)**2+DEL_A(5)**2+DEL_A(6)**2))/3.0)
      ELSE
        DEL_A(1) = U1(1)-U2(1)
        DEL_A(2) = U1(2)-U2(2)
        DEL_A(3) = U1(3)-U2(3)
        DEL_A(4) = U1(4)-U2(4)
        DEL_A(5) = U1(5)-U2(5)
        DEL_A(6) = U1(6)-U2(6)
        DELB = SQRT((DEL_A(1)**2+DEL_A(2)**2+DEL_A(3)**2+
     &          2.0*(DEL_A(4)**2+DEL_A(5)**2+DEL_A(6)**2))/3.0)
      ENDIF
      DELB = DELB*PISQ8
      IF(DELB.GT.BFAC_CUT*SIGMA_B) THEN
C
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('B-value outliers')
          WRITE(LINE,'(A,F7.2,A)')'B-value differences >',BFAC_CUT,
     &        'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          IFIRST = 1
        ENDIF
        IR1 = I_RESID(IO)
        IR2 = I_RESID(IT)
        call get_chain_namepdb(chnamp1,ir1)
        call get_chain_namepdb(chnamp2,ir2)
        WRITE(LINE,'(12A,F7.3,A,F7.3)')
     &                  chnamp1,RES_NUM_PDB(IR1)(3:7),
     &                  RES_NAME(IR1)(1:4),
     &                  ATM_NAME(IO)(1:4),ALT2CH(ID_ALT(IO)),' - ',
     &                  chnamp2,RES_NUM_PDB(IR2)(3:7),
     &                  RES_NAME(IR2)(1:4),
     &                  ATM_NAME(IT)(1:4),ALT2CH(ID_ALT(IT)),
     &                  '    ABS(DELTA)=',DELB,'   Sigma=',SIGMA_B
        CALL ERRWRT(-1,LINE)
      ENDIF
      RETURN
      END
C
      SUBROUTINE RIGID_BOND(SUMW,MAX_MAT,MAX_VEC,A_MAT,VECT,MAX_DIST,
     &            N_TARGET,N_OBJECT,NSYM_DIST,NW_UVAL)

C
C-----Subroutine puts rigid bond restraints on U values between covalently
C-----bonded atoms. Perhaps it should also be extended for B values???
C----- Rollett in Crystallographic Computing 1970)
C-----(Hirshfeld 1976, Acta Cryst A32, 239-244
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rharvest.fh'
C
      INTEGER MAX_MAT,MAX_VEC,MAX_DIST
      REAL SUMW
      REAL A_MAT(*),VECT(*)
      INTEGER N_OBJECT(*),N_TARGET(*),NW_UVAL(*),NSYM_DIST(4,*)
C
      INTEGER NSUM,IFIRST,L1,L2,LD,ID,IWT,IO,IT,IO1,IT1,IO11,IT11,LOV
      INTEGER LTV,LOM,LTM,IBOND,IANISO,IPOSMO,IPOSMT,IANISO1,IPOS,ITX(3)
      INTEGER I,ISYM
      REAL  U_ORT(6),U_ORT1(6),U_ORT2(6),XORT1(3),XORT2(3),XORT3(3)
      REAL  U_A1(6)
      REAL  XORT4(3),BONDL(3),BONDLL(6),BONDLL1(6),DEL_RIGID(6),DSUM
      REAL  DELLB2,SMALL_BOND,WWTT,WTT,DELB2,BLENGTH,DELL
      LOGICAL ERROR
      DATA SMALL_BOND/0.01/
      integer is,ierror,im
c
      integer, allocatable :: lposv(:)
      integer, allocatable :: lposm(:)
c
      real ro_unit(3,3),rfr_unit(3,3)
      real uucell2orth(6,6),uuorth2cell(6,6)
      real realsymm_aniso(6,6,192)
c
c---  body
      call nb_frorth(cs_cell(1),cs_cell(2),cs_cell(3),cs_cell(4),
     &     cs_cell(5),cs_cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call calc_unit_frac(cs_frac_to_ort,cs_cell,ro_unit)     
      call matinv3_r(ro_unit,rfr_unit)
      call find_conv_matrix(ro_unit,uucell2orth)
      call find_conv_matrix(rfr_unit,uuorth2cell)
      do  is=1,nsym
        call find_conv_matrix(cs_m_cs(1,1,is),realsymm_aniso(1,1,is))
      enddo
C
C----Initialize
      allocate(lposv(n_atom))
      allocate(lposm(n_atom))
      im = 1
      SUMW = 0.0
      L1 = 0
      L2 = NMTMP
C
C----Set the distance weighting scheme
      DSUM = 0.0
      NSUM = 0
      WWTT = 0.0
      IFIRST = 0
      IF(SIG_RIGID_B.GT.0.0) WWTT = WBSKAL*PISQ8/SIG_RIGID_B
C
C----Find positions for gradient and diagonal of second derivative matrix
C----It is important if we are using mixed refinement (i.e. some atoms
C----have isotropic U value some anisotropic)
cd      NDIS2 = NDIS - NVDW
cd      NBIS  = NDIS2
      CALL FIND_POS_OF_U(maxATOM,N_ATOM_mod,ATOM_REF_mod_FLAG,
     &                  U_ANISO_mod,LPOSV,LPOSM,1)
C
C----Cycle over distances
      LD = 1
      DO     ID=1,NDIS
        IWT   = NW_UVAL(ID)
C
C----Apply restraints only for 1-2 bonds
        IF(IWT.EQ.1) THEN
          WTT = WWTT**2
        ELSE
          WTT = 0.0
        ENDIF
cd        IF(IWT.LE.0) THEN
cd          GO TO 100
cd        ENDIF
        IO    = N_OBJECT(ID)
        IT    = N_TARGET(ID)
        IO1   = ATOM_REF_mod_FLAG(IO,im)/10
        IT1   = ATOM_REF_mod_FLAG(IT,im)/10
        IO11  = ATOM_REF_mod_FLAG(IO,im)-IO1*10
        IT11  = ATOM_REF_mod_FLAG(IT,im)-IT1*10
cd        IF(IO11.LE.0.OR.IT11.LE.0) STOP
        LOV   = LPOSV(IO1)
        LTV   = LPOSV(IT1)
        LOM   = LPOSM(IO1)
        LTM   = LPOSM(IT1)
        DELB2 = 0.0
        IF(U_ANISO_mod(2,IO,im).GT.0.0 .AND.
     &     U_ANISO_mod(2,IT,im).GT.0.0 .AND. IWT.EQ.1) THEN
C
C----Apply rigid bond restraints if both atoms are anisotropic. Symmetry should
C----be taken into account
           XORT1(1) = XYZ_CRD_mod(1,IO,im)
           XORT1(2) = XYZ_CRD_mod(2,IO,im)
           XORT1(3) = XYZ_CRD_mod(3,IO,im)
           
           XORT2(1) = XYZ_CRD_mod(1,IT,im)
           XORT2(2) = XYZ_CRD_mod(2,IT,im)
           XORT2(3) = XYZ_CRD_mod(3,IT,im)
           ISYM     = NSYM_DIST(1,ID)
           ITX(1)   = NSYM_DIST(2,ID)
           ITX(2)   = NSYM_DIST(3,ID)
           ITX(3)   = NSYM_DIST(4,ID)
           DO   IANISO = 1,6
             U_ORT (IANISO) = U_ANISO_mod(IANISO,IO,im)
             U_ORT1(IANISO) = U_ANISO_mod(IANISO,IT,im)
           ENDDO
C
C---Apply symmetry if needed. Convert coordinates to find correct bond 
C---vector and convert ADP to find correct projection.
           IF(ISYM.GT.1.OR.ITX(1).NE.0.OR.
     &                     ITX(2).NE.0.OR.ITX(3).NE.0) THEN
              CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XORT2,XORT3,ERROR)
              DO   I=1,3
                XORT4(I) = RealSymmMatrx(I,1,ISYM)*XORT3(1) +
     &                     RealSymmMatrx(I,2,ISYM)*XORT3(2) +
     &                     RealSymmMatrx(I,3,ISYM)*XORT3(3) +
     &                     RealSymmMatrx(I,4,ISYM) + FLOAT(ITX(I))

              ENDDO 
              CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XORT4,XORT2,ERROR)
           ENDIF
           IF(ISYM.GT.1) THEN
C
C---Now U values
              CALL MAT2VECT(6,6,UUORTH2CELL,U_ANISO_mod(1,IT,im),U_A1,
     &          ERROR)
              CALL MAT2VECT(6,6,RealSymm_Aniso(1,1,ISYM),U_ORT1,U_ORT2,
     &                                          ERROR)
              CALL MAT2VECT(6,6,UUCELL2ORTH,U_ORT2,U_ORT1,ERROR)
           ENDIF
C
C----Find bond vector.
           BLENGTH = 0.0
           DO   IBOND = 1,3
             BONDL(IBOND) = XORT1(IBOND) - XORT2(IBOND)
             BLENGTH      = BLENGTH + BONDL(IBOND)**2
           ENDDO
           BLENGTH = SQRT(AMAX1(SMALL_BOND,BLENGTH))
           DO     IBOND = 1,3
             BONDL(IBOND) = BONDL(IBOND)/BLENGTH
           ENDDO
           DO   IBOND = 1,3
             BONDLL(IBOND) = BONDL(IBOND)**2
           ENDDO
           BONDLL(4) = 2.0*BONDL(1)*BONDL(2)
           BONDLL(5) = 2.0*BONDL(1)*BONDL(3)
           BONDLL(6) = 2.0*BONDL(2)*BONDL(3)
C
           DELL  = 0.0
           DO    IANISO=1,3
             DEL_RIGID(IANISO)   = (U_ORT(IANISO) - U_ORT1(IANISO))*
     +                              BONDLL(IANISO)
             DEL_RIGID(IANISO+3) = (U_ORT(IANISO+3) - U_ORT1(IANISO+3))*
     +                              BONDLL(IANISO+3)
             DELL                =  DELL +  DEL_RIGID(IANISO) + 
     +                                      DEL_RIGID(IANISO+3)
             DELB2               =  DELB2 + DELL**2
           ENDDO
C
C---Apply symmetry if needed. It makes sense by general rule of derivatives
C---(What is applied for variables is applied for derivatives in reverse 
C---order.)
C
           IF(ISYM.GT.1) THEN
             CALL MAT2VEC(6,6,UUCELL2ORTH,BONDLL,U_ORT1,ERROR)
             CALL MAT2VEC(6,6,RealSymm_Aniso(1,1,ISYM),U_ORT1,U_ORT2,
     &                                          ERROR)
             CALL MAT2VEC(6,6,UUCELL2ORTH,U_ORT2,BONDLL1,ERROR)
           ENDIF
C
C---Increment diagonal terms
           IPOSMO =  L1 + LOM - 1
           IPOSMT =  L1 + LTM - 1
           DO    IANISO = 1,6
              IPOSMO     = IPOSMO + 1
              IPOSMT     = IPOSMT + 1
              A_MAT(IPOSMO) = A_MAT(IPOSMO) + WTT*BONDLL(IANISO)**2
              A_MAT(IPOSMT) = A_MAT(IPOSMT) + WTT*BONDLL1(IANISO)**2
           ENDDO
           DO    IANISO = 1,5
             DO    IANISO1 = IANISO+1,6
               IPOSMO = IPOSMO + 1
               IPOSMT = IPOSMT + 1
               A_MAT(IPOSMO) = A_MAT(IPOSMO) + WTT*BONDLL(IANISO)*
     +                                       BONDLL(IANISO1)
               A_MAT(IPOSMT) = A_MAT(IPOSMT) + WTT*BONDLL1(IANISO)*
     +                                       BONDLL1(IANISO1)
             ENDDO
           ENDDO
C
C---Consider case when pair of IAs are equal
C

C
C----Increment non diagonal terms
           IF(IO1.NE.IT1) THEN
             DO    IANISO=1,6
               DO    IANISO1=1,6
                     A_MAT(L2+LD) = A_MAT(L2+LD) - 
     +                              WTT*BONDLL(IANISO)*BONDLL1(IANISO1)
                 LD               = LD + 1
               ENDDO
             ENDDO
           ELSE
C
C---Atoms are same. Contribution to diagonal terms only (block diagonal
C---in some sense)
C
             IPOSMO = L1 + LOM - 1
             DO    IANISO = 1,6
                IPOSMO     = IPOSMO + 1
                A_MAT(IPOSMO) = A_MAT(IPOSMO) - 2.0*WTT*
     &                           BONDLL(IANISO)*BONDLL1(IANISO)
             ENDDO
             DO    IANISO = 1,5
               DO    IANISO1 = IANISO+1,6
                 IPOSMO = IPOSMO + 1
                 A_MAT(IPOSMO) = A_MAT(IPOSMO) - WTT*
     &                              (BONDLL(IANISO)*BONDLL1(IANISO1)+
     &                              (BONDLL1(IANISO)*BONDLL(IANISO1)))
               ENDDO
             ENDDO
             LD = LD + 36
           ENDIF
C
C-----Increment vector elements
           DO   IANISO=1,6
             IPOS       = LOV + IANISO - 1
             VECT(IPOS) = VECT(IPOS) - WTT*BONDLL(IANISO)*
     &                            DELL
             IPOS       = LTV + IANISO - 1
             VECT(IPOS) = VECT(IPOS) + WTT*BONDLL(IANISO)*
     &                            DELL
           ENDDO
C
C----Compile statistics
           IF(IWT.EQ.1.OR.IWT.EQ.3) THEN
             SUMW = SUMW + WTT*DELB2
             DSUM = DSUM + DELB2
             NSUM = NSUM + 1
           ENDIF
C
C----If one of atoms is not anisotropic then rigid bond restraint should 
C----not be used
          IF(MON_STYLE.NE.'NONE'.OR.MON_STYLE.NE.'FEW') 
     &       CALL RIGID_BOND_OUTLIER(IFIRST,IO,IT,DELL)
        ELSEIF(U_ANISO_mod(2,IO,im).LE.0.0 .AND.
     &         U_ANISO_mod(2,IT,im).LE.0.0) THEN
          LD = LD + 1
        ELSEIF(U_ANISO_mod(2,IO,im).GT.0.0 .OR.
     &         U_ANISO_mod(2,IT,im).GT.0.0) THEN
          LD = LD + 36
        ELSE
          LD = LD + 6
        ENDIF
  100   CONTINUE
      ENDDO
C
C---Save for harvesting and reporting
      IF(NSUM.GT.0) THEN
        DSUM = SQRT(DSUM/FLOAT(NSUM))
        HNRESTR = HNRESTR + 1
        HRESTR_DEVITAR(HNRESTR) = SIG_RIGID_B
        HRESTR_DEV(HNRESTR)     = DSUM*PISQ8
        HRESTR_NUM(HNRESTR)     = NSUM
        HRESTR_TYPE(HNRESTR) = 'Rigid bond restraints'
        HRESTR_CIF(HNRESTR) = 'r_rigid_bond_restr'
      ENDIF

      deallocate(lposv)
      deallocate(lposm)
      RETURN
      END
C
      SUBROUTINE RIGID_BOND_OUTLIER(IFIRST,IO,IT,DELL)
C
C---Reports outliers of rigind bond restraints
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      INTEGER IFIRST,IO,IT
      REAL DELL
C
      INTEGER IR1,IR2
      CHARACTER LINE*132,ALT2CH*1
      character chnamp1*4,chnamp2*4
C
      IF(MON_STYLE(1:3).EQ.'FEW'.OR.MON_STYLE(1:4).EQ.'NONE') RETURN

      IF(ABS(DELL)*PISQ8.GT.RBON_CUT*SIG_RIGID_B) THEN
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('Rigid bond outliers')
          WRITE(LINE,'(A,F7.2,A)')'Rigid bond differences >',RBON_CUT,
     &        'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          IFIRST = 1
        ENDIF
        IR1 = I_RESID(IO)
        IR2 = I_RESID(IT)
        call get_chain_namepdb(chnamp1,ir1)
        call get_chain_namepdb(chnamp2,ir2)
        WRITE(LINE,'(12A,F7.3,A,F7.3)')
     &                  chnamp1,RES_NUM_PDB(IR1)(3:7),
     &                  RES_NAME(IR1)(1:4),
     &                  ATM_NAME(IO)(1:4),ALT2CH(ID_ALT(IO)),' - ',
     &                  chnamp2,RES_NUM_PDB(IR2)(3:7),
     &                  RES_NAME(IR2)(1:4),
     &                  ATM_NAME(IT)(1:4),ALT2CH(ID_ALT(IT)),
     &                  '  Delta  =',ABS(DELL)*PISQ8,' Sigma=',
     &                             SIG_RIGID_B
        CALL ERRWRT(-1,LINE)
      ENDIF          
      RETURN
      END
C
      SUBROUTINE BSPHERE_RESTR(SUMW,MAX_MAT,MAX_VEC,A_MAT,VECT,
     &            MAX_DIST,
     &            N_TARGET,N_OBJECT,NW_UVAL)
C
C-----Subroutine puts restraints on U values between bonded atoms.
C-----Only covalent bonds, angle, and 1-4 planar bond have been taken 
C-----into account.
      IMPLICIT NONE
      INCLUDE 'monitor.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rharvest.fh'

      REAL A_MAT(*),VECT(*)
      REAL SUMW
      INTEGER N_OBJECT(*),N_TARGET(*),NW_UVAL(*)
      INTEGER MAX_MAT,MAX_VEC,MAX_DIST
C
      REAL  DSUM(2),DEL_ANISO(6),U_ORT(6),RRCONV(6,6),WWTT,TWO2THREE,
     &      ONE2THREE,WTT,U_ISO_EQUAV,DELB2,DELL
      INTEGER NCLASS,IWT,L1,IA,ID,IO,IT,IANISO2,LV,LM,IA1,IA11,IPOS,
     &        IANISO1,IFIRST,I,IANISO
      INTEGER NSUM(2)
      integer im
c
      integer, allocatable :: lfreeatom(:)
C
C----Initialize
      allocate(lfreeatom(n_atom))
      im = 1
      SUMW    = 0.0
      L1      = 0
      IFIRST  = 0
C
C----Set the distance weighting scheme
      NCLASS = 2
      DO    IWT=1,NCLASS
        DSUM(IWT) = 0.0
        NSUM(IWT) = 0
      ENDDO
      WWTT      = 0.0
      IF(SIGSPH.GT.0.0) WWTT = WBSKAL*PISQ8/SIGSPH
C
C----Find if atom is free or is involved in B restraints
      DO    IA=1,N_ATOM
        LFREEATOM(IA) = 0
      ENDDO
      DO    ID=1,NDIS
        IO = N_OBJECT(ID)
        IT = N_TARGET(ID)
        IF(IO.GT.0.AND.IT.GT.0.AND.
     &      NW_UVAL(ID).GE.1.AND.NW_UVAL(ID).LE.5) THEN
          LFREEATOM(IO) = LFREEATOM(IO) + 1
          LFREEATOM(IT) = LFREEATOM(IT) + 1
        ENDIF
      ENDDO
C
C----Find conversion from orthogonal to cell system.
      TWO2THREE = 2.0/3.0
      ONE2THREE = 1.0/3.0
      DO    IANISO=1,6
        IF(IANISO.GT.3) THEN
          RRCONV(IANISO,IANISO) = 2.0
        ELSE
          RRCONV(IANISO,IANISO) = TWO2THREE**2
        ENDIF
      ENDDO
      DO    IANISO=1,5
        DO    IANISO2=IANISO+1,6
          IF(IANISO.LT.3.AND.IANISO2.LE.3) THEN
            RRCONV(IANISO ,IANISO2) = -ONE2THREE/3.0
            RRCONV(IANISO2,IANISO ) = -ONE2THREE/3.0
          ELSE
            RRCONV(IANISO ,IANISO2) = 0.0
            RRCONV(IANISO2,IANISO ) = 0.0
          ENDIF
        ENDDO
      ENDDO
C
C----Cycle over atoms
cd      L1 = LATMN
      LV = 1
      LM = 1
      DO     IA=1,N_ATOM
        IA1 = ATOM_REF_mod_FLAG(IA,im)/10
        IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
        IF(IA11.LE.0) GOTO 100
        IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
          LV = LV + 1
          LM = LM + 1
        ELSE
          IWT = 1
          IF(LFREEATOM(IA).GT.1) IWT = 2
          WTT = WWTT**2
C
C----That is experimental case. Not much theory behind
          DO   IANISO = 1,6
            U_ORT(IANISO)  = U_ANISO_mod(IANISO,IA,im)
          ENDDO
          U_ISO_EQUAV = (U_ORT(1) + U_ORT(2) + U_ORT(3))/3.0
          DELB2       = 0.0
          DO    IANISO=1,3
            DELL                = U_ORT(IANISO) - U_ISO_EQUAV
            DEL_ANISO(IANISO)   = DELL*2.0/3.0
            DEL_ANISO(IANISO+3) = 2.0*U_ORT(IANISO+3)
            DELB2               = DELB2  
     +                           +     DELL**2 
     +                           + 2.0*U_ORT(IANISO+3)**2
          ENDDO
C
C---Convert derivatives to cell system
          IPOS = L1 + LM - 1
          DO    IANISO = 1,6
             IPOS        = IPOS + 1
             A_MAT(IPOS) = A_MAT(IPOS) + WTT*RRCONV(IANISO,IANISO)
             LM          = LM +1
          ENDDO
          DO    IANISO = 1,5
            DO   IANISO1 = IANISO+1,6
              IPOS        = IPOS + 1
              A_MAT(IPOS) = A_MAT(IPOS) + WTT*RRCONV(IANISO,IANISO1)
              LM          = LM +1
            ENDDO
          ENDDO
C
C-----Increment vector elements
          DO   IANISO=1,6
            IPOS       = LV
            VECT(IPOS) = VECT(IPOS) - WTT*DEL_ANISO(IANISO)
            LV         = LV + 1
          ENDDO
C
C----Compile statistics
          SUMW      = SUMW      + WTT*DELB2
          DSUM(IWT) = DSUM(IWT) + DELB2
          NSUM(IWT) = NSUM(IWT) + 1
          IF(MON_STYLE.NE.'NONE'.OR.MON_STYLE.NE.'FEW')
     &           CALL BSPHERE_OUTLIER(IFIRST,IA,U_ANISO_mod(1,IA,im))
        ENDIF
 100    CONTINUE
      ENDDO
C
c----Save for harvesting and reporting
      DO   I=1,2
        IF(NSUM(I).GT.0) THEN
          HNRESTR = HNRESTR + 1
          HRESTR_DEVITAR(HNRESTR) = SIGSPH
          HRESTR_DEV(HNRESTR)     = SQRT(DSUM(I)/FLOAT(NSUM(I)))*PISQ8
          HRESTR_NUM(HNRESTR)     = NSUM(I)
          IF(I.EQ.1) THEN
            HRESTR_TYPE(HNRESTR) = 'Sphericity. Free atoms'
            HRESTR_CIF(HNRESTR) = 'r_sphericity_free'
          ELSE
            HRESTR_TYPE(HNRESTR) = 'Sphericity. Bonded atoms'
            HRESTR_CIF(HNRESTR) = 'r_sphericity_bonded'
          ENDIF
        ENDIF
      ENDDO         
C
      deallocate(lfreeatom)
      RETURN
      END
C
      SUBROUTINE BSPHERE_OUTLIER(IFIRST,IA,U1)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
C
      INTEGER IFIRST,IA
      REAL    U1(6)
C
      INTEGER IR1
      REAL DELTA,U_ISO_EQUAV
      CHARACTER LINE*132,ALT2CH*1
      character chnamp1*4
C
      IF(MON_STYLE(1:3).EQ.'FEW'.OR.MON_STYLE(1:4).EQ.'NONE') RETURN
      U_ISO_EQUAV = (U1(1)+U1(2)+U1(3))/3.0
      DELTA       = SQRT((U1(1) - U_ISO_EQUAV)**2
     +                 + (U1(2) - U_ISO_EQUAV)**2
     +                 + (U1(3) - U_ISO_EQUAV)**2
     +                 + 2.0*U1(4)**2
     +                 + 2.0*U1(5)**2
     +                 + 2.0*U1(6)**2)
C
      IF(DELTA*PISQ8.GT.BSPH_CUT*SIGSPH) THEN
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('Sphericity outliers')
          WRITE(LINE,'(A,F7.2,A)')'U values different from sphere >',
     &        BSPH_CUT,'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          IFIRST = 1
        ENDIF
        IR1 = I_RESID(IA)
        call get_chain_namepdb(chnamp1,ir1)
        WRITE(LINE,'(6A,6F7.4,A,F6.3,A,F7.3)')
     &                 chnamp1,RES_NUM_PDB(IR1)(3:7),
     &                 RES_NAME(IR1)(1:4),
     &                 ATM_NAME(IA)(1:4),ALT2CH(ID_ALT(IA)),' U value=',
     &                 U1(1),U1(2),U1(3),U1(4),U1(5),U1(6),
     &                 ' Delta=',DELTA,' Sigma=',SIGSPH/PISQ8
        CALL ERRWRT(-1,LINE)
      ENDIF          
      RETURN
      END

      SUBROUTINE FIND_POS_OF_U(maxatom,N_atom_mod,ATOM_REF_mod_FLAG,
     &  U_ANISO_mod,LPOSV,LPOSM,nmodel)
C
C---Finds positions for isotropic and anisotropic U values in
C---in gradient and secodn derivative matrix
      IMPLICIT NONE
c      INTEGER QQA
      integer maxatom
      INTEGER LPOSV(*),LPOSM(*),N_Atom_mod(*)
      INTEGER ATOM_REF_mod_FLAG(maxatom,*)
      REAL U_ANISO_mod(6,maxatom,*)
C
      INTEGER LV,LM,IA,IA1
      integer nmodel,im
C
      
      LV = 1
      LM = 1
      IA1 = 0
      
      do im=1,nmodel
        DO   IA=1,N_Atom_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1 = IA1 + 1
            LPOSV(IA1) = LV
            LPOSM(IA1) = LM
            IF(U_ANISO_mod(2,IA,im).GT.0.0) THEN
              LV = LV + 6
              LM = LM + 21
            ELSE
              LV = LV + 1
              LM = LM + 1
            ENDIF
          ENDIF
        ENDDO
      enddo
      RETURN
      END
C
      SUBROUTINE FIND1_POS_OF_U(QQA,NA,ATOM_REF,U_ANISO,LPOSV)
C
C---Finds positions for isotropic and anisotropic U values in
C---in gradient and secodn derivative matrix. Finds positions
C---only for gradients
      IMPLICIT NONE
      INTEGER QQA,NA
      INTEGER LPOSV(*),ATOM_REF(*)
      REAL    U_ANISO(6,*)
C
      INTEGER  LV,IA,IA1
C
      LV = 1
      IA1 = 0
      DO   IA=1,NA
        IF(ATOM_REF(IA).GT.0) THEN
          IA1 = IA1 + 1
          LPOSV(IA1) = LV
          IF(U_ANISO(2,IA).NE.0.0) THEN
            LV = LV + 6
          ELSE
            LV = LV + 1
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END
C
      SUBROUTINE NCS_REF(MAX_MAT,MAX_VEC,A_MAT,VECT,SUMP,SUMB)
C
C----Restraints on non-crystallographic symmetry related molecules 
C----to obey it
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'
C
      INTEGER MAX_MAT,MAX_VEC
      REAL A_MAT(*),VECT(*)
      REAL SUMP,SUMB
C
      integer num_ncs_loc
      INTEGER I,L1,NPAR_U_NCS,IX,ISCRN,IWTT,NANISO_NCS,NS,IS,NCHN,ICHN,
     &        K,IA,ISS,LL,IFAIL,IGROUP,JX,IANISO,IY,IA1,LMPOS,LVPOS,M0,
     &        MM,NCHN1,IFIRST
      REAL WT,WBB,CC,DS,AN12N,BS
      REAL              RNCS_XYZ_ALL(3,3,MAX_NCS),
     +                  RNCS_ANISO_ALL(6,6,MAX_NCS),
     +                  RCONV_XYZ(3,3,MAX_NCS),RCONV_ANISO(6,6,MAX_NCS),
     +                  XYZ(3),XYZA(3),U_1(6),U_2(6),RBBAR(MAX_NCS),
     +                  RB(6,MAX_NCS),RX(3,MAX_NCS),RXBAR(MAX_NCS),
     +                  DD(MAX_NCS),DB(6,MAX_NCS),DDB(MAX_NCS),
     &                  DX(3,MAX_NCS),
     +                  VV(3,MAX_NCS),
     +                  RTEMP_XYZ(3,3),
     +                  RTEMP_ANISO(6,6),
     +                  RTEMP1_ANISO(6,6),WTT(6),DEL(MAX_NCS,6)
      INTEGER           NSW(6)
      integer im
c
c---allocatable
      real, allocatable :: sigx_n(:)
      real, allocatable :: sigb_n(:)
      real,    allocatable :: xa(:,:)
      real,    allocatable :: xb(:,:)
      real,    allocatable :: xc(:,:)
      real,    allocatable :: ws(:)
      integer, allocatable :: iwt(:)
      integer, allocatable :: lvaniso_pos(:)
      integer, allocatable :: lmaniso_pos(:)
      integer, allocatable :: iat(:,:)
c
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL           ANISO_FLAG_NCS,ERROR

C
C----Read the header record for a symmetry group
      if(len_trim(ncsr_file_name).le.0) return
      allocate(lvaniso_pos(n_atom))
      allocate(lmaniso_pos(n_atom))
c
      im = 1
c
      IF(NUMBER_NCSR.LE.0) THEN
        CALL ERRWRT(0,'No NCS has been defined')
        RETURN
      ENDIF
C
      SUMP = 0.0
      SUMB = 0.0
      DO  I = 1,6
         WTT(I) = 0.0
         sigs(i) = 0.0
c         IF(SIGS(I).GT.0.0) WTT(I) = WSSKAL/SIGS(I)
c         IF(I.GT.3) THEN
c            WTT(I) = WTT(I)*PISQ8
c         ENDIF
      ENDDO
C
C---Set up positions for derivatives of residual wrt U values.
C---Anisotropic or isotropic
      CALL FIND_POS_OF_U(MAXATOM,N_ATOM_mod,ATOM_REF_mod_FLAG,
     &                   U_ANISO_mod,LVANISO_POS,LMANISO_POS,1)

      IF(NCSR_FILE_NAME(1:1).EQ.' ') RETURN
      call open_unform_file(iscrn,ncsr_file_name,ifail)
C
      read(iscrn)num_ncs_loc
      DO      IGROUP=1,num_ncs_loc
C
C--Is it so
C
C----Initialise weights
      IFIRST = 0
      L1 = NMPOS + 9*NDIS
      DO  I = 1,6
        NSW(I) = 0
        sigs(i) = 0.0
        DO   K=1,MAX_NCS
          DEL(K,I) = 0.0
        ENDDO
      ENDDO
      ANISO_FLAG_NCS = .FALSE.
      NPAR_U_NCS  = 1

C
C--Second derivative matrix for not rotated atoms
      CALL MAT2IDENT(3,3,RTEMP_XYZ,ERROR)
      IF(ITEMP.GT.0) THEN
        CALL MAT2IDENT(6,6,RTEMP_ANISO,ERROR)
        DO    IX=4,6
          RTEMP_ANISO(IX,IX) = 2.0
        ENDDO
      ENDIF
C
C---Is it so

        READ(ISCRN)NS,nchn

        allocate(sigx_n(ns))
        allocate(sigb_n(ns))
        allocate(xa(3,ns))
        allocate(xb(3,ns))
        allocate(xc(3,ns))
        allocate(iat(ns,nchn))
        allocate(iwt(ns))
        allocate(ws(ns))
c
        IF(NS.LE.0) GOTO 300
c        NCHN = NCS_N_CHAIN(IGROUP)
        IF(NCHN.LE.1) GOTO 300
        AN12N = FLOAT(NCHN-1)/FLOAT(NCHN)
C
C----Read the atom equivalences for this symmetry group
        DO    IS=1,NS
          READ(ISCRN) IWT(IS),sigx_n(is),sigb_n(is),(IAT(IS,K),K=1,NCHN)
C
C----Find the symmetry transformations. This part should be changed.
          WS(IS) = 0.0
          DO   K=1,NCHN
            IA = IAT(IS,K)
            IF(ATOM_REF_mod_FLAG(IA,im).LE.0) GOTO 10
          ENDDO
          if(sigx_n(is).le.0) then
             IF(IWT(IS).GE.1.AND.IWT(IS).LE.3) THEN
                IF(SIGS(IWT(IS)).NE.0.0) WS(IS) = 1.0/SIGS(IWT(IS))**2
             ENDIF
          else
             ws(is) = 1/sigx_n(is)**2
             do  i=1,3
                wtt(i) = 1/sigx_n(is)
                wtt(i+3) = pisq8/sigb_n(is)
c                wtt(i+3) = 0.0
             enddo
          endif
 10       CONTINUE
        ENDDO
C---
        DO   K = 1,NCHN
          IF(K.EQ.1) THEN
            DO  IX = 1,3
              VV(IX,1) = 0.0
            ENDDO
            CALL MAT2IDENT(3,3,RNCS_XYZ_ALL(1,1,1),ERROR)
          ENDIF
          DO  IS = 1,NS
            ISS    = IAT(IS,K)
C
            IF(K.EQ.1) THEN
C
c---Refernence set of atoms for NCS
              XA(1,IS) = XYZ_CRD_mod(1,ISS,im)
              XA(2,IS) = XYZ_CRD_mod(2,ISS,im)
              XA(3,IS) = XYZ_CRD_mod(3,ISS,im)
            ELSE
C
c---Working set of atoms for which transformation should be found. 
              XB(1,IS) = XYZ_CRD_mod(1,ISS,im)
              XB(2,IS) = XYZ_CRD_mod(2,ISS,im)
              XB(3,IS) = XYZ_CRD_mod(3,ISS,im)
            ENDIF
          ENDDO
C
C---Find transformation matrix
          IF(K.NE.1) 
     &        CALL TOSS1(NS,RNCS_XYZ_ALL(1,1,K),VV(1,K),XA,XB,XC,WS)
          IF(MON_STYLE.EQ.'MANY') THEN
            CALL PRINTTRANS(NCS_CHAINS(K,IGROUP),NCS_CHAINS(1,IGROUP),
     &                      RNCS_XYZ_ALL(1,1,K),VV(1,K))
          ENDIF
C
C----Find conversion matrix for anisoU.
          IF(ITEMP.GT.0) THEN
            CALL FIND_CONV_MATRIX(RNCS_XYZ_ALL(1,1,K),
     &                             RNCS_ANISO_ALL(1,1,K))
          ENDIF
C
C---Calculate elements of second derivative matrices. They depend
C---only on weights and conversion matrices
          CALL MATT2MAT(3,3,RNCS_XYZ_ALL(1,1,K),RNCS_XYZ_ALL(1,1,K),
     &                      RCONV_XYZ(1,1,K),ERROR)
          IF(ITEMP.GT.0) THEN
            CALL MAT2MAT(6,6,RNCS_ANISO_ALL(1,1,K),RTEMP_ANISO,
     &                 RTEMP1_ANISO,ERROR)
            CALL MAT2MATT(6,6,RTEMP1_ANISO,RNCS_ANISO_ALL(1,1,K),
     &                     RCONV_ANISO(1,1,K),ERROR)
          ENDIF
        ENDDO
c
c       call ncs_oper_procrust(ns,nop,xyz_all,ws,rncs_xyz_all,vv_xyz_all,ierr)
C
C---Multiply conversion matrices by (NCHN-1)/NCHN
        DO    ICHN=1,NCHN
          DO    JX=1,3
            DO    IX=1,3
              RCONV_XYZ(IX,JX,ICHN) = AN12N**2*RCONV_XYZ(IX,JX,ICHN)
            ENDDO
          ENDDO
        ENDDO
        IF(ITEMP.GT.0) THEN
          DO    ICHN=1,NCHN
            DO    JX=1,6
              DO    IX=1,6
                RCONV_ANISO(IX,JX,ICHN) = 
     +                          AN12N**2*RCONV_ANISO(IX,JX,ICHN)
              ENDDO
            ENDDO
          ENDDO
        ENDIF
C
C---Cycle over all atom equavalences
        DO     IS=1,NS
          DO   K=1,NCHN
            IA = IAT(IS,K)
            IF(ATOM_REF_mod_FLAG(IA,im).LE.0) GOTO 200
          ENDDO
          IWTT = IWT(IS)
          WT   = 0.0
          WBB  = 0.0
          IF(IWTT.GT.0) WT  = WTT(IWTT)**2
          IF(IWTT.GT.0.AND.WT.GT.0.0) WBB = WTT(IWTT+3)**2
C
C----Find individual and average transformed positions
          DO    IANISO = 1,6
             RBBAR(IANISO) = 0.0
          ENDDO
          DO  IX = 1,3
            RXBAR(IX) = 0.0
          ENDDO
          NANISO_NCS = 0
          DO  K = 1,NCHN
            IA     = IAT(IS,K)
            XYZ(1) = XYZ_CRD_mod(1,IA,im)
            XYZ(2) = XYZ_CRD_mod(2,IA,im)
            XYZ(3) = XYZ_CRD_mod(3,IA,im)
C
C---Trnasform using NCS
            CALL MAT2VEC(3,3,RNCS_XYZ_ALL(1,1,K),XYZ,XYZA,ERROR)
            DO   IX = 1,3
              RX(IX,K)  = VV(IX,K)  + XYZA(IX)
              RXBAR(IX) = RXBAR(IX) + RX(IX,K)
            ENDDO
            IF(ITEMP.GT.0) THEN
C
C----Atom is isotropic
              IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                RB(1,K)        = U_ANISO_mod(1,IA,im)
                RBBAR(1)       = RBBAR(1)   + U_ANISO_mod(1,IA,im)
                NANISO_NCS     = NANISO_NCS + 1 
              ELSE
C
C---Atom is anisotropic.Apply transformation matrix
                DO   IANISO = 1,6
                  U_2(IANISO) = U_ANISO_mod(IANISO,IA,im)
                ENDDO
                CALL MAT2VECT(6,6,RNCS_ANISO_ALL(1,1,K),U_2,U_1,ERROR)
                DO   IANISO = 1,6
                  RB(IANISO,K)  = U_1(IANISO) 
                  RBBAR(IANISO) = RBBAR(IANISO) + U_1(IANISO)
                ENDDO
                NANISO_NCS      = NANISO_NCS + 6
              ENDIF
            ENDIF
          ENDDO
C
          IF(ITEMP.GT.0) THEN
            ANISO_FLAG_NCS = .FALSE.
            NPAR_U_NCS     = 1
            IF(NANISO_NCS.EQ.6*NCHN) THEN
              ANISO_FLAG_NCS = .TRUE.
              NPAR_U_NCS     = 6
            ELSEIF(NANISO_NCS.NE.NCHN) THEN
              CALL ERRWRT(-1,'NCS related atoms have different B types')
              CALL ERRWRT(-1,'It happens in MIXED B refinement')
              CALL 
     +         ERRWRT(1,'Check atom equavalencies in coordinate file')
            ENDIF
          ENDIF
          DO  IX = 1,3
            RXBAR(IX) = RXBAR(IX)/NCHN
          ENDDO
          IF(ITEMP.GT.0) THEN
            DO   IANISO = 1,NPAR_U_NCS
              RBBAR(IANISO) = RBBAR(IANISO)/NCHN
            ENDDO
          ENDIF
C
C----Find deviation from common superposibility
          DO  K=1,NCHN
            DD(K)  = 0.0
            IF(ITEMP.GT.0) DDB(K) = 0.0
            DO  IX=1,3
              DX(IX,K) = RX(IX,K) - RXBAR(IX)
              DD(K)    = DD(K)    + DX(IX,K)**2
            ENDDO
               
            IF(ITEMP.GT.0) THEN
              IF(.NOT.ANISO_FLAG_NCS) THEN
                DB(1,K)      = RB(1,K) - RBBAR(1)
                DDB(K)       = DDB(K) + DB(1,K)**2
              ELSE
                DO   IANISO = 1,6
                  CC = 1.0
                  IF(IANISO.GT.3) CC = 2.0
                  DB(IANISO,K) = CC*(RB(IANISO,K) - RBBAR(IANISO))
                  DDB(K)       = DDB(K) + DB(IANISO,K)**2/(3.0*CC)
                ENDDO
              ENDIF
            ENDIF
          ENDDO
C
C----Accumilate statistics and apply weights
          IF(IWTT.NE.0) THEN
            NSW(IWTT) = NSW(IWTT) + 1
            sigs(iwtt) = sigs(iwtt) + sigx_n(is)
            sigs(iwtt+3) = sigs(iwtt+3) + sigb_n(is)
            DO     K = 1,NCHN
              DS          = SQRT(ABS(DD(K)))
              SUMP        = SUMP + DD(K)*WT
              DEL(K,IWTT) = DEL(K,IWTT) + DD(K)
              IF(ITEMP.GT.0) THEN
                BS            = DDB(K)
                SUMB          = SUMB + BS*WBB
                DEL(K,IWTT+3) = DEL(K,IWTT+3) + BS
              ENDIF
            ENDDO
          ENDIF
C
C----Accumulate normal equation sums
          DO  K = 1,NCHN
            IA     = IAT(IS,K)
            IA1    = ATOM_REF_mod_FLAG(IA,im)/10
C
C----Increment right hand side of equation
            M0    = 3*(IA1-1) 
            LVPOS = LVANISO_POS(IA1)
            LMPOS = LMANISO_POS(IA1)
            DO   IX = 1,3
              XYZA(IX) = WT*DX(IX,K)*AN12N
            ENDDO
            CALL MAT2VECT(3,3,RNCS_XYZ_ALL(1,1,K),XYZA,XYZ,ERROR)
            DO   IX=1,3
              VECT(M0 + IX) = VECT(M0 + IX) - XYZ(IX)
            ENDDO
            IF(ITEMP.GT.0) THEN
              IF(.NOT.ANISO_FLAG_NCS) THEN
                VECT(NVPOS + LVPOS) = VECT(NVPOS + LVPOS) - 
     &                         DB(1,K)*WBB*AN12N
              ELSE
                DO   IANISO=1,6
                  U_1(IANISO) = WBB*DB(IANISO,K)*AN12N
                ENDDO
                CALL MAT2VEC(6,6,RNCS_ANISO_ALL(1,1,K),U_1,U_2,ERROR)
                DO   IANISO = 1,6
                  VECT(NVPOS + LVPOS + IANISO - 1) = 
     +                VECT(NVPOS + LVPOS + IANISO - 1) - U_2(IANISO)
                ENDDO
              ENDIF
            ENDIF
C
C----Increment matrix within atom blocks
            MM = 6*(IA1-1) + 1
            DO     IX=1,3
              A_MAT(MM) = A_MAT(MM) + WT*RCONV_XYZ(IX,IX,K)
              MM     = MM + 1
            ENDDO
            DO    IX = 1,2
              DO     JX = IX+1,3
                A_MAT(MM) = A_MAT(MM) + WT*RCONV_XYZ(IX,JX,K)
                MM     = MM + 1
              ENDDO
            ENDDO
            IF(ITEMP.GT.0) THEN
              IF(.NOT.ANISO_FLAG_NCS) THEN
                A_MAT(L1 + LMPOS) = A_MAT(L1 + LMPOS) + WBB*AN12N**2
              ELSE
C
C---Atoms are anisotropic
                DO    IX = 1,6
                  A_MAT(L1 + LMPOS + IX-1) = A_MAT(L1 + LMPOS + IX-1) 
     +                            + WBB*RCONV_ANISO(IX,IX,K)
                ENDDO
                IY = 6
                DO    IX = 1,5
                  DO     JX = IX+1,6
                    IY = IY + 1
                    A_MAT(L1 + LMPOS + IY-1) = A_MAT(L1 + LMPOS + IY-1) 
     +                                 + WBB*RCONV_ANISO(IX,JX,K)
                  ENDDO
                ENDDO
              ENDIF
            ENDIF
            IF(MON_STYLE.NE.'NONE'.AND.MON_STYLE(1:3).NE.'FEW') THEN
              CALL NCSR_OUTLIERS(DD(K),DDB(K),IA,IWTT,IFIRST)
            ENDIF
          ENDDO
 200      CONTINUE

        ENDDO
        IF(ITEMP.GT.0) THEN
          NSW(4) = NSW(1)
          NSW(5) = NSW(2)
          NSW(6) = NSW(3)
        ENDIF
C
c---Save for harvesting and reporting
        NCHN1 = NCHN
c
        do i=1,6
           sigs(i) = sigs(i)/float(nsw(i))
        enddo
c
        IF(NCHN.EQ.2) NCHN1 = 1
        DO   K=1,NCHN1
          DO    I=1,6
            IF(NSW(I).GT.0) THEN
              HNRESTR = HNRESTR + 1
              DEL(K,I) = SQRT(DEL(K,I)/FLOAT(NSW(I)))
              IF(I.GT.3) DEL(K,I) = DEL(K,I)*PISQ8
c              sigs(i) = sigs(i)/float(nsw(i))
              HRESTR_DEVITAR(HNRESTR) = SIGS(I)
              HRESTR_DEV(HNRESTR)     = DEL(K,I)
              HRESTR_NUM(HNRESTR)     = NSW(I)
              IF(I.EQ.1) THEN
                WRITE(HRESTR_TYPE(HNRESTR),'(A,I2,A,i3)')
     &      'NCS: tight positional , group ',IGROUP,
     &           ' chain ',k
              ELSEIF(I.EQ.2) THEN
                WRITE(HRESTR_TYPE(HNRESTR),'(A,I2,A,i3)')
     &      'NCS: medium positional, group ',IGROUP,
     &           ' chain ',k
              ELSEIF(I.EQ.3) THEN
                WRITE(HRESTR_TYPE(HNRESTR),'(A,I2,A,i3)')
     &      'NCS: loose positional , group ',IGROUP,
     &           ' chain ',k
              ELSEIF(I.EQ.4) THEN
                WRITE(HRESTR_TYPE(HNRESTR),'(A,I2,A,i3)')                 
     &      'NCS: tight thermal    , group ',IGROUP,
     &           ' chain ',k
              ELSEIF(I.EQ.5) THEN
                WRITE(HRESTR_TYPE(HNRESTR),'(A,I2,A,i3)')
     &      'NCS: medium thermal   , group ',IGROUP,
     &           ' chain ',k
              ELSEIF(I.EQ.6) THen
                WRITE(HRESTR_TYPE(HNRESTR),'(A,I2,A,i3)')
     &      'NCS: loose thermal    , group ',IGROUP,
     &           ' chain ',k
              ENDIF
            ENDIF
          ENDDO
        ENDDO
 300    CONTINUE
        deallocate(sigx_n)
        deallocate(sigb_n)
        deallocate(xa)
        deallocate(xb)
        deallocate(xc)
        deallocate(ws)
        deallocate(iwt)
        deallocate(iat)
      ENDDO
      deallocate(lvaniso_pos)
      deallocate(lmaniso_pos)
      CLOSE(UNIT = ISCRN)
      RETURN
      END
C
      SUBROUTINE NCSR_OUTLIERS(DD,DDB,IA,IWTT,IFIRST)
C
C---Reports NCS outliers
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INTEGER IA,IWTT,IFIRST
      REAL  DD,DDB
C
      INTEGER IR
      REAL  SIGMA_P,SIGMA_B
      CHARACTER LINE*128
      character chnamp1*4
C
C----Find sigmas
      SIGMA_P = SIGS(IWTT)
      IF(ITEMP.GT.0) THEN
         SIGMA_B = SIGS(IWTT+3)
      ENDIF
      IR = I_RESID(IA)
      IF(SQRT(DD).GT.NCSR_CUT*SIGMA_P) THEN
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('NCS restraint outliers')
          WRITE(LINE,'(A,F6.3,A)')'Deviations from the'//
     &      ' average position >',NCSR_CUT,'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          IFIRST  = 1
        ENDIF
        call get_chain_namepdb(chnamp1,ir)
        WRITE(LINE,'(7A,F6.3,A,F6.3,A,F7.3)')
     &                  'Positional: ',
     &                  chnamp1,RES_NUM_PDB(IR)(3:7),
     &                  RES_NAME(IR)(1:4),
     &                  ATM_NAME(IA)(1:4),ID_ALT(IA),
     &                  ' deviation =',SQRT(DD),' sigma=',SIGMA_P
        CALL ERRWRT(-1,LINE)
      ENDIF
      IF(ITEMP.GT.0) THEN
        IF(SQRT(DDB)*PISQ8.GT.NCSR_CUT*SIGMA_B) THEN
          IF(IFIRST.EQ.0) THEN
            CALL HEADER('NCS restraint outliers')
            WRITE(LINE,'(A,F6.3,A)')'Deviations from the'//
     &        ' average position >',NCSR_CUT,'Sigma will be monitored'
            CALL ERRWRT(-1,LINE)
            CALL ERRWRT(-1,' ')
            IFIRST  = 1
          ENDIF
          call get_chain_namepdb(chnamp1,ir)
          WRITE(LINE,'(7A,F6.3,A,F6.3,A,F7.3)')
     &                  'B value   : ',
     &                  chnamp1,RES_NUM_PDB(IR)(3:7),
     &                  RES_NAME(IR)(1:4),
     &                  ATM_NAME(IA)(1:4),ID_ALT(IA),
     &                  ' deviation =',SQRT(DDB)*PISQ8,' sigma=',SIGMA_B
          CALL ERRWRT(-1,LINE)
        ENDIF
      ENDIF
      RETURN
      END
C
      SUBROUTINE PRINTTRANS(ID1,ID2,R,T)
C
C---Print out transformations
      IMPLICIT NONE
      CHARACTER*(*) ID1,ID2
      REAL R(3,3),T(3)
      REAL P1,P2,P3,PHI,PSI,CHI
      CHARACTER LINE*80
      REAL DETR,DET3
C
      CALL ERRWRT(-1,' ')
      WRITE(LINE,'(A,A,A,A)')' Transformation from chain ',ID1,
     .       ' to chain ',ID2
      CALL ERRWRT(-1,LINE)
      CALL ERRWRT(-1,' ')
      DETR = DET3(R)
      WRITE(LINE,'(5X,3G15.4)')R(1,1),R(1,2),R(1,3)
      CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,3G15.4)')' R = ',R(2,1),R(2,2),R(2,3)
      CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(5X,3G15.4)')R(3,1),R(3,2),R(3,3)
      CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,3G15.4)')' T = ',T
      CALL ERRWRT(-1,LINE)
      CALL ERRWRT(-1,' ')
      WRITE(LINE,'(A,G15.4)')'       DET(R) = ',DETR
      CALL ERRWRT(-1,LINE)
      CALL ERRWRT(-1,' ')
      CALL POLAR(R,PSI,PHI,CHI)
      P1 = PHI
      P2 = PSI
      P3 = CHI
      WRITE(LINE,'(A,F8.2,A,F8.2,A,F8.2)')
     +     ' Phi =',P1,' Psi(or Omega) =',P2,' Chi(or Kapppa) = ',P3
      CALL ERRWRT(-1,LINE)
      CALL ERRWRT(-1,
     .'----------------------------------------------------')
      RETURN
      END
C
      SUBROUTINE TOSS1(NTAB,R,T,XA,XB,XC,WS)
C
C---Subroutine finds transformation matrix from coordinates.
C---I will change it. Eulers or polar angles and translations will be
C---refined
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'cif_incl.fh'
C
      REAL XA(3,*),XB(3,*),XC(3,*),WS(*)
      REAL               G(18,18),D(18),R(3,3),T(3),SIGR(3,3),SIGT(3)
      DATA               NCYCLE /10/
      LOGICAL            ERROR

C
C----INITIALIZE FOR THE UNCONDITIONAL MINIMIZATION
      NV = 12
      DO    M=1,NV
        D(M)=0
        DO    N=1,NV
          G(M,N)=0
        ENDDO
      ENDDO  
C
      DO    I=1,3
        SIGT(I) = 0.0
        DO    J=1,3
          SIGR(I,J) = 0.0
        ENDDO
      ENDDO
C
C----PREPARE RIGHT-HAND-SIDE SUMS FOR INITIAL MINIMIZATION
      M = 0
      DO    IX=1,3
        DO    JX=1,3
          M = M + 1
          DO    I=1,NTAB
            D(M) = D(M) + WS(I)*XA(IX,I)*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
      DO  IX=1,3
        M = M + 1
        DO  I=1,NTAB
          D(M) = D(M) + WS(I)*XA(IX,I)
        ENDDO
      ENDDO
C
C----PREPARE MATRIX ELEMENT SUMS
      DO    IX=1,3
        DO    JX=IX,3
          DO    I=1,NTAB
            SIGR(IX,JX) = SIGR(IX,JX) + WS(I)*XB(IX,I)*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
      DO    IX=1,3
        DO    I=1,NTAB
          SIGT(IX) = SIGT(IX) + WS(I)*XB(IX,I)
        ENDDO
      ENDDO
      SIGR(2,1) = SIGR(1,2)
      SIGR(3,1) = SIGR(1,3)
      SIGR(3,2) = SIGR(2,3)
C
C----Count the active equivalences
      MATCH  = 0
      WMATCH = 0.0
      DO    I=1,NTAB
        IF(WS(I).GT.0.0) MATCH = MATCH + 1
        WMATCH = WMATCH + WS(I)
      ENDDO
C
C----SET UP THE NORMAL EQUATIONS
      MN = 1
   44 CONTINUE
      MN0 = 3*(MN-1)
      DO    I=1,3
        M         = MN0 + I
        G(M,MN+9) = SIGT(I)
        G(MN+9,M) = SIGT(I)
        DO    J=1,3
          N      = MN0 + J
          G(M,N) = SIGR(I,J)
        ENDDO
      ENDDO
      G(MN+9,MN+9) = WMATCH
      MN           = MN + 1
      IF(MN.LE.3) GO TO 44
   50 CONTINUE
C
C----Invert the matrix and obtain new parameters
      CALL GAUSSJ(G,NV,18,D,1,1,ERROR)
       IF(ERROR) 
     + CALL ERRWRT(1,' *** Error in GAUSSJ - called from TOSS ***')

      C1     = D(1)**2   + D(2)**2   + D(3)**2
      C2     = D(4)**2   + D(5)**2   + D(6)**2
      C3     = D(7)**2   + D(8)**2   + D(9)**2
      C4     = D(4)*D(7) + D(5)*D(8) + D(6)*D(9)
      C5     = D(7)*D(1) + D(8)*D(2) + D(9)*D(3)
      C6     = D(1)*D(4) + D(2)*D(5) + D(3)*D(6)
      R(1,1) = D(1)
      R(1,2) = D(2)
      R(1,3) = D(3)
      R(2,1) = D(4)
      R(2,2) = D(5)
      R(2,3) = D(6)
      R(3,1) = D(7)
      R(3,2) = D(8)
      R(3,3) = D(9)
      T(1)   = D(10)
      T(2)   = D(11)
      T(3)   = D(12)
C
C----Orthogonal transformation constraints by non-linear least-squares
      NV     = 18
      KONVRG = 0
      DO 200 IC = 1,NCYCLE
C
C----Initialize for this cycle
      DO    M = 1,NV
        D(M) = 0
        DO    N = 1,NV
          G(M,N) = 0
        ENDDO
      ENDDO
C
C----Find the current transformed set of positions
      DO    IX = 1,3
        DO    I = 1,NTAB
          XC(IX,I) = T(IX)
        ENDDO
        DO    JX = 1,3
          DO    I  =1,NTAB
            XC(IX,I) = XC(IX,I) + R(IX,JX)*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
C
C----Prepare right-hand-side sums for this iteration
      M = 0
      DO    IX=1,3
        DO    JX=1,3
          M = M + 1
          DO    I=1,NTAB
            D(M) = D(M) + WS(I)*(XA(IX,I)-XC(IX,I))*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
      DO    IX=1,3
        M = M + 1
        DO    I=1,NTAB
          D(M) = D(M) + WS(I)*(XA(IX,I)-XC(IX,I))
        ENDDO
      ENDDO
C
C----Constraint contributions to right-hand-side vector
      D(13) = 1.0 - C1
      D(14) = 1.0 - C2
      D(15) = 1.0 - C3
      D(16) =     - C4
      D(17) =     - C5
      D(18) =     - C6
C
C----Set up the normal equations
      MN = 1
  144 CONTINUE
      MN0 = 3*(MN-1)
      DO     I=1,3
        M = MN0 + I
        G(M    ,MN+9 ) = SIGT(I)
        G(MN+9 ,M    ) = SIGT(I)
        G(M    ,MN+12) = 2*R(MN,I)
        G(MN+12,M    ) = 2*R(MN,I)
        G(16   ,I+3  ) = R(3,I)
        G(16   ,I+6  ) = R(2,I)
        G(17   ,I    ) = R(3,I)
        G(17   ,I+6  ) = R(1,I)
        G(18   ,I    ) = R(2,I)
        G(18   ,I+3  ) = R(1,I)
        G(I+3  ,16   ) = R(3,I)
        G(I+6  ,16   ) = R(2,I)
        G(I    ,17   ) = R(3,I)
        G(I+6  ,17   ) = R(1,I)
        G(I    ,18   ) = R(2,I)
        G(I+3  ,18   ) = R(1,I)
        DO     J=1,3
          N = MN0 + J
          G(M,N) = SIGR(I,J)
        ENDDO
      ENDDO
      G(MN+9,MN+9) = WMATCH
      MN           = MN + 1
      IF(MN.LE.3) GO TO 144
  150 CONTINUE
C
C----Invert the matrix and obtain new parameters
      CALL GAUSSJ(G,NV,18,D,1,1,ERROR)
      R(1,1) = R(1,1) + D(1)
      R(1,2) = R(1,2) + D(2)
      R(1,3) = R(1,3) + D(3)
      R(2,1) = R(2,1) + D(4)
      R(2,2) = R(2,2) + D(5)
      R(2,3) = R(2,3) + D(6)
      R(3,1) = R(3,1) + D(7)
      R(3,2) = R(3,2) + D(8)
      R(3,3) = R(3,3) + D(9)
      T(1)   = T(1)   + D(10)
      T(2)   = T(2)   + D(11)
      T(3)   = T(3)   + D(12)
      IF(KONVRG.NE.0) GO TO 220
      C1 = R(1,1)**2     + R(1,2)**2     + R(1,3)**2
      C2 = R(2,1)**2     + R(2,2)**2     + R(2,3)**2
      C3 = R(3,1)**2     + R(3,2)**2     + R(3,3)**2
      C4 = R(2,1)*R(3,1) + R(2,2)*R(3,2) + R(2,3)*R(3,3)
      C5 = R(3,1)*R(1,1) + R(3,2)*R(1,2) + R(3,3)*R(1,3)
      C6 = R(1,1)*R(2,1) + R(1,2)*R(2,2) + R(1,3)*R(2,3)
      DD = DET3(R)
      IF(ABS(ABS(DD)-1.0).LT.0.0000005) KONVRG=IC
  200 CONTINUE
  220 CONTINUE
      RETURN
      END
C
      subroutine ncs_oper_procrus(ntab,nop,xyz,ws,r,t,ierr)
      implicit none
c
c---  Find ncs operators using generalised weighted partial procrustes 
c---  analysis. (i.e. rotation and translations are found but scale assumed
c---  to be unit.
c
c---  inputs
      integer ntab,nop
      real xyz(nop,3,ntab)
      real ws(nop)
c
c---  outputs
      integer ierr
      real r(3,3,nop),t(3,3,nop)
c
c--   allocatable
      
c
c---  locals
      integer ic,i,j
      integer iter_max
      parameter (iter_max = 100)
c
c---  body
      ierr = 0
      if(ntab.le.0) then
         ierr = 1
         return
      endif
      if(nop.le.0) then
         ierr = 1
         return
      endif
c
c---  Use generalised weighted procrustes analysis to find all operators
c---  iteratively
      do  i=1,iter_max
         do   j=2,nop

         enddo
      enddo

      return
      end

       SUBROUTINE TOSS2(NTAB,R,T,XA,XB,XC,WS)
C
C---Subroutine finds transformation matrix from coordinates.
C---It uses Kabsch's algorithm (Acta cryst. A32 1976, pp 922-923, 
C---                                        A34 1978, pp 827-828
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'cif_incl.fh'
C
      REAL XA(3,*),XB(3,*),XC(3,*),WS(*)
      REAL               G(18,18),D(18),R(3,3),T(3),SIGR(3,3),SIGT(3)
      DATA               NCYCLE /10/
      LOGICAL            ERROR
C
C---First find translational part. Is it difference between centre of masses?
C

C
C----INITIALIZE FOR THE UNCONDITIONAL MINIMIZATION
      NV = 12
      DO    M=1,NV
        D(M)=0
        DO    N=1,NV
          G(M,N)=0
        ENDDO
      ENDDO  
C
      DO    I=1,3
        SIGT(I) = 0.0
        DO    J=1,3
          SIGR(I,J) = 0.0
        ENDDO
      ENDDO
C
C----PREPARE RIGHT-HAND-SIDE SUMS FOR INITIAL MINIMIZATION
      M = 0
      DO    IX=1,3
        DO    JX=1,3
          M = M + 1
          DO    I=1,NTAB
            D(M) = D(M) + WS(I)*XA(IX,I)*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
      DO  IX=1,3
        M = M + 1
        DO  I=1,NTAB
          D(M) = D(M) + WS(I)*XA(IX,I)
        ENDDO
      ENDDO
C
C----PREPARE MATRIX ELEMENT SUMS
      DO    IX=1,3
        DO    JX=IX,3
          DO    I=1,NTAB
            SIGR(IX,JX) = SIGR(IX,JX) + WS(I)*XB(IX,I)*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
      DO    IX=1,3
        DO    I=1,NTAB
          SIGT(IX) = SIGT(IX) + WS(I)*XB(IX,I)
        ENDDO
      ENDDO
      SIGR(2,1) = SIGR(1,2)
      SIGR(3,1) = SIGR(1,3)
      SIGR(3,2) = SIGR(2,3)
C
C----Count the active equivalences
      MATCH  = 0
      WMATCH = 0.0
      DO    I=1,NTAB
        IF(WS(I).GT.0.0) MATCH = MATCH + 1
        WMATCH = WMATCH + WS(I)
      ENDDO
C
C----SET UP THE NORMAL EQUATIONS
      MN = 1
   44 CONTINUE
      MN0 = 3*(MN-1)
      DO    I=1,3
        M         = MN0 + I
        G(M,MN+9) = SIGT(I)
        G(MN+9,M) = SIGT(I)
        DO    J=1,3
          N      = MN0 + J
          G(M,N) = SIGR(I,J)
        ENDDO
      ENDDO
      G(MN+9,MN+9) = WMATCH
      MN           = MN + 1
      IF(MN.LE.3) GO TO 44
   50 CONTINUE
C
C----Invert the matrix and obtain new parameters
      CALL GAUSSJ(G,NV,18,D,1,1,ERROR)
       IF(ERROR) 
     + CALL ERRWRT(1,' *** Error in GAUSSJ - called from TOSS ***')

      C1     = D(1)**2   + D(2)**2   + D(3)**2
      C2     = D(4)**2   + D(5)**2   + D(6)**2
      C3     = D(7)**2   + D(8)**2   + D(9)**2
      C4     = D(4)*D(7) + D(5)*D(8) + D(6)*D(9)
      C5     = D(7)*D(1) + D(8)*D(2) + D(9)*D(3)
      C6     = D(1)*D(4) + D(2)*D(5) + D(3)*D(6)
      R(1,1) = D(1)
      R(1,2) = D(2)
      R(1,3) = D(3)
      R(2,1) = D(4)
      R(2,2) = D(5)
      R(2,3) = D(6)
      R(3,1) = D(7)
      R(3,2) = D(8)
      R(3,3) = D(9)
      T(1)   = D(10)
      T(2)   = D(11)
      T(3)   = D(12)
C
C----Orthogonal transformation constraints by non-linear least-squares
      NV     = 18
      KONVRG = 0
      DO 200 IC = 1,NCYCLE
C
C----Initialize for this cycle
      DO    M = 1,NV
        D(M) = 0
        DO    N = 1,NV
          G(M,N) = 0
        ENDDO
      ENDDO
C
C----Find the current transformed set of positions
      DO    IX = 1,3
        DO    I = 1,NTAB
          XC(IX,I) = T(IX)
        ENDDO
        DO    JX = 1,3
          DO    I  =1,NTAB
            XC(IX,I) = XC(IX,I) + R(IX,JX)*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
C
C----Prepare right-hand-side sums for this iteration
      M = 0
      DO    IX=1,3
        DO    JX=1,3
          M = M + 1
          DO    I=1,NTAB
            D(M) = D(M) + WS(I)*(XA(IX,I)-XC(IX,I))*XB(JX,I)
          ENDDO
        ENDDO
      ENDDO
      DO    IX=1,3
        M = M + 1
        DO    I=1,NTAB
          D(M) = D(M) + WS(I)*(XA(IX,I)-XC(IX,I))
        ENDDO
      ENDDO
C
C----Constraint contributions to right-hand-side vector
      D(13) = 1.0 - C1
      D(14) = 1.0 - C2
      D(15) = 1.0 - C3
      D(16) =     - C4
      D(17) =     - C5
      D(18) =     - C6
C
C----Set up the normal equations
      MN = 1
  144 CONTINUE
      MN0 = 3*(MN-1)
      DO     I=1,3
        M = MN0 + I
        G(M    ,MN+9 ) = SIGT(I)
        G(MN+9 ,M    ) = SIGT(I)
        G(M    ,MN+12) = 2*R(MN,I)
        G(MN+12,M    ) = 2*R(MN,I)
        G(16   ,I+3  ) = R(3,I)
        G(16   ,I+6  ) = R(2,I)
        G(17   ,I    ) = R(3,I)
        G(17   ,I+6  ) = R(1,I)
        G(18   ,I    ) = R(2,I)
        G(18   ,I+3  ) = R(1,I)
        G(I+3  ,16   ) = R(3,I)
        G(I+6  ,16   ) = R(2,I)
        G(I    ,17   ) = R(3,I)
        G(I+6  ,17   ) = R(1,I)
        G(I    ,18   ) = R(2,I)
        G(I+3  ,18   ) = R(1,I)
        DO     J=1,3
          N = MN0 + J
          G(M,N) = SIGR(I,J)
        ENDDO
      ENDDO
      G(MN+9,MN+9) = WMATCH
      MN           = MN + 1
      IF(MN.LE.3) GO TO 144
  150 CONTINUE
C
C----Invert the matrix and obtain new parameters
      CALL GAUSSJ(G,NV,18,D,1,1,ERROR)
      R(1,1) = R(1,1) + D(1)
      R(1,2) = R(1,2) + D(2)
      R(1,3) = R(1,3) + D(3)
      R(2,1) = R(2,1) + D(4)
      R(2,2) = R(2,2) + D(5)
      R(2,3) = R(2,3) + D(6)
      R(3,1) = R(3,1) + D(7)
      R(3,2) = R(3,2) + D(8)
      R(3,3) = R(3,3) + D(9)
      T(1)   = T(1)   + D(10)
      T(2)   = T(2)   + D(11)
      T(3)   = T(3)   + D(12)
      IF(KONVRG.NE.0) GO TO 220
      C1 = R(1,1)**2     + R(1,2)**2     + R(1,3)**2
      C2 = R(2,1)**2     + R(2,2)**2     + R(2,3)**2
      C3 = R(3,1)**2     + R(3,2)**2     + R(3,3)**2
      C4 = R(2,1)*R(3,1) + R(2,2)*R(3,2) + R(2,3)*R(3,3)
      C5 = R(3,1)*R(1,1) + R(3,2)*R(1,2) + R(3,3)*R(1,3)
      C6 = R(1,1)*R(2,1) + R(1,2)*R(2,2) + R(1,3)*R(2,3)
      DD = DET3(R)
      IF(ABS(ABS(DD)-1.0).LT.0.0000005) KONVRG=IC
  200 CONTINUE
  220 CONTINUE
      RETURN
      END       
C
      SUBROUTINE POLAR(TRMAT,OMEGA,PHI,CHI)
C     ========================
C
C---- This s/r works out various rotation angles corresponding
C     to a given rotation matrix.
C     It could easily be extended to give other sets.
C
      INCLUDE 'const.fh'
C     .. Array Arguments ..
      REAL TRMAT(3,3)
C     ..
C     .. Local Scalars ..
      REAL CHI,CHK,COSCHI,OMEGA,PHI,R13,R23,R31,R32,SINCHI,SOMEGA,
     +     THETA1,THETA2,THETA3,TRACE
C     ..
C     .. Local Arrays ..
      REAL DC(5)
C     ..
      CHI = 0.0
      OMEGA = 0.0
      PHI = 0.0

      TRACE = TRMAT(1,1) + TRMAT(2,2) + TRMAT(3,3)
      IF (TRACE.LT.3.0) THEN
        IF (TRMAT(3,3).LT.0.99999) THEN
          IF (TRMAT(3,3).GT.-0.999999) THEN
            THETA2 = ACOS(AMAX1(-1.0,AMIN1(1.0,TRMAT(3,3))))*RTODEG
C
            R13 = TRMAT(1,3)
            R23 = TRMAT(2,3)
            R31 = TRMAT(3,1)
            R32 = TRMAT(3,2)
            IF (R23.LT.0.0) THEN
              R13 = -R13
              R23 = -R23
              R31 = -R31
              R32 = -R32
              THETA2 = -THETA2
            END IF
            THETA3 = 0.0
            THETA1 = 0.0
            IF(R32**2+R31**2.NE.0.0) 
     +          THETA3 = ATAN2(R32,-R31)*RTODEG
            IF(R23**2+R13**2.NE.0.0)
     +           THETA1 = ATAN2(R23,R13)*RTODEG
C
C---- Spherical polars ref patterson int tab vol2 p59
            DC(1) = 0.0
            DC(2) = 0.0
            DC(3) = 0.0
            COSCHI = TRACE/2.0 - 0.5
            SINCHI = SQRT(ABS(1.0-COSCHI*COSCHI))
            CHI = 0.0
            IF(SINCHI**2+COSCHI**2.NE.0.0)
     +            CHI = ATAN2(SINCHI,COSCHI)*RTODEG
            CHK = ABS(CHI)
            IF (CHK.GT.179.5) THEN
              GO TO 10
            ELSE
              DC(1) = (TRMAT(3,2)-TRMAT(2,3))/ (2.0*SINCHI)
              DC(2) = (TRMAT(1,3)-TRMAT(3,1))/ (2.0*SINCHI)
              DC(3) = (TRMAT(2,1)-TRMAT(1,2))/ (2.0*SINCHI)
              CHK = DC(1)**2 + DC(2)**2 + DC(3)**2
              IF (CHK.GT.0.8) THEN
                GO TO 20
              ELSE
                GO TO 10
              END IF
            END IF
          END IF
        END IF
C
C---- U_ANISO =0 or 180  can only find alpha + or - gamma.
        THETA2 = 0.0
        IF (TRMAT(3,3).LT.0.0) THETA2 = 180.0
        THETA3 = 0.0
        IF(TRMAT(2,1)**2+TRMAT(2,2)**2.NE.0.0) 
     +       THETA3 = ATAN2(TRMAT(2,1),TRMAT(2,2))*RTODEG
        THETA1 = 0.0
        IF (THETA2.EQ.0) CHI = THETA3
        IF (THETA2.EQ.180.0) CHI = 180.0
C
C---- IF CHI =180  COSCHI=-1,SINCHI=0
   10   DC(1) = SQRT(ABS(TRMAT(1,1)*0.5+0.5))
        DC(2) = SQRT(ABS(TRMAT(2,2)*0.5+0.5))
        DC(3) = SQRT(ABS(TRMAT(3,3)*0.5+0.5))
C
C---- Assume dc(1) positive
        IF (DC(1).NE.0.0) THEN
          IF (DC(2).NE.0.0) DC(2) = DC(2)*SIGN(1.0,TRMAT(1,2))
          IF (DC(3).NE.0.0) DC(3) = DC(3)*SIGN(1.0,TRMAT(1,3))
        ELSE IF (DC(2).NE.0.0) THEN
          IF (DC(3).NE.0.0) DC(3) = SIGN(1.0,TRMAT(2,3))*DC(3)
        END IF
   20   DC(4) = DC(1)
        DC(5) = DC(2)
C
        SOMEGA = SQRT(ABS(1.0-DC(3)*DC(3)))
        OMEGA = 0.0
        IF(SOMEGA**2+DC(3)**2.NE.0.0)
     +      OMEGA = ATAN2(SOMEGA,DC(3))*RTODEG
        CHK = DC(2)*DC(2) + DC(1)*DC(1)
        PHI = 999
        IF (CHK.GT.0.0) PHI = RTODEG*ATAN2(DC(2),DC(1))
      END IF
      END
C
       SUBROUTINE DIST_OUTLIER
C
C---This routine reports outliers for bond distancesc
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'

C
C---Local variables
      INTEGER I,ISCRB,ITX(3),LL,IFAIL,IA1,IA2,
     &        ISYM1,IA11,IA21,IA12,IA22,IFIRST,IR1,IR2
      integer ityp,nr_bond1
      REAL    XYZ_TMP1(3),XYZ_TMP(3),RS_VIDL,RS_SDI,DBDX1(3),
     &        WEIGHT_L,BOND_C,DBOND,ABS
      integer nr_tmp
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
      CHARACTER LINE*132
      character chnamp1*4,chnamp2*4
C
      IFIRST         = 0
      IF(BOND_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscrb,bond_file,ifail)

      read(iscrb)nr_bond1
      nr_tmp = 0
 10   CONTINUE
      READ(ISCRB,END=999)IA1,IA2,RS_VIDL,RS_SDI,ISYM1,ITX(1),ITX(2),
     &                    ITX(3),ityp
      nr_tmp = nr_tmp + 1
      IF(RS_SDI.LE.0.0) GOTO 10
      IF(ATOM_REF_FLAG(IA1).LE.0.OR.ATOM_REF_FLAG(IA2).LE.0) GOTO 10
c
      IA11 = ATOM_REF_FLAG(IA1)/10
      IA21 = ATOM_REF_FLAG(IA2)/10
      IA12 = ATOM_REF_FLAG(IA1) - 10*IA11
      IA22 = ATOM_REF_FLAG(IA2) - 10*IA21
      IF(IA12.LE.0.OR.IA22.LE.0) GOTO 10

      WEIGHT_L = (WDSKAL/RS_SDI)**2
C
C---Check if this bond is through symmetry. If yes apply symmetry.
      IF(ISYM1.GT.0) THEN
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA2),XYZ_TMP,ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(I,1,ISYM1)*XYZ_TMP(1) +
     &                  RealSymmMatrx(I,2,ISYM1)*XYZ_TMP(2) +
     &                  RealSymmMatrx(I,3,ISYM1)*XYZ_TMP(3) +
     &                  RealSymmMatrx(I,4,ISYM1) + FLOAT(ITX(I))
        ENDDO 
        CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)
      ELSE
        XYZ_TMP(1) = XYZ_CRD(1,IA2)
        XYZ_TMP(2) = XYZ_CRD(2,IA2)
        XYZ_TMP(3) = XYZ_CRD(3,IA2)
      ENDIF
C
C---Calculate derivative of the bond w.r.t. atomic parameters
      DBDX1(1) = XYZ_CRD(1,IA1)-XYZ_TMP(1)
      DBDX1(2) = XYZ_CRD(2,IA1)-XYZ_TMP(2)
      DBDX1(3) = XYZ_CRD(3,IA1)-XYZ_TMP(3)
C
      BOND_C  = SQRT(DBDX1(1)**2+DBDX1(2)**2+DBDX1(3)**2)
      DBOND   = RS_VIDL - BOND_C
      IF(ABS(DBOND).GT.DSCUT*RS_SDI) THEN
C
C----Report
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('Bond distance outliers')
          WRITE(LINE,'(A,F6.3,A)')'Bond distance deviations from the'//
     &      ' ideal >',DSCUT,'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          IFIRST  = 1
        ENDIF
        IR1 = I_RESID(IA1)
        IR2 = I_RESID(IA2)
        call get_chain_namepdb(chnamp1,ir1)
        call get_chain_namepdb(chnamp2,ir2)
        WRITE(LINE,'(12A,F6.3,A,F6.3,A,F7.3,A,F6.3)')
     &                  chnamp1,RES_NUM_PDB(IR1)(3:7),
     &                  RES_NAME(IR1)(1:4),
     &                  ATM_NAME(IA1)(1:4),ID_ALT(IA1),' - ',
     &                  chnamp2,RES_NUM_PDB(IR2)(3:7),
     &                  RES_NAME(IR2)(1:4),
     &                  ATM_NAME(IA2)(1:4),ID_ALT(IA2),
     &                  ' mod.=',BOND_C,' id.=',RS_VIDL,
     &                  ' dev=',DBOND,' sig.=',RS_SDI
        CALL ERRWRT(-1,LINE)
      ENDIF   
      GOTO 10
 999  CONTINUE
      CLOSE(ISCRB)
      ISCRB = 0
      RETURN
      END
C
      SUBROUTINE ANGL_OUTLIER
      IMPLICIT NONE
C---This routine calculates derivatives of restraints corresponding to
C---bond angles. they are strored in the file. file is opened and
C---closed at the end of program
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'

C
C---Local variables
      integer nr_angle
      integer i,ia
      INTEGER ISCRA,IA1(3),LL,IFAIL,IA11,IA21,IA31,IA12,IA32,IA22,IX,
     &        IR1,IR2,IFIRST
      REAL    XYZ_TMP1(3,3),RS_VIDL,RS_SDI
      real    RS_DIST,RS_DESD,SMALL_BOND,COS_ANGLE,SIN_ANGLE
      real    VECTOR1(3),VECTOR2(3),ANGLE
      real    RADTODEG,SMALL_SINE
      real    VEC1_NORM,VEC2_NORM,DANGLE
      real    VEC12_PROD,ABS
c
      integer is_t(4,3)
      integer is
      real    tx(3)
      real    xyz_t1(3),xyz_t2(3)
      INTEGER LENSTR
      EXTERNAL LENSTR     
      CHARACTER ALT2CH*1,LINE*132
      character chnamp1*4,chnamp2*4
      DATA SMALL_BOND/0.01/,SMALL_SINE/0.001/,RADTODEG/57.29578/
C
      IFIRST = 0
      IF(ANGLE_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscra,angle_file,ifail)
      read(iscra)nr_angle
 10   CONTINUE
      READ(ISCRA,END=999)IA1(1:3),(is_t(1:4,i),i=1,3),RS_VIDL,RS_SDI
      IF(RS_SDI.LE.0.0) GOTO 10
      IF(ATOM_REF_FLAG(IA1(1)).LE.0.OR.ATOM_REF_FLAG(IA1(2)).LE.0.OR.
     &   ATOM_REF_FLAG(IA1(3)).LE.0) GOTO 10
      IA11 = ATOM_REF_FLAG(IA1(1))/10
      IA21 = ATOM_REF_FLAG(IA1(2))/10
      IA31 = ATOM_REF_FLAG(IA1(3))/10
      IA12 = ATOM_REF_FLAG(IA1(1)) - IA11*10
      IA22 = ATOM_REF_FLAG(IA1(2)) - IA21*10
      IA32 = ATOM_REF_FLAG(IA1(3)) - IA31*10
      IF(IA12.LE.0.OR.IA22.LE.0.OR.IA32.LE.0) GOTO 10

      xyz_tmp1(1:3,1:3) = xyz_crd(1:3,ia1(1:3))
      do ia=1,3
         is = is_t(1,ia)
         tx(1:3) = is_t(2:4,ia)
         xyz_t1 = matmul(cs_ort_to_frac,xyz_tmp1(1:3,ia))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1)+
     &        cs_v_cs(1:3,is) + tx(1:3)
         xyz_tmp1(1:3,ia) = matmul(cs_frac_to_ort,xyz_t2)
      enddo

C
      DO   IX=1,3
        VECTOR1(IX) = XYZ_TMP1(IX,2) - XYZ_TMP1(IX,1)
        VECTOR2(IX) = XYZ_TMP1(IX,2) - XYZ_TMP1(IX,3)
      ENDDO
      VEC1_NORM = AMAX1(SQRT(VECTOR1(1)**2+VECTOR1(2)**2+VECTOR1(3)**2),
     &                  SMALL_BOND)
      VEC2_NORM = AMAX1(SQRT(VECTOR2(1)**2+VECTOR2(2)**2+VECTOR2(3)**2),
     &                  SMALL_BOND)

      VEC12_PROD = VECTOR1(1)*VECTOR2(1)+VECTOR1(2)*VECTOR2(2)+
     *             VECTOR1(3)*VECTOR2(3)
      COS_ANGLE = VEC12_PROD/(VEC1_NORM*VEC2_NORM)
      SIN_ANGLE = AMAX1(SQRT(1-COS_ANGLE**2),SMALL_SINE)
      ANGLE     = ACOS(AMAX1(-1.0,AMIN1(1.0,COS_ANGLE)))*RADTODEG
      DANGLE = RS_VIDL - ANGLE
      IF(ABS(DANGLE).GT.ANGLCUT*RS_SDI) THEN
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('Bond angle outliers')
          WRITE(LINE,'(A,F6.3,A)')'Bond angle deviations from the'//
     &      ' ideal >',ANGLCUT,'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          IFIRST  = 1
        ENDIF           
        IR1 = I_RESID(IA1(1))
        IR2 = I_RESID(IA1(3))
        call get_chain_namepdb(chnamp1,ir1)
        call get_chain_namepdb(chnamp2,ir2)
        WRITE(LINE,'(12A,F7.2,A,F7.2,A,F7.3,A,F7.3)')
     &               chnamp1,RES_NUM_PDB(IR1)(3:7),
     &               RES_NAME(IR1)(1:4),
     &               ATM_NAME(IA1(1))(1:4),ALT2CH(ID_ALT(IA1(1))),' - ',
     &               chnamp2,RES_NUM_PDB(IR2)(3:7),
     &               RES_NAME(IR2)(1:4),
     &               ATM_NAME(IA1(3))(1:4),ALT2CH(ID_ALT(IA1(3))),
     &               ' mod.=',ANGLE,' id.=',RS_VIDL,
     &               ' dev=',DANGLE,' sig.=',RS_SDI
        CALL ERRWRT(-1,LINE)
      ENDIF
      GOTO 10
 999  CONTINUE

C
c---Close file and return
      CLOSE(UNIT=ISCRA)
      ISCRA = 0
      END
C
      SUBROUTINE TORS_OUTLIER(ANGLE,RS_VIDL,DELTA,ITORS_PERIOD,
     &       TORS_LABEL,MON_STYLE,IA_T,TORCUT,RS_SDI,IFIRST)
C---This routine calculates derivatives of restraints corresponding to
C---torsion angles. they are strored in the file. file is opened and
C---closed at the end of program
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
C
C---Local variables
      INTEGER IA_T(4),ITORS_PERIOD,IFIRST
      REAL ANGLE,RS_VIDL,DELTA,RS_SDI,TORCUT
      CHARACTER TORS_LABEL*(*),MON_STYLE*(*)
C
      INTEGER IR1,IR2
      CHARACTER LINE*120,ALT2CH*1
      character chnamp1*4,chnamp2*4
C
      IF(MON_STYLE.EQ.'NONE'.OR.MON_STYLE.EQ.'FEW') RETURN
C
c---Check if this torsion angle has relevance. I.e. should this torsion
c---angle be included in restraints. Check is done bye name
C
C----Report
      IF(ABS(DELTA).GT.TORCUT*RS_SDI) THEN
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('Torsion angle outliers')
          WRITE(LINE,'(A,F6.3,A)')'Torsion angle deviations from the'//
     &      ' ideal >',TORCUT,'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          IFIRST  = 1
        ENDIF           
        IR1 = I_RESID(IA_T(1))
        IR2 = I_RESID(IA_T(4))
        call get_chain_namepdb(chnamp1,ir1)
        call get_chain_namepdb(chnamp2,ir2)
        WRITE(LINE,'(12A,F7.2,A,F7.2,A,I2,A,F7.2,A,F7.2)')
     &             chnamp1,RES_NUM_PDB(IR1)(3:7),
     &             RES_NAME(IR1)(1:4),
     &             ATM_NAME(IA_T(1))(1:4),ALT2CH(ID_ALT(IA_T(1))),' - ',
     &             chnamp2,RES_NUM_PDB(IR2)(3:7),
     &             RES_NAME(IR2)(1:4),
     &             ATM_NAME(IA_T(4))(1:4),ALT2CH(ID_ALT(IA_T(4))),
     &             ' mod.=',ANGLE,' id.=',RS_VIDL,
     &             ' per.=',ITORS_PERIOD,
     &             ' dev=',DELTA,' sig.=',RS_SDI
        CALL ERRWRT(-1,LINE)
      ENDIF
      RETURN
      END
C
      SUBROUTINE  CHIR_OUTLIER
c
C---This routine chiral volume outliers
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'

C
C---Local variables
      integer nr_chir
      integer i
      INTEGER ISCRC,IX,IA_C(4),IA1(4),IA12(4)
      integer LL,IFAIL,ICH,IFIRST,IR1,ICHIR_SIGN
      REAL    A(3,3),RS_VIDL,RS_SDI,RS_OBS,DELTA
      REAL DET3
      INTEGER LENSTR
      EXTERNAL LENSTR
      CHARACTER LINE*132,ALT2CH*1
      character chnamp1*4
c
      real    xyz_tmp(3,4)
      real    xyz_t1(3),xyz_t2(3)
      integer is_t(4,4)
      integer is
      real    tx(3)
C
c---- body
      ifirst = 0
      ISCRC  = 0
      IF(len_trim(chir_file).le.0) RETURN
      call open_unform_file(iscrc,chir_file,ifail)
      read(iscrc)nr_chir
 10   CONTINUE
      READ(ISCRC,END=999)IA_C(1:4),(is_t(1:4,i),i=1,4),
     &        RS_VIDL,RS_SDI,ICHIR_SIGN
      IF(RS_SDI.LE.0.0) GOTO 10
      DO   ICH = 1,4
         IF(ATOM_REF_FLAG(IA_C(ICH)).LE.0) GOTO 10
         IA1(ICH) = ATOM_REF_FLAG(IA_C(ICH))/10
         IA12(ICH) = ATOM_REF_FLAG(IA_C(ICH)) - IA1(ICH)*10
         IF(IA12(ICH).LE.0) GOTO 10
      ENDDO

      xyz_tmp(1:3,1:4) = xyz_crd(1:3,ia_c(1:4))
c
c---  symmetry
      do ich=1,4
         is = is_t(1,ich)
         tx(1:3) = float(is_t(2:4,ich))
         xyz_t1 = matmul(cs_ort_to_frac,xyz_tmp(1:3,ich))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1)+
     &        cs_v_cs(1:3,is) + tx(1:3)
         xyz_tmp(1:3,ich) = matmul(cs_frac_to_ort,xyz_t2)
      enddo
c
      do  ix=1,3
         a(1:3,ix) = xyz_tmp(1:3,ix+1)-xyz_tmp(1:3,1)
      enddo
c
      RS_OBS = DET3(A)
      IF(ICHIR_SIGN.EQ.0.AND.RS_OBS*RS_VIDL.LT.0.0) RS_VIDL = -RS_VIDL
      IF(ICHIR_SIGN.EQ.-1.AND.RS_VIDL.GT.0.0) RS_VIDL = -RS_VIDL
      IF(ICHIR_SIGN.EQ. 1.AND.RS_VIDL.LT.0.0) RS_VIDL = -RS_VIDL
      DELTA  = RS_VIDL-RS_OBS
c
c----Report outliers
      IF(ABS(DELTA).GT.CHICUT*RS_SDI) THEN
        IF(IFIRST.EQ.0) THEN
          CALL HEADER('Chiral volume outliers')
          WRITE(LINE,'(A,F6.3,A)')'Chiral volume deviations from the'//
     &      ' ideal >',CHICUT,'Sigma will be monitored'
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          IFIRST  = 1
        ENDIF  
        IR1 = I_RESID(IA_C(1))
        call get_chain_namepdb(chnamp1,ir1)
        WRITE(LINE,'(6A,F7.2,A,F7.2,A,F7.3,A,F7.3)')
     &             chnamp1,RES_NUM_PDB(IR1)(3:7),
     &             RES_NAME(IR1)(1:4),
     &             ATM_NAME(IA_C(1))(1:4),ALT2CH(ID_ALT(IA_C(1))),
     &             ' mod.=',RS_OBS,' id.=',RS_VIDL,
     &             ' dev=',DELTA,' sig.=',RS_SDI
        CALL ERRWRT(-1,LINE)
      ENDIF
      GOTO 10
c
 999  CONTINUE
      CLOSE(UNIT=ISCRC)
      ISCRC = 0
c
      RETURN
      END
C
      SUBROUTINE PLANE_OUTLIER
C---This routine calculates and monitors alrge deviation of atoms from 
C---planarity
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'


C
C---Local variables
      integer nr_plan,nmaxatom_plane
      INTEGER I,J
      INTEGER ISCRP,IA_P(50),IA1(50),IA12(50),NPLANE,
     &        NPLANE1,IPL,LL,IFAIL,IFIRST,IR1
      REAL    RS_VIDL,RS_SDI,XYZ_PLANE(3,50),VM(3),DELTA,D
      CHARACTER LINE*132,ALT2CH*1
      character chnamp1*4
c
      integer is_t(4,50)
      integer is
      real    tx(3)
      real    xyz_t1(3),xyz_t2(3)
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      IFIRST = 0
      IF(PLANE_FILE(1:1).EQ.' ') RETURN
      call open_unform_file(iscrp,plane_file,ifail)
      read(iscrp)nr_plan,nmaxatom_plane
 10   CONTINUE
      nplane = 0
      READ(ISCRP,END=999)NPLANE,RS_VIDL,RS_SDI,
     &         (IA_P(IPL),IPL=1,NPLANE),(is_t(1:4,i),i=1,nplane)
      IF(RS_SDI.LE.0.0) GOTO 10
      NPLANE1 = 0
      DO   IPL = 1,NPLANE
         IF(IA_P(IPL).LE.0) GOTO 10
         IF(ATOM_REF_FLAG(IA_P(IPL)).LE.0) GOTO 10
         IA1(IPL) = ATOM_REF_FLAG(IA_P(IPL))/10
         IA12(IPL) = ATOM_REF_FLAG(IA_P(IPL)) - IA1(IPL)*10
         IF(IA12(IPL).GT.0) THEN
           NPLANE1 = NPLANE1 + 1
           IA_P(NPLANE1) = IA_P(IPL)
         ENDIF
      ENDDO
      IF(NPLANE1.LE.0) GOTO 10
      NPLANE = NPLANE1
      xyz_plane(1:3,1:nplane) = xyz_crd(1:3,ia_p(1:nplane))
C
C---  symmetry
      do j=1,nplane
         is = is_t(1,j)
         tx(1:3) = float(is_t(2:4,j))
         xyz_t1 = matmul(cs_ort_to_frac,xyz_plane(1:3,j))
         xyz_t2 = matmul(cs_m_cs(1:3,1:3,is),xyz_t1)+
     &        cs_v_cs(1:3,is)+tx(1:3)
         xyz_plane(1:3,j) = matmul(cs_frac_to_ort,xyz_t2)
      enddo
      CALL PLANE_R(NPLANE,XYZ_PLANE,VM,D)
C
C---Calculate derivatives
      DO    J=1,NPLANE
        DELTA = D
        DO    I=1,3
          DELTA = DELTA - VM(I)*XYZ_PLANE(I,J)
        ENDDO
        IF(ABS(DELTA).GT.PLCUT*RS_SDI) THEN
          IF(IFIRST.EQ.0) THEN
            CALL HEADER('Large deviation of atoms from planarity')
            WRITE(LINE,'(A,F6.3,A)')'Deviations from the planarity >'
     &      ,PLCUT,'Sigma will be monitored'
            CALL ERRWRT(-1,LINE)
            IFIRST = 1
          ENDIF
          IR1 = I_RESID(IA_P(J))
          call get_chain_namepdb(chnamp1,ir1)
          WRITE(LINE,'(7A,F7.2,A,F7.2)')
     &             'Atom: ',chnamp1,RES_NUM_PDB(IR1)(3:7),
     &             RES_NAME(IR1)(1:4),
     &             ATM_NAME(IA_P(J))(1:4),ALT2CH(ID_ALT(IA_P(J))),
     &             ' deviation=',DELTA,' sigma.=',RS_SDI
          CALL ERRWRT(-1,LINE)          
        ENDIF
      ENDDO
      GOTO 10
 999  CONTINUE

      CLOSE(UNIT=ISCRP)
      ISCRP = 0
      RETURN
      END
C
      CHARACTER*1 FUNCTION ALT2CH(ALT_ID)
      IMPLICIT NONE
      CHARACTER ALT_ID*(*)
      ALT2CH = ' '
      IF(ALT_ID(1:1).NE.'.') ALT2CH = ALT_ID
      RETURN
      END

C
      SUBROUTINE SCALE_SHIFTS_ALL(N,NMAX,SC,DV,IERROR)
C
C-----Applies necessary scales to shifts. This routine is
C-----strongly correlated with SCALE_ALL where matrix and 
C-----vector are scaled
C
      IMPLICIT NONE
      REAL SC(*),DV(*)
      INTEGER N,NMAX,IERROR
      INTEGER I
C
      IERROR = 0
      IF(N.LE.0.OR.N.GT.NMAX) THEN
        IERROR = 1
        CALL ERRWRT(0,'In SCALE_SHIFTS_ALL. Size mismatch')
        RETURN
      ENDIF
C
      DO    I=1,N
        DV(I) = DV(I)*SC(I)
      ENDDO
      RETURN
      END 
C
      SUBROUTINE SCALE_ALL(NV1,NMAX,X,AM,SK,V,IERROR,nmodel)
c
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'

      INTEGER NV1,NO(QQD),NT(QQD),TTT(QQD),NSYM_DIST(4,QQD),LM,LV,
     &        IA,IV,IERROR,ID,KO,KT,KO1,KT1,LV1,LV2,COUNT,I,
     &        TMP,IPOS,IMG,IO,IT,IO1,IT1,LOV,LTV,IANISO,IANISO1,IPOS1,
     &        NMAX
      integer nmodel,im
      REAL    X(*),AM(*),V(*),SK(*)
C
      COMMON /DISTNS/ NO,NT,TTT,NSYM_DIST
C
      CHARACTER LINE*120
      character*12, atm_name_1,atm_name_2
c
      integer, allocatable :: u_hist(:)
c
      allocate(u_hist(n_atom))
      IERROR = 0
      LM = 1
      LV = 1
cR----Isolate the diagonal xx,yy,zz elements
      do im=1,nmodel
        DO IA = 1,N_ATOM_mod(im)
          IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            X(LV    ) = AM(LM    )
            X(LV + 1) = AM(LM + 1)
            X(LV + 2) = AM(LM + 2)
            LM        = LM + 6
            LV        = LV + 3
          ENDIF
        ENDDO
      enddo
c
      IF (ITEMP.NE.0) THEN
cR------We move the LM index to the point where ADPs elements are stored
         LM = LM + 9*NDIS
cR------Isolate the diagonal ADPs elements
         do im=1,nmodel
           DO IA = 1,N_ATOM_mod(im)
             IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
cR----------isotropic case
               IF (U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                  X(LV) = AM(LM)
                  LV    = LV + 1
                  LM    = LM + 1
               ELSE
cR------------anisotropic case
                  X(LV    ) = AM(LM    )
                  X(LV + 1) = AM(LM + 1)
                  X(LV + 2) = AM(LM + 2)
                  X(LV + 3) = AM(LM + 3)
                  X(LV + 4) = AM(LM + 4)
                  X(LV + 5) = AM(LM + 5)
                  LV        = LV + 6
                  LM        = LM + 21
               ENDIF
             ENDIF
           ENDDO
         enddo
      ENDIF
CR----Determination of the scale factors for positions and ADPs 
      DO IV = 1,NV1
         IF (X(IV).LE.0.0) THEN
cd            WRITE (LINE,'(A,I7)')' Zero or negative x at element ',IV
cd            CALL ERRWRT(-1,LINE)
           SK(IV) = 1.0
         ELSE
            SK(IV) = SQRT(1.0/X(IV))
         ENDIF
      ENDDO
C
C---First scale right hand side
      DO I = 1,NV1
         V(I) = V(I)*SK(I)
      ENDDO
c
C---- Now the scaling (conditioning) of the matrix elements is performed
c-----positional diagonal elements
      LM = 1
      LV = 1
      do im=1,nmodel
        DO IA = 1,N_ATOM_mod(im)
          IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            AM(LM    ) = 1.0
            AM(LM + 1) = 1.0
            AM(LM + 2) = 1.0
            AM(LM + 3) = AM(LM + 3)*SK(LV    )*SK(LV + 1)
            AM(LM + 4) = AM(LM + 4)*SK(LV    )*SK(LV + 2)
            AM(LM + 5) = AM(LM + 5)*SK(LV + 1)*SK(LV + 2)
            LM         = LM + 6
            LV         = LV + 3
          ENDIF
        ENDDO
      enddo
c-----positional off-diagonal elements if required
      IF (NDIS.GT.0) THEN
         DO ID = 1,NDIS
            KO  = NO(ID)
            KT  = NT(ID)
            KO1 = ATOM_REF_mod_FLAG(KO,1)/10
            KT1 = ATOM_REF_mod_FLAG(KT,1)/10
            IF ((KO1.GT.0).AND.(KT1.GT.0)) THEN
               LV1        = 3*KO1-2
               LV2        = 3*KT1-2
c               write(92,*) atm_name_1,atm_name_2,LV1,LV2 
               AM(LM    ) = AM(LM    )*SK(LV1  )*SK(LV2  )
               AM(LM + 1) = AM(LM + 1)*SK(LV1  )*SK(LV2+1)
               AM(LM + 2) = AM(LM + 2)*SK(LV1  )*SK(LV2+2)             
               AM(LM + 3) = AM(LM + 3)*SK(LV1+1)*SK(LV2  )              
               AM(LM + 4) = AM(LM + 4)*SK(LV1+1)*SK(LV2+1)             
               AM(LM + 5) = AM(LM + 5)*SK(LV1+1)*SK(LV2+2)             
               AM(LM + 6) = AM(LM + 6)*SK(LV1+2)*SK(LV2  )              
               AM(LM + 7) = AM(LM + 7)*SK(LV1+2)*SK(LV2+1)             
               AM(LM + 8) = AM(LM + 8)*SK(LV1+2)*SK(LV2+2)
               LM         = LM + 9
            ELSE
               CALL ERRWRT(1,'Problem with NO or NT')
            ENDIF
         ENDDO
      ENDIF
c
c-----ADP diagonal elements if to be refined
c
      IF (ITEMP.NE.0) THEN
c
c--------find the correct index for the atoms in the pair depending
c        on the mixture ISO/ANISO in the list before them
         COUNT =  1
         do im=1,1
           DO I = 1,N_ATOM_mod(im)
             U_HIST(I) = COUNT + NVPOS
             IF (ATOM_REF_mod_FLAG(I,im).GT.0) THEN
               IF (U_ANISO_mod(2,I,im).LE.0.0) THEN
                  COUNT = COUNT + 1
               ELSE
                  COUNT = COUNT + 6
               ENDIF
             ELSE
               U_HIST(I) = 0
             ENDIF
           ENDDO
         enddo
c                      
         do im=1,nmodel
           DO IA = 1,N_ATOM_mod(im)
             IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
               IF (U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                  AM(LM) = 1.0
                  LM     = LM + 1
                  LV     = LV + 1
               ELSE
                  DO IMG = LM,LM+5
                     AM(IMG) = 1.0
                  ENDDO
                  TMP       = SK(LV)
                  AM(LM+6 ) = AM(LM+6 )*TMP*SK(LV+1)
                  AM(LM+7 ) = AM(LM+7 )*TMP*SK(LV+2)
                  AM(LM+8 ) = AM(LM+8 )*TMP*SK(LV+3)
                  AM(LM+9 ) = AM(LM+9 )*TMP*SK(LV+4)
                  AM(LM+10) = AM(LM+10)*TMP*SK(LV+5)
                  TMP       = SK(LV+1 )
                  AM(LM+11) = AM(LM+11)*TMP*SK(LV+2)
                  AM(LM+12) = AM(LM+12)*TMP*SK(LV+3)
                  AM(LM+13) = AM(LM+13)*TMP*SK(LV+4)
                  AM(LM+14) = AM(LM+14)*TMP*SK(LV+5)
                  TMP       = SK(LV+2 )
                  AM(LM+15) = AM(LM+15)*TMP*SK(LV+3)
                  AM(LM+16) = AM(LM+16)*TMP*SK(LV+4)
                  AM(LM+17) = AM(LM+17)*TMP*SK(LV+5)
                  TMP       = SK(LV+3 )
                  AM(LM+18) = AM(LM+18)*TMP*SK(LV+4)
                  AM(LM+19) = AM(LM+19)*TMP*SK(LV+5)
                  AM(LM+20) = AM(LM+20)*SK(LV+4)*SK(LV+5)
                  LM        = LM + 21
                  LV        = LV + 6
               ENDIF
             ENDIF
           ENDDO
         enddo
c
c--------ADP off-diagonal elements if required
cd         return
         DO ID = 1,NDIS
            IO  = NO(ID)
            IT  = NT(ID)
            LOV = U_HIST(IO)
            LTV = U_HIST(IT)
            IO1 = ATOM_REF_mod_FLAG(IO,1)/10
            IT1 = ATOM_REF_mod_FLAG(IT,1)/10
            IF (IO1.GT.0.AND.IT1.GT.0) THEN
C----Case 1. Both atoms are Isotropic
               IF (U_ANISO_mod(2,IO,1).EQ.0.0 .AND.
     &             U_ANISO_mod(2,IT,1).EQ.0.0)  THEN
                  AM(LM ) = AM(LM)*SK(LOV)*SK(LTV)
                  LM      = LM  + 1
C----Case 2 and 3. One of atoms is anisotropic
               ELSEIF(U_ANISO_mod(2,IO,1).NE.0.0 .AND.
     &                U_ANISO_mod(2,IT,1).EQ.0.0) THEN
                  TMP   = SK(LTV)
                  DO IANISO=1,6

                     IPOS   = LOV + IANISO - 1
                     AM(LM) = AM(LM)*TMP*SK(IPOS)
                     LM     = LM + 1
                  ENDDO
               ELSEIF(U_ANISO_mod(2,IO,1).EQ.0.0 .AND.
     &                U_ANISO_mod(2,IT,1).NE.0.0) THEN
                  TMP   = SK(LOV)
                  DO IANISO=1,6
                     IPOS   = LTV + IANISO - 1
                     AM(LM) = AM(LM)*TMP*SK(IPOS)
                     LM     = LM + 1
                  ENDDO
C----Case 4. Both atoms are anisotropic.
               ELSEIF(U_ANISO_mod(2,IO,1).NE.0.0 .AND.
     &                U_ANISO_mod(2,IT,1).NE.0.0) THEN
                  DO IANISO = 1,6
                     IPOS = LOV + IANISO - 1
                     TMP  = SK(IPOS)
                     DO IANISO1 = 1,6
                        IPOS1  = LTV + IANISO1 - 1
                        AM(LM) = AM(LM)*TMP*SK(IPOS1)
                        LM     = LM + 1
                     ENDDO
                  ENDDO
               ENDIF
            ENDIF
         ENDDO
      ENDIF
c
      deallocate(u_hist)
      RETURN
      END
c
      SUBROUTINE MATMUL_ALL(NV1,NMAX,V1,AM,V2,IERROR,nmodel)
C
      IMPLICIT NONE
c
C-----Multiplies matrix AM to vector V1 and results are in V2
C-----This subroutine takes care of sparseness of matrix A
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
C
      integer nmodel,im
      INTEGER NV1,IERROR,NO(QQD),NT( QQD),TTT(QQD),NSYM_DIST(4,QQD)

      INTEGER I,IV,IA,ID,IO,IT,IO1,IT1,N1,N2,N11,N21,IK,LK,COUNT,IPOS,
     &        IPOS1,KO,KT,KO1,KT1,IANISO,NMAX,LWORK
      REAL    V1(*),V2(*),AM(*)
      REAL    AM11,AM12,AM13,AM14,AM15,AM16,
     &        AM21,AM22,AM23,AM24,AM25,AM26,
     &        AM31,AM32,AM33,AM34,AM35,AM36,
     &        AM41,AM42,AM43,AM44,AM45,AM46, 
     &        AM51,AM52,AM53,AM54,AM55,AM56,
     &        AM61,AM62,AM63,AM64,AM65,AM66
      REAL V11,V12,V13
      COMMON /DISTNS/ NO,NT,TTT,NSYM_DIST

      INTEGER LV1,LV2,LV3,LV4,LV5
      INTEGER LM,LV,LOV,LTV
      INTEGER LOV1,LOV2,LOV3,LOV4,LOV5,LTV1,LTV2,LTV3,LTV4,LTV5
c
      integer, allocatable :: u_hist(:)
c
      IERROR = 0

C-----initialise vector V2
      allocate(u_hist(n_atom))
      DO   IV=1,NV1
        V2(IV) = 0.0
      ENDDO
C
      LM = 1
      LV = 1
C-----Diagonal positional

      do im=1,nmodel
        DO IA = 1,N_ATOM_mod(im)
          IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            AM11 = AM(LM)
            AM22 = AM(LM+1)
            AM33 = AM(LM+2)
            AM12 = AM(LM+3)
            AM13 = AM(LM+4)
            AM23 = AM(LM+5)
            LV1 = LV + 1
            LV2 = LV + 2
            V11 = V1(LV)
            V12 = V1(LV1)
            V13 = V1(LV2)
            V2(LV )=V2(LV )+AM11*V11+AM12*V12+AM13*V13 
            V2(LV1)=V2(LV1)+AM12*V11+AM22*V12+AM23*V13
            V2(LV2)=V2(LV2)+AM13*V11+AM23*V12+AM33*V13
            LM      = LM + 6
            LV      = LV + 3
          ENDIF
        ENDDO
      enddo
cd      return
C
C-----off-diagonal positional
      IF (NDIS.gt.0) THEN
         DO ID = 1,NDIS
            IO = NO(ID)
            IT = NT(ID)
            IO1 = ATOM_REF_mod_FLAG(IO,1)/10
            IT1 = ATOM_REF_mod_FLAG(IT,1)/10
cd            IF (IO1.GT.0 .AND. IT1.GT.0) THEN
               N1  = 3*IO1-2
               N2  = 3*IT1-2
               N11 = N1 + 2
               N21 = N2 + 2
               DO IK = N1,N11
                  DO LK = N2,N21
                     V2(IK) = V2(IK) + AM(LM)*V1(LK) 
                     V2(LK) = V2(LK) + AM(LM)*V1(IK)
                     LM     = LM + 1
                  ENDDO
               ENDDO
cd            ENDIF
         ENDDO
      ENDIF
C
C-----ADP diagonal parameters
      IF (ITEMP.NE.0) THEN
        do im=1,nmodel
          DO IA = 1,N_ATOM_mod(im)
            IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
               IF (U_ANISO_mod(2,IA,im).EQ.0.0) THEN
C-----------------Atom is isotropic
                  V2(LV) = AM(LM)*V1(LV)
                  LV     = LV + 1
                  LM     = LM + 1
               ELSE
C---Atom is anisotropic
                  AM11 = AM(LM)
                  AM22 = AM(LM+ 1)
                  AM33 = AM(LM+ 2)
                  AM44 = AM(LM+ 3)
                  AM55 = AM(LM+ 4)
                  AM66 = AM(LM+ 5)
                  AM12 = AM(LM+ 6)
                  AM13 = AM(LM+ 7)
                  AM14 = AM(LM+ 8)
                  AM15 = AM(LM+ 9)
                  AM16 = AM(LM+10)
                  AM23 = AM(LM+11)
                  AM24 = AM(LM+12)
                  AM25 = AM(LM+13)
                  AM26 = AM(LM+14)
                  AM34 = AM(LM+15)
                  AM35 = AM(LM+16)
                  AM36 = AM(LM+17)
                  AM45 = AM(LM+18)
                  AM46 = AM(LM+19)
                  AM56 = AM(LM+20)
                  LV1  = LV+1
                  LV2  = LV+2
                  LV3  = LV+3
                  LV4  = LV+4
                  LV5   = LV+5
                  V2(LV  ) = V2(LV  ) +
     +                                   AM11*V1(LV  )+
     +                                   AM12*V1(LV1)+
     +                                   AM13*V1(LV2)+
     +                                   AM14*V1(LV3)+
     +                                   AM15*V1(LV4)+
     +                                   AM16*V1(LV5)
                  V2(LV1 ) = V2(LV1 ) +
     +                                   AM12*V1(LV  )+
     +                                   AM22*V1(LV1)+
     +                                   AM23*V1(LV2)+
     +                                   AM24*V1(LV3)+
     +                                   AM25*V1(LV4)+
     +                                   AM26*V1(LV5)

                  V2(LV2 ) = V2(LV2 ) +
     +                                   AM13*V1(LV  )+
     +                                   AM23*V1(LV1)+
     +                                   AM33*V1(LV2)+
     +                                   AM34*V1(LV3)+
     +                                   AM35*V1(LV4)+
     +                                   AM36*V1(LV5)
                  V2(LV3 ) = V2(LV3 ) +
     +                                   AM14*V1(LV  )+
     +                                   AM24*V1(LV1)+
     +                                   AM34*V1(LV2)+
     +                                   AM44*V1(LV3)+
     +                                   AM45*V1(LV4)+
     +                                   AM46*V1(LV5)
                  V2(LV4 ) = V2(LV4 ) +
     +                                   AM15*V1(LV  )+
     +                                   AM25*V1(LV1)+
     +                                   AM35*V1(LV2)+
     +                                   AM45*V1(LV3)+
     +                                   AM55*V1(LV4)+
     +                                   AM56*V1(LV5)
                  V2(LV5 ) = V2(LV5 ) +
     +                                   AM16*V1(LV  )+
     +                                   AM26*V1(LV1)+
     +                                   AM36*V1(LV2)+
     +                                   AM46*V1(LV3)+
     +                                   AM56*V1(LV4)+
     +                                   AM66*V1(LV5)

                  LM = LM + 21
                  LV = LV + 6
               ENDIF
             ENDIF
           ENDDO            
         enddo
cdC
C---Distance blocks
C
cd         return
        COUNT =  1
        do im=1,1
           DO I = 1,N_ATOM_mod(im)
             IF (ATOM_REF_mod_FLAG(I,im).GT.0) THEN
               U_HIST(I) = COUNT + NVPOS
               IF (U_ANISO_mod(2,I,im).LE.0.0) THEN
                  COUNT = COUNT + 1
               ELSE
                  COUNT = COUNT + 6
               ENDIF
             ELSE
               U_HIST(I) = 0
             ENDIF
           ENDDO   
         enddo
c
cd         RETURN
         DO ID = 1,NDIS
            IO = NO(ID)
            IT = NT(ID)
            IO1 = ATOM_REF_mod_FLAG(IO,1)/10
            IT1 = ATOM_REF_mod_FLAG(IT,1)/10
cd            IF (IO1.GT.0.AND.IT1.GT.0) THEN
               LOV = U_HIST(IO)
               LTV = U_HIST(IT)
C--------------Case 1. IO and IT are isotropic
               IF (U_ANISO_mod(2,IO,1).EQ.0.0 .AND.
     &             U_ANISO_mod(2,IT,1).EQ.0.0) THEN
                  V2(LOV) = V2(LOV) + AM(LM)*V1(LTV)
                  V2(LTV) = V2(LTV) + AM(LM)*V1(LOV)
                  LM = LM + 1
C-------------Case 2. IO is anisotropic and IT is isotropic
               ELSEIF (U_ANISO_mod(2,IO,1).NE.0.0 .AND.
     &                 U_ANISO_mod(2,IT,1).EQ.0.0) THEN
                  IPOS1 = LTV
                  DO IANISO    = 1,6
                     IPOS      = LOV + IANISO - 1
                     V2(IPOS ) = V2(IPOS ) + AM(LM)*V1(IPOS1)
                     V2(IPOS1) = V2(IPOS1) + AM(LM)*V1(IPOS )
                     LM        = LM + 1
                  ENDDO
C-------------Case 3. IO is isotropic and IT is anisotropic
               ELSEIF (U_ANISO_mod(2,IO,im).EQ.0.0 .AND.
     &                 U_ANISO_mod(2,IT,im).NE.0.0) THEN
                  IPOS1 = LOV
                  DO IANISO  = 1,6
                     IPOS      = LTV + IANISO - 1
                     V2(IPOS ) = V2(IPOS ) + AM(LM)*V1(IPOS1)
                     V2(IPOS1) = V2(IPOS1) + AM(LM)*V1(IPOS )
                     LM        = LM + 1
                  ENDDO
C-------------Case 4. Both atoms are anisotropic
               ELSE 
                 AM11 = AM(LM  )
                 AM12 = AM(LM+1)
                 AM13 = AM(LM+2)
                 AM14 = AM(LM+3)
                 AM15 = AM(LM+4)
                 AM16 = AM(LM+5)
                 AM21 = AM(LM+6)
                 AM22 = AM(LM+7)
                 AM23 = AM(LM+8)
                 AM24 = AM(LM+9)
                 AM25 = AM(LM+10)
                 AM26 = AM(LM+11)
                 AM31 = AM(LM+12)
                 AM32 = AM(LM+13)
                 AM33 = AM(LM+14)
                 AM34 = AM(LM+15)
                 AM35 = AM(LM+16)
                 AM36 = AM(LM+17)
                 AM41 = AM(LM+18)
                 AM42 = AM(LM+19)
                 AM43 = AM(LM+20)
                 AM44 = AM(LM+21)
                 AM45 = AM(LM+22)
                 AM46 = AM(LM+23)
                 AM51 = AM(LM+24)
                 AM52 = AM(LM+25)
                 AM53 = AM(LM+26)
                 AM54 = AM(LM+27)
                 AM55 = AM(LM+28)
                 AM56 = AM(LM+29)
                 AM61 = AM(LM+30)
                 AM62 = AM(LM+31)
                 AM63 = AM(LM+32)
                 AM64 = AM(LM+33)
                 AM65 = AM(LM+34)
                 AM66 = AM(LM+35)
                 LOV1 = LOV+1
                 LOV2 = LOV+2
                 LOV3 = LOV+3
                 LOV4 = LOV+4
                 LOV5 = LOV+5
                 LTV1 = LTV+1
                 LTV2 = LTV+2
                 LTV3 = LTV+3
                 LTV4 = LTV+4
                 LTV5 = LTV+5
                 V2(LOV  ) = V2(LOV  ) +
     +                                  AM11*V1(LTV  ) +
     +                                  AM12*V1(LTV1) +
     +                                  AM13*V1(LTV2) +
     +                                  AM14*V1(LTV3) +
     +                                  AM15*V1(LTV4) + 
     +                                  AM16*V1(LTV5)
                 V2(LOV1 ) = V2(LOV1 ) +
     +                                  AM21*V1(LTV  ) +
     +                                  AM22*V1(LTV1) +
     +                                  AM23*V1(LTV2) +
     +                                  AM24*V1(LTV3) +
     +                                  AM25*V1(LTV4) + 
     +                                  AM26*V1(LTV5)
                 V2(LOV2 ) = V2(LOV2 ) +
     +                                  AM31*V1(LTV  ) +
     +                                  AM32*V1(LTV1) +
     +                                  AM33*V1(LTV2) +
     +                                  AM34*V1(LTV3) +
     +                                  AM35*V1(LTV4) + 
     +                                  AM36*V1(LTV5)
                 V2(LOV3 ) = V2(LOV3 ) +
     +                                  AM41*V1(LTV  ) +
     +                                  AM42*V1(LTV1) +
     +                                  AM43*V1(LTV2) +
     +                                  AM44*V1(LTV3) +
     +                                  AM45*V1(LTV4) + 
     +                                  AM46*V1(LTV5)
                 V2(LOV4 ) = V2(LOV4 ) +
     +                                  AM51*V1(LTV  ) +
     +                                  AM52*V1(LTV1) +
     +                                  AM53*V1(LTV2) +
     +                                  AM54*V1(LTV3) +
     +                                  AM55*V1(LTV4) + 
     +                                  AM56*V1(LTV5)
                 V2(LOV5 ) = V2(LOV5 ) +
     +                                  AM61*V1(LTV  ) +
     +                                  AM62*V1(LTV1) +
     +                                  AM63*V1(LTV2) +
     +                                  AM64*V1(LTV3) +
     +                                  AM65*V1(LTV4) + 
     +                                  AM66*V1(LTV5)
c
                 V2(LTV  ) = V2(LTV  ) +
     +                                  AM11*V1(LOV  ) +
     +                                  AM21*V1(LOV1) +
     +                                  AM31*V1(LOV2) +
     +                                  AM41*V1(LOV3) +
     +                                  AM51*V1(LOV4) + 
     +                                  AM61*V1(LOV5)
                 V2(LTV1 ) = V2(LTV1 ) +
     +                                  AM12*V1(LOV  ) +
     +                                  AM22*V1(LOV1) +
     +                                  AM32*V1(LOV2) +
     +                                  AM42*V1(LOV3) +
     +                                  AM52*V1(LOV4) + 
     +                                  AM62*V1(LOV5)
                 V2(LTV2 ) = V2(LTV2 ) +
     +                                  AM13*V1(LOV  ) +
     +                                  AM23*V1(LOV1) +
     +                                  AM33*V1(LOV2) +
     +                                  AM43*V1(LOV3) +
     +                                  AM53*V1(LOV4) + 
     +                                  AM63*V1(LOV5)
                 V2(LTV3 ) = V2(LTV3 ) +
     +                                  AM14*V1(LOV  ) +
     +                                  AM24*V1(LOV1) +
     +                                  AM34*V1(LOV2) +
     +                                  AM44*V1(LOV3) +
     +                                  AM54*V1(LOV4) + 
     +                                  AM64*V1(LOV5)
                 V2(LTV4 ) = V2(LTV4 ) +
     +                                  AM15*V1(LOV  ) +
     +                                  AM25*V1(LOV1) +
     +                                  AM35*V1(LOV2) +
     +                                  AM45*V1(LOV3) +
     +                                  AM55*V1(LOV4) + 
     +                                  AM65*V1(LOV5)
                 V2(LTV5 ) = V2(LTV5 ) +
     +                                  AM16*V1(LOV  ) +
     +                                  AM26*V1(LOV1) +
     +                                  AM36*V1(LOV2) +
     +                                  AM46*V1(LOV3) +
     +                                  AM56*V1(LOV4) + 
     +                                  AM66*V1(LOV5)
               
                 LM = LM + 36
               ENDIF
cd            ENDIF
         ENDDO
      ENDIF
c
      deallocate(u_hist)
      RETURN
      END
C
      SUBROUTINE INV_SCALE_ALL(NV1,NMAX,X,AM,SK,V,IERROR,nmodel)
c
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'

      integer nmodel,im
      INTEGER NV1,NO(QQD),NT(QQD),TTT(QQD),NSYM_DIST(4,QQD),LM,LV,
     &        IA,IV,IERROR,ID,KO,KT,KO1,KT1,LV1,LV2,COUNT,I,
     &        TMP,IPOS,IMG,IO,IT,IO1,IT1,LOV,LTV,IANISO,IANISO1,IPOS1,
     &        NMAX
      REAL    X(*),AM(*),V(*),SK(*)
C
      COMMON /DISTNS/ NO,NT,TTT,NSYM_DIST
C
      CHARACTER LINE*120
      character*12, atm_name_1,atm_name_2
c
      integer, allocatable :: u_hist(:)
c
      allocate(u_hist(n_atom))
      DO IV = 1,NV1
            SK(IV) = 1.0/SK(IV)
      ENDDO
c
C---- Now the scaling (conditioning) of the matrix elements is performed
c-----positional diagonal elements
      LM = 1
      LV = 1
      do im=1,nmodel
        DO IA = 1,N_ATOM_mod(im)
          IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            AM(LM    ) = 1.0
            AM(LM + 1) = 1.0
            AM(LM + 2) = 1.0
            AM(LM + 3) = AM(LM + 3)*SK(LV    )*SK(LV + 1)
            AM(LM + 4) = AM(LM + 4)*SK(LV    )*SK(LV + 2)
            AM(LM + 5) = AM(LM + 5)*SK(LV + 1)*SK(LV + 2)
            LM         = LM + 6
            LV         = LV + 3
          ENDIF
        ENDDO
      enddo
c-----positional off-diagonal elements if required
      IF (NDIS.GT.0) THEN
         DO ID = 1,NDIS
            KO  = NO(ID)
            KT  = NT(ID)
            KO1 = ATOM_REF_mod_FLAG(KO,1)/10
            KT1 = ATOM_REF_mod_FLAG(KT,1)/10
            IF ((KO1.GT.0).AND.(KT1.GT.0)) THEN
               LV1        = 3*KO1-2
               LV2        = 3*KT1-2
c               write(92,*) atm_name_1,atm_name_2,LV1,LV2 
               AM(LM    ) = AM(LM    )*SK(LV1  )*SK(LV2  )
               AM(LM + 1) = AM(LM + 1)*SK(LV1  )*SK(LV2+1)
               AM(LM + 2) = AM(LM + 2)*SK(LV1  )*SK(LV2+2)             
               AM(LM + 3) = AM(LM + 3)*SK(LV1+1)*SK(LV2  )              
               AM(LM + 4) = AM(LM + 4)*SK(LV1+1)*SK(LV2+1)             
               AM(LM + 5) = AM(LM + 5)*SK(LV1+1)*SK(LV2+2)             
               AM(LM + 6) = AM(LM + 6)*SK(LV1+2)*SK(LV2  )              
               AM(LM + 7) = AM(LM + 7)*SK(LV1+2)*SK(LV2+1)             
               AM(LM + 8) = AM(LM + 8)*SK(LV1+2)*SK(LV2+2)
               LM         = LM + 9
            ELSE
               CALL ERRWRT(1,'Problem with NO or NT')
            ENDIF
         ENDDO
      ENDIF
c
c-----ADP diagonal elements if to be refined
c
      IF (ITEMP.NE.0) THEN
c
c--------find the correct index for the atoms in the pair depending
c        on the mixture ISO/ANISO in the list before them
         COUNT = 1
         do im=1,1
           DO I = 1,N_ATOM_mod(im)
             IF (ATOM_REF_mod_FLAG(I,im).GT.0) THEN
               U_HIST(I) = COUNT + NVPOS
               IF (U_ANISO_mod(2,I,im).LE.0.0) THEN
                  COUNT = COUNT + 1
               ELSE
                  COUNT = COUNT + 6
               ENDIF
             ELSE
               U_HIST(I) = 0
             ENDIF
           ENDDO
         enddo
c                      
         do im=1,nmodel
           DO IA = 1,N_ATOM_mod(im)
             IF (ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
               IF (U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                  AM(LM) = 1.0
                  LM     = LM + 1
                  LV     = LV + 1
               ELSE
                  DO IMG = LM,LM+5
                     AM(IMG) = 1.0
                  ENDDO
                  TMP       = SK(LV)
                  AM(LM+6 ) = AM(LM+6 )*TMP*SK(LV+1)
                  AM(LM+7 ) = AM(LM+7 )*TMP*SK(LV+2)
                  AM(LM+8 ) = AM(LM+8 )*TMP*SK(LV+3)
                  AM(LM+9 ) = AM(LM+9 )*TMP*SK(LV+4)
                  AM(LM+10) = AM(LM+10)*TMP*SK(LV+5)
                  TMP       = SK(LV+1 )
                  AM(LM+11) = AM(LM+11)*TMP*SK(LV+2)
                  AM(LM+12) = AM(LM+12)*TMP*SK(LV+3)
                  AM(LM+13) = AM(LM+13)*TMP*SK(LV+4)
                  AM(LM+14) = AM(LM+14)*TMP*SK(LV+5)
                  TMP       = SK(LV+2 )
                  AM(LM+15) = AM(LM+15)*TMP*SK(LV+3)
                  AM(LM+16) = AM(LM+16)*TMP*SK(LV+4)
                  AM(LM+17) = AM(LM+17)*TMP*SK(LV+5)
                  TMP       = SK(LV+3 )
                  AM(LM+18) = AM(LM+18)*TMP*SK(LV+4)
                  AM(LM+19) = AM(LM+19)*TMP*SK(LV+5)
                  AM(LM+20) = AM(LM+20)*SK(LV+4)*SK(LV+5)
                  LM        = LM + 21
                  LV        = LV + 6
               ENDIF
             ENDIF
           ENDDO
         enddo
c
c--------ADP off-diagonal elements if required
         DO ID = 1,NDIS
            IO  = NO(ID)
            IT  = NT(ID)
            LOV = U_HIST(IO)
            LTV = U_HIST(IT)
            IO1 = ATOM_REF_mod_FLAG(IO,1)/10
            IT1 = ATOM_REF_mod_FLAG(IT,1)/10
            IF (IO1.GT.0.AND.IT1.GT.0) THEN
C----Case 1. Both atoms are Isotropic
               IF (U_ANISO_mod(2,IO,im).EQ.0.0 .AND.
     &             U_ANISO_mod(2,IT,im).EQ.0.0) THEN
                  AM(LM ) = AM(LM)*SK(LOV)*SK(LTV)
                  LM      = LM  + 1
C----Case 2 and 3. One of atoms is anisotropic
               ELSEIF(U_ANISO_mod(2,IO,im).NE.0.0 .AND.
     &                U_ANISO_mod(2,IT,im).EQ.0.0) THEN
                  TMP   = SK(LTV)
                  DO IANISO=1,6

                     IPOS   = LOV + IANISO - 1
                     AM(LM) = AM(LM)*TMP*SK(IPOS)
                     LM     = LM + 1
                  ENDDO
               ELSEIF(U_ANISO_mod(2,IO,im).EQ.0.0 .AND.
     &                U_ANISO_mod(2,IT,im).NE.0.0) THEN
                  TMP   = SK(LOV)
                  DO IANISO=1,6
                     IPOS   = LTV + IANISO - 1
                     AM(LM) = AM(LM)*TMP*SK(IPOS)
                     LM     = LM + 1
                  ENDDO
C----Case 4. Both atoms are anisotropic.
               ELSEIF(U_ANISO_mod(2,IO,im).NE.0.0.AND.
     &                U_ANISO_mod(2,IT,im).NE.0.0)THEN
                  DO IANISO = 1,6
                     IPOS = LOV + IANISO - 1
                     TMP  = SK(IPOS)
                     DO IANISO1 = 1,6
                        IPOS1  = LTV + IANISO1 - 1
                        AM(LM) = AM(LM)*TMP*SK(IPOS1)
                        LM     = LM + 1
                     ENDDO
                  ENDDO
               ENDIF
            ENDIF
         ENDDO
      ENDIF
c
      DO I = 1,NV1
         V(I) = V(I)*SK(I)
      ENDDO
      deallocate(u_hist)
      RETURN
      END
C

      subroutine harm_ref(qqm,am)
      implicit none
      include 'atom_com.fh'
      include 'restr_files.fh'
c
      integer qqm
      real am(qqm)
c
c---locals
      integer iharm,iend,ierr
      integer nharms
      integer i,irest_type,ia1,ia11,ipos_m
      real sigma,w
c
c---  body
      if(len_trim(harmonic_file).le.0) return
      call open_unform_file(iharm,harmonic_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with harmonic_file'
         return
      endif
c     
      nharms = 0
      read(iharm,iostat=iend)nharms
      if(iend.ne.0.or.nharms.le.0) then
         close(iharm)
         return
      endif
      do i=1,nharms
         read(iharm,iostat=iend)ia1,sigma,irest_type
         if(irest_type.eq.1.and.iend.eq.0) then
            if(sigma.gt.0.0.and.ia1.gt.0) then
               ia11 = atom_ref_flag(ia1)/10
               if(ia11.gt.0) then
                  w            = 1/sigma**2
                  ipos_m       = 6*(ia11-1)
                  am(ipos_m+1) = am(ipos_m+1) + w
                  am(ipos_m+2) = am(ipos_m+2) + w
                  am(ipos_m+3) = am(ipos_m+3) + w
               endif
            endif
         endif
      enddo
      close(iharm)
      return
      end
c
      subroutine spec_ref(sumspec,qqm,qqv,am,v)
      implicit none
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---Restraints to keep defined atoms in a special positio
      integer qqv,qqm
      real am(qqm),v(qqv)
      real sumspec
c
      integer iharm,iend,nharms
      integer irest_type
      integer ia1,ia11,ns_l
      integer i,is,ipos_v,ipos_m
      integer ierr
      real    sigma
      real    w
      real    xyz_0(3),xyz_1(3),xyz_2(3),xyz_3(3)
      integer itx(3)
      real tx(3),t_aver(3),vec1(3),vec2(3)
      real ident(3,3),a_aver(3,3),a_mat(3,3),a_mat2(3,3)
c
      real small_b
      data small_b/0.5/

c
      sumspec = 0.0
      ident(1:3,1:3)=0.0
      ident(1,1) = 1.0
      ident(2,2) = 1.0
      ident(3,3) = 1.0
      if(len_trim(harmonic_file).le.0) return
      call open_unform_file(iharm,harmonic_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with harmonic_file'
         return
      endif
c     
      nharms = 0
      read(iharm,iostat=iend)nharms
      if(iend.ne.0.or.nharms.le.0) then
         close(iharm)
         return
      endif
      do i=1,nharms
         read(iharm,iostat=iend)ia1,sigma,irest_type
         if(irest_type.eq.2.and.iend.eq.0.and.ia1.gt.0) then
            ia11 = atom_ref_flag(ia1)/10
            if(sigma.le.0.0) sigma = 0.1
            w = 1/sigma**2
            xyz_0 = xyz_crd(1:3,ia1)
            ns_l = 1
            a_aver = ident
            t_aver = 0.0
            do is=2,cs_nsym
               xyz_1 = matmul(cs_ort_to_frac,xyz_0)
               tx(1:3) = cs_v_cs(1:3,is)
               xyz_2 = matmul(cs_m_cs(1:3,1:3,is),xyz_1)+cs_v_cs(1:3,is)
               call find_closest_xyz(xyz_1,xyz_2,itx)
               xyz_2 = xyz_2 + float(itx)
               xyz_3 = matmul(cs_frac_to_ort,xyz_2)
               if(sqrt(sum(xyz_3-xyz_0)**2).le.small_b) then
                  ns_l = ns_l + 1
                  a_aver = a_aver + matmul(cs_frac_to_ort,
     &                 matmul(cs_m_cs(1:3,1:3,is),cs_ort_to_frac))
                  tx = tx + float(itx)
                  t_aver = t_aver + matmul(cs_frac_to_ort,tx)
               endif
            enddo
            if(ns_l.gt.1) then
               a_mat = ident - a_aver/ns_l
               t_aver = t_aver/ns_l
            endif
            vec1 = matmul(a_mat,xyz_0)-t_aver
            sumspec = sumspec + w*sum(vec1**2)
            vec2 = matmul(transpose(a_mat),vec1)
            ipos_v = 3*(ia11-1)
            ipos_m = 6*(ia11-1)
            v((ipos_v+1):(ipos_v+3))=v((ipos_v+1):(ipos_v+3))+vec2
            a_mat2 = matmul(transpose(a_mat),a_mat)
            am(ipos_m+1) = am(ipos_m+1) + w*a_mat2(1,1)
            am(ipos_m+2) = am(ipos_m+2) + w*a_mat2(2,2)
            am(ipos_m+3) = am(ipos_m+3) + w*a_mat2(3,3)
            am(ipos_m+4) = am(ipos_m+4) + w*a_mat2(1,2)
            am(ipos_m+5) = am(ipos_m+5) + w*a_mat2(1,3)
            am(ipos_m+6) = am(ipos_m+6) + w*a_mat2(2,3)
         endif
      enddo
      close(iharm)
      return
      end
c
      subroutine noe_ref(sumnmr,qqm,qqv,av,v)
      implicit none
c
      integer qqm,qqv
      real sumnmr
      real av(*),v(*)
c
c---  body
      sumnmr = 0

      return
      end
