
      subroutine asym_list(maxsym,nsym,rot,tr,cell,
     &     nrefl,res_max,hkl_list)
      implicit none
c
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer nrefl
      real res_max
      integer hkl_list(3,nrefl)
c
c--local parameters
      integer hmax,kmax,lmax
      integer h,k,l,is
      integer hhh(3),hkl_l(3)
      integer isysabs,icent
      real ast,bst,cst,cosast,cosbst,coscst
      real rs,rsq,epsl,epsi
      real degtor
      real lstlsq
      external lstlsq
      integer i,nrefl_l
      integer itemp
      integer hsym,ksym,lsym,hcur,kcur,lcur
      integer ir
C--Make sure cell angles are in radians
C
      degtor = 4.0*atan2(1.0,1.0)/180.0
      if(cell(4).gt.4.0.and.cell(5).gt.4.0.and.cell(6).gt.4.0) then
        cell(4) = cell(4)*degtor
        cell(5) = cell(5)*degtor
        cell(6) = cell(6)*degtor
      endif
C
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      call find_max_hkl(res_max,cell,hmax,kmax,lmax)
C
      nrefl_l = 0
C
C---loop over sphere and take only unique reflections
      do   l=-lmax,lmax
        do  k=-kmax,kmax
          do   h=-hmax,hmax
C
c--If this reflection is inside resolution limit and 
C--it is present by symmetry then account it
C
             if(h.eq.0.and.k.eq.0.and.l.eq.0) goto 200
             hhh(1) = h
             hhh(2) = k
             hhh(3) = l
             call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
             rs = sqrt(rsq)/2.0
             if(rs.gt.res_max) goto 200

             call sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
             if(isysabs.eq.1) goto 200
             do is = 1,nsym
                hkl_l(3)=nint(rot(1,3,is)*h+
     &                        rot(2,3,is)*k+
     &                        rot(3,3,is)*l) 
C
C---If at least one of the symmety related is greater than this 
c   reflection 
c---then go out of the symmetry loop and do not take this reflection 
c---into account
               if(hkl_l(3).gt.l) then
                  goto 200
               else if(hkl_l(3).eq.l) then
                 hkl_l(2)=nint(rot(1,2,is)*h+
     &                         rot(2,2,is)*k+
     &                         rot(3,2,is)*l)
                 if(hkl_l(2).gt.k) then
                   goto 200
                 else if(hkl_l(2).eq.k) then
                   hkl_l(1)=nint(rot(1,1,is)*h+
     &                           rot(2,1,is)*k+
     &                           rot(3,1,is)*l)
                   if(hkl_l(1).gt.h) then
                     goto 200
                   endif
                 endif
               endif  
c
c---consider -h,-k,-l
               hkl_l(3)=-nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
C
C---If at least one of the symmety related is less than this reflection 
c---then go out oof the symmetry loop and do not take this reflection 
c---into account
C
               if(hkl_l(3).gt.l) then
                 goto 200
               else if(hkl_l(3).eq.l) then
                 hkl_l(2)=-nint(rot(1,2,is)*h+rot(2,2,is)*k+
     &                                       rot(3,2,is)*l)
                 if(hkl_l(2).gt.k) then
                   goto 200
                 else if(hkl_l(2).eq.k) then
                   hkl_l(1)=-nint(rot(1,1,is)*h+rot(2,1,is)*k+
     &                                         rot(3,1,is)*l)
                   if(hkl_l(1).gt.h) then
                     goto 200
                   endif
                 endif
               endif  
             enddo
C
C--this reflection is maximum among all symmetry related. Take it.
C 
             nrefl_l = nrefl_l + 1
             hkl_list(1,nrefl_l) = h
             hkl_list(2,nrefl_l) = k
             hkl_list(3,nrefl_l) = l
            
C--Do we need to add centricity and epslon into this array?
C
 200         continue
          enddo
        enddo
      enddo
c
c     Do we need sorting. By nature of
c     generation of the list it has the required sorting order (h fastest, 
c     k second and l slowest)
      do  i=1,nrefl_l
        itemp = hkl_list(3,i)
        hkl_list(3,i) = hkl_list(1,i)
        hkl_list(1,i) = itemp
      enddo
      call  iheap_sort_0(nrefl_l,3,hkl_list)
      do  i=1,nrefl_l
        itemp = hkl_list(3,i)
        hkl_list(3,i) = hkl_list(1,i)
        hkl_list(1,i) = itemp
      enddo
      return
      end
C
      subroutine asym_list_size(maxsym,nsym,rot,tr,cell,nrefl,res_max)
      implicit none
c
      real res_max
      integer nrefl
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
C
C--   local parameters
      integer hmax,kmax,lmax
      integer h,k,l,is
      integer i,j
      integer hhh(3),hkl_l(3)
      integer isysabs,icent
      real ast,bst,cst,cosast,cosbst,coscst
      real rs,rsq,epsl,epsi
      real degtor
      real lstlsq
      external lstlsq
C
C--Make sure cell angles are in radians
C
      degtor = 4.0*atan2(1.0,1.0)/180.0
      if(cell(4).gt.4.0.and.cell(5).gt.4.0.and.cell(6).gt.4.0) then
         cell(4) = cell(4)*degtor
         cell(5) = cell(5)*degtor
         cell(6) = cell(6)*degtor
      endif
C
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      call find_max_hkl(res_max,cell,hmax,kmax,lmax)
C
      nrefl = 0
C
C---loop over hemisphere and take only unique reflections
C
      do   l=-lmax,lmax
         do  k=-kmax,kmax
            do   h=-hmax,hmax
C
c--If this reflection is inside resolution limit and 
C--it is present by symmetry then account itt
C
               if(h.eq.0.and.k.eq.0.and.l.eq.0) goto 200
               hhh(1) = h
               hhh(2) = k
               hhh(3) = l
               call define_res(h,k,l,ast,bst,cst,
     &              cosast,cosbst,coscst,rsq)
               rs = sqrt(rsq)/2.0
               if(rs.gt.res_max) goto 200
               call sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
               if(isysabs.eq.1) goto 200
               do is = 1,nsym
                  hkl_l(3)=
     &                 nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
C
C---If at least one of the symmety related is less than this reflection 
c---then go out oof the symmetry loop and do not take this reflection 
c---into account
C
                  if(hkl_l(3).gt.l) then
                     goto 200
                  else if(hkl_l(3).eq.l) then
                     hkl_l(2)=nint(rot(1,2,is)*h+rot(2,2,is)*k+
     &                    rot(3,2,is)*l)
                     if(hkl_l(2).gt.k) then
                        goto 200
                     else if(hkl_l(2).eq.k) then
                        hkl_l(1)=nint(rot(1,1,is)*h+rot(2,1,is)*k+
     &                       rot(3,1,is)*l)
                        if(hkl_l(1).gt.h) then
                           goto 200
                        endif
                     endif
                  endif  
c
c---consider -h,-k,-l
                  hkl_l(3)=
     &                 -nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
C
C---If at least one of the symmety related is less than this reflection 
c---then go out oof the symmetry loop and do not take this reflection 
c---into account
C
                  if(hkl_l(3).gt.l) then
                     goto 200
                  else if(hkl_l(3).eq.l) then
                     hkl_l(2)=-nint(rot(1,2,is)*h+rot(2,2,is)*k+
     &                    rot(3,2,is)*l)
                     if(hkl_l(2).gt.k) then
                        goto 200
                     else if(hkl_l(2).eq.k) then
                        hkl_l(1)=-nint(rot(1,1,is)*h+rot(2,1,is)*k+
     &                       rot(3,1,is)*l)
                        if(hkl_l(1).gt.h) then
                           goto 200
                        endif
                     endif
                  endif  
               enddo
C
C--this reflection is minimum among all symmetry related. Take it.
C 
               nrefl = nrefl + 1
 200           continue
            enddo
         enddo
      enddo

      return
      end
C
      subroutine abcd_2_asym(nasym,hkl_asym,abcd_file)
c
      implicit none
      integer nasym
      integer hkl_asym(3,nasym)
c
      character abcd_file*(*)
c
      real, allocatable :: abcd(:,:)
      integer, allocatable :: hkl_l(:,:)
     
      integer nph_refl
      integer i,j,k
      integer ifail,ll,in_file

      ifail = -1
      in_file = 0
      ll = 0
      call ccpdpn(in_file,abcd_file,'UNKOWN','U',ll,ifail)
c
      read(in_file)nph_refl
      if(.not.allocated(abcd)) allocate(abcd(4,nph_refl))
      if(.not.allocated(hkl_l)) allocate(hkl_l(3,nph_refl))

      do   i=1,nph_refl
        read(in_file)(hkl_l(j,i),j=1,3),(abcd(k,i),k=1,4)
      enddo
c
c   Now find reference to the asymmetric unit
c
      do  i=1,nph_refl

      enddo
      deallocate(abcd)
      deallocate(hkl_l)
      return
      end
c

      subroutine find_max_hkl(res_max,cell,hmax,kmax,lmax)
      implicit none
c
c--Input parameters
c    res_max = maximum resolution as 2sin(theta)/lambda
C    hmax
c    kmax
c    lmax      maximum miller indices
c    ast
c    bst
c    cst
c    cosast
c    cosbst
c    coscst   reciprocal space cell parameters and their cosines
c
      real res_max
      real cell(6)
      real sina,cosa,sinb,cosb,sinc,cosc
      real vol,volunit
      real ast,bst,cst,cosast,cosbst,coscst,sinast,sinbst,sincst
      real coshst,coskst,coslst
      integer hmax,kmax,lmax
C
     
      cosa = cos(cell(4))
      cosb = cos(cell(5))
      cosc = cos(cell(6))
      sina = sin(cell(4))
      sinb = sin(cell(5))
      sinc = sin(cell(6))
      volunit = sqrt(1.0-cosa**2-cosb**2-cosc**2+2.0*cosa*cosb*cosc)
      vol = cell(1)*cell(2)*cell(3)*volunit
      ast = cell(2)*cell(3)*sina/vol
      bst = cell(1)*cell(3)*sinb/vol
      cst = cell(1)*cell(2)*sinc/vol
      cosast = (cosb*cosc-cosa)/(sinb*sinc)
      cosbst = (cosa*cosc-cosb)/(sina*sinc)
      coscst = (cosa*cosb-cosc)/(sina*sinb)
      sinast = vol/(cell(1)*cell(2)*cell(3)*sinb*sinc)
      sinbst = vol/(cell(1)*cell(2)*cell(3)*sina*sinc)
      sincst = vol/(cell(1)*cell(2)*cell(3)*sina*sinb)
      coslst = sqrt(1-cosast**2-cosbst**2-coscst**2+
     &            2.0*cosast*cosbst*coscst)/sincst
      coskst = sqrt(1-cosast**2-cosbst**2-coscst**2+
     &            2.0*cosast*cosbst*coscst)/sinbst
      coshst =  sqrt(1-cosast**2-cosbst**2-coscst**2+
     &            2.0*cosast*cosbst*coscst)/sinast
C
      hmax = nint(2.0*res_max/(ast*coshst)) + 1
      kmax = nint(2.0*res_max/(bst*coskst)) + 1
      lmax = nint(2.0*res_max/(cst*coslst)) + 1
C
      return
      end

c
      subroutine hkl_2_asym(hkl_in,hkl_out)
      implicit none
      include 'celsym.fh'

      integer hkl_in(3)
      integer hkl_out(3)
c
      integer is
      integer hsym,ksym,lsym,hcur,kcur,lcur
c
      hcur = hkl_in(1)
      kcur = hkl_in(2)
      lcur = hkl_in(3)

      do is=1,nsym
         lsym = nint(rot(1,3,is)*hkl_in(1)+ 
     &        rot(2,3,is)*hkl_in(2)+
     &        rot(3,3,is)*hkl_in(3))
         ksym = nint(rot(1,2,is)*hkl_in(1)+ 
     &        rot(2,2,is)*hkl_in(2)+
     &        rot(3,2,is)*hkl_in(3))
         hsym = nint(rot(1,1,is)*hkl_in(1) + 
     &        rot(2,1,is)*hkl_in(2)+
     &        rot(3,1,is)*hkl_in(3))
         if(lsym.gt.lcur) then
            hcur = hsym
            kcur = ksym
            lcur = lsym
         else if(lsym.eq.lcur) then
            if(ksym.gt.kcur) then
               hcur = hsym
               kcur = ksym
               lcur = lsym
            else if(ksym.eq.kcur) then
               if(hsym.gt.hcur) then
                  hcur = hsym
                  kcur = ksym
                  lcur = lsym
               endif
            endif
         endif
         hsym = -hsym
         ksym = -ksym
         lsym = -lsym
         if(lsym.gt.lcur) then
            hcur = hsym
            kcur = ksym
            lcur = lsym
         else if(lsym.eq.lcur) then
            if(ksym.gt.kcur) then
               hcur = hsym
               kcur = ksym
               lcur = lsym
            else if(ksym.eq.kcur) then
               if(hsym.gt.hcur) then
                  hcur = hsym
                  kcur = ksym
                  lcur = lsym
               endif
            endif
         endif   
      enddo
      hkl_out(1) = hcur
      hkl_out(2) = kcur
      hkl_out(3) = lcur
      return
      end
c
      subroutine twin_max_reso(maxsym,nsym,rot,tr,ntwin_domain,
     &     twin_oper,cell,res_max_out,nobs,hkl_list)
      implicit none
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer ntwin_domain
      integer twin_oper(3,3,*)
      integer nobs
      integer hkl_list(3,nobs)
      real res_max_out
c
c---  locals
      integer ir,itw
      integer h,k,l
      integer hkl_out(3)
      real degtor
      real ast,bst,cst,cosast,cosbst,coscst
      real res_loc,rsq
c
c---  body
C
C--Make sure cell angles are in radians
C
      degtor = 4.0*atan2(1.0,1.0)/180.0
      if(cell(4).gt.4.0.and.cell(5).gt.4.0.and.cell(6).gt.4.0) then
         cell(4) = cell(4)*degtor
         cell(5) = cell(5)*degtor
         cell(6) = cell(6)*degtor
      endif
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)

      res_max_out = 0.0

      do ir=1,nobs
         do itw=1,ntwin_domain
            hkl_out(1:3)= 
     &           matmul(transpose(twin_oper(1:3,1:3,itw)),
     &           hkl_list(1:3,ir))/12
            h = hkl_out(1)
            k = hkl_out(2)
            l = hkl_out(3)
            call define_res(h,k,l,ast,bst,cst,
     &           cosast,cosbst,coscst,rsq)
            res_loc = sqrt(rsq)/2.0
            res_max_out = max(res_max_out,res_loc)
         enddo

      enddo


      return
      end
