      subroutine calc_ls_stat(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs1,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,ierr)
      implicit none
      include 'atom_com.fh'
      include 'agreem.fh'
      include 'refi_flags.fh'
      include 'twin_refmac.fh'
      include 'celsym.fh'
      include 'weights.fh'
      include 'rharvest.fh'
      include 'vitals.fh'
c
c---  calculate statistics related with agreement of observations and calc
c
c---  inputs
      integer npart_act
      integer nasym
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs1
      integer obs_start(nobs1+1)
      real    iobs(2,nobs1)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)

c
c---outputs
      integer ierr
c
c---locals
      logical isitfree
      real hkl_this(3),hkl_sym(3),s_this(3),ss_v(6)
      integer ifree
      integer i,k,j,ip,is,m,jc,jal
      integer o_s,o_f,c_s,c_f,c_1,o_c_s,o_c_f,c_n

      real s,ss0,ss
      real a_all,b_all,ict,ico,fo0,wfo0,delta,adelta,wdelta,sigma
      real fct
      real ic(48)
      integer ish,ib,nb1
      real foav_work,fcav_work,fo2av_work,fc2av_work,fofcav_work
      real foav_free,fcav_free,fo2av_free,fc2av_free,fofcav_free
      real foav_all,fcav_all,fo2av_all,fc2av_all,fofcav_all

      real foav_shell_work(hmaxshell),fcav_shell_work(hmaxshell)
      real foav_shell_free(hmaxshell),fcav_shell_free(hmaxshell)
      real foav_shell_all(hmaxshell),fcav_shell_all(hmaxshell)

      real numer_all,denom_all,wnumer_all,wdenom_all
      real numer_free,denom_free,wnumer_free,wdenom_free
      real numer_work,denom_work,wnumer_work,wdenom_work
 
      real numer_shell_free(hmaxshell),denom_shell_free(hmaxshell)
      real wnumer_shell_free(hmaxshell),wdenom_shell_free(hmaxshell)
      real numer_shell_work(hmaxshell),denom_shell_work(hmaxshell)
      real wnumer_shell_work(hmaxshell),wdenom_shell_work(hmaxshell) 
      real numer_shell_all(hmaxshell),denom_shell_all(hmaxshell)
      real wnumer_shell_all(hmaxshell),wdenom_shell_all(hmaxshell)
c
      integer n_refined_atoms,nrefmnpar
      real compl
      real bans,exp1,expban,s_b_part,expbs,expbs_bulk
      real fh1,fh2
      logical error
c
      real lstlsq_r
c
c---  body
c
c----Initialise
c      b_ls_aniso_over(1:6) = 0.0
c      call print_ls_scale_twin
      nb1 = nbin + 1

      do i=1,nb1
         hd_shell_high(i) = 0.5/smaxb(i)
         hd_shell_low(i) = 0.5/sminb(i)
      enddo
c
      if(sminb(1).gt.0.0) then
         hd_low = 0.5/sminb(1)
      else
         hd_low = 1000.0
      endif
      hd_high = 0.5/smaxb(nbin)
      hnshell = nbin

      nhrefl_work = 0
      nhrefl_free = 0
      nhrefl_all = 0

      rfactor_all = 0.0
      rfactor_free = 0.0
      rfactor_work = 0.0
      foav_work = 0.0
      fcav_work = 0.0
      fo2av_work = 0.0
      fc2av_work = 0.0
      fofcav_work = 0.0
      hcorr_fofc = 0.0
            
      rfactor_free = 0.0
      foav_free = 0.0
      fcav_free = 0.0
      fo2av_free = 0.0
      fc2av_free = 0.0
      fofcav_free = 0.0
      hcorr_fofc = 0.0
      hcorr_fofc_free = 0.0

      numer_all = 0.0
      denom_all = 0.
      wnumer_all = 0.0
      wdenom_all =0.0
      wnumer_free = 0.0
      wdenom_free =0.0
      wnumer_work = 0.0
      wdenom_work =0.0
      numer_free = 0.0
      denom_free = 0.0
      numer_work = 0.0
      denom_work = 0.0
      call find_nrefined_atoms(n_refined_atoms)

      do  ish=1,hnshell
         numer_shell_free(ish) = 0.0
         denom_shell_free(ish) = 0.0
         wnumer_shell_free(ish) = 0.0
         wdenom_shell_free(ish) = 0.0

         numer_shell_work(ish) = 0.0
         denom_shell_work(ish) = 0.0
         wnumer_shell_work(ish) = 0.0
         wdenom_shell_work(ish) = 0.0
            
         numer_shell_all(ish) = 0.0
         denom_shell_all(ish) = 0.0
         wnumer_shell_all(ish) = 0.0
         wdenom_shell_all(ish) = 0.0

         hrfac_shell_free(ish) = 0.0
         hwrfac_shell_free(ish) = 0.0
         hrfac_shell_work(ish) =0.0
         hwrfac_shell_work(ish) = 0.0
         hwrfac_shell_all(ish) =  0.0
         hwrfac_shell_all(ish) = 0.0

         nrefa(1:2,ish) = 0
      enddo
      hnref_shell_all(1:nb1) = 0
      hnref_shell_free(1:nb1) = 0
      hnref_shell_work(1:nb1) = 0
      afo(1:2,1:nb1) = 0.0
      afc(1:2,1:nb1) = 0.0
      nrefa(1:2,nb1) = 0
c
c---------------
c
c--loop over asymmetric unit and calculate props f asym. Like the number of
c---  potential reflections etc.
      do i=1,nasym
         ss = lstlsq_r(1,hkl_asym(1:3,i))
         s = sqrt(ss)
         do ib=1,nbin
            if(s.ge.sminb(ib).and.s.le.smaxb(ib)) then
               ish = ib
               goto 2
            endif
         enddo
         goto 10
 2       continue
         hnref_shell_all(ish) = hnref_shell_all(ish) + 1
         hnref_shell_all(nb1) = hnref_shell_all(nb1)+1
 10      continue
      enddo
c
      do  i=1,num_blocks
         isitfree = .FALSE.
         if(freer(i).eq.0) isitfree = .TRUE.
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         ss = lstlsq_r(1,hkl_asym(1:3,c_1))
         s = sqrt(ss)
c         ss0 = 0.5*s/hstlmax*hnshell
c         ish = min(hnshell,int(ss0) + 1)
         do ib = 1,nbin
            if(s.ge.sminb(ib).and.s.le.smaxb(ib)) then
               ish = ib
               goto 20
            endif
         enddo
         goto 100

         if(ss.le.sminb(1)) ish = 1
         if(ss.ge.smaxb(nbin)) ish = nbin
 20      continue
         
         jc = 0
         do m=c_s,c_f
            jc = jc + 1
            c_n           = block_2_asym(m)
            hkl_this(1:3) = hkl_asym(1:3,c_n)
            a_all         = fcalc(1,c_n)
            b_all         = fcalc(2,c_n)
            ss = lstlsq_r(1,hkl_asym(1:3,c_n))
            expbs = exp(-ss*b_ls_over)*scale_ls_over
            expbs_bulk = (1.0-exp(-ss*b_ls_bulk)*scale_ls_bulk)*expbs
            expban = 0.0
            do  is=1,nsym
               hkl_sym = matmul(transpose(rot(1:3,1:3,is)),hkl_this)
               s_this  = matmul(transpose(rfr),hkl_sym)

               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans = ss_v(1)*b_ls_aniso_over(1)+
     &              ss_v(2)*b_ls_aniso_over(2)+
     &              ss_v(3)*b_ls_aniso_over(3)+
     &              ss_v(4)*b_ls_aniso_over(4)+
     &              ss_v(5)*b_ls_aniso_over(5)+
     &              ss_v(6)*b_ls_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
            enddo
            expban = expban/nsym
            do ip=1,npart_act
               s_b_part = scale_ls_part(ip)*exp(-b_ls_part(ip)*ss)
               a_all    = a_all+fpart(ip,1,c_n)*s_b_part
               b_all    = b_all+fpart(ip,2,c_n)*s_b_part
            enddo 
            Ic(jc) = (a_all**2+b_all**2)*expban*expbs_bulk
         enddo
         do j=o_s,o_f
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            ict=0.0

            do k=o_c_s,o_c_f
               jc  = ref_2_asym(k)
               jal = comp_numb(k)
               ict = ict+twin_frac(jal)*Ic(jc)
            enddo
            fo0 = sqrt(max(0.001*iobs(2,j),iobs(1,j)))
            sigma = iobs(2,j)/(sqrt(fo0**2+iobs(2,j))+fo0)
c            ict = ict*expbs_bulk
            fct = sqrt(ict)
            fh1 = Ict - max(-3.0*iobs(2,j),iobs(1,j))
            fh2 = fct+sqrt(max(0.001*iobs(2,j),iobs(1,j)))
            delta = fh1/fh2

c            delta = fo0-fct
            adelta = abs(delta)
            wdelta = adelta/sigma
            wfo0    = fo0/sigma

            numer_all = numer_all + adelta
            denom_all = denom_all + fo0
            wnumer_all = wnumer_all + wdelta
            wdenom_all = wdenom_all + wfo0
            ifree = 1
            if(isitfree) ifree = 2
            nrefa(ifree,ish) = nrefa(ifree,ish) + 1
            nrefa(ifree,nb1) = nrefa(ifree,nb1) + 1

            if(isitfree) then
               nhrefl_free = nhrefl_free + 1
               fo2av_free = fo2av_free + fo0**2
               fc2av_free = fc2av_free + fct**2
               fofcav_free  = fofcav_free  + fo0*fct
               foav_free = foav_free + fo0
               fcav_free = fcav_free + fct
               numer_free = numer_free + adelta
               denom_free = denom_free + fo0
               wnumer_free = wnumer_free + wdelta
               wdenom_free = wdenom_free + wfo0
               hnref_shell_free(ish) = hnref_shell_free(ish) + 1
               denom_shell_free(ish) = denom_shell_free(ish) + fo0
               numer_shell_free(ish) = numer_shell_free(ish) + adelta
               wdenom_shell_free(ish) = wdenom_shell_free(ish) + wfo0
               wnumer_shell_free(ish) = wnumer_shell_free(ish) +wdelta
               afo(2,ish) = afo(2,ish) + fo0
               afc(2,ish) = afc(2,ish) + fct
            else
               nhrefl_work = nhrefl_work + 1
               fo2av_work = fo2av_work + fo0**2
               fc2av_work = fc2av_work + fct**2
               fofcav_work  = fofcav_work  + fo0*fct
               foav_work = foav_work + fo0
               fcav_work = fcav_work + fct
               numer_work = numer_work + adelta
               denom_work = denom_work + fo0
               wnumer_work = wnumer_work + wdelta
               wdenom_work = wdenom_work + wfo0
               hnref_shell_work(ish) = hnref_shell_work(ish) + 1
               denom_shell_work(ish) = denom_shell_work(ish) + fo0
               numer_shell_work(ish) = numer_shell_work(ish) +adelta
               wdenom_shell_work(ish) = wdenom_shell_work(ish) + wfo0
               wnumer_shell_work(ish) = wnumer_shell_work(ish) +wdelta
               afo(1,ish) = afo(1,ish) + fo0
               afc(1,ish) = afc(1,ish) + fct
            endif
            numer_shell_all(ish) = numer_shell_all(ish) + adelta
            denom_shell_all(ish) = denom_shell_all(ish) + fo0
            wnumer_shell_all(ish) = wnumer_shell_all(ish) + wdelta
            wdenom_shell_all(ish) = wdenom_shell_all(ish) + wfo0
         enddo
 100     continue
      enddo         
c
c---
      hnref_shell_work(nb1) = nhrefl_work
      hnref_shell_free(nb1) = nhrefl_free
c      hnrefl_free = nhrefl_free
c      hnrefl_work = nhrefl_work

      if(nhrefl_work+nhrefl_free.gt.0) then
         perc_free = 
     &        float(nhrefl_free)/(float(nhrefl_free+nhrefl_work))*100.0
      endif
      if(denom_all.gt.0.0) rfactor_all = numer_all/denom_all
      if(denom_free.gt.0.0) rfactor_free = numer_free/denom_free
      if(denom_work.gt.0.0) rfactor_work = numer_work/denom_work
      if(wdenom_all.gt.0.0) rwfactor_all = wnumer_all/wdenom_all
      if(wdenom_free.gt.0.0) rwfactor_free = wnumer_free/wdenom_free
      if(wdenom_work.gt.0.0) rwfactor_work = wnumer_work/wdenom_work
      if(hnref_shell_all(nb1).gt.0.0) then
         hperc_shell_refl(nb1)=float((nhrefl_free+nhrefl_work))/
     &        float(hnref_shell_all(nb1))*100.0
      endif
      hrfac_shell_all(nb1)  = rfactor_all
      hrfac_shell_free(nb1) = rfactor_free
      hrfac_shell_work(nb1) = rfactor_work
      if(nhrefl_work.gt.0) then
         rfactor_work = numer_work/denom_work

         foav_work = foav_work/nhrefl_work
         fcav_work = fcav_work/nhrefl_work
         fo2av_work = fo2av_work/nhrefl_work
         fc2av_work = fc2av_work/nhrefl_work
         fofcav_work = fofcav_work/nhrefl_work
         hcorr_fofc = (fofcav_work-foav_work*fcav_work)/
     &        (sqrt(fo2av_work-foav_work**2)*
     &          sqrt(fc2av_work-fcav_work**2))
      endif
      if(nhrefl_free.gt.0) then
         rfactor_free = numer_free/denom_free
         foav_free = foav_free/nhrefl_free
         fcav_free = fcav_free/nhrefl_free
         fo2av_free = fo2av_free/nhrefl_free
         fc2av_free = fc2av_free/nhrefl_free
         fofcav_free = fofcav_free/nhrefl_free
         hcorr_fofc_free = (fofcav_free-foav_free*fcav_free)/
     &        (sqrt(fo2av_free-foav_free**2)*
     &          sqrt(fc2av_free-fcav_free**2)) 
      endif
      do  ish=1,hnshell
         if(hnref_shell_free(ish).gt.0) then
            hrfac_shell_free(ish) = 
     &           numer_shell_free(ish)/denom_shell_free(ish)
            hwrfac_shell_free(ish) = 
     &           wnumer_shell_free(ish)/wdenom_shell_free(ish)
            afo(2,ish) = afo(2,ish)/hnref_shell_free(ish)
            afc(2,ish) = afc(2,ish)/hnref_shell_free(ish)
         endif
         if(hnref_shell_work(ish).gt.0) then
            hrfac_shell_work(ish) = 
     &           numer_shell_work(ish)/denom_shell_work(ish)
            hwrfac_shell_work(ish) = 
     &           wnumer_shell_work(ish)/wdenom_shell_work(ish)
            afo(1,ish) = afo(1,ish)/hnref_shell_work(ish)
            afc(1,ish) = afc(1,ish)/hnref_shell_work(ish)
            
         endif
         if(hnref_shell_all(ish).gt.0) then
            hrfac_shell_all(ish) = 
     &           numer_shell_all(ish)/denom_shell_all(ish)
            hwrfac_shell_all(ish) = 
     &           wnumer_shell_all(ish)/wdenom_shell_all(ish)
         endif
         if(hnref_shell_all(ish).gt.0) then
            hperc_shell_refl(ish)=
     &           float(hnref_shell_work(ish)+hnref_shell_free(ish))/
     &           float(hnref_shell_all(ish))*100.0
         endif
      enddo
c
      compl = hperc_shell_refl(nb1)
      hesu_cruic = 0.0
      nrefmnpar = nrefa(1,nb1) - nref_pars

      if(nrefmnpar.gt.0) then
         hesu_cruic = sqrt(float(n_refined_atoms)/float(nrefmnpar))*
     *        compl**(-0.333333)*hd_high*hrfac_shell_work(nb1)
      endif
     
      if(freer_flag.and.nrefa(2,nb1).gt.0) then
         hesu_free=sqrt(float(n_refined_atoms)/float(nrefa(1,nb1)))*
     *        compl**(-0.333333)*hd_high*hrfac_shell_free(nb1)
      endif

      return
      end
c
      subroutine report_xray_stats_twin
      implicit none
c
c---report xray statistics
      include 'rharvest.fh'
      include 'monitor.fh'
      include 'twin_refmac.fh'
c
c--   locals
      integer ish
c
c---  body
      if(ntwin_domain.gt.1) then
         write(*,'(a,i10)')'The number of twin domains             = ',
     &        ntwin_domain
         write(*,'(a,30f6.5)')'Twin fractions ',
     &        twin_frac(1:ntwin_domain)
      endif
c
      if(mon_style.eq.'MANY') then
         do ish=1,hnshell

         enddo
      endif
c
      if(mon_style.eq.'MANY') then

      endif
      write(*,'(a,f10.4)')'Overall R factor                     = ',
     &  rfactor_work
      if(rfactor_free.ge.0.0) then
         write(*,'(a,f10.4)')'Overall R factor                     = ',
     &        rfactor_work
      endif
      if(fomover.gt.0.0) then
         write(*,'(a,f10.4)')'Overall figure of merit              = ',
     &     fomover
      endif

      return
      end
c
      subroutine calc_ml_stat(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs_1,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,ierr)
      implicit none
      include 'atom_com.fh'
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'celsym.fh'
      include 'rharvest.fh'
      include 'weights.fh'
      include 'refi_flags.fh'
c
c---  calculate statistics related with likelihood parameters
c
c---  inputs
      integer npart_act
      integer nasym
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs_1
      integer obs_start(nobs_1+1)
      real    iobs(2,nobs_1)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
      real fmax(2,nasym)
      integer ierr
c
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
c
      integer i,j,k,ifree,ip
      integer ibin,ib,ib1
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_1,c_n
      real sigma,sigma1,fc_l,fom,fvalue,a_all,b_all
      real xx,xx1,xx2
      real ss,ssq
      real fom_calc,lstlsq_r
      external fom_calc,lstlsq_r
c
c---  body
      allocate(obs_bins(num_blocks))
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs_1,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs_1,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
c     
      nrefa(1:2,1:nbin) = 0
      fomava(1:2,1:nbin) = 0.0
      nrefc(1:2,1:nbin) = 0
      fomavc(1:2,1:nbin) = 0.0
      d_ml(1:2,1:nbin) = 0.0
      fomovera(1:2) = 0.0
      fomoverc(1:2) = 0.0
      fomovert(1:2) = 0.0
      nrefovera(1:2) = 0
      nrefoverc(1:2) = 0
      nrefovert(1:2) = 0
      fxray = 0.0
      fxfree = 0.0
      do i=1,num_blocks
         ibin = obs_bins(i)
         sigma = sigma_ml(ibin)
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         ssq = lstlsq_r(1,hkl_asym(1:3,c_1))
         ss = sqrt(ssq)
         do ib = 1,nbin
            if(ss.ge.sminb(ib).and.ss.le.smaxb(ib)) then
               ib1 = ib
               goto 20
            endif
         enddo
 19      continue
         if(ss.le.sminb(1)) ib1 = 1
         if(ss.ge.smaxb(nbin)) ib1 = nbin
 20      continue

         ifree = 1
         if(freer(i).eq.0) ifree = 2
         do j=c_s,c_f
            c_n = block_2_asym(j)
            a_all = scale_ml(ibin,1)*fcalc(1,c_n)
            b_all = scale_ml(ibin,1)*fcalc(2,c_n)
            do ip=1,npart_act
               a_all = a_all+scale_ml(ibin,ip+1)*fpart(ip,1,c_n)
               b_all = b_all+scale_ml(ibin,ip+1)*fpart(ip,2,c_n)
            enddo
            fc_l = sqrt(a_all**2+b_all**2)
            sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
     &           + 2.0*fmax(2,c_n)**2
            xx = 2.0*fmax(1,c_n)*fc_l/sigma1
            fom = fom_calc(centrs(c_n),xx)
            if(centrs(c_n).eq.0) then
               call bessi0(xx,xx2,xx1)
               fomovera(ifree)  = fomovera(ifree) + fom
               nrefovera(ifree) = nrefovera(ifree) + 1
               nrefa(ifree,ib1) = nrefa(ifree,ib1) + 1
               fomava(ifree,ib1) = fomava(ifree,ib1) + fom
               d_ml(ifree,ib1) = d_ml(ifree,ib1) + scale_ml(ibin,1)
            else
               if(xx.gt.30) then
                  xx1 = xx
                  xx2 = 0.5
               else
                  xx1 = 0.0
                  xx2 = cosh(xx)
               endif
               fomoverc(ifree)  = fomoverc(ifree) + fom
               nrefoverc(ifree) = nrefoverc(ifree) + 1
               nrefc(ifree,ib1) = nrefc(ifree,ib1) + 1
               fomavc(ifree,ib1) = fomavc(ifree,ib1) + fom
               d_ml(ifree,ib1)  = d_ml(ifree,ib1) + scale_ml(ibin,1)
            endif
            fvalue = (fmax(1,c_n)**2+fc_l**2)/sigma1 - xx1 - log(xx2)
            if(centrs(c_n).eq.0) then
               fvalue = fvalue - log(fmax(1,c_n)) + log(sigma1)
            else
               fvalue = fvalue + 0.5*log(sigma1)
            endif
            if(ifree.eq.1) then
               fxray = fxray + fvalue
            else
               fxfree = fxfree + fvalue
            endif
            fomovert(ifree)  = fomovert(ifree) + fom
            nrefovert(ifree) = nrefovert(ifree) + 1
         enddo
      enddo
c
      do i=1,2
         if(nrefovera(i).gt.0) then
            fomovera(i) = fomovera(i)/nrefovera(i)
         endif
         if(nrefoverc(i).gt.0) then
            fomoverc(i) = fomoverc(i)/nrefoverc(i)
         endif
         if(nrefovert(i).gt.0) then
            fomovert(i) = fomovert(i)/nrefovert(i)
         endif
      enddo
      do ib1 = 1,nbin
         do i=1,2
            if(nrefa(i,ib1).gt.0) then
               fomava(i,ib1) = fomava(i,ib1)/nrefa(i,ib1)
            endif
            if(nrefc(i,ib1).gt.0) then
               fomavc(i,ib1) = fomavc(i,ib1)/nrefc(i,ib1)
            endif
            if(nrefa(i,ib1)+nrefc(i,ib1).gt.0) then
               d_ml(i,ib1) = d_ml(i,ib1)/(nrefa(i,ib1)+nrefc(i,ib1))
            endif
         enddo
      enddo
c      
      deallocate(obs_bins)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
c
      SUBROUTINE PRINT_LS_SCALE_twin
C
C---Prints parameters of scale factors.
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      include 'twin_refmac.fh'
      INTEGER IP
      CHARACTER LINE*128
C
      IF(MON_STYLE.EQ.'NONE') RETURN
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      if(ntwin_domain.gt.1) then
         write(line,'(a,48f6.3)')'Twin fractions        :',
     &        twin_frac(1:ntwin_domain)
         call errwrt(-1,line)
      endif
      WRITE(LINE,'(A,2(A,F8.3))')  'Overall               :'
     &          ,' scale = ',SCALE_LS_OVER,', B  =',B_LS_OVER
      CALL ERRWRT(-1,LINE)
c      IF(BULK_LS_FLAG) THEN
        WRITE(LINE,'(A,2(A,F8.3))')'Babinet"s bulk solvent:'
     &          ,' scale = ',SCALE_LS_BULK,', B  =',B_LS_BULK
        CALL ERRWRT(-1,LINE)
c      ENDIF
      DO   IP=1,NPART
        WRITE(LINE,'(A,I3,2(A,F8.3))')'Partial structure  ',IP,
     &        ': scale = ',SCALE_LS_PART(IP),', B  =', B_LS_PART(IP)
        CALL ERRWRT(-1,LINE)
      ENDDO
      IF(B_LS_ANISO_OVER_FLAG) THEN
        CALl ERRWRT(-1,'Overall anisotropic scale factors')
        WRITE(LINE,'(2X,6(A,F6.2))')' B11 =',B_LS_ANISO_OVER(1),
     &                             ' B22 =',B_LS_ANISO_OVER(2),
     &                             ' B33 =',B_LS_ANISO_OVER(3),
     &                             ' B12 =',B_LS_ANISO_OVER(4),
     &                             ' B13 =',B_LS_ANISO_OVER(5),
     &                             ' B23 =',B_LS_ANISO_OVER(6)
        CALL ERRWRT(-1,LINE)
      ENDIF
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      RETURN
      END
