      subroutine align_r(ncases,nseq1,nseq2,sequence1,sequence2,
     &     sim_table,align_out,pen1,pen2,ierr)
      implicit none
c
c---  Subroutine for alignment of two sequences
      integer ierr
      integer ncases,nseq1,nseq2
      real pen1,pen2
      integer sequence1(nseq1),sequence2(nseq2)
      real sim_table(ncases,ncases)
      integer align_out(2,*)
c
      integer i,j,i1,j1
      real, allocatable :: table1(:,:)

      allocate(table1(nseq1,nseq2))
c
c---  body
      do i=1,nseq1
         i1 = sequence1(i)
         if(i1.le.0.or.i1.gt.ncases) then
            write(*,*)'Error: Wrong sequence'
            ierr = 1
            goto 999
         endif
         do j=1,nseq2
            j1 = sequence1(i)
            if(j1.le.0.or.j1.gt.ncases) then
               write(*,*)'Error: Wrong sequence'
               ierr = 1
               goto 999
            endif
            table1(i,j) = sim_table(sequence1(i),sequence2(j))
         enddo
      enddo
c
      call align_real(nseq1,nseq2,pen1,pen2,table1,align_out,ierr)

 999  continue
      deallocate(table1)
      return
      end
c
      subroutine align_eal(nseq1,nseq2,pen1,pen2,table1,align_out,ierr)
      implicit none
      integer nseq1,nseq2,ierr
      real pen1,pen2
      real table1(nseq1,nseq2)
      integer align_out(2,*)
c
      integer i,j,n1,nl
      real a,b,c
      real, allocatable :: f(:,:)
      integer, allocatable :: al1(:)
      integer, allocatable :: al2(:)
c
c---- 
      real eps

c
c---  Foward step
      eps = 1.0e-7
      allocate(f(nseq1,nseq2))
c
      do i=1,nseq1
         f(i,1) = i*pen1
      enddo
      do j=1,nseq2
         f(1,j) = j*pen1
      enddo
c
      do i=2,nseq1
         do j=2,nseq2
            a = f(i-1,i-1) - table1(i-1,j-1)
            b = f(i-1,j) - pen1
            c = f(i,i-1) - pen1
            f(i,j) = min(a,min(b,c))
         enddo
      enddo
c
c---  Backward step
      n1 = nseq1 + nseq2
      allocate(al1(n1))
      allocate(al2(n1))
c
      al1(n1) = nseq1
      al2(n1) = nseq2
      i = nseq1
      j = nseq2
      do while (i.gt.1.and.j.gt.1)
         if(f(i,j)-f(i-1,j-1)-table1(i-1,j-1).lt.eps) then
            n1 = n1 -1
            i = i - 1
            j = j - 1
            al1(n1) = i
            al2(n1) = j
         else if(f(i,j)-f(i-1,j) - pen1.lt.eps) then
            n1 = n1 - 1
            i = i - 1
            al1(n1) = i
            al2(n1) = 0
         else if(f(i,j)-f(i,j-1)-pen1.lt.eps) then
            n1 = n1 - 1
            j = j - 1
            al1(n1) = 0
            al2(n1) = j
         endif
      enddo
      if(i.gt.1) then
         do while(i.gt.1) 
            n1 = n1 - 1
            i = i - 1
            al1(n1) = i
            al2(n1) = 0
         enddo
      endif
      if(j.gt.1) then
         do while (j.gt.1) 
            n1 = n1 - 1
            j = j - 1
            al1(n1) = 0
            al2(n1) = j
         enddo
      endif
c
c---Remove zeros
      i = 1
      do while (al1(i).eq.0.and.al2(i).eq.0)
         i = i + 1
      enddo
      nl = n1-i+1
      align_out(1,1:nl) = al1(i:n1)
      align_out(2,1:nl) = al2(i:n1)
c
      deallocate(al1)
      deallocate(al2)
      deallocate(f)
      return
      end
