      subroutine decide_twin_operators(input_file)
      implicit none
      include 'twin_refmac.fh'
      include 'restr_files.fh'
      character input_file*(*)
c
      integer ncomp,nasym
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: nref_comp(:)
      integer, allocatable :: hkl_comp(:,:)
      integer, allocatable :: comp_number(:)
      integer, allocatable :: refer_2_asym(:)
      integer, allocatable :: refer_2_symm(:)
      real, allocatable :: iobs(:,:)
      integer, allocatable :: free_refl(:)
c
      integer nobs1,ncomp1
c
      integer in_file
      integer i,itw,ierr
      character text_loc*128
      integer ntwin_domain_save
      real twin_oper_save(3,3,48),tr_l(3)
      real r_merge(48)
c
c---  body
      if(twin_user_flag) return
      if(ntwin_domain.le.1) return
c
c---  Asymmetric unit
      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
      do i=1,nasym
         read(in_file)hkl_asym(1:3,i)
      enddo
      close(in_file)
c
      twin_oper_save(1:3,1:3,1:ntwin_domain) =
     &     twin_oper(1:3,1:3,1:ntwin_domain)
      ntwin_domain_save = ntwin_domain

      r_merge(1) = 0.0
      ntwin_domain = 2
      call read_refl_size(input_file,nobs1)
      ncomp1 = nobs1*ntwin_domain

      do itw=2,ntwin_domain_save
         allocate(iobs(2,nobs1))
         allocate(nref_comp(nobs1+1))
         allocate(hkl_comp(3,ncomp1))
         allocate(comp_number(ncomp1))
         allocate(free_refl(nobs1))
         twin_oper(1:3,1:3,2:2) = twin_oper_save(1:3,1:3,itw:itw)
         call read_refl_twin(input_file,nobs1,ncomp1,iobs,
     &        nref_comp,hkl_comp,comp_number,free_refl,
     &        ierr)      
c
c---  if twin operators defined by the program then check if potential twins
c---  are really twin. Calculate rmerge if it is more than 50 then 
c---  very likely not to be twin
         ncomp = ncomp1
c
c--Now we have read reflections with their potential comoponents
c--Components are twin domains. Now we are ready to organise observations
         allocate(refer_2_asym(ncomp1))
         allocate(refer_2_symm(ncomp1))
         call find_refer2asym(ncomp,hkl_comp,refer_2_asym,
     &        refer_2_symm,nasym,hkl_asym,ierr)
         
         deallocate(hkl_comp)
         call block_organise_observ(ncomp1,comp_number,refer_2_asym,
     &        refer_2_symm,nobs1,iobs,free_refl,nref_comp,
     &        nasym,hkl_asym,
     &        refl_file,ierr)
         deallocate(refer_2_symm)
         deallocate(refer_2_asym)
         deallocate(nref_comp)
         deallocate(comp_number)
         deallocate(free_refl)
         call calculate_rmerge(r_merge(itw))
      enddo
      deallocate(hkl_asym)
c
      ntwin_domain = 1
      tr_l(1:3) = 0.0
      do itw=2,ntwin_domain_save
         call put_symm_to_text(twin_oper_save(1:3,1:3,itw:itw),tr_l,
     &        text_loc)

         if(r_merge(itw).le.0.49) then
            write(*,*)'Symmetry operator :',trim(text_loc),
     &           '; R_merge =',r_merge(itw),'; Twin unlikely '

         elseif(r_merge(itw).le.0.10) then
            write(*,*)'Symmetry operator= ',trim(text_loc),
     &           ' R_merge=',r_merge(itw),': twin or higher symmetry '
            ntwin_domain = ntwin_domain + 1
            twin_oper(1:3,1:3,ntwin_domain) = 
     &           twin_oper_save(1:3,1:3,itw)
c
c--   very strong twin or higher space group
         else
            write(*,*)'Symmetry operator= ',trim(text_loc),
     &           ' R_merge =',r_merge(itw),': twin is probable '
            ntwin_domain = ntwin_domain + 1
            twin_oper(1:3,1:3,ntwin_domain) = 
     &           twin_oper_save(1:3,1:3,itw)
         endif
      enddo

      return
      end
c
      subroutine calculate_rmerge(r_merge)
      implicit none
      include 'celsym.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'

      real r_merge
c
      integer nobs,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: iobs(:,:)
c
      integer i,ib,in_file,ierr
      integer ii,io1,kk,ko1,jo1,jj,io,jnum_o
      integer o_s,o_f,c_s,c_f
      integer nobs_block,nobs_block1
      real r_merge0,iaver
c
c---  body
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c     
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(iobs(2,nobs))
      allocate(obs_start(nobs+1))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      num_list = num_blocks
c
c---  How many fractions do we have. Need to be stored somewhere.
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
c            iobs(1:2,ii) = iobs(1:2,ii)/scale_ls_init
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c---  Consider calculating moments, correlations and other things

      r_merge = 0.0
      r_merge0 = 0.0
c
c---  Use robust stats like rank correlation etc
c
c---  Bootstrap??
      do ib=1,num_blocks
         o_s = block_start(i) + 1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i) + 1
         c_f = ref_2_asym_start(i+1)
         if(c_s-c_f.gt.0) then
            iaver = 0
            nobs_block = o_f-o_s + 1
            nobs_block1 = nobs_block-nobs_block-1
            do i=o_s,o_f
               iaver = iaver + iobs(1,i)
            enddo
            iaver = iaver/nobs_block
            do i=o_s,o_f
               r_merge = r_merge + abs(iobs(1,i)-iaver)/nobs_block
               r_merge0 = r_merge0 + iobs(1,i)/nobs_block
            enddo
         endif
      enddo
      r_merge = r_merge/r_merge0
c
c---  deallocate
      deallocate(freer)
      deallocate(block_start)
      deallocate(ref_2_asym_start)
      deallocate(iobs)
      deallocate(obs_start)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)      
      return
      end
