      subroutine write_mtz_file(maxsym1,nsym1,rot1,tr1,cell1,
     &      nasym,hkl_asym,fcalc,fpart,fexpected,ierr)
      implicit none
      include 'agreem.fh'
      include 'mtz_params.fh'
      include 'celsym.fh'
c
      integer maxsym1,nsym1
      real rot1(3,3,maxsym1),tr1(3,maxsym1),cell1(6)
      integer nasym
      integer hkl_asym(3,nasym)
      real fcalc(2,nasym),fpart(2,npart_act,nasym),fexpected(2,nasym)
      integer ierr
c
c---  locals
      logical error
      integer i
      integer mtzout,iappnd
      real rtodeg
      real cell_out(6)
      real a0,b0,a1,b1,fmod,fmod1,phi,phi1
      real bdata(20)
      real, allocatable :: fc1(:,:)
      real, allocatable :: sigmas(:)
      real, allocatable :: epsls(:)
      real, allocatable :: centrs(:)
c
      real xx,fom_l,ss
      real sim
      external sim
c
c---  body
      allocate(fc1(2,nasym))
      allocate(sigmas(nasym))
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl_asym,epsls,
     &     centrs)
      call calc_sigmas(nasym,cell,sigmas,hkl_asym,error)
      call  calc_full_fcalc(nasym,npart_act,cell,hkl_asym,
     &     fcalc,fpart,fc1,error)
c
      rtodeg = 45.0/atan2(1.0,1.0)
      mtzout = 2
      iappnd = 0
      call lwopen(mtzout,'HKLOUT')
      call lwtitl(mtzout,'Output mtz from map_coefs',1)
      cell_out(1:6) = cell1(1:6)
      do  i=4,6
         if(maxval(cell(4:6)).le.5.0) then
            cell_out(4:6)  = cell1(4:6)*rtodeg
         endif
      enddo
c
c
c--Experimental file
      open(70)
      call lwcell(mtzout,cell_out)
      isort(1:5) = 0
      call lwsort(mtzout,isort)
      call lwsymm(mtzout,nsym1,numprimsymm,realsymmmatrx,ltype,
     &     numspacegroup,spacegroupname,pointgroupname)

      call lwassn(mtzout,lsprgo,nlprgo,ctprgo,iappnd)
c
      do   i=1,nasym
         call equal_magic(mtzout,bdata,20)
         bdata(1:3) = real(hkl_asym(1:3,i))
         XX = sqrt(fexpected(1,i)**2+fexpected(2,i)**2)*
     &        sqrt(fc1(1,i)**2+fc1(2,i)**2)/(epsls(i)*sigmas(i))
         if(nint(centrs(i)).eq.0) then
            fom_l = sim(2.0*xx)
         else
            fom_l = tanh(xx)
         endif
         a0 = (fexpected(1,i) - fc1(1,i))
         b0 = (fexpected(2,i) - fc1(2,i))
         a1 = fexpected(1,i) + a0
         b1 = fexpected(2,i) + b0
         write(70,*)a0**2+b0**2,epsls(i)*sigmas(i)

c         a1 = fom_l*fexpected(1,i)
c         b1 = fom_l*fexpected(2,i)
c         write(*,*)sqrt(fexpected(1,i)**2+fexpected(2,i)**2),
c     &        sqrt(fc1(1,i)**2+fc1(2,i)**2)
         fmod = sqrt(a0**2+b0**2)
         fmod1 = sqrt(a1**2+b1**2)
         phi = 0
         if(fmod.gt.0.0) phi = atan2(b0,a0)*rtodeg
         phi1 = 0.0
         if(fmod1.gt.0.0) phi1 = atan2(b1,a1)*rtodeg
         bdata(4) = fmod1
         bdata(5) = phi1
         bdata(6) = fmod
         bdata(7) = phi
         call lwrefl(mtzout,bdata)
      enddo
      close(70)
      call lwclos(mtzout,0)
c
      deallocate(fc1)
      deallocate(sigmas)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
