      subroutine template
      implicit none
c
c---  Solve linear equations with linear constraints using augmanted 
c---  Lagrangain method
      integer nv,nm,nm_nondiag
      real am_diag(nm),am_nondiag(nm_nondiag)
      real vect(nv),dx(nv)

      integer nmega
      integer par_size(nmega)
      integer npairs
      integer pairs(2,npairs)

      integer ncoef_const,nconst
      integer nc(nconst)
      integer const_pos(ncoef_const)
      real const_coef(ncoef_const)
      real bconst(nconst)
c
      integer nv
      integer d_pos1,d_pos2
      real    coef
c---allocatable
      integer, allocatable :: diag_pos(:)
      integer, allocatable :: v_pos(:)
      integer, allocatable :: nondiag_pos(:)
      integer, allocatable :: const_pos(:)
      real, allocatable :: lam(:)
      real, allocatable :: sigma(:)
      real, allocatable :: bnew(:)
      real, allocatable :: acnd(:)
      real, allocatable :: p1(:)
      real, allocatable :: r1(:)
      real, allocatable :: tmp(:,:)

c
c---  locals
      nmaxv = maxval(par_size(1:nmega))
      allocate(lam(nconst))
      allocate(sigma(nconst))
      allocate(bnew(nv))
      allocate(p1(nv))
      allocate(r1(nv))
      allocate(diag_pos(nmega))
      allocate(v_pos(nmega))
      allocate(nondiag_pos(npairs))
      allocate(acnd(ndiag_size))
      allocate(const_pos(ncoef_const))
      allocate(tmp(nmaxv,nmaxv))
c
c--define parameter positions for ease of use
      par_pos(1) = 1
      if(nmega.gt.1) then
         do i=2,nmega
            par_pos(i) = par_pos(i-1) + par_size(i-1)
            par_pos_diag(i) = par_pos_diag(i-1) + par_size(i-1)**2
         enddo
      endif
      par_pos_nondiag(1) = 1
      if(npairs.gt.1) then
         do i=2,npairs
            j1 = pairs(1,i)
            j2 = pairs(2,i)
            n1 = par_size(j1)
            n2 = par_size(j2)
            par_pos_nondiag(i) = par_pos_nondiah(i-1)+ n1*n2
         enddo
      endif
c
c--initialise sigmas and lambdas and some other parameters for constraints
      if(nconst.gt.0) then
         lambda(1:nconst) = 0.0
         sigma(1:nconst) = 1.0
      endif
c
c---find conditioners
      const_converged = .FALSE.
      do while(.not.const_coverged)

         do while(.not.cg_converged)

            do  i=1,nmega
               j1 = par_pos(i)
               n1 = par_size(i)
               am(1:n1,1:n1) = reshape(am_diag(j1:(j1+n1*n1-1)),/n1,n1/)
c
c--add constraints
         call find_square_root_inverse_matix(am,am_inv_square)
         am_cond(j1:(j1+n1*n1-1)) = 
     &        reshape(am_inv_square(1:n1,1:n1)),/n1*n1/)
      enddo
c
c--matric vector multiplication
      call sparse_mat2vec_refmac(nmega,par_pos,par_size,par_pos_diag,
     &     npairs,pairs,par_pos_nondiag,am_daig,am_nondiag,vect,
     &     vect_out)
c
c--diagonals
      do  i=1,nmega
         j1 = par_pos(i)
         n1 = par_size(i)
         jm = par_pos_diag(i)
         v1(1:n)=vect(j1:(j1+n1-1))
         am(1:n,1:n) = reshape(am_diag(jm:(jm+n1*n1-1))
         v2 = am*v1
         vout(j1:(j1+n1-1)) = v2(1:n1)
      enddo
c
c--nondiagonals
      do  i=1,npairs
         i1 = pairs(1,i)
         i2 = pairs(2,i)
         j1 = par_pos(i1)
         j2 = par_pos(i2)
         n1 = par_size(i1)
         n2 = par_size(i2)
         jm = par_pos_nondiag(i)
         v1 = vect(j1:(j1+n1-1))
         v2 = vect(j2:(j2+n2-1))
         am = reshape(n1,n2,anondiag(jm:(jm+n1*n2-1)))
         v11 = am*v1
         v_out(j2:(j2+n1-1)) = v11(1:n2)
         v22 = am_trans*v2
         v_out(j1:(j1+n1-1)) = v22(1:n2)
      enddo

      diag_pos(1) = 1
      v_pos(1)    = 1
      do  i=2,nmega
         n1 = par_size(i-1)
         diag_pos(i) = diag_pos(i-1) + n1*n1
         v_pos(i) = v_pos(i-1) + n1
      enddo
      nondiag_pos(1) = diag_pos(nmega)
      do i=2,npairs
         i1 = pais(1,i)
         i2 = pairs(2,i)
         n1 = par_sizes(i1)
         n2 = par_sizes(i2)
         nondiag_pos(i) = nondiag_pois(i-1) + n1*n2
      enddo
      l = 0
      do i=1,nconst
         do j=1,nc(i)
            l = l + 1
            imega = const_mega(l)
            const_pos(l) = v_pos(imega)+const_mega_pos(l)-1
         enddo
      enddo
c     
c---  locals
      dx(1:nv) = 0.0
      lam(1:nconst) = 0.0
      sigma(1:nconst) = 10.0

      const_conv = .FALSE.
      cprev = 1.0E32
      do while(.not.const_conv)
c
c--modify the left hand side 
         c1_conv = .FALSE.
         do while(.not.c1_conv)
            l = 0
            bnew(1:nv) = g(1:nv)
            do  i=1,nconst
               do  j=1,nc(i)
                  l = l + 1
                  jpos = const_pos(l)
                  coef = const(l)
                  bnew(ipos) = bnew(ipos) + coef*lam(i)
                  bnew(ipos) = bnew(ipos) + sigma(i)*coef*bconst(i)
               enddo
            enddo
c     
c---  find conditioner
            do i=1,nmega
               n1 = par_sizes(i)
               d_pos1 = diag_pos(i)
               d_pos2 = d_pos1 + n1*n1-1
               tmp(1:n1,1:n1) = reshape(amat(d_pos1:d_pos2),/n1,n2/)
c
c---Add constraints to the conditioner
               l = 0
               do j=1,nconst
                  do k=1,nc(j)
                     l = l + 1
                     imega = const_mega(l)
                     if(imega.eq.i) then
                        ipos_mega = const_mega_pos(l)
                        cc = const(l)*const(l)
                        tmp(ipos_mega,ipos_mega) = cc
                     endif
                  enddo
               enddo

               call sqrt_inv_mat(n1,tmp,asq,asqinv)
               n12 = n1*n2
               acnd(d_pos1:d_pos2) = reshape(asq(1:n1,1:n1),/n12/)
               acin(d_pos1:d_pos2) = reshape(asqinv(1:n1,1:n1),/n12/)
               v_pos1 = vec_pos(i)
               v_pos2 = vec_pos(i) + n1 - 1
               sz = n1
               bnew(v_pos1:v_pos2) = 
     &              matmul(acnd(1:sz,1:sz),bnew(v_pos1:v_pos2))
            enddo
c
c---Solve the equation. Take care of conditioner
c     y = acond*dv
c
c---a subroutine for this
            call add_cond_local(dx,y2)
            call matmul_and_const_local(y2,y3)
            call add_cond_local(y2,y3)
c
            r1(1:nv) = bnew(1:nv) - y3(1:nv)
            p1(1:nv) = r1(1:nv)
            cg_conv = .FALSE.
            icycle = 0
            do while(.not.cg_conv)
               icycle = icycle + 1
c
c---Matrix multiplication with addition of constraints
               do i=1,nmega
                  pp(v_pos1:v_pos2) = matmul(acnd(1:sz,1:sz),p1(v_pos1:v_pos2)
               enddo
               call add_cond_local(p1,pp)
               call matmul_and_const_local(pp,p1)
               call add_cond_local(p1,pp)
c
               r1r1 = dot_product(r1(1:nv),r1(1:nv))
               p1pp = dot_product(p1(1:nv),pp(1:nv))
               alpha = r1r1/p1pp
               r2(1:nv) = r1(1:nv) - alpha * pp(1:nv)
               r2r2 = dot_product(r2(1:nv),r2(1:nv))
               
               beta = r2r2/r1r1
               p2(1:nv) = r1(1:nv) + beta * p1(1:nv)
               dy(1:nv) = dy(1:nv) + alpha * p1(1:nv)
               if(abs(sum(r1**2)).lt.eps_loc) then
                  cg_conv = .TRUE.
               else
                  r1(1:nv) = r2(1:nv)
                  p1(1:nv) = p2(1:nv)
               enddo
            enddo
c
c---If not converged we need to add gamma type correction
            do  i=1,nmega
               n1 = v_pos(i)
               sz = par_sizes(i)
               n2 = n1 + sz - 1
               dx(n1:n2) = matmul(acnd(1:sz,1:sz),dy(n1:n2))
            enddo

            if(nconst.gt.0) then
               delta(1:nonst) = 0
c
c---  Check constraints. If necessary increase sigmas
               do  i=1,nconst
                  do j=1,nc(i)
                     ipos = const_pos(j)
                     coef = const_coef(j)
                     delta(i) = delta(i) + coef*dx(ipos)
                  enddo
                  delta(i) = delta(i) - bconst(i)
               enddo

               c_max = max(abs(cx(1:nconst) - bconst(1:nconst)))
               
               if(c_max.gt.0.25*cprev)  then
                  c1_conv = .FALSE.
                  do i=1,nconst
                     if(abs(delta(i)).gt.cprev*0.25) then
                        sigma(i) = 10.0*sigma(i)
                     endif
                  enddo
               else
                  cprev = c_max
                  c1_conv = .TRUE.
               endif
            else
               c1_cov = .TRUE.
            endif
         enddo
c
c---  Modify lagrangian if necessary
         if(max(delta).le.conv_limit.or.nconst.le.0) then
            const_conv = .TRUE.
         else
            lam(1:nconst)=lam(1:nconst)-sigma(1:nconst)*delta(1:nconst)
         endif
      enddo
c
c---  deallocate and return

      return
      end
c
      subroutine add_cond_local()
      implicit none

      return
      end
