C
C     REFMAC refinement program
C     Copyright (C) 2000-2004 Garib Murshudov
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
cd      PROGRAM refmac
C------------------------------------------------------------------------
C----Remarks on program organization
C     Program for refinement macromolecular structures. Current 
C     ersion of program works as Hendickson-Konnert restrained refinement
c     with or without restraints and with FFT
C
C     Rigid body refinement
c    
c----CCPFYP
c----MTZINI        subroutines makes possible to work with CCP4
c
c
c----DEFLTS        defines default values of parameters
c
c----RCARD         reads necessary parametrs for refinement
c
c----HKREF         refines macromolecular structures using output from
c----              PROTIN. This subroutine works as HK + Agarwal program
c
C------------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      INCLUDE 'makecif_version.fh'
      include 'lib_com.fh'
C
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
C
C----Initialize ccp4 like file organization
      CALL CCP4_PROG_VERSION(R_VERSNO,0)
      CALL CCPFYP
      CALL MTZINI
      CALL DEFLTS
c-----------------------------------------------------
c
c----Open system input and output
c
c----------------------------------------------------
      CALL CCPRCS(ISYSW,'Refmac_'//R_VERSNO,
     & '$Date: '//R_VERSDATE//' $')
      write (isysw,11)
 11   format (
     +     ' $TEXT:Reference1: $$ comment $$ '/2x,
     +     ' "Refinement of Macromolecular Structures by the ',
     +     ' Maximum-Likelihood Method:"'/2x,
     +     ' G.N. Murshudov, A.A.Vagin and E.J.Dodson,(1997)'/2x,
     +     ' Acta Crystallogr. D53, 240-255'/2x,
     +     ' EU  Validation contract: BIO2CT-92-0524',//,' $$',/,
     +     ' $SUMMARY :Reference1:  $$ Refmac: $$'/
     +     ' :TEXT:Reference1: $$'/)
C
c----Initialise for harvesting and read cards and instructions
C
      CALL rharvest(0)
      CALL RCARD
c---------------------------------------------------
c----Read coordinate and reflection files if necessary
c---------------------------------------------------
      IF(MODE.EQ.'RIGI') REFID = 'UNRE'
      IF(CRDUSE) CALL OPPRO
      IF(REFUSE) CALL REFPRE
C---------------------------------------------------
C---General preperation. 
C---Calc orth. deorth matrices and so on
C--------------------------------------------------
      CALL GENPRE
C
C---If all atoms should be anisotropic then convert those which are not 
C---anisotropic yet
      call write_dist_exit

      NANISO_ATOMS = 0
      DO   IA=1,N_ATOM
         IF(U_ANISO(2,IA).NE.0.0) NANISO_ATOMS = NANISO_ATOMS + 1
      ENDDO
      IF(ITEMP.EQ.2) CALL ALLBS2ANISOU
      CALL CHECK_U_VALUES
C---Begin actions
C
      IFLAGB = 0
      IFLAGE = 1
      CALL CCPTIM(IFLAGE,CPU,ELAPS)
      CALL CCPTIM(IFLAGB,CPU,ELAPS)
 6018 FORMAT ('  Time in seconds: CPU = ',F12.2,/,
     +        '             Elapsed =   ',F12.2)
C
      IF(MODE.EQ.'HKRF') THEN
        CALL HKON
      ELSEIF(MODE.EQ.'CELR') THEN
cd        CALL CELLREF(NAME)
      ELSEIF(MODE.EQ.'RIGI') THEN
        CALL RIGID_BODY
      ELSEIF(MODE.EQ.'TLSR') THEN
        CALL TLS_REFINE
      ELSEIF(MODE.EQ.'NEWE') THEN
        CALL NEWENTRY_IDEALISE
      elseif(mode.eq.'OCCU'.OR.REFID.EQ.'OCCU') then
         call occup_only_refine
cd      ELSEIF(MODE.EQ.'INTE') THEN
cd        CALL INTERNAL_REFINE
c
c     ELSEIF(MODE.EQ.'CONS') THEN
C        CALL  CONSTR
C     ELSEIF(MODE.EQ.'FULL') THEN
C        CALL FULLM
C     ELSEIF(MODE.EQ.'OMT1') THEN
C        CALL OMIT1
C     ELSEIF(MODE.EQ.'OMT2') THEN
C        CALL OMIT2
C     ELSEIF(MODE.EQ.'BLCK') THEN
C        CALL BLOCKR
C     ELSEIF(MODE.EQ.'SFCL') THEN
C        CALL SFCALC
C     ELSEIF(MODE.EQ.'MAPC') THEN
C        CALL MAPCALC
C     ELSEIF(MODE.EQ.'AUTO') THEN
C        CALL AUTOREF
      ELSE
        CALL ERRWRT(1,' Other modes are not active')
      ENDIF
C
C---Another action?
C     IF(ICONTINUE.EQ.1) GOTO 1
C                ************************
      CALL WRITE_ATOMS_REFMAC
      IFLAGB = 0
      IFLAGE = 1
      CALL CCPTIM(IFLAGE,CPU,ELAPS)
      WRITE (ISYSW,FMT=6018) CPU,ELAPS
      CALL CCPTIM(IFLAGB,CPU,ELAPS)
C
C---Write harvesting data
      CALL WRITE_VS_CYCLE
      CALL rharvest(1)
      CALL REFMAC_CLEAN_UP_FILES
      call calc_final_coord_stats
      call write_xml

      CALL CCPERR(0,'End of Refmac_'//R_VERSNO)
      END

      SUBROUTINE REFMAC_CLEAN_UP_FILES
      IMPLICIT NONE
C
C---Removes intermadiate files used
      INCLUDE 'restr_files.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'makecif.fh'
      LOGICAL LEXISTS
      INTEGER IFAIL,IUNIT,ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,
     &        NEWFIL,INXYZ,IOUTX,MTZIN,LL
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
C
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      IF(STRUCT_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=STRUCT_FILE(1:LENSTR(STRUCT_FILE)),EXIST=LEXISTS)
      IF(LEXISTS) THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,STRUCT_FILE(1:LENSTR(STRUCT_FILE)),
     &          'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(RESTRAINT_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=RESTRAINT_FILE(1:LENSTR(RESTRAINT_FILE)),
     &           EXIST=LEXISTS)
      IF(LEXISTS.AND.RESTRAINT_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,RESTRAINT_FILE(1:LENSTR(RESTRAINT_FILE)),
     &          'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(COORD_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=COORD_FILE(1:LENSTR(RESTRAINT_FILE)),
     &           EXIST=LEXISTS)
      IF(LEXISTS.AND.COORD_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,COORD_FILE(1:LENSTR(RESTRAINT_FILE)),
     &          'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(BOND_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=BOND_FILE(1:LENSTR(BOND_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.BOND_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,BOND_FILE(1:LENSTR(BOND_FILE)),'UNKNOWN',
     &          'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(LENSTR(BOND_FILE_EXTRA).GT.0) THEN
      INQUIRE (FILE=BOND_FILE_EXTRA(1:LENSTR(BOND_FILE_EXTRA)),
     &            EXIST=LEXISTS)
      IF(LEXISTS.AND.BOND_FILE_EXTRA(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,BOND_FILE_EXTRA(1:LENSTR(BOND_FILE_EXTRA)),
     &          'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      
      IF(LENSTR(ANGLE_FILE).GT.0) THEN
      INQUIRE (FILE=ANGLE_FILE(1:LENSTR(ANGLE_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.ANGLE_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,ANGLE_FILE(1:LENSTR(ANGLE_FILE)),'UNKNOWN',
     &     'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(LENSTR(ANGLE_FILE_EXTRA).GT.0) THEN
      INQUIRE (FILE=ANGLE_FILE_EXTRA(1:LENSTR(ANGLE_FILE_EXTRA)),
     &               EXIST=LEXISTS)
      IF(LEXISTS.AND.ANGLE_FILE_EXTRA(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,ANGLE_FILE_EXTRA(1:LENSTR(ANGLE_FILE_EXTRA)),
     &     'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF      
      IF(VDW_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=VDW_FILE(1:LENSTR(VDW_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.VDW_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,VDW_FILE(1:LENSTR(VDW_FILE)),'UNKNOWN',
     &         'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(VDW_FILE_0(1:1).NE.' '.AND.LENSTR(VDW_FILE_0).GT.0) THEN
      INQUIRE (FILE=VDW_FILE_0(1:LENSTR(VDW_FILE_0)),EXIST=LEXISTS)
      IF(LEXISTS.AND.VDW_FILE_0(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,VDW_FILE_0(1:LENSTR(VDW_FILE_0)),'UNKNOWN',
     &         'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(CHIR_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=CHIR_FILE(1:LENSTR(CHIR_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.CHIR_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,CHIR_FILE(1:LENSTR(CHIR_FILE)),'UNKNOWN',
     &         'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF      
      ENDIF

      IF(TORS_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=TORS_FILE(1:LENSTR(TORS_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.TORS_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,TORS_FILE(1:LENSTR(TORS_FILE)),'UNKNOWN',
     &        'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
 
      IF(NCSR_FILE_NAME(1:1).NE.' ') THEN
      INQUIRE (FILE=NCSR_FILE_NAME(1:LENSTR(NCSR_FILE_NAME)),
     &      EXIST=LEXISTS)
      IF(LEXISTS.AND.NCSR_FILE_NAME(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,NCSR_FILE_NAME(1:LENSTR(NCSR_FILE_NAME)),
     &           'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(NCSC_FILE_NAME(1:1).NE.' ') THEN
      INQUIRE (FILE=NCSC_FILE_NAME(1:LENSTR(NCSC_FILE_NAME)),
     &      EXIST=LEXISTS)
      IF(LEXISTS.AND.NCSC_FILE_NAME(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,NCSC_FILE_NAME(1:LENSTR(NCSC_FILE_NAME)),
     &           'UNKNOWN','U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(PLANE_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=PLANE_FILE(1:LENSTR(PLANE_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.PLANE_FILE(1:1).NE.' ') THEN
        IFAIL = -1
        IUNIT = 0
        CALL CCPDPN(IUNIT,PLANE_FILE(1:LENSTR(PLANE_FILE)),'UNKNOWN',
     &         'U',LL,IFAIL)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      if(keywords_file(1:1).ne.' ') then
         INQUIRE (FILE=keywords_file(1:LENSTR(keywords_file)),
     &        EXIST=LEXISTS)
         IF(LEXISTS.AND.keywords_file(1:1).NE.' ') THEN
            IFAIL = -1
            IUNIT = 0
            CALL CCPDPN(IUNIT,keywords_file(1:LENSTR(keywords_file)),
     &           'UNKNOWN','F',LL,IFAIL)
            CLOSE(IUNIT,STATUS='DELETE')
         ENDIF
      ENDIF 
      if(fomap_file(1:1).ne.' ') then
         inquire(file=fomap_file,exist=lexists)
         if(lexists) then
            ifail = -1
            iunit = 0
            call ccpdpn(iunit,fomap_file,'UNKNOWN','U',ll,ifail)
            close(iunit,status='delete')
         endif
      endif
C
      IF(ISCRF.GT.0) CLOSE(ISCRF,STATUS='DELETE')
      IF(ISCRF0.GT.0) CLOSE(ISCRF0,STATUS='DELETE')
       IF(IFSCR_SAVE.GT.0) CLOSE(IFSCR_SAVE,STATUS='DELETE')

      RETURN
      END
C
      SUBROUTINE WRITE_VS_CYCLE
C
C---This routine writes some info vs cycle into ouput log file
C---things like R factor free etc
      IMPLICIT NONE
      INCLUDE 'rharvest.fh'
C
      INTEGER ICC
      CHARACTER LINE*80
C
        CALL HEADER('Things for loggraph, R factor and others vs cycle')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,
     &     '$TABLE: Rfactor analysis, stats vs cycle  :')
        CALL ERRWRT(-1,'$GRAPHS:<Rfactor> vs cycle :N:1,2,3:')
        CALL ERRWRT(-1,':FOM vs cycle :N:1,4:')
        CALL ERRWRT(-1,':-LLG vs cycle :N:1,5:')
        CALL ERRWRT(-1,':Geometry vs cycle:N:1,6,7,8:')
        CALL ERRWRT(-1,'$$')
        CALL ERRWRT(-1,
     &   '      Ncyc   Rfact   Rfree     FOM         LLG  rmsBOND '//
     &    ' rmsANGLE rmsCHIRAL $$')
        CALL ERRWRT(-1,'$$')
C
      DO    ICC = 1,NCYCLE_OVERALL
        LINE = ' '
        WRITE(LINE(1:10),'(I10)')ICC-1
        IF(RFACTOR_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(11:18),'(1X,F7.3)')RFACTOR_VS_CYCLE(ICC)
        ELSE
          WRITE(LINE(11:18),'(A)')'   0.0  '
        ENDIF
        IF(RFREE_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(19:27),'(1X,F7.3)')RFREE_VS_CYCLE(ICC)
        ELSE
          WRITE(LINE(19:27),'(A)')'   0.0  '
        ENDIF
        IF(FOM_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(28:36),'(1X,F7.3)')FOM_VS_CYCLE(ICC)
        ELSE
          WRITE(LINE(28:36),'(A)')'   0.0  '
        ENDIF
        WRITE(LINE(37:50),'(1X,F12.1)')LLG_VS_CYCLE(ICC)
        IF(BOND_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(51:59),'(1X,F7.3)')BOND_VS_CYCLE(ICC)
        ELSE
          WRITE(LINE(51:59),'(A)')'   0.0  '
        ENDIF
        IF(ANGLE_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(60:68),'(1X,F7.3)')ANGLE_VS_CYCLE(ICC)
        ELSE
          WRITE(LINE(60:68),'(A)')'   0.0  '
        ENDIF
        IF(CHIR_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(69:77),'(1X,F7.3)')CHIR_VS_CYCLE(ICC)
        ELSE
          WRITE(LINE(69:77),'(A)')'   0.0  '
        ENDIF
        CALL ERRWRT(-1,LINE)
      ENDDO
      CALL ERRWRT(-1,' $$ ')

      RETURN
      END
c
      subroutine calc_final_coord_stats
      implicit none
      include 'atom_com.fh'
      include 'rharvest.fh'
c
c---Calculate overall B values for all atoms, main and side chains      
      integer ich
      integer i,ir,nside,nmain,nall
      real bloc,pi,eightpisq
      character side_or_main*1
c
      nmain = 0
      nside = 0
      nall  = 0
      baver_main = 0.0
      baver_side = 0.0
      baver_all  = 0.0
      do ich=1,n_group
         nmain_gr(ich) = 0
         nside_gr(ich) = 0
         nall_gr(ich) = 0
         baver_main_gr(ich) = 0.0
         baver_side_gr(ich) = 0.0
         baver_all_gr(ich) = 0.0
      enddo
c
      pi = 4.0*atan2(1.0,1.0)
      eightpisq = 8.0*pi**2
      do i=1,n_atom
         ir = i_resid(i)
         ich = i_chain(ir)
         if(occup(i).gt.0.0) then
            if(atom_ref_flag(i).gt.0) then
               if(u_aniso(2,i).le.0.0) then
                  bloc = u_aniso(1,i)
               else
                  bloc = sum(u_aniso(1:3,i))/3.0
               endif
               call check_side_or_main(atm_name(i),side_or_main)
               ir = i_resid(i)
               if(res_type(ires_type(ir))(1:5).eq.'L-pep'.or.
     &            res_type(ires_type(ir))(1:5).eq.'D-pep') then
                  if(side_or_main.eq.'S') then
                     nside = nside + 1
                     nside_gr(ich) = nside_gr(ich) + 1
                     baver_side = baver_side + bloc
                     baver_side_gr(ich) = baver_side_gr(ich) + bloc
                  else
                     nmain = nmain + 1
                     nmain_gr(ich) = nmain_gr(ich) + 1
                     baver_main = baver_main + bloc
                     baver_main_gr(ich) = baver_main_gr(ich) + bloc
                  endif
               endif
               nall = nall + 1
               nall_gr(ich) = nall_gr(ich) + 1
               baver_all = baver_all + bloc
               baver_all_gr(ich) = baver_all_gr(ich) + bloc
            endif
         endif
      enddo
c
      if(nside.gt.0) baver_side = eightpisq*baver_side/nside
      if(nmain.gt.0) baver_main = eightpisq*baver_main/nmain
      if(nall.gt.0 ) baver_all  = eightpisq*baver_all/nall
      do ich = 1,n_group
         if(nside_gr(ich).gt.0) baver_side_gr(ich) =
     &        eightpisq*baver_side_gr(ich)/nside_gr(ich)
         if(nmain_gr(ich).gt.0) baver_main_gr(ich) =
     &        eightpisq*baver_main_gr(ich)/nmain_gr(ich)
         if(nall_gr(ich).gt.0) baver_all_gr(ich) =
     &        eightpisq*baver_all_gr(ich)/nall_gr(ich)
      enddo
c
      return
      end
c
      subroutine write_xml
      implicit none
      include 'atom_com.fh'
      include 'rharvest.fh'
c
      character local_file*512
      character file_pdb*512,file_mtz*512
      integer l
      integer lenstr
      external lenstr
c
c---
      integer ich
      integer in,ifail,ll
      call ugtenv('XMLOUT',local_file)
      if(local_file.eq.' ') return
      in = 0
      ifail = -1
      ll = 0
      call ccpdpn(in,local_file,'UNKNOWN','F',ll,ifail)
c
c--write all necessary info.
      write(in,'(a)')
     &     '<?xml version="1.0" encoding="ASCII" standalone="yes"?>'
      write(in,'(a)')'<!-- refmac output  -->'
      write(in,'(a)')'<REFMAC>'
      write(in,'(a)')'Error <err_level>         0</err_level><br/>'
      write(in,'(a)')
     &     'Message <err_message>normal termination</err_message>'
      write(in,'(a)')'Job <job>refmac</job>'
      write(in,*)'n_cycle  <n_cycle>',ncycle_overall,'</n_cycle><br/>'
      write(in,*)'r_factor_init <r_factor_init>',rfactor_vs_cycle(1),
     &     '</r_factor_init><br/>'
      write(in,*)'r_factor <r_factor>',
     &     rfactor_vs_cycle(ncycle_overall),'</r_factor><br/>'
      write(in,*)'r_free_init <r_free_init>',rfree_vs_cycle(1),
     &     '</r_free_init><br/>'
      write(in,*)'r_free <r_free>',rfree_vs_cycle(ncycle_overall),
     &     '</r_free> <br/>'
      write(in,*)'baverage_all <baver_all>',baver_all,
     &     '</baver_all> <br/>'
      write(in,*)'baverage_main <baver_main>',baver_main,
     &     '</baver_main> <br/>'
      write(in,*)'baverage_side <baver_side>',baver_side,
     &     '</baver_side> <br/>'
      if(n_group.gt.1) then
         do ich = 1,n_group
            write(in,*)'B values for chains <chain_b_values>',
     &           group_id(ich), 
     &        '<br/>'
            write(in,*)'   baverage_all_chain <baver_all> ',
     &           baver_all_gr(ich),'</baver_all> <br />'
            write(in,*)'   baverage_side_chain <baver_side> ',
     &           baver_side_gr(ich),'</baver_side> <br />'
            write(in,*)'   baverage_main_chain <baver_main> ',
     &           baver_main_gr(ich),'</baver_main> <br />'
         write(in,*)'</chain_b_values> <br/>'
         enddo
      endif
      call ugtenv('XYZOUT',file_pdb)
      if(file_pdb.eq.' ') file_pdb = 'XYZOUT'
      l = lenstr(file_pdb)
      write(in,'(3a)')'<solution sol_file="',file_pdb(1:l),'"/><br/>'
      call ugtenv('HKLOUT',file_mtz)
      if(file_mtz.eq.' ') file_mtz = 'HKLOUT'
      l = lenstr(file_mtz)
      write(in,'(3a)')'<mtz mtz_file="',file_mtz(1:l),'"/><br/>'
      write(in,*)'</REFMAC>'
      close(in)

      return
      end
c
      subroutine check_end
      implicit none
c     

      return
      end
