      subroutine reorganise_all_data(input_file)
c
c--This subroutine reads observation file and organises data for
c--general twin/unmerged/split crystal treatment. It is assumed that imput data
c--are intensities.
c
      implicit none
      include 'celsym.fh'
      include 'twin_refmac.fh'
      include 'refi_flags.fh'
      include 'restr_files.fh'
c
      character input_file*(*)
      integer ncomp,nasym
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: nref_comp(:)
      integer, allocatable :: hkl_comp(:,:)
      integer, allocatable :: comp_number(:)
      integer, allocatable :: refer_2_asym(:)
      integer, allocatable :: refer_2_symm(:)
      real, allocatable :: iobs(:,:)
      integer, allocatable :: free_refl(:)
c
      integer nobs1,ncomp1,n_twins
      integer ierr
      integer i,j
      integer is 
c
      integer in_file
c
c---  call find_reflection_file_type(input_file,hkl_format)
c
c--read Mller indices for asymmetic unit
      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
      do i=1,nasym
         read(in_file)hkl_asym(1:3,i)
      enddo
      close(in_file)
c
      if(reftyp.eq.'HKL') then
         twin_user_flag = .TRUE.
         call read_hklf5_size(nobs1,ncomp1,n_twins,ierr,input_file) 
         if(ierr.gt.0) then
            write(*,*)'Error in reading HKLF 5 file'
            stop
         endif
c
         allocate(iobs(2,nobs1))
         allocate(nref_comp(nobs1+1))
         allocate(hkl_comp(3,ncomp1))
         allocate(comp_number(ncomp1))
         allocate(free_refl(nobs1))
         call read_hklf5(nobs1,ncomp1,iobs,nref_comp,
     &        hkl_comp,comp_number,ierr,input_file)
c
c---  We need to sort out free reflections for this case
         free_refl(1:nobs1) = 1
         if(ierr.gt.0) then
            write(*,*)'Error in reading HKLF 5 file'
            stop
         endif
      else if(reftyp.eq.'MTZ') then
c
c--Now we are reading (converted) mtz file. It can be more than mtz
         if(.not.twin_user_flag) then
            call decide_twin_operators(input_file)
         endif

         call read_refl_size(input_file,nobs1)
         ncomp1 = nobs1*ntwin_domain
         allocate(iobs(2,nobs1))
         allocate(nref_comp(nobs1+1))
         allocate(hkl_comp(3,ncomp1))
         allocate(comp_number(ncomp1))
         allocate(free_refl(nobs1))
         call read_refl_twin(input_file,nobs1,ncomp1,iobs,
     &        nref_comp,hkl_comp,comp_number,free_refl,
     &        ierr)     

c---  if twin operators defined by the program then check if potential twins
c---  are really twin. Calculate rmerge if it is more than 50 then 
c---  very likely not to be twin
         ncomp = ncomp1
      else
         
      endif
c
c--Now we have read reflections with their potential comoponents
c--Components are twin domains. Now we are ready to organise observations
      allocate(refer_2_asym(ncomp1))
      allocate(refer_2_symm(ncomp1))
      call find_refer2asym(ncomp,hkl_comp,refer_2_asym,
     &     refer_2_symm,nasym,hkl_asym,ierr)
      
      deallocate(hkl_comp)
      call block_organise_observ(ncomp1,comp_number,refer_2_asym,
     &     refer_2_symm,nobs1,iobs,free_refl,nref_comp,
     &     nasym,hkl_asym,
     &     refl_file,ierr)

      deallocate(refer_2_symm)
      deallocate(refer_2_asym)
      deallocate(nref_comp)
      deallocate(comp_number)
      deallocate(free_refl)
      deallocate(iobs)

      return
      end
c      
      subroutine read_refl_size(input_file,nobs1)
c---This subroutine finds number of observations and total number
c---of twin operators multiplied by observations
c
      implicit none
      include 'celsym.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
      integer nobs1
c
      character input_file*(*)
      integer in_file,ifail
      integer ierr
c
c---  body
      call open_unform_file(in_file,input_file,ifail)
      read(in_file)nobs1
      close(in_file)
c      
      return
      end
c     
      subroutine  read_refl_twin(input_file,nobs,ncomp1,iobs,
     &     nref_comp,hkl_comp,
     &     comp_number,free_refl,ierr)
      implicit none
      include 'celsym.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
c----Read relfections and generate twin counterparts if available
      integer nrefl,nobs,ncomp1
      real iobs(2,nobs)
      integer comp_number(ncomp1)
      integer hkl_comp(3,ncomp1)
      character input_file*(*)
      integer ierr
C
c---Things for Andrey's subroutine
      integer ioutput

      integer nobs_line
      integer isysabs
      integer integer_flag
      integer hkl_out(3),hkl1(3)
      integer nref_comp(nobs+1)
      integer free_refl(nobs)

c
c---things for the organisation of the data
      integer, allocatable :: hkl_obs(:,:)
      integer, allocatable :: hkl_obs_twin(:,:)
c
      real iol(2)
      integer free1
      integer i,j,k
      integer itw,ncomp_all,ip
      integer ir
      integer in_file,ll,ifail
      logical lerror
c
      integer nobs1
c
c---  body
      call open_unform_file(in_file,input_file,ierr)
      read(in_file)nobs
      nobs1 = 0
      allocate(hkl_obs(3,nobs))
      do   i=1,nobs
         read(in_file)hkl1(1:3),iol(1:2),free1
         call sysabs_symm_r(maxsym,nsym,rot,tr,hkl1(1),
     &        hkl1(2),hkl1(3),isysabs)
         if(isysabs.eq.0) then
            nobs1 = nobs1 + 1
            hkl_obs(1:3,nobs1) = hkl1(1:3)
            iobs(1:2,nobs1)    = iol(1:2)
            free_refl(nobs1)        = free1
         else
            write(*,*)'Systematic absence ',hkl1
         endif
      enddo
      close(in_file)
c
      nref_comp(1) = 0
      ip = 0
      do ir = 1,nobs
         ip = ip + 1
         nref_comp(ir+1) = nref_comp(ir) + 1
         hkl_comp(1:3,ip)=hkl_obs(1:3,ir) 
         comp_number(ip) = 1
         if(ntwin_domain.gt.1) then
c
c--loop over twinning operators and generate all components for this 
c---observation
            do   itw=2,ntwin_domain
               hkl_out(1:3)= 
     &              matmul(transpose(twin_oper(1:3,1:3,itw)),
     &              hkl_obs(1:3,ir))
               
C---  Careful. Make sure that reflection is integer.
               hkl1(1:3)=hkl_out(1:3)/12
               integer_flag = 1
               do   j=1,3
                  if(12*hkl1(j).ne.hkl_out(j)) then
                     integer_flag = 0
                  endif
               enddo
               if(integer_flag.eq.1) then
                  call sysabs_symm_r(maxsym,nsym,rot,tr,hkl1(1),
     &                 hkl1(2),hkl1(3),isysabs)
                  if(isysabs.eq.0) then
                     nref_comp(ir+1) = nref_comp(ir+1) + 1
                     ip = ip +1
                     hkl_comp(1:3,ip)=hkl1(1:3)
                     comp_number(ip) = itw
                  endif
               endif
            enddo
         endif
      enddo
      ncomp1 = ip
      ncomp_all = ip
      deallocate(hkl_obs)
      return
      end
c
      subroutine find_refer2asym(ncomp,hkl_comp,refer_2_asym,
     &     refer_2_symm,nasym,hkl_asym,ierr)
C
c--This subroutine find reference to asymmetric unit (defined by hkl_asym) from
C--hkl_in. It also remember what was symmetry that was used to bring the reflection
C--from the list hkl_in to asymmetric unit. This subroutine assumes that 
C--reflceions in asymmetric unit have been sorted using iheap_sort.
C
      implicit none
      include 'celsym.fh'
c
c---  Inputs
      integer nasym,ncomp
c
c--outputs
      integer ierr
      integer hkl_comp(3,ncomp)
      integer hkl_asym(3,nasym)
      integer refer_2_asym(ncomp),refer_2_symm(ncomp)
c
c----locals
      integer, allocatable :: index(:)
C
      integer irot(3,3,192)
      integer ir,is,ia,i
      integer isysabs
      integer hcur,kcur,lcur
      integer hsym,ksym,lsym
      integer iscur
      integer itemp
c
      real lstlsq
C---Bring to asymmetric unit. Take into account friedel pairs also
      allocate(index(ncomp))

      do ir=1,ncomp
        index(ir) = ir
      enddo
C
      irot(1:3,1:3,1:nsym) = nint(rot(1:3,1:3,1:nsym))

      do  ir=1,ncomp
        hcur = hkl_comp(1,ir)
        kcur = hkl_comp(2,ir)
        lcur = hkl_comp(3,ir)
        iscur = 1
c
c-- we take maximum among symmetry related ones. asym unit should also have similar
c---organisation
c      something wrong here
        do is=1,nsym
           lsym = nint(rot(1,3,is)*hkl_comp(1,ir)+ 
     &                 rot(2,3,is)*hkl_comp(2,ir)+
     &                 rot(3,3,is)*hkl_comp(3,ir))
           ksym = nint(rot(1,2,is)*hkl_comp(1,ir)+ 
     &                 rot(2,2,is)*hkl_comp(2,ir)+
     &                 rot(3,2,is)*hkl_comp(3,ir))
           hsym = nint(rot(1,1,is)*hkl_comp(1,ir) + 
     &                 rot(2,1,is)*hkl_comp(2,ir)+
     &                 rot(3,1,is)*hkl_comp(3,ir))
           if(lsym.gt.lcur) then
              hcur = hsym
              kcur = ksym
              lcur = lsym
              iscur = is
           else if(lsym.eq.lcur) then
              if(ksym.gt.kcur) then
                 hcur = hsym
                 kcur = ksym
                 lcur = lsym
                 iscur = is
              else if(ksym.eq.kcur) then
                 if(hsym.gt.hcur) then
                    hcur = hsym
                    kcur = ksym
                    lcur = lsym
                    iscur = is
                 endif
              endif
           endif
           hsym = -hsym
           ksym = -ksym
           lsym = -lsym
           if(lsym.gt.lcur) then
              hcur = hsym
              kcur = ksym
              lcur = lsym
              iscur = -is
           else if(lsym.eq.lcur) then
              if(ksym.gt.kcur) then
                 hcur = hsym
                 kcur = ksym
                 lcur = lsym
                 iscur = -is
              else if(ksym.eq.kcur) then
                 if(hsym.gt.hcur) then
                    hcur = hsym
                    kcur = ksym
                    lcur = lsym
                    iscur = -is
                 endif
              endif
           endif   
        enddo         
        refer_2_symm(ir) = iscur
        hkl_comp(1,ir) = hcur
        hkl_comp(2,ir) = kcur
        hkl_comp(3,ir) = lcur
      enddo
c
      do  ir=1,ncomp
         itemp          = hkl_comp(3,ir)
         hkl_comp(3,ir) = hkl_comp(1,ir)
         hkl_comp(1,ir) = itemp
      enddo
      call iheap_sort_r(ncomp,3,hkl_comp,index)
      do  ir=1,ncomp
         itemp          = hkl_comp(3,ir)
         hkl_comp(3,ir) = hkl_comp(1,ir)
         hkl_comp(1,ir) = itemp
      enddo
c
c---  Find references to the asymmetric unit
      do   ir=1,ncomp
         refer_2_asym(ir) = 0
      enddo
c      stop
c     
      ir = 1
      ia = 1
c
      do while(ir.le.ncomp.and.ia.le.nasym)
c
         if(hkl_comp(3,ir).lt.hkl_asym(3,ia)) then
            ir = ir + 1
         else if(hkl_comp(3,ir).gt.hkl_asym(3,ia)) then
            ia = ia + 1
         else
            if(hkl_comp(2,ir).lt.hkl_asym(2,ia)) then
               ir = ir + 1
            else if(hkl_comp(2,ir).gt.hkl_asym(2,ia)) then
               ia = ia + 1
            else
               if(hkl_comp(1,ir).lt.hkl_asym(1,ia)) then
                  ir = ir + 1
               else if(hkl_comp(1,ir).gt.hkl_asym(1,ia)) then
                  ia = ia + 1
               else
                  if(refer_2_asym(index(ir)).gt.0) then
c                  if(refer_2_asym(ir).gt.0) then

                     write(*,*)
     &                    'The same reflection have more than one '//
     &                    'reference to the asymmetric unit'
                     write(*,*)(hkl_comp(i,index(ir)),i=1,3)
                     stop
                  else
                     refer_2_asym(index(ir)) = ia
c                     refer_2_asym(ir) = ia
                     ir = ir + 1
                  endif
               endif
            endif
         endif       
      enddo
c
c--   Remove reflections that do not have reference to asymmetric unit  
      do   ir=1,ncomp
         if(refer_2_asym(index(ir)).le.0) then
            write(*,*)nasym,ir,
     &           (hkl_comp(i,ir),i=1,3),refer_2_asym(index(ir))
                  call sysabs_symm_r(maxsym,nsym,rot,tr,hkl_comp(1,ir),
     &                 hkl_comp(2,ir),hkl_comp(3,ir),isysabs)
                  write(*,*)0.5/sqrt(lstlsq(1,hkl_comp(1,ir),
     &                 hkl_comp(2,ir),hkl_comp(3,ir)))
            write(*,*)
     &           'Not all observation have reference to asymmetric unit'
            stop
        endif
      enddo
      deallocate(index)
      return
      end
 
