# This program reads two map series and masks the first map series with
# the second. i.e. any cell which is missing in the corresponding month
# of the second series is also set to missing in the first.
# Usage:
#  python mask.py map.dat mask.dat > new.map


import sys, math, numpy


# write a month of map data
def write_map( year, month, smap ):
  tmap = reversed( smap )
  lines = ["%4d %2d\n"%(year,month)]
  for row in tmap:
    s = ""
    for val in row:
      if not numpy.isnan(val):
        s += "%7.3f "%(val)
      else:
        s += "-99.9 "
    lines.append( s[:-1] + "\n" )
  return lines


# main program
import numpy as np

data = np.genfromtxt(sys.argv[1])
print >> sys.stderr, data.shape
data.shape = (-1,180,89)
print >> sys.stderr, data.shape

data[data==-180.0] = -9999

nmonths = data.shape[0]
y0 = 1990

# calculate maps
for m in range(0,nmonths):
  year = y0 + m//12
  month = m%12+1
  tmap = 0.01*data[m].T
  tmap2 = numpy.empty([180,360])
  tmap2.fill( numpy.nan )
  for i in range(1,179):
    for j in range(0,360):
      tmap2[i,j] = tmap[(i-1)//2,(j+181)//2%180]
  for l in write_map( year, month, tmap2 ):
    print l,

