/*! \file brigantine-lib.cpp brigantine library */
/* (C) 2006 Kevin Cowtan & University of York all rights reserved */

#include "brigantine-lib.h"


OmitCoordinates::OmitCoordinates( clipper::Spacegroup spgr, clipper::Cell cell, int nomit )
{
  typedef clipper::Xmap<char>::Map_reference_index MRI;

  // calculate sphere radius
  double vasu = cell.volume() / spgr.num_symops();
  double r0 = 1.10*pow( vasu/double(nomit), 0.333 );

  // make a map
  clipper::Resolution reso( 1.0 );
  clipper::Grid_sampling grid( spgr, cell, reso );
  clipper::Xmap<float> xmap( spgr, cell, grid );
  xmap = 0.0;

  clipper::Grid_range gm( cell, grid, r0 );
  clipper::Xmap_base::Map_reference_coord i0, iu, iv, iw ;

  // now start packing spheres in ASU
  double cut2 = r0*r0;
  for ( MRI ix = xmap.first(); !ix.last(); ix.next() ) {
    if ( xmap[ix] == 0.0 ) {
      clipper::Coord_orth x0 = ix.coord_orth();
      coords.push_back( x0 );
      clipper::Coord_grid cent = x0.coord_frac( cell ).coord_grid( grid );
      clipper::Coord_grid g0 = cent + gm.min();
      clipper::Coord_grid g1 = cent + gm.max();
      i0 = clipper::Xmap_base::Map_reference_coord( xmap, g0 );
      for ( iu = i0; iu.coord().u() <= g1.u(); iu.next_u() )
	for ( iv = iu; iv.coord().v() <= g1.v(); iv.next_v() )
	  for ( iw = iv; iw.coord().w() <= g1.w(); iw.next_w() ) {
	    double r2 = ( iw.coord_orth() - x0 ).lengthsq();
	    if ( r2 < cut2 ) {
	      float r = 1.0-r2/cut2;
	      xmap[iw] = clipper::Util::max( xmap[iw], r );
	    }
	  }
    }
  }

  std::cout << coords.size() << "\n";

  // find the lowest points remaining
  float fcut = 0.40;
  for ( int i = 0; i < 2*nomit; i++ ) {
    MRI iz = xmap.first();
    for ( MRI iy = xmap.first(); !iy.last(); iy.next() )
      if ( xmap[iy] < xmap[iz] ) iz = iy;
    if ( xmap[iz] < fcut ) {
      clipper::Coord_orth x0 = iz.coord_orth();
      coords.push_back( x0 );
      clipper::Coord_grid cent = x0.coord_frac( cell ).coord_grid( grid );
      clipper::Coord_grid g0 = cent + gm.min();
      clipper::Coord_grid g1 = cent + gm.max();
      i0 = clipper::Xmap_base::Map_reference_coord( xmap, g0 );
      for ( iu = i0; iu.coord().u() <= g1.u(); iu.next_u() )
	for ( iv = iu; iv.coord().v() <= g1.v(); iv.next_v() )
	  for ( iw = iv; iw.coord().w() <= g1.w(); iw.next_w() ) {
	    double r2 = ( iw.coord_orth() - x0 ).lengthsq();
	    if ( r2 < cut2 ) {
	      float r = 1.0-r2/cut2;
	      xmap[iw] = clipper::Util::max( xmap[iw], r );
	    }
	  }
    } else {
      break;
    }
  }


  // check the map for unfilled points
  int n0, n1, n2;
  n0 = n1 = n2 = 0;
  for ( MRI ix = xmap.first(); !ix.last(); ix.next() ) {
    if      ( xmap[ix] < 0.01 ) n0++;
    else if ( xmap[ix] < fcut ) n1++;
    else                        n2++;
  }
  std::cout << coords.size() << "\n";
  std::cout << n0 << "\t" << n1 << "\t" << n2 << "\n";
  //for ( int i = 0; i < coords.size(); i++ ) std::cout << i << " " << coords[i].format() << "\n";

  rad = r0*sqrt(1.0-fcut);
}
