/*! \file brigantine-lib.h brigantine library */
/* (C) 2002-2006 Kevin Cowtan & University of York all rights reserved */


#ifndef BRIGANTINE_LIB
#define BRIGANTINE_LIB

#include <clipper/clipper.h>
#include <clipper/clipper-contrib.h>


class OmitCoordinates {
 public:
  OmitCoordinates() {}
  OmitCoordinates( clipper::Spacegroup spgr, clipper::Cell cell, int nomit );
  const std::vector<clipper::Coord_orth>& coordinates() { return coords; }
  double radius() const { return rad; }
 private:
  std::vector<clipper::Coord_orth> coords;
  double rad;
};


class MapFilterFn_smooth : public clipper::MapFilterFn_base {
public:
  MapFilterFn_smooth( const clipper::ftype& r0, const clipper::ftype& r1 ) : r0_(r0), r1_(r1) {}
    clipper::ftype operator() ( const clipper::ftype& radius ) const 
    {
      if ( radius > r1_ ) return 0.0;
      if ( radius < r0_ ) return 1.0;
      clipper::ftype x = ( radius - r0_ ) / ( r1_ - r0_ );
      return (2.0*x*x*x-3.0*x*x+1.0);
    }
private:
    clipper::ftype r0_, r1_;
};


#endif
